/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.print.engine;

import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.helper.ExportContext;
import com.kingdee.bos.ctrl.print.ui.component.IPainter;
import com.kingdee.bos.ctrl.print.ui.component.Page;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.data.DataExtend;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.data.DataParamSource;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.IR1Page;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.ReportModel;
import com.kingdee.bos.ctrl.reportone.r1.common.script.ScriptExecutor;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.common.node.ExportException;
import com.kingdee.bos.ctrl.reportone.r1.print.common.R1PrintInfo;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.model.R1PrintModelHelper;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.DelayVarProvider;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.ExecuteContext;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.IR1PrintEngineListener;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.IWidgetExecuteHelper;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.RuntimeModel;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.ScriptSystemMethod;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.data.DataUsingContext;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.exception.R1PrintDataException;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.exception.R1PrintException;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.exporter.R1PrintW2VExporter;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.importer.R1PrintD2WImporter;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.IAdjustHeightSupport;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.IDatasourceSupport;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.IPaginationSupport;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.IPrintWidget;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.IPrintWidgetContainer;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.PWPage;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.datagrid.PWDataGrid;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.datagrid.context.GridExecuteContext;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.layoutgrid.PWLayoutGrid;
import com.kingdee.bos.ctrl.script.miniscript.MiniScriptParseException;
import com.kingdee.bos.ctrl.script.miniscript.MiniScriptRuntimeException;
import com.kingdee.bos.ctrl.script.miniscript.ScriptResult;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.tree.TreePath;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.PrintServicePluginProxy;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.LongProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.InteTimeZone;

public class R1PrintEngine {
    private static final String BOS_PRINT_ENGINE = "bos-print-engine";
    private static final String R_1_PRINT_ENGINE_1 = "R1PrintEngine_1";
    private static final String R_1_PRINT_ENGINE_2 = "R1PrintEngine_2";
    private static final Log log = LogFactory.getLog(R1PrintEngine.class);
    private ScriptExecutor scriptExecutor = new ScriptExecutor();
    private RuntimeModel runtimeModel;
    private IR1PrintEngineListener listener;
    private ArrayList outputPages = new ArrayList();
    private ArrayList executedPages = new ArrayList();
    private HashMap outputWidgets = new HashMap();
    private Pagination pagination;
    private IWidgetExecuteHelper executeHelper = new ExecuteHelper();
    private boolean forceStopField = false;
    private int forceStopPages = 0;
    public static int pageTotalIndex = 1;
    public static boolean isReCountPageNumber = false;
    public static boolean isNewPageNumWhenEconomizePages = false;
    private IFreshOutputRobber freshOutputRobber;
    private boolean isSingleDs;

    private static String getFiledName() {
        return ResManager.loadKDString((String)"\u5b57\u6bb5\uff1a", (String)"R1PrintEngine_9", (String)BOS_PRINT_ENGINE, (Object[])new Object[0]);
    }

    public R1PrintEngine(RuntimeModel runtimeModel, IR1PrintEngineListener listener) {
        this.runtimeModel = runtimeModel;
        this.listener = listener;
        this.executeHelper.setPluginProxy(runtimeModel.getPluginProxy());
        this.pagination = new Pagination();
        DataExtend[] dataExtends = this.getModel().getDataManager().getDataExtends();
        if (dataExtends.length > 0) {
            DataExtend mainDs = this.analyseMainDatasource(dataExtends);
            this.pagination.setMainDs(mainDs.getName());
            this.isSingleDs = dataExtends.length == 1;
        }
    }

    public void setDelayVarProvider(DelayVarProvider dpv) {
        ((ExecuteHelper)this.executeHelper).setDelayVarProvider(dpv);
    }

    public void forceStop() {
        this.forceStopField = true;
    }

    public void setPagesOfForceStop(int n) {
        this.forceStopPages = n;
    }

    private boolean isForceStop(int pageIndex) {
        return this.forceStopField || this.pageOverLimit(pageIndex);
    }

    private boolean pageOverLimit(int pageIndex) {
        return this.forceStopPages > 0 && pageIndex >= this.forceStopPages;
    }

    private RuntimeModel getRuntimeModel() {
        return this.runtimeModel;
    }

    private ReportModel getModel() {
        return this.runtimeModel.getReportModel();
    }

    private R1PrintInfo GetPrintInfo() {
        return R1PrintModelHelper.getPrintInfo(this.getModel());
    }

    public Page getOutputPage(int index) {
        if (this.outputPages != null) {
            Page page = (Page)this.outputPages.get(index);
            this.outputPages.set(index, null);
            return page;
        }
        return null;
    }

    private PWPage importPage() throws R1PrintException {
        R1PrintD2WImporter d2w = null;
        try {
            d2w = new R1PrintD2WImporter(this.getRuntimeModel().getPluginProxy(), this.getRuntimeModel().getPageId(), this.getRuntimeModel().getPkId());
        }
        catch (Exception e) {
            throw new R1PrintException(e);
        }
        IR1Page designPage = this.getModel().getPage();
        IPrintWidget widget = d2w.translate(designPage);
        PWPage pwp = (PWPage)widget;
        pwp.setFooterHeight(designPage.getFooterHeight());
        return pwp;
    }

    public void execute(int pageWidth, int pageHeight) throws R1PrintException {
        this.listener.beginOutput();
        PWPage page = this.importPage();
        boolean i = false;
        boolean toRepeatPage = true;
        int pageIdx = 0;
        int lastPageIndex = 0;
        pageTotalIndex = 1;
        isNewPageNumWhenEconomizePages = true;
        isReCountPageNumber = true;
        boolean isForceSetPageIndexZero = false;
        int pageIndexBeforForceSetZero = 0;
        boolean isChangeBillAfert = true;
        boolean isNewMainDataSource = false;
        boolean isNeedSumTotalPage = false;
        while (toRepeatPage) {
            if (this.isForceStop(pageIdx)) {
                if (!this.pageOverLimit(pageIdx)) break;
                String msg = ResManager.loadKDString((String)"\u8f93\u51fa\u9875\u8d85\u8fc7\u6700\u5927\u9650\u5236\uff08%s\uff09\uff0c\u8bf7\u51cf\u5c11\u6570\u636e\uff0c\u6216\u68c0\u67e5\u6a21\u7248\u3002", (String)"R1PrintEngine_0", (String)BOS_PRINT_ENGINE, (Object[])new Object[0]);
                throw new KDBizException(String.format(msg, this.forceStopPages));
            }
            toRepeatPage = false;
            isNeedSumTotalPage = false;
            boolean isPaginateByObject = this.getPagination().isPaginateByObject();
            if (isPaginateByObject) {
                isNewMainDataSource = false;
                toRepeatPage = true;
                log.debug("\u5bf9\u8c61\u5f15\u8d77\u5206\u9875\u65f6\u7684\u7279\u6b8a\u5904\u7406\uff0c\u7b2c" + (pageIdx + 1) + "\u9875");
                Iterator it = this.getPagination().iteratorContext();
                while (it.hasNext()) {
                    IPaginationSupport.IPaginationContext context = (IPaginationSupport.IPaginationContext)it.next();
                    if (!(context instanceof IDatasourceSupport.IDatasourceContext)) continue;
                    IDatasourceSupport.IDatasourceContext ctx = (IDatasourceSupport.IDatasourceContext)((Object)context);
                    String ds = ctx.secondSpringDatasource();
                    if (this.getRuntimeModel().isEOF(ds)) {
                        if (this.getPagination().isMainDs(ds)) {
                            if (this.isSingleDs) continue;
                            log.debug(ds + "\u662f\u4e3b\u6570\u636e\u6e90\uff0c\u5f3a\u884c\u590d\u6d3b\u3002");
                            context.relive();
                            continue;
                        }
                        if (ctx.isRequestSecondBirth()) {
                            log.debug(ds + "\u6ca1\u6570\u636e\uff0csecondBirth.");
                            context.relive();
                            this.getRuntimeModel().secondSpring(ds);
                            continue;
                        }
                        if (context.isRequestRelive()) {
                            log.debug(ds + "\u6ca1\u6570\u636e\uff0crelive.");
                            context.relive();
                            continue;
                        }
                        log.debug(ds + "\u6ca1\u6570\u636e\uff0c\u6ca1\u8981\u6c42\u590d\u6d3b\u3002");
                        continue;
                    }
                    Object oo = this.getPagination().getPaginatingObject().get(0);
                    if (oo instanceof PWLayoutGrid && context instanceof GridExecuteContext || context instanceof GridExecuteContext && oo instanceof PWDataGrid && !((PWDataGrid)oo).getDatasource().equals(((GridExecuteContext)context).getGrid().getDatasource())) continue;
                    log.debug(ds + "\u6709\u6570\u636e\uff0crelive.");
                    context.relive();
                }
            } else {
                String ds = this.getPagination().getMainDs();
                if (this.getRuntimeModel().hasNext(ds)) {
                    this.getRuntimeModel().next(ds);
                    toRepeatPage = true;
                    this.getPagination().reliveAll();
                    isNewMainDataSource = true;
                } else {
                    toRepeatPage = false;
                }
            }
            if (!toRepeatPage && isForceSetPageIndexZero) {
                pageIdx = pageIndexBeforForceSetZero;
            }
            if (toRepeatPage || pageIdx == 0) {
                if (isReCountPageNumber && isNewMainDataSource) {
                    pageIdx = 0;
                    lastPageIndex = 0;
                }
                this.listener.beginPageOutput(page.getId(), pageIdx);
                this.getPagination().resetStateAll();
                page.setPageIndex(pageIdx++);
                int tempPageIdx = pageIdx;
                page.updatePageNumberOfLongPageMode(!isPaginateByObject);
                PWPage executedPage = this.executePage(page, pageWidth, pageHeight);
                this.executedPages.add(executedPage);
                this.exportPage(true);
                this.outputWidgets.clear();
                if (this.pagination.isPaginateByObject()) {
                    toRepeatPage = true;
                    isChangeBillAfert = false;
                    if (!isNewMainDataSource && pageIdx == 0) {
                        isNeedSumTotalPage = true;
                    }
                } else {
                    isChangeBillAfert = true;
                    isNeedSumTotalPage = true;
                    if (pageIdx == 0 && isNewMainDataSource) {
                        pageIdx = 1;
                    } else if (pageIdx == 0) {
                        pageIdx = tempPageIdx;
                    } else if (toRepeatPage && isChangeBillAfert && isNewPageNumWhenEconomizePages) {
                        pageIndexBeforForceSetZero = pageIdx;
                        isForceSetPageIndexZero = true;
                        pageIdx = 0;
                    }
                }
                if (ExportContext.get().isPageSeparation() && isChangeBillAfert && lastPageIndex % 2 == 0) {
                    this.executedPages.add(executedPage.copy());
                }
                if (isNeedSumTotalPage && (isReCountPageNumber || isChangeBillAfert && isNewPageNumWhenEconomizePages)) {
                    if (pageIdx == 0 && lastPageIndex != 0) {
                        this.executeHelper.getDelayVarProvider().fillValue("pageTotal" + pageTotalIndex, new Variant(lastPageIndex + 1));
                    } else if (pageIdx == 0) {
                        this.executeHelper.getDelayVarProvider().fillValue("pageTotal" + pageTotalIndex, new Variant(pageIdx + 1));
                    } else {
                        this.executeHelper.getDelayVarProvider().fillValue("pageTotal" + pageTotalIndex, new Variant(pageIdx));
                    }
                    ++pageTotalIndex;
                }
                lastPageIndex = pageIdx;
            }
            if (!this.getPagination().isPaginateByObject()) continue;
            toRepeatPage = true;
        }
        if (!this.isForceStop(pageIdx)) {
            this.executeHelper.getDelayVarProvider().fillValue("pageTotal", new Variant(pageIdx));
            page.updatePageNumberOfLongPageMode(true);
            this.exportPage(true);
            if (!this.executedPages.isEmpty()) {
                this.exportPage(false);
                log.error("@@ \u7b49\u5f85\u586b\u5145\u503c\u7684\u9875\u672a\u5f97\u5230\u586b\u5145\u503c\uff0c\u8fd9\u662fR1Print\u5f15\u64ce\u7684\u9519\u8bef\uff01\u9875\u4f9d\u7136\u8f93\u51fa\uff0c\u4f46\u5f85\u586b\u5145\u5904\u4e3a\u7a7a\u3002@@");
            }
        }
        this.listener.endOutput();
    }

    private PWPage executePage(PWPage page, int pageWidth, int pageHeight) throws R1PrintException {
        page.getRectangle().setSize(pageWidth, pageHeight);
        PWPage executedPage = (PWPage)page.execute(this.executeHelper);
        this.executeHelper.getDataContext().removeOverdoData(executedPage);
        return executedPage;
    }

    private void exportPage(boolean checkUnsure) throws R1PrintException {
        int index;
        int c = this.executedPages.size();
        for (index = 0; index < c; ++index) {
            PWPage page = (PWPage)this.executedPages.get(index);
            if (checkUnsure && page.isUnsure()) break;
            if (this.freshOutputRobber != null) {
                this.freshOutputRobber.rob(page);
            }
            R1PrintW2VExporter w2v = null;
            try {
                w2v = new R1PrintW2VExporter();
            }
            catch (ExportException e) {
                throw new R1PrintException(e);
            }
            IPainter viewPage = w2v.translate(page);
            this.outputPages.add(page.getPageIndex(), viewPage);
            this.listener.endPageOutput(page.getId(), page.getPageIndex());
        }
        for (int i = 0; i < index; ++i) {
            this.executedPages.remove(0);
        }
    }

    private DataExtend analyseMainDatasource(DataExtend[] exts) {
        DataExtend dataExt;
        int i;
        for (i = 0; i < exts.length; ++i) {
            dataExt = exts[i];
            if (!dataExt.isMainDS()) continue;
            return dataExt;
        }
        for (i = 0; i < exts.length; ++i) {
            DataParamSource dps;
            dataExt = exts[i];
            if (dataExt.getParamSources().values().isEmpty()) {
                return dataExt;
            }
            Iterator<DataParamSource> paramSources = dataExt.getParamSources().values().iterator();
            if (!paramSources.hasNext() || !StringUtils.isNotBlank((CharSequence)(dps = paramSources.next()).getReferenceDataName())) continue;
            return dataExt;
        }
        return exts[0];
    }

    private Pagination getPagination() {
        return this.pagination;
    }

    public static void markOutputId(IWidgetExecuteHelper helper, List outputs) {
        int c = outputs.size();
        for (int i = 0; i < c; ++i) {
            Object obj = outputs.get(i);
            if (!(obj instanceof IPrintWidget)) continue;
            helper.markOutputId((IPrintWidget)obj);
        }
    }

    public static Object runFormula(IWidgetExecuteHelper helper, IPrintWidget widget, String target) {
        if (target != null && (target.startsWith("=") || target.startsWith("$"))) {
            Object result = helper.runFormula(widget, target.substring(1));
            if (result instanceof Date) {
                InteTimeZone sysTz = InteTimeZone.getSysTimeZone();
                return sysTz.format((Date)result);
            }
            if ((isReCountPageNumber || isNewPageNumWhenEconomizePages) && result != null && result.toString().indexOf("pageTotal") != -1) {
                result = result.toString().replace("pageTotal", "pageTotal" + pageTotalIndex);
            }
            return result;
        }
        return null;
    }

    public void setFreshOutputRobber(IFreshOutputRobber robber) {
        this.freshOutputRobber = robber;
    }

    private ScriptExecutor getScriptExecutor() {
        if (this.scriptExecutor == null) {
            this.scriptExecutor = new ScriptExecutor();
        }
        return this.scriptExecutor;
    }

    public static TreePath createOutputedParent(TreePath parentOfParent, IPrintWidget parent) {
        if (parentOfParent == null) {
            return new TreePath(parent);
        }
        return parentOfParent.pathByAddingChild(parent);
    }

    @FunctionalInterface
    public static interface IFreshOutputRobber {
        public void rob(PWPage var1);
    }

    private class ExecuteHelper
    implements IWidgetExecuteHelper {
        private IWidgetExecuteHelper.IDataHelper dataHelper;
        private ScriptSystemMethod systemMethod;
        private DelayVarProvider delayVarProvider;
        private DataUsingContext dataUsingContext;
        private PrintServicePluginProxy pluginProxy;

        private ExecuteHelper() {
            this.dataHelper = new DataHelper();
            this.dataUsingContext = new DataUsingContext();
        }

        @Override
        public PrintServicePluginProxy getPluginProxy() {
            return this.pluginProxy;
        }

        @Override
        public void setPluginProxy(PrintServicePluginProxy pluginProxy) {
            this.pluginProxy = pluginProxy;
        }

        @Override
        public IWidgetExecuteHelper.IDataHelper getDataHelper() {
            return this.dataHelper;
        }

        @Override
        public void setDataHelper(IWidgetExecuteHelper.IDataHelper dataHelper) {
            this.dataHelper = dataHelper;
        }

        private ScriptSystemMethod getSystemMethod() {
            if (this.systemMethod == null) {
                this.systemMethod = new ScriptSystemMethod();
                this.systemMethod.setExecuteHelper(this);
            }
            return this.systemMethod;
        }

        @Override
        public void markOutputId(IPrintWidget widget) {
            R1PrintEngine.this.outputWidgets.put(widget.getId(), widget);
        }

        @Override
        public void runScript(IPrintWidget widget, int type) {
            String script = "";
            if (type == 1) {
                script = widget.getPreScript();
            } else if (type == 2) {
                script = widget.getScript();
            } else if (type == 3) {
                script = widget.getLastScript();
            }
            if (StringUtils.isNotBlank((CharSequence)script)) {
                try {
                    String[] scripts = script.split("//<RunAfterStat>");
                    if (scripts.length == 2) {
                        script = scripts[0];
                        widget.setLastScript(scripts[1]);
                    }
                    R1PrintEngine.this.getScriptExecutor().execute(script, this.getSystemMethod(), widget, R1PrintEngine.this.outputWidgets);
                }
                catch (MiniScriptParseException | MiniScriptRuntimeException e) {
                    log.error(ResManager.loadKDString((String)"\u811a\u672c\u89e3\u6790\u9519\u8bef\uff0c\u5bf9\u8c61ID\uff1a%1$s\uff0c\u811a\u672c\uff1a%2$s", (String)"R1PrintEngine_11", (String)R1PrintEngine.BOS_PRINT_ENGINE, (Object[])new Object[]{widget.getId(), script}), (Throwable)e);
                }
            }
        }

        @Override
        public Object runFormula(IPrintWidget widget, String formula) {
            if (StringUtils.isNotBlank((CharSequence)formula)) {
                try {
                    String formulaResult = "r1printFormulaResult";
                    StringBuilder process = new StringBuilder();
                    process.append(formulaResult);
                    process.append("=");
                    process.append(formula);
                    ScriptResult scriptResult = R1PrintEngine.this.getScriptExecutor().execute(process.toString(), this.getSystemMethod(), widget, R1PrintEngine.this.outputWidgets);
                    Object result = scriptResult.getVar(formulaResult);
                    scriptResult.delVar(formulaResult);
                    if (result != null && !DelayVarProvider.isVar(result.toString()) && DelayVarProvider.isContainsVar(result.toString())) {
                        return DelayVarProvider.makeVarSign(result.toString());
                    }
                    return result;
                }
                catch (MiniScriptRuntimeException e) {
                    log.error("\u516c\u5f0f\u6267\u884c\u9519\u8bef\uff0c\u5bf9\u8c61ID\uff1a" + widget.getId(), (Throwable)e);
                }
                catch (MiniScriptParseException e) {
                    log.error("\u516c\u5f0f\u89e3\u6790\u9519\u8bef\uff0c\u5bf9\u8c61ID\uff1a" + widget.getId(), (Throwable)e);
                }
            }
            return null;
        }

        @Override
        public void executChildren(IPrintWidgetContainer widgetContainer, IPrintWidgetContainer outputWidgetContainer) throws R1PrintException {
            if (!widgetContainer.hasChildren()) {
                return;
            }
            IPrintWidget childWithMainDs = null;
            ArrayList<IPrintWidget> listLaterExec = new ArrayList<IPrintWidget>();
            for (IPrintWidget child : widgetContainer.getChildren()) {
                if (widgetContainer instanceof PWPage && child.getRectangle() != null && child.getRectangle().getY() > widgetContainer.getRectangle().getHeight()) {
                    log.debug(String.format(ResManager.loadKDString((String)"\u6807\u8bc6\u4e3a%s\u7684\u5143\u7d20\u4e0d\u5728\u7eb8\u5f20\u8303\u56f4\u5185\uff0c\u8bf7\u91cd\u65b0\u8c03\u6574\u3002", (String)"R1PrintEngine_10", (String)R1PrintEngine.BOS_PRINT_ENGINE, (Object[])new Object[0]), child.getId()));
                }
                if (child instanceof IPaginationSupport || child instanceof IPrintWidgetContainer) {
                    if (child instanceof IDatasourceSupport && R1PrintEngine.this.getPagination().isMainDs(((IDatasourceSupport)((Object)child)).getDatasource())) {
                        childWithMainDs = child;
                        continue;
                    }
                    listLaterExec.add(child);
                    continue;
                }
                IPrintWidget outputChild = this.executWidget(outputWidgetContainer, child);
                outputWidgetContainer.addChild(outputChild);
            }
            if (childWithMainDs != null) {
                listLaterExec.add(childWithMainDs);
            }
            widgetContainer.getContext().setChildrenPaginating(false);
            if (!listLaterExec.isEmpty()) {
                for (IPrintWidget child : listLaterExec) {
                    child.setMainDs(R1PrintEngine.this.getPagination().getMainDs());
                    IPrintWidget outputChild = this.executWidget(outputWidgetContainer, child);
                    outputWidgetContainer.addChild(outputChild);
                    boolean paginationSupport = Boolean.FALSE;
                    if (child instanceof IPaginationSupport) {
                        PWDataGrid pwDataGrid;
                        paginationSupport = Boolean.TRUE;
                        if (child instanceof PWDataGrid && (pwDataGrid = (PWDataGrid)child).isSubGrid() && !child.getContext().isAdjustHeight()) {
                            paginationSupport = Boolean.FALSE;
                        }
                    }
                    if (!paginationSupport) continue;
                    IPaginationSupport ps = (IPaginationSupport)((Object)child);
                    IPaginationSupport.IPaginationContext context = (IPaginationSupport.IPaginationContext)((Object)child.getContext());
                    if (ps.isOutputEnd()) {
                        R1PrintEngine.this.getPagination().removePaginatingObject(ps);
                        R1PrintEngine.this.getPagination().registerContext(context);
                        context.dead();
                        continue;
                    }
                    R1PrintEngine.this.getPagination().addPaginatingObject(ps);
                    R1PrintEngine.this.getPagination().unregisterContext(context);
                    widgetContainer.getContext().setChildrenPaginating(true);
                }
            }
        }

        private IPrintWidget executWidget(IPrintWidgetContainer parent, IPrintWidget widget) throws R1PrintException {
            ExecuteContext context = widget.getContext();
            Rectangle rect = parent.getRectangle();
            int footerHeight = 0;
            if (parent instanceof PWPage) {
                footerHeight = ((PWPage)parent).getFooterHeight();
            }
            if (widget instanceof PWDataGrid || widget instanceof PWLayoutGrid) {
                context.setContainerHeight(rect.height - footerHeight);
            } else {
                context.setContainerHeight(rect.height);
            }
            context.setContainerWidth(rect.width);
            context.setOwner(parent.getContext().getOwner());
            if (parent instanceof IAdjustHeightSupport) {
                IAdjustHeightSupport ahs = (IAdjustHeightSupport)((Object)parent);
                context.setAdjustHeight(ahs.isAdjustHeight());
                context.setMaxHeightToAdjust(ahs.getMaxHeightToAdjust());
            } else {
                context.setAdjustHeight(false);
                if (widget instanceof PWDataGrid || widget instanceof PWLayoutGrid) {
                    context.setMaxHeightToAdjust(rect.height - footerHeight);
                } else {
                    context.setMaxHeightToAdjust(rect.height);
                }
            }
            context.setOutputedParent(R1PrintEngine.createOutputedParent(parent.getOutputedParent(), parent));
            context.passContextDataHelper(parent.getContext());
            IPrintWidget outputWidget = widget.execute(this);
            return outputWidget;
        }

        @Override
        public DelayVarProvider getDelayVarProvider() {
            return this.delayVarProvider;
        }

        public void setDelayVarProvider(DelayVarProvider dvp) {
            this.delayVarProvider = dvp;
        }

        @Override
        public DataUsingContext getDataContext() {
            return this.dataUsingContext;
        }
    }

    private class DataHelper
    implements IWidgetExecuteHelper.IDataHelper {
        private DataHelper() {
        }

        @Override
        public Variant getFieldValue(String ds, String field) {
            try {
                return R1PrintEngine.this.getRuntimeModel().getFieldData(ds, field);
            }
            catch (R1PrintDataException e) {
                StringBuilder sb = new StringBuilder(ResManager.loadKDString((String)"\u53d6\u5b57\u6bb5\u503c\u53d1\u751f\u5f02\u5e38\u3002\u6570\u636e\u6e90\uff1a", (String)R1PrintEngine.R_1_PRINT_ENGINE_1, (String)R1PrintEngine.BOS_PRINT_ENGINE, (Object[])new Object[0]));
                sb.append(ds);
                sb.append(R1PrintEngine.getFiledName());
                sb.append(field);
                log.error(sb.toString(), (Throwable)e);
                return null;
            }
        }

        @Override
        public Object getValue(String ds, String field) {
            try {
                Variant va = R1PrintEngine.this.getRuntimeModel().getFieldData(ds, field);
                return va.getValue();
            }
            catch (R1PrintDataException e) {
                StringBuilder sb = new StringBuilder(ResManager.loadKDString((String)"\u53d6\u5b57\u6bb5\u503c\u53d1\u751f\u5f02\u5e38\u3002\u6570\u636e\u6e90\uff1a", (String)R1PrintEngine.R_1_PRINT_ENGINE_1, (String)R1PrintEngine.BOS_PRINT_ENGINE, (Object[])new Object[0]));
                sb.append(ds);
                sb.append(R1PrintEngine.getFiledName());
                sb.append(field);
                log.error(sb.toString(), (Throwable)e);
                return null;
            }
        }

        @Override
        public Object getFieldType(String ds, String field) {
            try {
                return R1PrintEngine.this.getRuntimeModel().getFieldType(ds, field);
            }
            catch (R1PrintDataException e) {
                StringBuilder sb = new StringBuilder(ResManager.loadKDString((String)"\u53d6\u5b57\u6bb5\u7c7b\u578b\u53d1\u751f\u5f02\u5e38\u3002", (String)R1PrintEngine.R_1_PRINT_ENGINE_1, (String)R1PrintEngine.BOS_PRINT_ENGINE, (Object[])new Object[0]));
                sb.append(ds);
                sb.append(R1PrintEngine.getFiledName());
                sb.append(field);
                log.error(sb.toString(), (Throwable)e);
                return null;
            }
        }

        @Override
        public Variant getPreviousRowFieldValue(String ds, String field) {
            try {
                return R1PrintEngine.this.getRuntimeModel().getPreviousRowFieldData(ds, field);
            }
            catch (R1PrintDataException e) {
                log.error("", (Throwable)e);
                return null;
            }
        }

        @Override
        public Variant getPropheticRowFieldData(String ds, String field) {
            try {
                return R1PrintEngine.this.getRuntimeModel().getPropheticRowFieldData(ds, field);
            }
            catch (R1PrintDataException e) {
                log.error("", (Throwable)e);
                return null;
            }
        }

        @Override
        public boolean isNumberField(String ds, String field) {
            Object type;
            try {
                type = R1PrintEngine.this.getRuntimeModel().getFieldType(ds, field);
            }
            catch (R1PrintDataException e) {
                log.error("", (Throwable)e);
                return false;
            }
            return type instanceof DecimalProp || type instanceof LongProp;
        }

        @Override
        public boolean hasNext(String ds) {
            try {
                return R1PrintEngine.this.getRuntimeModel().hasNext(ds);
            }
            catch (R1PrintDataException e) {
                log.error("", (Throwable)e);
                return false;
            }
        }

        @Override
        public boolean next(String ds) {
            try {
                return R1PrintEngine.this.getRuntimeModel().next(ds);
            }
            catch (R1PrintDataException e) {
                log.error("", (Throwable)e);
                return false;
            }
        }

        @Override
        public boolean isEOF(String ds) {
            try {
                return R1PrintEngine.this.getRuntimeModel().isEOF(ds);
            }
            catch (R1PrintDataException e) {
                log.error("", (Throwable)e);
                return false;
            }
        }

        @Override
        public boolean isBOF(String ds) {
            try {
                return R1PrintEngine.this.getRuntimeModel().isBOF(ds);
            }
            catch (R1PrintDataException e) {
                log.error("", (Throwable)e);
                return false;
            }
        }

        @Override
        public int getCurrentPositon(String ds) {
            try {
                return R1PrintEngine.this.getRuntimeModel().getCurrentPositon(ds);
            }
            catch (R1PrintDataException e) {
                log.error("", (Throwable)e);
                return -1;
            }
        }

        @Override
        public int getRowsCount(String ds) {
            try {
                return R1PrintEngine.this.getRuntimeModel().getRowsCount(ds);
            }
            catch (R1PrintDataException e) {
                log.error("", (Throwable)e);
                return -1;
            }
        }

        @Override
        public boolean isContextRelative() {
            return false;
        }
    }

    private static class Pagination {
        private String mainDs;
        private ArrayList paginatingObject = new ArrayList();
        private ArrayList contexts = new ArrayList();

        private Pagination() {
        }

        public void setMainDs(String ds) {
            this.mainDs = ds;
        }

        public String getMainDs() {
            return this.mainDs;
        }

        public boolean isMainDs(String compareDs) {
            return StringUtils.equals((CharSequence)this.getMainDs(), (CharSequence)compareDs);
        }

        public ArrayList getPaginatingObject() {
            return this.paginatingObject;
        }

        public void addPaginatingObject(IPaginationSupport obj) {
            if (!this.paginatingObject.contains(obj)) {
                this.paginatingObject.add(obj);
            }
        }

        public void removePaginatingObject(IPaginationSupport obj) {
            this.paginatingObject.remove(obj);
        }

        public boolean isPaginateByObject() {
            return !this.paginatingObject.isEmpty();
        }

        public boolean isMainDsPaginate() {
            Object obj;
            if (this.paginatingObject.size() == 1 && (obj = this.paginatingObject.get(0)) instanceof IDatasourceSupport) {
                return this.isMainDs(((IDatasourceSupport)obj).getDatasource());
            }
            return false;
        }

        public void registerContext(IPaginationSupport.IPaginationContext context) {
            if (!this.contexts.contains(context)) {
                this.contexts.add(context);
            }
        }

        public void unregisterContext(IPaginationSupport.IPaginationContext context) {
            if (this.contexts.contains(context)) {
                this.contexts.remove(context);
            }
        }

        public Iterator iteratorContext() {
            return this.contexts.iterator();
        }

        public void reliveAll() {
            for (IPaginationSupport.IPaginationContext context : this.contexts) {
                context.relive();
            }
        }

        public void resetStateAll() {
            for (IPaginationSupport.IPaginationContext context : this.contexts) {
                context.resetState();
            }
        }
    }
}

