/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.print.engine;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.data.DataExtend;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.data.DataParamSource;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.ReportModel;
import com.kingdee.bos.ctrl.reportone.r1.print.data.IPrintDataProvider;
import com.kingdee.bos.ctrl.reportone.r1.print.data.IPrintVariantListener;
import com.kingdee.bos.ctrl.reportone.r1.print.data.SystemR1PrintDataParameter;
import com.kingdee.bos.ctrl.reportone.r1.print.data.SystemR1PrintDataSource;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.model.R1PrintModelHelper;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.data.AbstractInteriorDataProviderFactory;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.data.R1PDataVisitor;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.exception.R1PrintDataException;
import java.util.ArrayList;
import java.util.HashMap;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.PrintServicePluginProxy;
import kd.bos.entity.plugin.args.SensitiveArgs;
import kd.bos.form.watermark.WaterMark;
import org.apache.commons.lang3.StringUtils;

public class RuntimeModel {
    private ReportModel reportModel;
    private HashMap<String, R1PDataVisitor> mapDataVisitor;
    private IPrintVariantListener variantListener;
    private IRtDsInfoCreator rtDsInfoCreator;
    private String pdfName;
    private String modelType;
    private PrintServicePluginProxy pluginProxy;
    private String pageId;
    private String pkId;
    private WaterMark waterMark;

    public WaterMark getWaterMark() {
        return this.waterMark;
    }

    public void setWaterMark(WaterMark waterMark) {
        this.waterMark = waterMark;
    }

    public PrintServicePluginProxy getPluginProxy() {
        return this.pluginProxy;
    }

    public void setPluginProxy(PrintServicePluginProxy pluginProxy) {
        this.pluginProxy = pluginProxy;
    }

    public String getPageId() {
        return this.pageId;
    }

    public void setPageId(String pageId) {
        this.pageId = pageId;
    }

    public String getPkId() {
        return this.pkId;
    }

    public void setPkId(String pkId) {
        this.pkId = pkId;
    }

    public String getModelType() {
        return this.modelType;
    }

    public String getPdfName() {
        return this.pdfName;
    }

    public void setPdfName(String pdfName) {
        this.pdfName = pdfName;
    }

    public RuntimeModel(ReportModel rptModel) {
        this.reportModel = rptModel;
    }

    public ReportModel getReportModel() {
        return this.reportModel;
    }

    public void setRuntimeDsInfoCreator(IRtDsInfoCreator creator) {
        this.rtDsInfoCreator = creator;
    }

    private IRtDsInfoCreator getRuntimeDsInfoCreator() {
        if (this.rtDsInfoCreator == null) {
            this.rtDsInfoCreator = new DefaultRtDsInfoCreator();
        }
        return this.rtDsInfoCreator;
    }

    public void hookDataProvider(IPrintDataProvider dataProvider) {
        this.hookDataProvider(dataProvider, null);
    }

    public void hookDataProvider(IPrintDataProvider dataProvider, AbstractInteriorDataProviderFactory dpf) {
        this.modelType = dataProvider.getModelType();
        R1PDataVisitor[] dss = this.getAllDataVisitors();
        PrintServicePluginProxy pluginProxy = dataProvider.getPluginProxy();
        HashMap<String, SensitiveArgs> cacheArgs = new HashMap<String, SensitiveArgs>(16);
        for (int i = 0; i < dss.length; ++i) {
            MainEntityType entityType;
            R1PDataVisitor dsv = dss[i];
            dsv.setDelegate(dataProvider);
            dsv.setInteriorImpl(dpf);
            if (pluginProxy == null || (entityType = dsv.getEntityType()) == null) continue;
            if (cacheArgs.containsKey(entityType.getName())) {
                dsv.setSensitiveArgs((SensitiveArgs)cacheArgs.get(entityType.getName()));
                continue;
            }
            pluginProxy.setContext(entityType);
            SensitiveArgs sensitiveArgs = new SensitiveArgs((Object)this);
            pluginProxy.fireBeforeDesensitive(sensitiveArgs);
            dsv.setSensitiveArgs(sensitiveArgs);
            cacheArgs.put(entityType.getName(), sensitiveArgs);
        }
    }

    public void reInitialize() {
        R1PDataVisitor[] dss = this.getAllDataVisitors();
        for (int i = 0; i < dss.length; ++i) {
            R1PDataVisitor dsv = dss[i];
            dsv.reInitialize();
        }
    }

    private R1PDataVisitor[] getAllDataVisitors() {
        return this.getDataVisitors().values().toArray(new R1PDataVisitor[0]);
    }

    private HashMap<String, R1PDataVisitor> getDataVisitors() {
        if (this.mapDataVisitor == null) {
            int i;
            this.mapDataVisitor = new HashMap();
            ArrayList<String[]> relationCache = new ArrayList<String[]>();
            DataExtend[] dataExtends = this.getReportModel().getDataManager().getDataExtends();
            for (i = 0; i < dataExtends.length; ++i) {
                DataExtend dataExt = dataExtends[i];
                this.buildDataVisitor(dataExt, relationCache);
            }
            if (!relationCache.isEmpty()) {
                for (i = relationCache.size() - 1; i >= 0; --i) {
                    String[] cache = relationCache.get(i);
                    R1PDataVisitor master = this.mapDataVisitor.get(cache[0]);
                    R1PDataVisitor servant = this.mapDataVisitor.get(cache[1]);
                    if (master == null) continue;
                    master.addRelativeDataVisitor(servant);
                }
            }
        }
        return this.mapDataVisitor;
    }

    private R1PDataVisitor buildDataVisitor(DataExtend dataExt, ArrayList<String[]> relationCache) {
        SystemR1PrintDataSource dsInfo = this.getRuntimeDsInfoCreator().createDsInfo(dataExt);
        R1PDataVisitor dataVisitor = new R1PDataVisitor(dsInfo);
        for (DataParamSource designParam : dataExt.getParamSources().values()) {
            SystemR1PrintDataParameter runtimeParam = new SystemR1PrintDataParameter(designParam.getName());
            String associateSource = designParam.getReferenceDataName();
            if (associateSource != null) {
                runtimeParam.setAssociateSource(associateSource);
                runtimeParam.setAssociateField(designParam.getValue());
                R1PDataVisitor master = this.mapDataVisitor.get(associateSource);
                if (master == null) {
                    relationCache.add(new String[]{associateSource, dsInfo.getId()});
                } else {
                    master.addRelativeDataVisitor(dataVisitor);
                }
            } else {
                runtimeParam.setValue(new Variant(designParam.getValue()));
            }
            dsInfo.addParam(runtimeParam);
        }
        this.mapDataVisitor.put(dsInfo.getId(), dataVisitor);
        return dataVisitor;
    }

    private R1PDataVisitor getDataVisitor(String dataSource) {
        return this.getDataVisitors().get(dataSource);
    }

    public void setVariantListener(IPrintVariantListener value) {
        this.variantListener = value;
    }

    public IPrintVariantListener getVariantListener() {
        return this.variantListener;
    }

    public int getRowsCount(String dataSource) throws R1PrintDataException {
        R1PDataVisitor wrapper = this.getDataVisitor(dataSource);
        if (wrapper != null) {
            return wrapper.getRowsCount();
        }
        return 0;
    }

    public boolean hasNext(String dataSource) throws R1PrintDataException {
        R1PDataVisitor wrapper = this.getDataVisitor(dataSource);
        if (wrapper != null) {
            return wrapper.hasNext();
        }
        return false;
    }

    public boolean next(String dataSource) throws R1PrintDataException {
        R1PDataVisitor wrapper = this.getDataVisitor(dataSource);
        if (wrapper != null) {
            return wrapper.next();
        }
        return false;
    }

    public Variant getFieldData(String dataSource, String field) throws R1PrintDataException {
        if (StringUtil.equals(dataSource, "context")) {
            return this.getSystemParamValue(dataSource, field);
        }
        R1PDataVisitor wrapper = this.getDataVisitor(dataSource);
        if (wrapper != null) {
            if ((wrapper.isDataChanged() || wrapper.isBOF()) && !wrapper.isEOF()) {
                wrapper.next();
            }
            return wrapper.getFieldData(field);
        }
        return Variant.getNewEmptyVariant();
    }

    public Variant getPreviousRowFieldData(String dataSource, String field) throws R1PrintDataException {
        if (StringUtil.equals(dataSource, "context")) {
            return this.getSystemParamValue(dataSource, field);
        }
        R1PDataVisitor wrapper = this.getDataVisitor(dataSource);
        if (wrapper != null) {
            return wrapper.getPreviousRowFieldData(field);
        }
        return Variant.getNewEmptyVariant();
    }

    public Variant getPropheticRowFieldData(String dataSource, String field) throws R1PrintDataException {
        if (StringUtil.equals(dataSource, "context")) {
            return this.getSystemParamValue(dataSource, field);
        }
        R1PDataVisitor wrapper = this.getDataVisitor(dataSource);
        if (wrapper != null) {
            return wrapper.getPropheticRowFieldData(field);
        }
        return Variant.getNewEmptyVariant();
    }

    private Variant getSystemParamValue(String dataSource, String field) throws R1PrintDataException {
        if (this.getVariantListener() != null) {
            return new Variant(this.getVariantListener().requestVar(dataSource, field));
        }
        return null;
    }

    public Object getFieldType(String dataSource, String field) throws R1PrintDataException {
        R1PDataVisitor wrapper = this.getDataVisitor(dataSource);
        if (wrapper != null) {
            return wrapper.getFieldType(field);
        }
        return null;
    }

    public boolean isEOF(String dataSource) throws R1PrintDataException {
        R1PDataVisitor wrapper = this.getDataVisitor(dataSource);
        if (wrapper != null) {
            return wrapper.isEOF();
        }
        return true;
    }

    public boolean isBOF(String dataSource) throws R1PrintDataException {
        R1PDataVisitor wrapper = this.getDataVisitor(dataSource);
        if (wrapper != null) {
            return wrapper.isBOF();
        }
        return true;
    }

    public void secondSpring(String dataSource) throws R1PrintDataException {
        R1PDataVisitor wrapper = this.getDataVisitor(dataSource);
        if (wrapper != null) {
            wrapper.secondSpring();
        }
    }

    public int getCurrentPositon(String dataSource) throws R1PrintDataException {
        R1PDataVisitor wrapper = this.getDataVisitor(dataSource);
        if (wrapper != null) {
            return wrapper.getCurrentPositon();
        }
        return -1;
    }

    private static class DefaultRtDsInfoCreator
    implements IRtDsInfoCreator {
        private DefaultRtDsInfoCreator() {
        }

        @Override
        public SystemR1PrintDataSource createDsInfo(DataExtend dataExt) {
            SystemR1PrintDataSource dsInfo = new SystemR1PrintDataSource();
            dsInfo.setId(dataExt.getName());
            dsInfo.setSortFields(R1PrintModelHelper.getDataSorts(dataExt));
            dsInfo.setDsType(dataExt.getDsType());
            dsInfo.setQueryEntityId(dataExt.getQueryEntityId());
            dsInfo.setUsedFields(dataExt.getUsedFields());
            dsInfo.setUnionFields(dataExt.getUnionFields());
            dsInfo.setFilterCondition(dataExt.getFilterCondition());
            String refName = dataExt.getParentName();
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{refName})) {
                dsInfo.setReference(refName);
            }
            return dsInfo;
        }
    }

    @FunctionalInterface
    public static interface IRtDsInfoCreator {
        public SystemR1PrintDataSource createDsInfo(DataExtend var1);
    }
}

