/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.print.engine.data;

import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.common.variant.VariantExt;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.data.BasedataVersionManager;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.exception.R1PrintDataException;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.exception.R1PrintRuntimeException;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.property.AttachmentProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.CreateDateProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.ItemClassTypeProp;
import kd.bos.entity.property.ModifyDateProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.property.TimeProp;
import kd.bos.form.flex.FlexValueFormatUtils;
import kd.bos.inte.api.IInteService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.InteTimeZone;
import kd.bos.service.KDDateUtils;
import kd.bos.service.ServiceFactory;

public class MultiCursorRowSet {
    private static final String TIME_FORMAT = "timeFormat";
    private BasedataVersionManager basedataVersionManager = new BasedataVersionManager();
    private static final Log log = LogFactory.getLog(MultiCursorRowSet.class);
    private static final ArrayList EmptyRow = new ArrayList();
    private Cursor _currentCursor;
    private IDataEntityProperty[] _colTypes;
    private Map<String, Integer> _mapFieldIdx = new HashMap<String, Integer>();
    private List _cacheRows = new ArrayList();
    private DynamicObject dataEntity;
    private DynamicObjectCollection dataEntities;
    private Long inteFormatId;

    public DynamicObjectCollection getDataEntities() {
        return this.dataEntities;
    }

    public Long getInteFormatId() {
        return this.inteFormatId;
    }

    public void setInteFormatId(Long inteFormatId) {
        this.inteFormatId = inteFormatId;
    }

    public MultiCursorRowSet(List<DynamicObject> rowSet, DynamicObjectCollection objs) throws R1PrintDataException {
        this(rowSet, objs, 0L);
    }

    public MultiCursorRowSet(List<DynamicObject> rowSet, DynamicObjectCollection objs, Long inteFormatId) throws R1PrintDataException {
        this.dataEntities = objs;
        this.inteFormatId = inteFormatId;
        this.initMeta(rowSet);
        this.cacheData(rowSet);
        if (rowSet == null) {
            log.debug("RowSet is null.");
        } else {
            log.debug("RowSet has rows: " + this._cacheRows.size());
        }
    }

    private void initMeta(List<DynamicObject> rowSet) throws R1PrintDataException {
        if (rowSet == null || rowSet.size() == 0) {
            this._colTypes = new IDataEntityProperty[0];
            return;
        }
        try {
            int size = rowSet.get(0).getDynamicObjectType().getProperties().size();
            this._colTypes = new IDataEntityProperty[size];
            for (int i = 0; i < size; ++i) {
                IDataEntityProperty prop;
                this._colTypes[i] = prop = (IDataEntityProperty)rowSet.get(0).getDynamicObjectType().getProperties().get(i);
                this._mapFieldIdx.put(prop.getName(), i);
            }
        }
        catch (Exception sqle) {
            throw new R1PrintDataException(sqle);
        }
    }

    private void cacheData(List<DynamicObject> rowSet) throws R1PrintDataException {
        if (rowSet == null) {
            return;
        }
        try {
            for (int i = 0; i < rowSet.size(); ++i) {
                ArrayList row = this.getRecordOfRow(rowSet.get(i));
                this._cacheRows.add(row);
            }
        }
        catch (IOException e) {
            throw new R1PrintDataException(e);
        }
    }

    private ArrayList getRecordOfRow(DynamicObject rowSet) throws IOException {
        ArrayList<Variant> row = new ArrayList<Variant>();
        for (int i = 0; i < this._colTypes.length; ++i) {
            String value;
            Variant var = new Variant();
            IDataEntityProperty prop = this._colTypes[i];
            if (prop instanceof FlexProp) {
                value = FlexValueFormatUtils.getReportDisplayValue((DynamicObject)rowSet, (FlexProp)((FlexProp)prop));
                var.setObject(value, 17);
            } else if (prop instanceof DateTimeProp) {
                String date = this.getFormatedDate(rowSet, i, prop);
                var.setObject(date);
            } else if (prop instanceof TimeProp) {
                String time = this.getFormatedTime(rowSet, i, prop);
                var.setObject(time);
            } else if (prop instanceof MuliLangTextProp) {
                value = this.getMuliLangText(rowSet, i);
                var.setObject(value);
            } else {
                Class type = prop.getPropertyType();
                if (type == Integer.class) {
                    if (rowSet.get(i) != null) {
                        var.setInteger(Integer.parseInt(rowSet.get(i).toString()));
                    }
                } else if (type == Long.class) {
                    if (rowSet.get(i) != null) {
                        var.setLong((Long)rowSet.get(i));
                    } else {
                        var.setObject(rowSet.get(i));
                    }
                } else if (type == Boolean.TYPE) {
                    var = new Variant(rowSet.getBoolean(i), 8);
                } else if (type == BigDecimal.class) {
                    BigDecimal val = rowSet.getBigDecimal(i);
                    if (val != null) {
                        if (prop instanceof FieldProp) {
                            if (((FieldProp)prop).isZeroShow() || BigDecimal.ZERO.compareTo(val) != 0) {
                                var.setBigDecimal(val);
                            }
                        } else {
                            var.setBigDecimal(val);
                        }
                    } else {
                        var.setObject(val);
                    }
                } else if (type == String.class) {
                    if (prop instanceof TextProp && ((TextProp)prop).isPassword()) {
                        VariantExt variantExt = new VariantExt();
                        variantExt.setCanPrint(Boolean.FALSE);
                        variantExt.setDisplayValue("******");
                        variantExt.setObject(rowSet.getString(i), 11);
                        row.add(variantExt);
                        continue;
                    }
                    var.setObject(rowSet.getString(i), 11);
                } else {
                    var.setObject(rowSet.get(i), 17);
                }
            }
            row.add(var);
        }
        return row;
    }

    private String getMuliLangText(DynamicObject currentObj, int index) {
        OrmLocaleValue localeValue = (OrmLocaleValue)currentObj.get(index);
        return localeValue.toString();
    }

    private String getFormatedTime(DynamicObject currentObj, int index, IDataEntityProperty prop) {
        String result = "";
        if (currentObj.get(index) != null) {
            Integer time = (Integer)currentObj.get(index);
            Integer hour = time / 3600;
            time = time % 3600;
            Integer minutes = time / 60;
            Integer second = time % 60;
            result = (hour < 10 ? "0" : "") + hour + ":" + (minutes < 10 ? "0" : "") + minutes + ":" + (second < 10 ? "0" : "") + second;
        }
        return result;
    }

    private String getFormatedDate(DynamicObject currentObj, int index, IDataEntityProperty prop) {
        String result = "";
        Date oldDate = currentObj.getDate(index);
        if (oldDate != null) {
            IInteService inteService = (IInteService)ServiceFactory.getService(IInteService.class);
            if (ObjectUtils.isEmpty((Object)this.getInteFormatId())) {
                this.setInteFormatId(0L);
            }
            Map format = inteService.getFormat(this.getInteFormatId());
            String dateFormat = (String)format.get("dateFormat");
            Map timeFormat = (Map)format.get(TIME_FORMAT);
            SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
            sdf.setTimeZone(KDDateUtils.getSysTimeZone());
            if (prop instanceof DateProp) {
                result = sdf.format(oldDate);
            } else if (prop instanceof CreateDateProp || prop instanceof ModifyDateProp) {
                sdf = new SimpleDateFormat(dateFormat + " " + (String)timeFormat.get(TIME_FORMAT));
                sdf.setTimeZone(KDDateUtils.getSysTimeZone());
                InteTimeZone sysTz = InteTimeZone.getSysTimeZone();
                result = sysTz.format(oldDate, (DateFormat)sdf);
            } else {
                DateTimeProp dProp = (DateTimeProp)prop;
                if (dProp.getRegionType() == 2) {
                    sdf = new SimpleDateFormat(dateFormat + " " + (String)timeFormat.get(TIME_FORMAT));
                }
                sdf.setTimeZone(KDDateUtils.getSysTimeZone());
                if (InteTimeZone.TransType.OrgTimeZone.equals((Object)InteTimeZone.TransType.get((int)dProp.getTimeZoneTransType()))) {
                    Long relateOrgid = this.getRelateOrgId(currentObj, dProp.getRelateOrg());
                    InteTimeZone orgTz = InteTimeZone.getOrgTimeZone((Long)relateOrgid);
                    result = orgTz.format(oldDate, (DateFormat)sdf);
                } else {
                    result = sdf.format(oldDate);
                }
            }
        }
        return result;
    }

    private Long getRelateOrgId(DynamicObject currentObj, String relateOrg) {
        Long orgId = 0L;
        if (currentObj != null) {
            String orgKey = relateOrg;
            IDataEntityType entityType = currentObj.getDataEntityType();
            if (entityType instanceof MainEntityType) {
                Object org;
                if (StringUtils.isBlank((CharSequence)relateOrg)) {
                    orgKey = ((MainEntityType)entityType).getMainOrg();
                }
                if (StringUtils.isNotBlank((CharSequence)orgKey) && (org = currentObj.get(orgKey)) != null) {
                    orgId = org instanceof Long ? (Long)org : (Long)((DynamicObject)org).getPkValue();
                }
            } else if (entityType instanceof EntryType) {
                if (StringUtils.isNotBlank((CharSequence)relateOrg)) {
                    DynamicProperty orgProp = ((EntryType)entityType).getProperty(relateOrg);
                    if (orgProp != null) {
                        Object org = currentObj.get(orgKey);
                        if (org != null) {
                            orgId = org instanceof Long ? (Long)org : (Long)((DynamicObject)org).getPkValue();
                        }
                    } else {
                        Stream<DynamicObject> st = this.getDataEntities().stream().filter(p -> p.getPkValue().equals(currentObj.getPkValue()));
                        Optional<DynamicObject> opt = st.findFirst();
                        DynamicObject parentObj = null;
                        parentObj = opt.isPresent() ? (DynamicObject)opt.get().getParent() : (DynamicObject)currentObj.getParent();
                        orgId = this.getRelateOrgId(parentObj, relateOrg);
                    }
                } else {
                    Stream<DynamicObject> st = this.getDataEntities().stream().filter(p -> p.getPkValue().equals(currentObj.getPkValue()));
                    Optional<DynamicObject> opt = st.findFirst();
                    DynamicObject parentObj = null;
                    parentObj = opt.isPresent() ? (DynamicObject)opt.get().getParent() : (DynamicObject)currentObj.getParent();
                    orgId = this.getRelateOrgId(parentObj, relateOrg);
                }
            }
        }
        return orgId;
    }

    private ArrayList getRow(int rowIdx) {
        if (rowIdx < 0 || rowIdx >= this.getRowsCount()) {
            if (rowIdx == -1 || rowIdx == this.getRowsCount()) {
                return EmptyRow;
            }
            throw new R1PrintRuntimeException("Row index out of range. " + rowIdx);
        }
        return (ArrayList)this._cacheRows.get(rowIdx);
    }

    Cursor getCurrentCursor() {
        if (this._currentCursor == null) {
            this._currentCursor = new Cursor();
        }
        return this._currentCursor;
    }

    private int getColsCount() {
        return this._colTypes.length;
    }

    private int getFieldIndex(String field) {
        Integer index = -1;
        index = field.toLowerCase(Locale.ENGLISH).endsWith(".seq") ? this._mapFieldIdx.get("seq") : this._mapFieldIdx.get(field.toLowerCase(Locale.ENGLISH));
        if (index != null) {
            return index;
        }
        return -1;
    }

    public int getRowsCount() {
        return this._cacheRows.size();
    }

    public Object getFieldType(String field) {
        int idx = this.getFieldIndex(field);
        if (idx >= 0 && idx < this.getColsCount()) {
            return this._colTypes[idx];
        }
        return null;
    }

    public boolean isBOF() {
        return this.getCurrentCursor().getRowIdx() == -1;
    }

    public boolean isEOF() {
        if (this.isBOF() && !this.hasNext()) {
            return true;
        }
        return this.getCurrentCursor().getRowIdx() >= this.getRowsCount();
    }

    public boolean hasNext() {
        int rc = this.getRowsCount();
        return rc > 0 && this.getCurrentCursor().getRowIdx() < rc - 1;
    }

    public void next() {
        this.getCurrentCursor().next();
    }

    public Variant getFieldData(String field) {
        ArrayList row = this.getRow(this.getCurrentCursor().getRowIdx());
        return this.getRowFieldData(row, field);
    }

    public Variant getPropheticRowFieldData(String field) {
        ArrayList row = this.getRow(this.getCurrentCursor().getRowIdx() + 1);
        return this.getRowFieldData(row, field);
    }

    private Variant getRowFieldData(List row, String field) {
        Variant retVar = Variant.emptyVariant;
        if (row == EmptyRow || StringUtils.isBlank((CharSequence)field)) {
            retVar = Variant.emptyVariant;
        } else if (field.contains(" ")) {
            retVar = this.getCombineVariant(row, field);
        } else {
            int colIdx = this.getFieldIndex(field);
            if (colIdx >= 0) {
                Variant vi = (Variant)row.get(colIdx);
                if (!ObjectUtils.isEmpty((Object)vi.getValue())) {
                    IDataEntityProperty propType = this._colTypes[colIdx];
                    retVar = propType instanceof AttachmentProp ? this.getAttachmentVar(vi) : (propType instanceof MulBasedataProp ? this.getMulBasedataVar(vi.getValue()) : (propType instanceof ItemClassTypeProp ? this.getItemClassTypeVar(vi.getValue()) : vi));
                }
            } else if (field.contains(".")) {
                if (this.dataEntities != null && !this.dataEntities.isEmpty() && ((DynamicObject)this.dataEntities.get(0)).getDataEntityType() instanceof QueryEntityType) {
                    try {
                        retVar = this.getBasedataVariant(row, field);
                    }
                    catch (Exception e) {
                        log.error("\u67e5\u8be2\u5b9e\u4f53\u67e5\u8be2\u6570\u636e\u5f02\u5e38", (Throwable)e);
                    }
                } else {
                    retVar = this.getBasedataVariant(row, field);
                }
            }
        }
        return retVar;
    }

    private Variant getAttachmentVar(Variant vi) {
        Variant retVar = new Variant();
        DynamicObjectCollection collection = (DynamicObjectCollection)vi.getValue();
        StringBuilder builder = new StringBuilder();
        for (DynamicObject dyObj : collection) {
            String name;
            DynamicObject obj = dyObj.getDynamicObject("fbasedataid");
            if (obj == null || (name = obj.getString("name")) == null) continue;
            if (builder.length() == 0) {
                builder.append(name);
                continue;
            }
            builder.append("\n").append(name);
        }
        retVar.setObject(builder.toString(), 11);
        return retVar;
    }

    private Variant getCombineVariant(List row, String field) {
        Variant retVar = Variant.emptyVariant;
        if (field.contains("|") || field.contains("\t")) {
            String[] groupFields = field.split("\\|");
            String combinStr = "";
            for (int i = 0; i < groupFields.length; ++i) {
                Variant item = this.getCombineVariant(row, groupFields[i]);
                if (item == null || item.getValue() == null) continue;
                combinStr = StringUtils.isBlank((CharSequence)combinStr) ? item.getValue().toString() : combinStr + "|" + item.getValue().toString();
            }
            retVar = new Variant(combinStr);
        } else {
            String p = "\"([^\"]*)\"";
            Pattern pa = Pattern.compile(p);
            Matcher ma = pa.matcher(field);
            ArrayList<String> customValues = new ArrayList<String>();
            while (ma.find()) {
                field = field.replace(ma.group(), "**");
                customValues.add(ma.group().replace("\"", ""));
            }
            String[] combinFields = field.split("\\s+");
            String combinStr = "";
            int c = 0;
            for (int i = 0; i < combinFields.length; ++i) {
                String item = combinFields[i];
                if (item.matches("\\*+")) {
                    combinStr = combinStr + (String)customValues.get(c);
                    ++c;
                }
                if (item.contains(".")) {
                    Variant ret = this.getBasedataVariant(row, item.trim());
                    if (ret == null || ret.getValue() == null) continue;
                    if (StringUtils.isBlank((CharSequence)combinStr)) {
                        combinStr = ret.getValue().toString();
                        continue;
                    }
                    combinStr = combinStr + ret.getValue().toString();
                    continue;
                }
                int colIdx = this.getFieldIndex(item);
                if (colIdx < 0) continue;
                Variant vi = (Variant)row.get(colIdx);
                if (!ObjectUtils.isEmpty((Object)vi.getValue())) {
                    IDataEntityProperty propType = this._colTypes[colIdx];
                    if (propType instanceof MulBasedataProp) {
                        vi = this.getMulBasedataVar(vi.getValue());
                    } else if (propType instanceof ItemClassTypeProp) {
                        vi = this.getItemClassTypeVar(vi.getValue());
                    }
                }
                if (vi == null || vi.getValue() == null) continue;
                if (vi.getValue() instanceof BigDecimal) {
                    BigDecimal value = (BigDecimal)vi.getValue();
                    if (StringUtils.isNotBlank((CharSequence)combinStr)) {
                        combinStr = combinStr + value.toPlainString();
                        continue;
                    }
                    combinStr = value.toPlainString();
                    continue;
                }
                combinStr = StringUtils.isNotBlank((CharSequence)combinStr) ? combinStr + vi.getValue().toString() : vi.getValue().toString();
            }
            retVar = new Variant(combinStr);
        }
        return retVar;
    }

    private Variant getItemClassTypeVar(Object itemClassTypeFormId) {
        Variant retVar = Variant.emptyVariant;
        if (StringUtils.isNotBlank((Object)itemClassTypeFormId)) {
            BasedataEntityType ty = (BasedataEntityType)EntityMetadataCache.getDataEntityType((String)itemClassTypeFormId.toString());
            retVar = new Variant();
            retVar.setObject(ty.getDisplayName(), 11);
        }
        return retVar;
    }

    private Variant getMulBasedataVar(Object mulbasedataObjs) {
        ArrayList<String> names = new ArrayList<String>();
        DynamicObjectCollection mulObjs = (DynamicObjectCollection)mulbasedataObjs;
        IDataEntityProperty basedataProp = this.getBaseDataProp(mulObjs);
        if (basedataProp != null) {
            BasedataEntityType basedataDT = (BasedataEntityType)((BasedataProp)basedataProp).getComplexType();
            for (DynamicObject obj : mulObjs) {
                DynamicObject basedataObj = (DynamicObject)basedataProp.getValueFast((Object)obj);
                if (basedataObj == null) continue;
                IDataEntityProperty nameProp = basedataDT.findProperty(basedataDT.getNameProperty());
                this.handBasedataVersionName(basedataObj, basedataDT, nameProp.getName());
                String name = nameProp.getValue((Object)basedataObj).toString();
                if (name == null) continue;
                names.add(name);
            }
        }
        Variant retVar = new Variant();
        retVar.setObject(String.join((CharSequence)",", names), 11);
        return retVar;
    }

    private Variant getBasedataVariant(List row, String field) {
        Variant bsdVar;
        Variant retVar = Variant.emptyVariant;
        String[] fieldArry = field.split("\\.");
        String basedataKey = fieldArry[0];
        String basedataFieldKey = fieldArry[1];
        int colIdx = this.getFieldIndex(basedataKey);
        if (colIdx >= 0 && !ObjectUtils.isEmpty((Object)(bsdVar = (Variant)row.get(colIdx)).getValue())) {
            IDataEntityProperty propType = this._colTypes[colIdx];
            if (propType instanceof ItemClassProp && !(bsdVar.getValue() instanceof DynamicObject)) {
                Variant typeVar;
                Object typeFormid;
                ItemClassProp icProp = (ItemClassProp)propType;
                String typeFieldKey = icProp.getTypePropName();
                int idx = this.getFieldIndex(typeFieldKey);
                if (idx >= 0 && StringUtils.isNotBlank((Object)(typeFormid = (typeVar = (Variant)row.get(idx)).getValue()))) {
                    BasedataEntityType ty = (BasedataEntityType)EntityMetadataCache.getDataEntityType((String)typeFormid.toString());
                    Map rets = BusinessDataReader.loadFromCache((Object[])new Object[]{bsdVar.getValue()}, (DynamicObjectType)ty);
                    DynamicObject obj = (DynamicObject)rets.get(bsdVar.getValue());
                    String fieldKey = basedataFieldKey;
                    if ("number".equals(fieldKey)) {
                        fieldKey = ty.getNumberProperty();
                    } else if ("name".equals(basedataFieldKey)) {
                        fieldKey = ty.getNameProperty();
                        this.handBasedataVersionName(obj, ty, fieldKey);
                    }
                    if (obj != null && (ty.getNameProperty().equalsIgnoreCase(fieldKey) || ty.getNumberProperty().equalsIgnoreCase(fieldKey))) {
                        retVar = new Variant();
                        retVar.setObject(obj.get(fieldKey));
                    }
                }
            } else {
                DynamicObject basedataObj = (DynamicObject)bsdVar.getValue();
                BasedataProp mpop = (BasedataProp)propType;
                BasedataEntityType fullType = (BasedataEntityType)EntityMetadataCache.getDataEntityType((String)mpop.getBaseEntityId());
                String key = field.substring(field.indexOf(46) + 1, field.length());
                if (StringUtils.equals((CharSequence)key, (CharSequence)fullType.getNameProperty())) {
                    this.handBasedataVersionName(basedataObj, fullType, key);
                }
                Object rv = this.getLoopBsdFieldValue(basedataObj, key, (EntityType)fullType);
                retVar = new Variant();
                retVar.setObject(rv, 11);
                return retVar;
            }
        }
        return retVar;
    }

    private void handBasedataVersionName(DynamicObject basedataObj, BasedataEntityType fullType, String key) {
        if (!this.basedataVersionManager.isEnableBaseVersion()) {
            return;
        }
        try {
            DynamicObject headObj = this.getDataEntity();
            if (headObj == null) {
                headObj = (DynamicObject)this.getDataEntities().get(this._currentCursor.getRowIdx());
            }
            if (headObj == null) {
                return;
            }
            Optional<Object> versionName = this.basedataVersionManager.getVersionName(headObj, fullType, basedataObj);
            if (versionName.isPresent()) {
                basedataObj.set(key, versionName.get());
            }
        }
        catch (Exception ignore) {
            log.error("\u6253\u5370\u7248\u672c\u5316\u5904\u7406\u5931\u8d25", (Throwable)ignore);
        }
    }

    private Object getLoopBsdFieldValue(DynamicObject basedataObj, String fieldName, EntityType bsdType) {
        if (!fieldName.contains(".")) {
            IDataEntityProperty propType = bsdType.findProperty(fieldName);
            if (propType == null || basedataObj == null) {
                return "";
            }
            if (propType instanceof MulBasedataProp) {
                DynamicObjectCollection v = (DynamicObjectCollection)propType.getValue((Object)basedataObj);
                StringBuilder s = new StringBuilder();
                for (DynamicObject d : v) {
                    s.append(d.getDynamicObject("fbasedataid").getString("name")).append(",");
                }
                return s.toString().substring(0, s.toString().lastIndexOf(","));
            }
            return propType.getValue((Object)basedataObj);
        }
        String[] fieldArry = fieldName.split("\\.");
        String key = fieldName.substring(fieldName.indexOf(46) + 1, fieldName.length());
        IDataEntityProperty propType = bsdType.findProperty(fieldArry[0]);
        if (propType instanceof EntryProp) {
            DynamicObjectCollection entryObjs = (DynamicObjectCollection)propType.getValue((Object)basedataObj);
            if (entryObjs != null && !entryObjs.isEmpty()) {
                IDataEntityType ety = ((EntryProp)propType).getItemType();
                return this.getLoopBsdFieldValue((DynamicObject)entryObjs.get(0), key, (EntityType)((EntryType)ety));
            }
            return "";
        }
        BasedataProp mpop = (BasedataProp)propType;
        if (mpop == null) {
            return "";
        }
        BasedataEntityType fullType = (BasedataEntityType)EntityMetadataCache.getDataEntityType((String)mpop.getBaseEntityId());
        Object obj = mpop.getValue((Object)basedataObj);
        return this.getLoopBsdFieldValue((DynamicObject)obj, key, (EntityType)fullType);
    }

    private IDataEntityProperty getBaseDataProp(DynamicObjectCollection mulObjs) {
        IDataEntityProperty basedataProp = null;
        for (IDataEntityProperty prop : mulObjs.getDynamicObjectType().getProperties()) {
            if (!(prop instanceof BasedataProp)) continue;
            basedataProp = prop;
            break;
        }
        return basedataProp;
    }

    public Variant getPreviousRowFieldData(String field) {
        int preRowIdx = 0;
        if (this.getCurrentCursor().getRowIdx() != 0) {
            preRowIdx = this.getCurrentCursor().getRowIdx() - 1;
        }
        ArrayList row = this.getRow(preRowIdx);
        return this.getRowFieldData(row, field);
    }

    public void secondSpring() {
        this.getCurrentCursor()._rowIdx = -1;
    }

    public DynamicObject getDataEntity() {
        return this.dataEntity;
    }

    public void setDataEntity(DynamicObject dataEntity) {
        this.dataEntity = dataEntity;
    }

    static class Cursor {
        private int _rowIdx = -1;

        Cursor() {
        }

        public int getRowIdx() {
            return this._rowIdx;
        }

        public void next() {
            ++this._rowIdx;
        }
    }
}

