/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.print.engine.data;

import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.common.variant.VariantExt;
import com.kingdee.bos.ctrl.helper.ExportContext;
import com.kingdee.bos.ctrl.reportone.r1.print.data.AbstractDataProcessor;
import com.kingdee.bos.ctrl.reportone.r1.print.data.IPrintDataProvider;
import com.kingdee.bos.ctrl.reportone.r1.print.data.SystemR1PrintDataParameter;
import com.kingdee.bos.ctrl.reportone.r1.print.data.SystemR1PrintDataSource;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.data.AbstractInteriorDataProviderFactory;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.data.MultiCursorRowSet;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.exception.R1PrintDataException;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.exception.R1PrintRuntimeException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.args.SensitiveArgs;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.svc.util.print.PrintDesensitive;

public class R1PDataVisitor {
    private static final Log log = LogFactory.getLog(R1PDataVisitor.class);
    private SystemR1PrintDataSource _ds;
    private IPrintDataProvider _dataProvider;
    private AbstractInteriorDataProviderFactory _interiorDataProviderFactory;
    private MultiCursorRowSet _multiCursorRowSet;
    private MainEntityType entityType;
    private ArrayList<R1PDataVisitor> _relativeDatas;
    private SensitiveArgs sensitiveArgs;
    private boolean _dataChanged;

    public R1PDataVisitor(SystemR1PrintDataSource ds) {
        this._ds = ds;
        this._dataChanged = true;
        String dsType = ds.getDsType();
        if ("1".equals(dsType) || "2".equals(dsType) || "3".equals(dsType) || "9".equals(dsType) || "7".equals(dsType)) {
            this.entityType = EntityMetadataCache.getDataEntityType((String)this._ds.getQueryEntityId());
        }
    }

    private R1PDataVisitor() {
    }

    public static R1PDataVisitor create(List<DynamicObject> rowSet) throws R1PrintDataException {
        R1PDataVisitor dataVisitor = new R1PDataVisitor();
        dataVisitor._multiCursorRowSet = new MultiCursorRowSet(rowSet, dataVisitor._dataProvider.getDataEntities(), dataVisitor._dataProvider.getInteFormatId());
        dataVisitor._dataChanged = false;
        return dataVisitor;
    }

    public void reInitialize() {
        this._dataChanged = true;
    }

    public void setDelegate(IPrintDataProvider dataProvider) {
        this._dataProvider = dataProvider;
        this._dataChanged = true;
    }

    public void setInteriorImpl(AbstractInteriorDataProviderFactory dataProviderFactory) {
        this._interiorDataProviderFactory = dataProviderFactory;
        this._dataChanged = true;
    }

    public boolean isDataChanged() {
        return this._dataChanged;
    }

    private boolean init() throws R1PrintDataException {
        if (this._dataChanged) {
            this._dataChanged = false;
            this.execute();
            return true;
        }
        return false;
    }

    private void execute() throws R1PrintDataException {
        IPrintDataProvider dataProvider = null;
        if (this._interiorDataProviderFactory != null) {
            dataProvider = this._interiorDataProviderFactory.getUsableDataProvider(this._ds, this._dataProvider);
        }
        if (dataProvider == null) {
            dataProvider = this._dataProvider;
        }
        if (dataProvider != null) {
            List<DynamicObject> rowSet;
            StringBuilder sbInfo = new StringBuilder("DataProvider execute. ");
            sbInfo.append(this._ds.getLogString());
            log.debug(sbInfo.toString());
            log.debug("DataProvider is: " + dataProvider.getClass().getName());
            long time = System.currentTimeMillis();
            try {
                rowSet = dataProvider.getData(this._ds);
            }
            catch (Exception e) {
                throw new KDException((Throwable)e, BosErrorCode.printFailed, new Object[]{e});
            }
            time = System.currentTimeMillis() - time;
            sbInfo.insert(0, "After ");
            sbInfo.append(", Used time: ");
            sbInfo.append(time);
            log.debug(sbInfo.toString());
            if (this._interiorDataProviderFactory != null) {
                AbstractDataProcessor dp = this._interiorDataProviderFactory.getSpecialDataProcessor(this._ds);
                rowSet = this.process(rowSet, dp);
                dp = this._interiorDataProviderFactory.getDataProcessor(this._ds);
                rowSet = this.process(rowSet, dp);
            }
            if (rowSet == null) {
                throw new R1PrintDataException("R1Print getData from DataProvider error\uff1arowset is null.");
            }
            this._multiCursorRowSet = new MultiCursorRowSet(rowSet, dataProvider.getDataEntities(), dataProvider.getInteFormatId());
            this._multiCursorRowSet.setDataEntity(dataProvider.getDataEntity());
        }
    }

    private List<DynamicObject> process(List<DynamicObject> rowSet, AbstractDataProcessor dp) {
        if (dp != null) {
            long time = System.currentTimeMillis();
            try {
                rowSet = dp.process(rowSet, this._ds);
            }
            catch (Exception e) {
                log.error("Data processing error. Class: " + dp.getClass(), (Throwable)e);
            }
            time = System.currentTimeMillis() - time;
            log.debug("Data processed, Used time: " + time);
        }
        return rowSet;
    }

    private ArrayList<R1PDataVisitor> getRelativeDatas() {
        if (this._relativeDatas == null) {
            this._relativeDatas = new ArrayList();
        }
        return this._relativeDatas;
    }

    public void addRelativeDataVisitor(R1PDataVisitor relativeData) {
        if (!this.getRelativeDatas().contains(relativeData)) {
            this.getRelativeDatas().add(relativeData);
        }
    }

    private void notifyRelativeData() throws R1PrintDataException {
        if (this._relativeDatas != null) {
            Object[] relativeDatas = this._relativeDatas.toArray();
            for (int i = relativeDatas.length - 1; i >= 0; --i) {
                ((R1PDataVisitor)relativeDatas[i]).updateParam(this);
            }
        }
    }

    private void updateParam(R1PDataVisitor masterData) throws R1PrintDataException {
        SystemR1PrintDataParameter p = (SystemR1PrintDataParameter)this._ds.getAssociateParameter();
        if (masterData._ds.getId().equals(p.getAssociateSource())) {
            Variant var = null;
            String associateField = p.getAssociateField();
            if (associateField.contains("&")) {
                associateField = StringUtils.substringBefore((String)associateField, (String)"&");
            }
            if ((var = masterData.isBOF() ? masterData.getPropheticRowFieldData(associateField) : masterData.getFieldData(associateField)) == null && p.getValue() == null) {
                return;
            }
            if (var != null && var.getValue() != null && p.getValue() != null && ((Variant)p.getValue()).getValue() != null && var.compareTo((Variant)p.getValue()) == 0) {
                return;
            }
            p.setValue(var);
            this._dataChanged = true;
            this.notifyRelativeData();
        }
    }

    public Object getFieldType(String field) throws R1PrintDataException {
        this.init();
        return this._multiCursorRowSet.getFieldType(field);
    }

    public int getRowsCount() throws R1PrintDataException {
        this.init();
        return this._multiCursorRowSet.getRowsCount();
    }

    public boolean isBOF() throws R1PrintDataException {
        this.init();
        return this._multiCursorRowSet.isBOF();
    }

    public boolean isEOF() throws R1PrintDataException {
        this.init();
        return this._multiCursorRowSet.isEOF();
    }

    public boolean hasNext() throws R1PrintDataException {
        this.init();
        return this._multiCursorRowSet.hasNext();
    }

    public boolean next() throws R1PrintDataException {
        this.init();
        if (!this._multiCursorRowSet.isEOF()) {
            this._multiCursorRowSet.next();
            this.notifyRelativeData();
            return true;
        }
        throw new R1PrintRuntimeException("Can not next when data set isEOF.");
    }

    public Variant getFieldData(String field) throws R1PrintDataException {
        String desensitizeVal;
        Object desensitizeObj;
        this.init();
        Variant fieldData = this._multiCursorRowSet.getFieldData(field);
        if (!fieldData.isCanPrint()) {
            return fieldData;
        }
        if (this.entityType == null || field == null) {
            return fieldData;
        }
        String realField = this.getRealField(field);
        if (!this.isCanPrint(realField)) {
            VariantExt variant = new VariantExt();
            variant.setObject(fieldData.getValue(), fieldData.getVt());
            variant.setCanPrint(Boolean.FALSE);
            return variant;
        }
        if (this.sensitiveArgs != null && this.sensitiveArgs.contain(realField) && Objects.nonNull(fieldData.getValue())) {
            String fieldVal = fieldData.getValue().toString();
            VariantExt variant = new VariantExt();
            variant.setObject(fieldData.getValue(), fieldData.getVt());
            variant.setCanPrint(Boolean.FALSE);
            SensitiveArgs.SensitiveRule rule = this.sensitiveArgs.getRule(realField);
            if (rule != null && Pattern.matches(rule.regex, fieldVal)) {
                String displayVal = fieldVal.replaceAll(rule.regex, rule.replacement);
                variant.setDisplayValue(displayVal);
            } else {
                String displayVal = this.sensitiveArgs.getDesensitiveFun().handle(realField, fieldVal);
                variant.setDisplayValue(displayVal);
            }
            return variant;
        }
        String oriVal = "";
        if (Objects.nonNull(fieldData.getValue())) {
            oriVal = fieldData.getValue().toString();
        }
        String formId = this.entityType.getName();
        String localeId = ExportContext.get().getLocalLang(formId);
        if (localeId == null) {
            localeId = this._dataProvider.getPrintLang(formId).toString();
        }
        if ((desensitizeObj = PrintDesensitive.desensitize((String)formId, (String)realField, (String)localeId, (Object)oriVal)) != null && !StringUtils.equals((CharSequence)oriVal, (CharSequence)(desensitizeVal = desensitizeObj.toString()))) {
            VariantExt variant = new VariantExt();
            variant.setObject(fieldData.getValue(), fieldData.getVt());
            variant.setCanPrint(Boolean.FALSE);
            variant.setDisplayValue(desensitizeVal);
            return variant;
        }
        return fieldData;
    }

    private long getMainOrgId() {
        long orgId = 0L;
        String mainOrg = this.entityType.getMainOrg();
        if (StringUtils.isNotBlank((CharSequence)mainOrg)) {
            Object mainOrgObj = null;
            if (this._multiCursorRowSet.getDataEntity() != null && this.entityType.equals((Object)this._multiCursorRowSet.getDataEntity().getDataEntityType())) {
                mainOrgObj = this._multiCursorRowSet.getDataEntity().get(mainOrg);
            } else {
                Variant mainOrgField = this._multiCursorRowSet.getFieldData(mainOrg);
                if (mainOrgField.isEmpty() || mainOrgField.isNull()) {
                    mainOrgField = this._multiCursorRowSet.getFieldData(mainOrg + ".id");
                }
                if (!mainOrgField.isEmpty() && !mainOrgField.isNull()) {
                    mainOrgObj = mainOrgField.getValue();
                }
            }
            if (mainOrgObj != null) {
                orgId = mainOrgObj instanceof DynamicObject ? (Long)((DynamicObject)mainOrgObj).getPkValue() : Long.parseLong(mainOrgObj.toString());
            }
        }
        return orgId;
    }

    private boolean isCanPrint(String realField) {
        long orgId = this.getMainOrgId();
        String[] fieldArr = realField.split("\\.");
        return this._dataProvider.isCanPrint(this.entityType.getName(), orgId, fieldArr[0]);
    }

    private String getRealField(String field) {
        String dsType = this._ds.getDsType();
        if ("9".equals(dsType)) {
            Map allEntities = this.entityType.getAllEntities();
            Iterator iterator = allEntities.keySet().iterator();
            while (iterator.hasNext()) {
                field = field.replace((String)iterator.next() + ".", "");
            }
        }
        return field;
    }

    public Variant getPropheticRowFieldData(String field) throws R1PrintDataException {
        this.init();
        return this._multiCursorRowSet.getPropheticRowFieldData(field);
    }

    public Variant getPreviousRowFieldData(String field) throws R1PrintDataException {
        this.init();
        return this._multiCursorRowSet.getPreviousRowFieldData(field);
    }

    public int getCurrentPositon() {
        return this._multiCursorRowSet.getCurrentCursor().getRowIdx();
    }

    public void secondSpring() throws R1PrintDataException {
        if (!this.init()) {
            this._multiCursorRowSet.secondSpring();
        }
    }

    public void setSensitiveArgs(SensitiveArgs sensitiveArgs) {
        this.sensitiveArgs = sensitiveArgs;
    }

    public MainEntityType getEntityType() {
        return this.entityType;
    }
}

