/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.print.engine.exporter;

import com.kingdee.bos.ctrl.print.ui.component.IPainter;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.common.ObjFactory;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.common.node.ExportException;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.exporter.AR1PNode_W2V;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.IPrintWidget;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class R1PrintW2VExporter {
    private ObjFactory _objFactory;
    private static final Log log = LogFactory.getLog(R1PrintW2VExporter.class);
    private HashMap _cacheFactory = new HashMap();

    public R1PrintW2VExporter() throws ExportException {
        String config = "/R1PrintWidget2View.xml";
        try (InputStream in = this.getClass().getResourceAsStream(config);){
            if (in == null) {
                throw new ExportException("ObjectFactory config xml not found:" + config);
            }
            this._objFactory = new ObjFactory();
            try {
                this._objFactory.loadTypesConfig(in);
            }
            catch (Exception ex) {
                ExportException.makeException(ex);
            }
        }
        catch (IOException e) {
            log.error("IOException", (Throwable)e);
        }
    }

    private AR1PNode_W2V getTranslater(IPrintWidget node) {
        String key = node.getType();
        Object objNodeTranslater = this._cacheFactory.get(key);
        if (objNodeTranslater == null) {
            objNodeTranslater = this._objFactory.newObject(key);
            this._cacheFactory.put(key, objNodeTranslater);
        }
        return (AR1PNode_W2V)objNodeTranslater;
    }

    public IPainter translate(IPrintWidget widget) {
        AR1PNode_W2V translater = this.getTranslater(widget);
        translater.setExporter(this);
        translater.setNode(widget);
        return translater.exporting();
    }
}

