/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.print.engine.exporter.impl;

import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.print.ui.component.Canvas;
import com.kingdee.bos.ctrl.print.ui.component.IPainter;
import com.kingdee.bos.ctrl.print.util.KDPrinterUtils;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.exporter.AR1PNode_W2V;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.exporter.impl.ContainerNode_W2V;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.exporter.impl.StringNode_W2V;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.view.R1PLabelCell;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.AbstractPrintWidgetText;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.IPrintWidget;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.StyleAccess;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.datagrid.AbstractPWDataGridRow;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.datagrid.PWDataGrid;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.datagrid.PWDataGridCell;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.datagrid.PWDataGridColumn;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.datagrid.PWDetailRow;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.datagrid.PWGroupRow;
import java.awt.Rectangle;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.util.StringUtils;

public class R1PDataGrid_W2V
extends AR1PNode_W2V {
    @Override
    protected IPainter createViewt(IPrintWidget node) {
        return new Canvas();
    }

    @Override
    protected void exportSpecial(IPrintWidget widget, IPainter view) {
        StringNode_W2V cell_string_W2V = new StringNode_W2V();
        ContainerNode_W2V cell_container_W2V = new ContainerNode_W2V();
        cell_container_W2V.setExporter(this.getExporter());
        PWDataGrid dataGrid = (PWDataGrid)widget;
        int sink = dataGrid.getExtProps().getInt("sinkToBottom", -1);
        AbstractPWDataGridRow firstDetailRow = null;
        int startRowIdx = 0;
        for (int r = 0; r < dataGrid.getOutputRows().size(); ++r) {
            AbstractPWDataGridRow fr = dataGrid.getOutputRows().get(r);
            if (!(fr instanceof PWDetailRow)) continue;
            firstDetailRow = fr;
            startRowIdx = r + 1;
            break;
        }
        List<IPrintWidget> optCols = dataGrid.getOutputColumns();
        for (int c = 0; c < optCols.size(); ++c) {
            PWDataGridColumn col = (PWDataGridColumn)optCols.get(c);
            if (!col.isMergeDetailCol()) continue;
            ArrayList<Integer> sumIdxList = new ArrayList<Integer>();
            if (col.getSumColKeys() != null && !col.getSumColKeys().isEmpty()) {
                for (int i = 0; i < optCols.size(); ++i) {
                    PWDataGridColumn match = (PWDataGridColumn)optCols.get(i);
                    if (col.getId().equalsIgnoreCase(match.getId()) || !col.getSumColKeys().contains(match.getId())) continue;
                    sumIdxList.add(i);
                }
            }
            this.mergeCell(firstDetailRow, dataGrid.getOutputRows(), startRowIdx, c, sumIdxList);
        }
        Canvas canvas = (Canvas)view;
        int addedX = 0;
        int addedY = 0;
        int rc = dataGrid.getOutputRows().size();
        for (int r = 0; r < rc; ++r) {
            AbstractPWDataGridRow row = dataGrid.getOutputRows().get(r);
            if (sink > 0 && row.getExtProps().getBoolean("sinkToBottom", false)) {
                addedY += sink;
                sink = -1;
            }
            List<IPrintWidget> cols = dataGrid.getOutputColumns();
            addedX = 0;
            int cc = cols.size();
            for (int c = 0; c < cc; ++c) {
                PWDataGridColumn col = (PWDataGridColumn)cols.get(c);
                PWDataGridCell cell = row.getCell(c);
                if (cell != null && !cell.isHide() && col.isPrintable()) {
                    IPainter cellView;
                    R1PDataGrid_W2V.dealStyle(dataGrid, row, col, cell, r, c);
                    if (cell.hasChildren()) {
                        cell_container_W2V.setNode(cell);
                        cellView = cell_container_W2V.exporting();
                    } else {
                        cell_string_W2V.setNode(cell);
                        cellView = cell_string_W2V.exporting();
                        if (cellView instanceof R1PLabelCell) {
                            ((R1PLabelCell)cellView).setCurrencyColumnSupport(cell.getExtProps().getBoolean("currencyColumn", true));
                        }
                    }
                    cellView.setPainterLocation((float)KDPrinterUtils.lomToPrintPoint(addedX), (float)KDPrinterUtils.lomToPrintPoint(addedY));
                    canvas.addPainter(cellView);
                }
                if (!col.isPrintable()) continue;
                addedX += col.getWidth();
            }
            addedY += row.getHeight();
        }
        canvas.setPainterSize((float)KDPrinterUtils.lomToPrintPoint(addedX) + 1.0f, (float)KDPrinterUtils.lomToPrintPoint(addedY) + 1.0f);
    }

    private void mergeCell(AbstractPWDataGridRow currentRow, List<AbstractPWDataGridRow> outputRows, int startRowIdx, int mergeColIdx, List<Integer> sumIdxs) {
        if (currentRow == null || currentRow instanceof PWGroupRow) {
            return;
        }
        String text = "";
        PWDataGridCell firstCell = currentRow.getCell(mergeColIdx);
        if (firstCell != null) {
            PWDataGridCell widgetText = firstCell;
            text = widgetText.getOutputText();
        }
        if (StringUtils.isBlank((String)text)) {
            AbstractPWDataGridRow nextRow = null;
            if (outputRows.get(startRowIdx) != null) {
                nextRow = outputRows.get(startRowIdx);
            }
            this.mergeCell(nextRow, outputRows, startRowIdx + 1, mergeColIdx, sumIdxs);
        }
        HashMap<Integer, PWDataGridCell> sumOris = new HashMap<Integer, PWDataGridCell>();
        for (int ix : sumIdxs) {
            PWDataGridCell sumCell = currentRow.getCell(ix);
            if (sumCell == null) continue;
            PWDataGridCell sumCellText = sumCell;
            sumOris.put(ix, sumCellText);
        }
        boolean skipGroupRow = false;
        int breakIdx = 0;
        for (int r = startRowIdx; r < outputRows.size(); ++r) {
            PWDataGridCell cell;
            AbstractPWDataGridRow row = outputRows.get(r);
            if (row instanceof PWGroupRow) {
                skipGroupRow = true;
                continue;
            }
            if (skipGroupRow) {
                breakIdx = r;
                break;
            }
            if (!(row instanceof PWDetailRow) || (cell = row.getCell(mergeColIdx)) == null) continue;
            PWDataGridCell widgetText = cell;
            String currentText = widgetText.getOutputText();
            if (text.equalsIgnoreCase(currentText)) {
                int newHeight = firstCell.getRectangle().height + cell.getRectangle().height;
                Rectangle rect = new Rectangle(firstCell.getRectangle().width, newHeight);
                firstCell.setRectangle(rect);
                cell.setHide(true);
                for (Map.Entry entry : sumOris.entrySet()) {
                    Rectangle rect2;
                    int newHeight2;
                    int sumColIdx = (Integer)entry.getKey();
                    AbstractPrintWidgetText sumCell = (AbstractPrintWidgetText)entry.getValue();
                    String firstOri = sumCell.getOriValue();
                    if (sumColIdx <= -1) continue;
                    PWDataGridCell curtCell = row.getCell(sumColIdx);
                    String ori = curtCell.getOriValue();
                    if (StringUtils.isNotEmpty((String)ori)) {
                        if (!R1PDataGrid_W2V.isDecimal(ori)) continue;
                        newHeight2 = sumCell.getRectangle().height + curtCell.getRectangle().height;
                        rect2 = new Rectangle(sumCell.getRectangle().width, newHeight2);
                        sumCell.setRectangle(rect2);
                        BigDecimal firstBd = new BigDecimal(0);
                        if (StringUtils.isNotEmpty((String)firstOri)) {
                            firstBd = new BigDecimal(firstOri);
                        }
                        BigDecimal bd = new BigDecimal(ori);
                        BigDecimal newVal = firstBd.add(bd);
                        Variant newVit = new Variant(newVal);
                        sumCell.setOriValue(newVal.toString());
                        sumCell.setValue(newVit);
                        sumCell.formatOutput();
                        curtCell.setHide(true);
                        continue;
                    }
                    newHeight2 = sumCell.getRectangle().height + curtCell.getRectangle().height;
                    rect2 = new Rectangle(sumCell.getRectangle().width, newHeight2);
                    sumCell.setRectangle(rect2);
                    curtCell.setHide(true);
                }
                continue;
            }
            breakIdx = r;
            break;
        }
        if (breakIdx > 0) {
            AbstractPWDataGridRow nextRow = outputRows.get(breakIdx);
            this.mergeCell(nextRow, outputRows, breakIdx + 1, mergeColIdx, sumIdxs);
        }
    }

    private static boolean isDecimal(String str) {
        String regex = "^\\d*\\.\\d+|\\d+\\.\\d*$";
        Pattern pattern = Pattern.compile(regex);
        Matcher match = pattern.matcher(str);
        return match.matches();
    }

    private static void dealStyle(PWDataGrid dataGrid, AbstractPWDataGridRow currentRow, PWDataGridColumn currentCol, PWDataGridCell currentCell, int rowIdx, int colIdx) {
        boolean isLastAtRow = true;
        int c = dataGrid.getOutputColumns().size();
        for (int j = colIdx + 1; j < c; ++j) {
            if (currentRow.getCell(j) == null || !dataGrid.getOutputColumn(j).isPrintable()) continue;
            isLastAtRow = false;
            break;
        }
        int rowBorderTag = colIdx == 0 ? (isLastAtRow ? 4369 : 4881) : (isLastAtRow ? 12561 : 13073);
        boolean isLastAtCol = true;
        int c2 = dataGrid.getOutputRows().size();
        for (int j = rowIdx + 1; j < c2; ++j) {
            if (dataGrid.getOutputRow(j).getCell(colIdx) == null) continue;
            isLastAtCol = false;
            break;
        }
        int colBorderTag = rowIdx == 0 ? (isLastAtCol ? 4369 : 4371) : (isLastAtCol ? 4401 : 4403);
        StyleAccess styleAccess = currentCell.getStyleAccess();
        styleAccess.merge(currentRow.getStyleAccess(), rowBorderTag);
        styleAccess.merge(currentCol.getStyleAccess(), colBorderTag);
        styleAccess.merge(dataGrid.getStyleAccess(), colBorderTag | rowBorderTag);
    }
}

