/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.print.engine.exporter.impl;

import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.print.ui.component.IPainter;
import com.kingdee.bos.ctrl.print.ui.component.ImageCell;
import com.kingdee.bos.ctrl.print.ui.view.ImageCellView;
import com.kingdee.bos.ctrl.reportone.r1.print.common.ImageUtil;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.exporter.AR1PNode_W2V;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.IPrintWidget;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.PWPicture;
import java.awt.Image;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.SQLException;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class R1PPicture_W2V
extends AR1PNode_W2V {
    private static final Log log = LogFactory.getLog(R1PPicture_W2V.class);

    @Override
    protected IPainter createViewt(IPrintWidget node) {
        return new ImageCell();
    }

    @Override
    protected void exportSpecial(IPrintWidget widget, IPainter view) {
        PWPicture widgetPicture = (PWPicture)widget;
        ImageCell imageCell = (ImageCell)view;
        Variant outputValue = widgetPicture.getOutputValue();
        if (outputValue != null) {
            Object value = outputValue.getValue();
            if (value instanceof String) {
                imageCell.setImageKey((String)value);
            }
            if (imageCell.getPainterView() instanceof ImageCellView) {
                imageCell.setImage(R1PPicture_W2V.loadImage(value));
            }
            imageCell.setScale(widgetPicture.getScaleType());
        }
    }

    public static Image loadImage(Object value) {
        if (value != null) {
            byte[] imageData = null;
            if (value instanceof byte[]) {
                imageData = (byte[])value;
            } else if (value instanceof Blob) {
                imageData = R1PPicture_W2V.blobToBytes((Blob)value);
            } else if (value instanceof String && StringUtils.isNotBlank((Object)value)) {
                imageData = ImageUtil.getImageByUrl((String)value);
            }
            if (imageData != null) {
                return ImageUtil.makeImage(imageData);
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static byte[] blobToBytes(Blob blob) {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
             InputStream is = blob.getBinaryStream();){
            if (is == null) return new byte[0];
            byte[] c = new byte[1024];
            int len = 0;
            while ((len = is.read(c, 0, c.length)) != -1) {
                baos.write(c, 0, len);
            }
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (SQLException sqlEx) {
            log.error((Throwable)sqlEx);
            return new byte[0];
        }
        catch (IOException ioEx) {
            log.error((Throwable)ioEx);
        }
        return new byte[0];
    }
}

