/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.print.engine.importer.impl;

import com.kingdee.bos.ctrl.reportone.r1.common.designercore.data.Field;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.IReportObject;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.AbstractCell;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.AbstractColumn;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.AbstractRow;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.IGridsFactory;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.biz.AbstractDetailRow;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.biz.AbstractGroupRow;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.cellvalue.CellField;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.cellvalue.ICellValue;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.cellvalue.StatField;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.cellvalue.Text;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.merge.MergeBlock;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.util.MergeUtil;
import com.kingdee.bos.ctrl.reportone.r1.print.common.gridcompute.AbstractExpr;
import com.kingdee.bos.ctrl.reportone.r1.print.common.gridcompute.ICompositeExpr;
import com.kingdee.bos.ctrl.reportone.r1.print.common.gridcompute.VExpr;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.element.grid.datagrid.DataGrid;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.element.grid.datagrid.DataGridCell;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.element.grid.datagrid.DataGridDetailRow;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.element.grid.datagrid.DataGridExtendRow;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.element.grid.datagrid.DataGridFactory;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.element.grid.datagrid.IDataGridRow;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.element.grid.datagrid.IDisplayEveryPage;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.element.grid.datagrid.R1PrintGroup;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.element.grid.datagrid.cellvalue.GridCompute;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.importer.AR1PNode_D2W;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.IPrintWidget;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.datagrid.AbstractPWDataGridRow;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.datagrid.GroupDesc;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.datagrid.PWDataGrid;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.datagrid.PWDataGridCell;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.datagrid.PWDataGridColumn;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.datagrid.PWDetailRow;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.datagrid.PWGroupRow;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.datagrid.cellvalue.CellValueCompute;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.datagrid.cellvalue.CellValueField;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.datagrid.cellvalue.CellValueStat;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.datagrid.cellvalue.CellValueText;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import kd.bos.entity.plugin.args.DynamicColumnArgs;
import kd.bos.entity.print.DynamicColumn;
import kd.bos.entity.print.GridHeader;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class R1PDataGrid_D2W
extends AR1PNode_D2W {
    private static Log log = LogFactory.getLog(R1PDataGrid_D2W.class);

    @Override
    protected IPrintWidget createWidget(IReportObject node) {
        return new PWDataGrid();
    }

    @Override
    protected void importSpecial(IReportObject design, IPrintWidget widget) {
        DataGrid designGrid = (DataGrid)design;
        PWDataGrid widgetGrid = (PWDataGrid)widget;
        widgetGrid.setDatasource(designGrid.getDataSource().getDs());
        widgetGrid.setSubGrid(designGrid.isSubGrid());
        this.analysisDynamicColumns(widgetGrid, designGrid);
        int lc = designGrid.getColumnsCount();
        for (int j = 0; j < lc; ++j) {
            AbstractColumn designCol = designGrid.getColumn(j);
            PWDataGridColumn widgetCol = widgetGrid.addColumn();
            widgetCol.setMergeDetailCol(designCol.isMergeDetailCol());
            R1PDataGrid_D2W.importElementCommon(designCol, widgetCol);
            widgetCol.setWidth(designCol.getWidthLom());
        }
        ArrayList<String> listGroupDesc = new ArrayList<String>();
        listGroupDesc.add(null);
        int rc = designGrid.getRowsCount();
        for (int i = 0; i < rc; ++i) {
            AbstractPWDataGridRow widgetRow;
            AbstractRow designRow = designGrid.getRow(i);
            if (designRow instanceof AbstractDetailRow) {
                if (designRow instanceof DataGridExtendRow) {
                    widgetRow = widgetGrid.addRow(3);
                } else {
                    widgetRow = widgetGrid.addRow(2);
                    if (designRow instanceof DataGridDetailRow) {
                        DataGridDetailRow dRow = (DataGridDetailRow)designRow;
                        if (dRow.isBackwardForward()) {
                            widgetRow.setGroupLevel(listGroupDesc.size() - 1);
                        } else {
                            widgetRow.setGroupLevel(listGroupDesc.size());
                            int repeatTimes = dRow.getRepeatTimes();
                            ((PWDetailRow)widgetRow).setRepeatAtPage(repeatTimes);
                        }
                        ((PWDetailRow)widgetRow).setNotBlankRow(dRow.isNotBlankRow());
                    }
                }
            } else {
                R1PrintGroup group;
                widgetRow = widgetGrid.addRow(1);
                PWGroupRow groupRow = (PWGroupRow)widgetRow;
                if (designRow instanceof IDisplayEveryPage) {
                    IDisplayEveryPage ipage = (IDisplayEveryPage)((Object)designRow);
                    boolean isAppearEveryPage = ipage.isDisplayEveryPage();
                    groupRow.setAppearEveryPage(isAppearEveryPage);
                }
                String groupField = null;
                boolean isDividePageWhenDifferentGroup = false;
                if (designRow instanceof AbstractGroupRow && (group = (R1PrintGroup)((AbstractGroupRow)designRow).getGroup()) != null) {
                    groupField = group.getAccording();
                    isDividePageWhenDifferentGroup = group.isDividePageWhenDifferGroup();
                }
                GroupDesc groupDesc = new GroupDesc();
                groupDesc.setGroupField(groupField);
                groupDesc.setDividePageWhenDifferent(isDividePageWhenDifferentGroup);
                groupRow.setGroupDesc(groupDesc);
                if (listGroupDesc.contains(groupField)) {
                    int level = listGroupDesc.indexOf(groupField);
                    groupRow.setGroupLevel(level);
                } else {
                    listGroupDesc.add(groupField);
                    groupRow.setGroupLevel(listGroupDesc.size() - 1);
                }
            }
            R1PDataGrid_D2W.importElementCommon(designRow, widgetRow);
            widgetRow.setHeight(designRow.getHeightLom());
            widgetRow.setAdjustHeight(!designRow.isFixedHeight());
            widgetRow.setBackwardForward(((IDataGridRow)((Object)designRow)).isBackwardForward());
            this.importCell(designRow, widgetRow, widgetGrid.getMergeBlocks());
        }
    }

    private void importCell(AbstractRow designRow, AbstractPWDataGridRow widgetRow, List mergeBlocks) {
        int lc = designRow.getCellCount();
        block6: for (int j = 0; j < lc; ++j) {
            ICellValue designCellValue;
            DataGridCell designCell = (DataGridCell)designRow.getCell(j);
            PWDataGridCell widgetCell = widgetRow.getCell(j);
            R1PDataGrid_D2W.importElementCommon(designCell, widgetCell);
            widgetCell.setDivideCharNums(designCell.getDivideCharNums());
            widgetCell.setDivideModel(designCell.getDivideModel());
            MergeBlock mb = designCell.getMergeBlock();
            if (mb != null) {
                widgetCell.setBeMerged(true);
                if (!mergeBlocks.contains(mb)) {
                    mergeBlocks.add(mb.clone());
                }
            }
            if ((designCellValue = designCell.getValue()) == null) {
                this.importChildren(designCell, widgetCell);
                continue;
            }
            switch (designCellValue.getCellType()) {
                case 2: {
                    String field = ((CellField)designCellValue).getName();
                    widgetCell.setCellValue(new CellValueField(field));
                    continue block6;
                }
                case 1: {
                    String text = ((Text)designCellValue).getText();
                    widgetCell.setCellValue(new CellValueText(text));
                    continue block6;
                }
                case 3: {
                    StatField statField = (StatField)designCellValue;
                    String fieldName = statField.getField().getName();
                    int statType = R1PDataGrid_D2W.toEngineType(statField.getType());
                    int statRange = R1PDataGrid_D2W.toEngineRange(statField.getRange());
                    CellValueStat cellValueStat = new CellValueStat(fieldName);
                    cellValueStat.setStatType(statType + statRange);
                    cellValueStat.setSumAfterFormat(designCell.isSumAfterFormat());
                    if (statField.isShowGroupStatLast()) {
                        widgetCell.getExtProps().put("showGroupStatLast", Boolean.TRUE);
                    }
                    widgetCell.setCellValue(cellValueStat);
                    continue block6;
                }
                case 11: {
                    GridCompute compute = (GridCompute)designCellValue;
                    CellValueCompute cellValueCompute = new CellValueCompute(compute.getExpr());
                    this.showGroupStatLast(compute.getExpr(), widgetCell, widgetRow);
                    widgetCell.setCellValue(cellValueCompute);
                    continue block6;
                }
            }
        }
    }

    private static int toEngineRange(int range) {
        switch (range) {
            case 18: {
                return 1;
            }
            case 17: {
                return 2;
            }
            case 19: {
                return 8;
            }
        }
        return 4;
    }

    private static int toEngineType(int type) {
        switch (type) {
            case 1: {
                return 16;
            }
            case 2: {
                return 32;
            }
            case 3: {
                return 64;
            }
            case 4: {
                return 128;
            }
            case 5: {
                return 256;
            }
        }
        return 16;
    }

    private void showGroupStatLast(AbstractExpr currentExpr, PWDataGridCell widgetCell, AbstractPWDataGridRow widgetRow) {
        if (currentExpr instanceof VExpr) {
            if (((VExpr)currentExpr).getLevel() == widgetRow.getGroupLevel() && ((VExpr)currentExpr).isShowGroupStatLast()) {
                widgetCell.getExtProps().put("showGroupStatLast", Boolean.TRUE);
            }
            return;
        }
        if (currentExpr instanceof ICompositeExpr) {
            if (((ICompositeExpr)((Object)currentExpr)).getLeftExpr() != null) {
                this.showGroupStatLast(((ICompositeExpr)((Object)currentExpr)).getLeftExpr(), widgetCell, widgetRow);
            }
            if (((ICompositeExpr)((Object)currentExpr)).getRightExpr() != null) {
                this.showGroupStatLast(((ICompositeExpr)((Object)currentExpr)).getRightExpr(), widgetCell, widgetRow);
            }
        }
    }

    private IGridsFactory getGridsFactory() {
        return DataGridFactory.getPrintDataGridFactory();
    }

    public void analysisDynamicColumns(PWDataGrid widgetGrid, DataGrid designGrid) {
        if (this.getPluginProxy() == null) {
            return;
        }
        for (int i = 0; i < designGrid.getColumnsCount(); ++i) {
            AbstractColumn designCol = designGrid.getColumn(i);
            if (designCol.getColumnType() == null || !designCol.getColumnType().equalsIgnoreCase("Dynamic")) continue;
            DynamicColumnArgs arg = new DynamicColumnArgs(designCol, designCol.getId(), this.getPageId(), this.getPkId());
            this.getPluginProxy().fireAddDynamicColumns(arg);
            List<DynamicColumn> dynamicCols = arg.getDynamicColumns();
            if (dynamicCols != null && !dynamicCols.isEmpty()) {
                int avgWidth;
                boolean statistic = false;
                for (int m = 0; m < designGrid.getRowsCount(); ++m) {
                    AbstractRow row = designGrid.getRow(m);
                    DataGridCell designCell = (DataGridCell)row.getCell(i);
                    DynamicColumn dyItem = dynamicCols.get(0);
                    if (row instanceof AbstractDetailRow) {
                        designCell.setValue(CellField.create(dyItem.getBindField(), dyItem.getBindField()));
                        statistic = true;
                        continue;
                    }
                    if (dyItem.getGridHeader() != null && !dyItem.getGridHeader().isEmpty()) {
                        int index = m;
                        Stream<GridHeader> matchRow = dyItem.getGridHeader().stream().filter(p -> index == p.getRowIndex());
                        Optional<GridHeader> opt = matchRow.findFirst();
                        if (opt.isPresent()) {
                            designCell.setValue(new Text(opt.get().getCaption()));
                        }
                    }
                    if (!dyItem.isStatistic() || row instanceof AbstractDetailRow || !statistic) continue;
                    StatField stat = new StatField();
                    Field mf = Field.valueOf(dyItem.getBindField(), null);
                    stat.setType(dyItem.getStatisticType());
                    stat.setRange(dyItem.getStatisticScope());
                    stat.setField(mf);
                    designCell.setValue(stat);
                    statistic = false;
                }
                int columWidth = avgWidth = (int)Math.floor((double)designCol.getWidthLom() / (double)dynamicCols.size());
                if (dynamicCols.get(0).getWidth() != null && (columWidth = Integer.parseInt(dynamicCols.get(0).getWidth().toString()) * 10) > designGrid.getWidthLom() / 2) {
                    columWidth = avgWidth;
                    log.debug("\u6253\u5370\uff1a\u63d2\u4ef6\u4e2d\u8bbe\u7f6e\u7684\u52a8\u6001\u5217\u5217\u5bbd\u8fc7\u5bbd\uff0c\u4e0d\u80fd\u8d85\u8fc7\u8868\u683c\u5bbd\u5ea6\u7684\u4e09\u5206\u4e4b\u4e00");
                }
                AbstractColumn firstDynamicColunm = designGrid.getColumn(i);
                firstDynamicColunm.setWidthLom(columWidth);
                for (int j = 1; j < dynamicCols.size(); ++j) {
                    statistic = false;
                    DynamicColumn dyItem = dynamicCols.get(j);
                    int index = i + j;
                    AbstractColumn col = this.getGridsFactory().createColumn();
                    col.setStyle(designCol.getStyle());
                    col.setId(col.getIdPrefix() + (100 + j + index));
                    columWidth = avgWidth;
                    if (dyItem.getWidth() != null && (columWidth = Integer.parseInt(dyItem.getWidth().toString()) * 10) > designGrid.getWidthLom() / 2) {
                        columWidth = avgWidth;
                        log.debug("\u6253\u5370\uff1a\u63d2\u4ef6\u4e2d\u8bbe\u7f6e\u7684\u52a8\u6001\u5217\u5217\u5bbd\u8fc7\u5bbd\uff0c\u4e0d\u80fd\u8d85\u8fc7\u8868\u683c\u5bbd\u5ea6\u7684\u4e09\u5206\u4e4b\u4e00");
                    }
                    col.setWidthLom(columWidth);
                    designGrid.getColumns().add(index, col);
                    MergeUtil.adjustInserCol(designGrid, index);
                    for (int k = 0; k < designGrid.getRowsCount(); ++k) {
                        AbstractRow row = designGrid.getRow(k);
                        AbstractCell designCell = row.getCell(i);
                        DataGridCell cell = (DataGridCell)this.getGridsFactory().createCell();
                        cell.setId("dycell" + k + j);
                        cell.setStyle(designCell.getStyle());
                        if (row instanceof AbstractDetailRow) {
                            cell.setValue(CellField.create(dyItem.getBindField(), dyItem.getBindField()));
                            statistic = true;
                        } else {
                            if (dyItem.getGridHeader() != null && !dyItem.getGridHeader().isEmpty()) {
                                int idx = k;
                                Stream<GridHeader> matchRow = dyItem.getGridHeader().stream().filter(p -> idx == p.getRowIndex());
                                Optional<GridHeader> opt = matchRow.findFirst();
                                if (opt.isPresent()) {
                                    cell.setValue(new Text(opt.get().getCaption()));
                                }
                            }
                            if (dyItem.isStatistic() && !(row instanceof AbstractDetailRow) && statistic) {
                                StatField stat = new StatField();
                                Field mf = Field.valueOf(dyItem.getBindField(), null);
                                stat.setType(dyItem.getStatisticType());
                                stat.setRange(dyItem.getStatisticScope());
                                stat.setField(mf);
                                cell.setId("statcell" + k + j);
                                cell.setValue(stat);
                                statistic = false;
                            }
                        }
                        row.getCells().add(index, cell);
                    }
                }
            }
            if (arg.getMergeBlocks() == null || arg.getMergeBlocks().isEmpty()) continue;
            for (int k = 0; k < arg.getMergeBlocks().size(); ++k) {
                kd.bos.entity.print.MergeBlock mb = arg.getMergeBlocks().get(k);
                int top = mb.getTop();
                int bottom = mb.getBottom();
                int left = mb.getLeft();
                int right = mb.getRight();
                MergeBlock newMb = MergeBlock.create(left, right, top, bottom);
                widgetGrid.getMergeBlocks().add(newMb);
                for (int m = top; m <= bottom; ++m) {
                    for (int j = left; j <= right; ++j) {
                        DataGridCell cell = (DataGridCell)designGrid.getCell(m, j);
                        cell.setMergeBlock(newMb);
                        cell.setValue(new Text(mb.getContent()));
                    }
                }
            }
        }
    }
}

