/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.print.engine.importer.impl;

import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.IReportObject;
import com.kingdee.bos.ctrl.reportone.r1.print.common.headfooter.HeaderOrFooterModel;
import com.kingdee.bos.ctrl.reportone.r1.print.common.headfooter.LongPageModeHeadFooterModel;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.element.R1PrintPage;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.model.R1PrintModelHelper;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.importer.AR1PNode_D2W;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.IPrintWidget;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.PWPage;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.headfooter.PWHeadFooter;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.headfooter.PWHeadFooterLabel;
import java.awt.Point;
import java.awt.Rectangle;

public class R1PPage_D2W
extends AR1PNode_D2W {
    @Override
    protected IPrintWidget createWidget(IReportObject node) {
        return new PWPage();
    }

    @Override
    protected void importSpecial(IReportObject design, IPrintWidget widget) {
        R1PrintPage node = (R1PrintPage)design;
        PWPage widgetPage = (PWPage)widget;
        widgetPage.setBackgroundPicture(node.getImageContent());
        widgetPage.setBackgroundOffset(new Point(node.getPictureOffSetX(), node.getPictureOffSetY()));
        this.importChildren(node, widgetPage);
    }

    private void importHeadFooter(R1PrintPage node, PWPage widgetPage) {
    }

    private void importHeadFooterOfLongPageMode(R1PrintPage node, PWPage widgetPage) {
        LongPageModeHeadFooterModel hfm;
        if (!node.isHeightSyncFromPaper() && (hfm = R1PrintModelHelper.getHeadFooterOfLongPageMode(node)) != null) {
            PWHeadFooter header = this.createHeaderOrFooter(hfm.getHeader(), node.getWidthLom(), "header");
            header.setId("headerOfLongPageMode");
            widgetPage.addChild(header);
            PWHeadFooter footer = this.createHeaderOrFooter(hfm.getFooter(), node.getWidthLom(), "footer");
            footer.setId("footerOfLongPageMode");
            widgetPage.addChild(footer);
        }
    }

    private PWHeadFooter createHeaderOrFooter(HeaderOrFooterModel mo, int width, String idPrefix) {
        int seg = width / 3;
        StyleAttributes sa = mo.getSa();
        sa.setHorizontalAlign(Styles.HorizontalAlignment.LEFT);
        PWHeadFooterLabel left = this.createHeadFooterLabel(mo.getLeft());
        left.setId(idPrefix + "LeftOfLongPageMode");
        left.setStyle(Styles.getStyle(sa));
        left.getRectangle().x = 0;
        left.getRectangle().width = seg;
        sa.setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
        PWHeadFooterLabel center = this.createHeadFooterLabel(mo.getCenter());
        center.setId(idPrefix + "CenterOfLongPageMode");
        center.setStyle(Styles.getStyle(sa));
        center.getRectangle().x = seg;
        center.getRectangle().width = seg;
        sa.setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        PWHeadFooterLabel right = this.createHeadFooterLabel(mo.getRight());
        right.setId(idPrefix + "RightOfLongPageMode");
        right.setStyle(Styles.getStyle(sa));
        right.getRectangle().x = seg * 2;
        right.getRectangle().width = seg;
        PWHeadFooter hf = new PWHeadFooter();
        hf.setPrintable(true);
        hf.setRectangle(new Rectangle(0, 0, width, mo.getHeightLom()));
        hf.addChild(left);
        hf.addChild(center);
        hf.addChild(right);
        return hf;
    }

    private PWHeadFooterLabel createHeadFooterLabel(String text) {
        PWHeadFooterLabel widget = new PWHeadFooterLabel();
        widget.setPrintable(true);
        widget.setType("Text");
        widget.setRectangle(new Rectangle(0, 0, 100, 100));
        widget.setHFill(false);
        widget.setVFill(true);
        widget.setOriValue(text);
        return widget;
    }
}

