/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.print.engine.view;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kdf.util.render.r1print.DivideModel;
import com.kingdee.bos.ctrl.kdf.util.render.r1print.ICurrencySupport;
import com.kingdee.bos.ctrl.kdf.util.render.r1print.IDivideCharacterSupport;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.print.KDPrinter;
import com.kingdee.bos.ctrl.print.config.IXmlTranslate;
import com.kingdee.bos.ctrl.print.config.IXmlTranslate2;
import com.kingdee.bos.ctrl.print.ui.component.LabelCell;
import com.kingdee.bos.ctrl.print.ui.io.Painter2Xml;
import com.kingdee.bos.ctrl.print.ui.io.Xml2Painter;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.io.StyleCache;
import com.kingdee.bos.ctrl.reportone.r1.print.common.IAdjustHeightRenderSupport;
import com.kingdee.bos.ctrl.reportone.r1.print.common.R1PrintStringRender;
import java.awt.Color;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.dom4j.Element;
import org.dom4j.tree.DefaultCDATA;
import org.dom4j.tree.DefaultElement;

public class R1PLabelCell
extends LabelCell
implements IDivideCharacterSupport,
ICurrencySupport,
IAdjustHeightRenderSupport {
    private static final String SHOW_DIVIDE_LINE = "showDivideLine";
    private static final String STYLECACHE = "r1_divideStyle";
    private int _divideCharNums = -1;
    private DivideModel _divideModel;
    private boolean _isCurrencyColumn;
    private boolean _isAdjustHeight;

    public R1PLabelCell() {
        this.setRender(R1PrintStringRender.getInstance());
    }

    @Override
    public Color getBackGround() {
        if (this.getStyle() != null) {
            return this.getStyle().getBackground();
        }
        return null;
    }

    @Override
    public final int getDivideCharNums() {
        return this._divideCharNums;
    }

    @Override
    public final void setDivideCharNums(int divideCharNums) {
        this._divideCharNums = divideCharNums;
    }

    @Override
    public DivideModel getDivideModel() {
        if (this._divideModel == null) {
            this._divideModel = new DivideModel();
        }
        return this._divideModel;
    }

    @Override
    public void setDivideModel(DivideModel model) {
        this._divideModel = model;
    }

    @Override
    public boolean isCurrencyColumnSupport() {
        return this._isCurrencyColumn;
    }

    public void setCurrencyColumnSupport(boolean isSupport) {
        this._isCurrencyColumn = isSupport;
    }

    @Override
    public boolean isUseAdjustHeightRender() {
        return this._isAdjustHeight;
    }

    public void setUseAdjustHeightRender(boolean isAdjustHeight) {
        this._isAdjustHeight = isAdjustHeight;
    }

    @Override
    public IXmlTranslate createXmlTrans() {
        XmlTranslate xmlTranslate = new XmlTranslate();
        if (KDPrinter.getPainterXmlTranslate(xmlTranslate.getName()) == null) {
            KDPrinter.registerPainterXmlTranslate(xmlTranslate.getName(), xmlTranslate);
        }
        return xmlTranslate;
    }

    private class XmlTranslate
    implements IXmlTranslate2 {
        private Painter2Xml painter2Xml;
        private Xml2Painter xml2Painter;

        private XmlTranslate() {
        }

        @Override
        public Element toXmlElement() {
            DefaultElement xml = new DefaultElement("R1PLabelCell");
            this.painter2Xml.makeCommon(R1PLabelCell.this, (Element)xml);
            String text = R1PLabelCell.this.getText();
            if (text == null) {
                text = "";
            }
            xml.setContent(Stream.of(new DefaultCDATA(text)).collect(Collectors.toList()));
            if (R1PLabelCell.this.getDivideCharNums() != -1) {
                xml.addAttribute("divideCharNums", Integer.toString(R1PLabelCell.this.getDivideCharNums()));
                if (R1PLabelCell.this.getDivideModel().isShowLine()) {
                    StyleCache styleCache = (StyleCache)this.painter2Xml.getStyles().get(R1PLabelCell.STYLECACHE);
                    if (styleCache == null) {
                        styleCache = new StyleCache();
                        this.painter2Xml.getStyles().put(R1PLabelCell.STYLECACHE, styleCache);
                    }
                    xml.addAttribute(R1PLabelCell.SHOW_DIVIDE_LINE, Boolean.toString(R1PLabelCell.this.getDivideModel().isShowLine()));
                    String linesStyleId = styleCache.cacheStyle(R1PLabelCell.this.getDivideModel().getSSA());
                    xml.addAttribute("divideLineId", linesStyleId);
                }
            }
            if (R1PLabelCell.this.isCurrencyColumnSupport()) {
                xml.addAttribute("isCurrencyColumnSupport", "true");
            }
            if (R1PLabelCell.this.isUseAdjustHeightRender()) {
                xml.addAttribute("isAdjustHeight", "true");
            }
            return xml;
        }

        @Override
        public Object fromXmlElement(Element xml) {
            String strAdjustHeight;
            String strCurrencyColumnSupport;
            R1PLabelCell lbl = new R1PLabelCell();
            this.xml2Painter.parseCommon(lbl, xml);
            lbl.setText(xml.getText());
            String strDivideCharNums = xml.attributeValue("divideCharNums");
            if (strDivideCharNums != null) {
                lbl.setDivideCharNums(Integer.parseInt(strDivideCharNums));
            }
            if (!StringUtil.isEmptyString(xml.attributeValue(R1PLabelCell.SHOW_DIVIDE_LINE))) {
                DivideModel model = new DivideModel();
                model.setShowLine(Boolean.parseBoolean(xml.attributeValue(R1PLabelCell.SHOW_DIVIDE_LINE)));
                String lineId = xml.attributeValue("divideLineId");
                if (!StringUtil.isEmptyString(lineId)) {
                    StyleCache styleCache = (StyleCache)this.xml2Painter.getObject(R1PLabelCell.STYLECACHE);
                    StyleAttributes ssa = styleCache.getStyle(lineId);
                    model.upDataDivideLine(ssa);
                }
                lbl.setDivideModel(model);
            }
            if ((strCurrencyColumnSupport = xml.attributeValue("isCurrencyColumnSupport")) != null) {
                lbl.setCurrencyColumnSupport(true);
            }
            if ((strAdjustHeight = xml.attributeValue("isAdjustHeight")) != null) {
                lbl.setUseAdjustHeightRender(true);
            }
            return lbl;
        }

        @Override
        public String getName() {
            return "R1PLabelCell";
        }

        @Override
        public void setPainter2Xml(Painter2Xml handle) {
            this.painter2Xml = handle;
        }

        @Override
        public void setXml2Painter(Xml2Painter handle) {
            this.xml2Painter = handle;
        }
    }
}

