/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.print.engine.widget;

import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.reportone.r1.print.common.currency.CurrencyFormatManager;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.IWidgetExecuteHelper;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.ScriptSystemMethod;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.data.BlankRowDataHelper;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.exception.R1PrintException;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.AbstractPrintWidgetText;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.CurrencyFormat;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.IPrintWidget;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Map;
import kd.bos.cache.CacheLoader;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.format.CurrencyFormatObject;
import kd.bos.entity.format.FormatFactory;
import kd.bos.entity.format.FormatObject;
import kd.bos.entity.format.FormatTypes;
import kd.bos.entity.format.NumberFormatObject;
import kd.bos.entity.property.DecimalProp;
import kd.bos.inte.api.IInteService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.ServiceFactory;
import org.apache.commons.lang3.StringUtils;

public class PWCurrency
extends AbstractPrintWidgetText {
    private static final Log log = LogFactory.getLog(PWCurrency.class);
    private CurrencyFormat _currencyFormat;

    public CurrencyFormat getFormatDescription() {
        if (this._currencyFormat == null) {
            this._currencyFormat = new CurrencyFormat();
        }
        return this._currencyFormat;
    }

    public void setFormatDescription(CurrencyFormat desc) {
        this._currencyFormat = desc;
    }

    @Override
    public IPrintWidget copy() {
        IPrintWidget widget = super.copy();
        PWCurrency wc = (PWCurrency)widget;
        wc.setFormatDescription(this.getFormatDescription());
        return widget;
    }

    @Override
    protected void executing(IWidgetExecuteHelper helper, IPrintWidget outputWidget) throws R1PrintException {
        PWCurrency output = (PWCurrency)outputWidget;
        String ds = output.getDatasource();
        Variant opValue = output.getOutputValue();
        if (opValue == null) {
            if (StringUtils.isBlank((CharSequence)ds)) {
                output.setOutputValue(new Variant(output.getOriValue()));
                output.getFormatDescription().setCurrencyCode(this.getFormatDescription().getCurrencyCodeField());
            } else {
                IWidgetExecuteHelper.IDataHelper dataHelper = this.getDataHelper(helper, ds);
                Variant outputValue = dataHelper.getFieldValue(ds, output.getOriValue());
                output.setOutputValue(outputValue);
                if (this.getFormatDescription().isLowerNumber() && this.getFormatDescription().isShowCySymbol()) {
                    Variant varCurrency;
                    DecimalProp prop;
                    String controlPropName;
                    Object type = dataHelper.getFieldType(ds, output.getOriValue());
                    if (type instanceof DecimalProp && StringUtils.isNotBlank((CharSequence)(controlPropName = (prop = (DecimalProp)type).getControlPropName())) && (varCurrency = dataHelper.getFieldValue(ds, controlPropName + "_symbol")) != null && varCurrency.getValue() != null) {
                        String sign = (String)varCurrency.getValue();
                        output.getFormatDescription().setCurrencyCode(sign);
                    }
                } else if (this.getFormatDescription().isShowCyCode()) {
                    DecimalProp prop;
                    String controlPropName;
                    Object type = dataHelper.getFieldType(ds, output.getOriValue());
                    if (type instanceof DecimalProp && StringUtils.isNotBlank((CharSequence)(controlPropName = (prop = (DecimalProp)type).getControlPropName()))) {
                        Variant varCurrency = dataHelper.getFieldValue(ds, controlPropName + "_code");
                        if (varCurrency != null && varCurrency.getValue() != null) {
                            String sign = (String)varCurrency.getValue();
                            output.getFormatDescription().setCurrencyCode(sign);
                        } else {
                            varCurrency = dataHelper.getFieldValue(ds, controlPropName);
                            if (varCurrency != null && varCurrency.getValue() != null) {
                                DynamicObject object = (DynamicObject)varCurrency.getValue();
                                String number = object.getString("number");
                                output.getFormatDescription().setCurrencyCode(number);
                            }
                        }
                    }
                } else {
                    output.getFormatDescription().setCurrencyCode(this.getFormatDescription().getCurrencyCodeField());
                }
            }
        }
        output.formatOutput();
    }

    private static CurrencyFormatManager getFormater() {
        return CurrencyFormatManager.shareInstance();
    }

    @Override
    public void formatOutput() {
        Variant vt = this.getOutputValue();
        Object value = vt.getValue();
        if (value == null) {
            this.setOutputText("");
            return;
        }
        if (vt == BlankRowDataHelper.EMPTY) {
            this.setOutputText(vt.toString());
            return;
        }
        StringBuilder outputText = new StringBuilder();
        boolean isIgnoreZero = this.getFormatDescription().isIgnoreZero();
        BigDecimal bigValue = this.toBigDecimal(value);
        int c = bigValue.compareTo(BigDecimal.ZERO);
        if (isIgnoreZero && c == 0) {
            outputText.append("");
        } else {
            if (!(value instanceof BigDecimal)) {
                String result = value.toString();
                if (this.getFormatDescription().isIgnoreTailZero()) {
                    result = result.replaceAll("(0)+$", "");
                    result = result.replaceAll("[.]$", "");
                    value = result;
                }
            }
            if (!this.getFormatDescription().isLowerNumber()) {
                if (this.getFormatDescription().isTypeNote()) {
                    if (this.getFormatDescription().getCurrencyCode() != null) {
                        ScriptSystemMethod ssm = new ScriptSystemMethod();
                        String symbol = PWCurrency.getFormater().getSymbol(this.getFormatDescription().getCurrencyCode());
                        outputText.append(ssm.formatChequeCurrency(vt, symbol.charAt(symbol.length() - 1), 1));
                    } else {
                        outputText.append(this.getOutputValue());
                    }
                } else {
                    if (StringUtils.isEmpty((CharSequence)this.getFormatDescription().getCurrencyCode())) {
                        this.getFormatDescription().setCurrencyCode("RMB");
                        this.getFormatDescription().setAddPrefix(false);
                    }
                    if (vt.isCanPrint()) {
                        outputText.append(PWCurrency.getFormater().upperFomat(this.getFormatDescription().getCurrencyCode(), this.getFormatDescription().getLanguage().getLocale(), this.getOutputValue(), this.getFormatDescription().isAddPrefix()));
                    } else {
                        outputText.append(this.getOutputValue());
                    }
                }
            }
            if (this.getFormatDescription().isAddPrefix() && !this.getFormatDescription().isTypeNote()) {
                if (this.getFormatDescription().isLowerNumber()) {
                    if (this.getFormatDescription().isShowCySymbol() || this.getFormatDescription().isShowCyCode()) {
                        if (StringUtils.isNotBlank((CharSequence)this.getFormatDescription().getCurrencyCode())) {
                            if (value instanceof BigDecimal) {
                                outputText.delete(0, outputText.length());
                                outputText.append(this.defaultCurrenyFormat((BigDecimal)value));
                            } else {
                                outputText.insert(0, this.getFormatDescription().getCurrencyCode());
                                outputText.append(value);
                            }
                        } else if (value instanceof BigDecimal) {
                            outputText.append(this.formatSeparator((BigDecimal)value));
                        } else {
                            outputText.append(value);
                        }
                    } else {
                        outputText.insert(0, PWCurrency.getFormater().getSymbol(this.getFormatDescription().getCurrencyCode()));
                        if (value instanceof BigDecimal) {
                            outputText.append(this.formatSeparator((BigDecimal)value));
                        } else {
                            outputText.append(value);
                        }
                    }
                }
            } else if (this.getFormatDescription().isLowerNumber()) {
                if (value instanceof BigDecimal) {
                    outputText.append(this.formatSeparator((BigDecimal)value));
                } else {
                    outputText.append(value);
                }
            }
        }
        this.setOutputText(outputText.toString());
    }

    private String formatSeparator(BigDecimal value) {
        Long inteFormatId = this.getFormatDescription().getInteFormatId();
        Map<String, Object> format = PWCurrency.getInteFormat(inteFormatId);
        Map numberFormat = (Map)format.get("numberFormat");
        String decimalPoint = (String)numberFormat.get("decimalPoint");
        String negativeFormat = (String)numberFormat.get("negativeFormat");
        String numGroupFormat = (String)numberFormat.get("numGroupFormat");
        String numSeparator = (String)numberFormat.get("numSeparator");
        FormatObject formatObject = new FormatObject();
        NumberFormatObject numberformatObj = new NumberFormatObject(decimalPoint.charAt(0), numSeparator.charAt(0), "", numGroupFormat, negativeFormat);
        int scale = value.scale();
        if (this.getFormatDescription().isIgnoreTailZero()) {
            scale = value.stripTrailingZeros().scale();
        }
        numberformatObj.setMinimumFractionDigits(scale);
        formatObject.setNumberFormat(numberformatObj);
        String num = FormatFactory.get((FormatTypes)FormatTypes.Number).getFormat(formatObject).format(value);
        if (this.getDivideCharNums() > 0 && StringUtils.isNotBlank((CharSequence)numSeparator)) {
            num = num.replaceAll(numSeparator, "");
        }
        return num;
    }

    private String defaultCurrenyFormat(BigDecimal value) {
        Long inteFormatId = this.getFormatDescription().getInteFormatId();
        Map<String, Object> format = PWCurrency.getInteFormat(inteFormatId);
        Map currencyFormat = (Map)format.get("currencyFormat");
        String decimalPoint = (String)currencyFormat.get("decimalPoint");
        String negativeFormat = (String)currencyFormat.get("negativeFormat");
        String numGroupFormat = (String)currencyFormat.get("numGroupFormat");
        String numSeparator = (String)currencyFormat.get("numSeparator");
        String currPosFormat = (String)currencyFormat.get("currPosFormat");
        String cnyShowPrefix = (String)currencyFormat.get("cnyShowPrefix");
        FormatObject formatObject = new FormatObject();
        CurrencyFormatObject currencyformatObj = new CurrencyFormatObject(currPosFormat, decimalPoint.charAt(0), numSeparator.charAt(0), "", numGroupFormat, negativeFormat);
        int scale = value.scale();
        if (this.getFormatDescription().isIgnoreTailZero()) {
            scale = value.stripTrailingZeros().scale();
        }
        currencyformatObj.setMinimumFractionDigits(scale);
        formatObject.setCurrencyFormat(currencyformatObj);
        String curr = FormatFactory.get((FormatTypes)FormatTypes.Currency).getFormat(formatObject).format(value);
        if (cnyShowPrefix != null) {
            if (cnyShowPrefix.equals("1") || cnyShowPrefix.equals("2")) {
                String preFix = this.getFormatDescription().getCurrencyCode();
                curr = curr.replace("\uffe5", preFix);
            } else if (cnyShowPrefix.equals("3")) {
                curr = curr.replace("\uffe5", "");
            }
        }
        if (this.getDivideCharNums() > 0 && StringUtils.isNotBlank((CharSequence)numSeparator)) {
            curr = curr.replaceAll(numSeparator, "");
        }
        return curr;
    }

    public static Map<String, Object> getInteFormat(final Long formatId) {
        String cacheKey = PWCurrency.getThreadCacheKey("inte", formatId.toString());
        Map format = (Map)ThreadCache.get((Object)cacheKey, (CacheLoader)new CacheLoader<Map<String, Object>>(){

            public Map<String, Object> load() {
                IInteService inteService = (IInteService)ServiceFactory.getService(IInteService.class);
                return inteService.getFormat(formatId);
            }
        });
        return format;
    }

    private static String getThreadCacheKey(String ... keys) {
        StringBuilder sb = new StringBuilder("PWCurrency");
        for (String key : keys) {
            sb.append(".").append(key);
        }
        return sb.toString();
    }

    private BigDecimal toBigDecimal(Object value) {
        BigDecimal ret = BigDecimal.ZERO;
        if (value instanceof BigDecimal) {
            ret = (BigDecimal)value;
        } else if (value instanceof String) {
            try {
                ret = new BigDecimal((String)value);
            }
            catch (Exception e) {
                log.debug(e.getMessage());
            }
        } else if (value instanceof BigInteger) {
            ret = new BigDecimal((BigInteger)value);
        } else if (value instanceof Number) {
            ret = BigDecimal.valueOf(((Number)value).doubleValue());
        }
        return ret;
    }
}

