/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.print.engine.widget;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.util.Util;
import com.kingdee.bos.ctrl.reportone.r1.print.common.ImageUtil;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.IWidgetExecuteHelper;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.exception.R1PrintException;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.AbstractPrintWidget;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.IAdjustHeightSupport;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.IDatasourceSupport;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.IPrintWidget;
import java.awt.Image;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.SQLException;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class PWPicture
extends AbstractPrintWidget
implements IAdjustHeightSupport,
IDatasourceSupport {
    private static final Log log = LogFactory.getLog(PWPicture.class);
    private String _ds;
    private String _oriValue;
    private byte[] _imageContent;
    private int _scale;
    private Variant _outputValue;
    private boolean _isAdjustHeight;
    private int _maxHeightToAdjust;

    @Override
    public void setValue(Object value) {
        this.setOriValue((String)value);
    }

    @Override
    public void setDatasource(String ds) {
        this._ds = ds;
    }

    @Override
    public String getDatasource() {
        return this._ds;
    }

    public void setOriValue(String value) {
        this._oriValue = value;
    }

    public String getOriValue() {
        return this._oriValue;
    }

    public void setImage(byte[] content) {
        this._imageContent = content;
    }

    public byte[] getImage() {
        return this._imageContent;
    }

    public void setScaleType(int scaleType) {
        this._scale = scaleType;
    }

    public int getScaleType() {
        return this._scale;
    }

    public void setOutputValue(Variant value) {
        this._outputValue = value;
    }

    public Variant getOutputValue() {
        return this._outputValue;
    }

    @Override
    public IPrintWidget copy() {
        IPrintWidget widget = super.copy();
        PWPicture wp = (PWPicture)widget;
        wp.setDatasource(this.getDatasource());
        wp.setOriValue(this.getOriValue());
        wp.setImage(this.getImage());
        wp.setScaleType(this.getScaleType());
        return widget;
    }

    @Override
    protected void executing(IWidgetExecuteHelper helper, IPrintWidget outputWidget) throws R1PrintException {
        PWPicture output = (PWPicture)outputWidget;
        Variant outputValue = null;
        if (StringUtil.isEmptyString(this.getDatasource())) {
            outputValue = output.getImage() == null ? new Variant(output.getOriValue()) : new Variant(output.getImage());
        } else {
            String ds = output.getDatasource();
            outputValue = this.getDataHelper(helper, ds).getFieldValue(ds, output.getOriValue());
        }
        output.setOutputValue(outputValue);
        if (output.isAdjustHeight()) {
            Image image = PWPicture.loadImage(outputValue.getValue());
            int h = 0;
            if (image != null) {
                h = Util.pixel2Lom(image.getHeight(null));
            }
            output.getRectangle().height = h;
        }
    }

    @Override
    public void setAdjustHeight(boolean isAdjustHeight) {
        this._isAdjustHeight = isAdjustHeight;
    }

    @Override
    public boolean isAdjustHeight() {
        return this._isAdjustHeight;
    }

    @Override
    public void setMaxHeightToAdjust(int maxHeight) {
        this._maxHeightToAdjust = maxHeight;
    }

    @Override
    public int getMaxHeightToAdjust() {
        return this._maxHeightToAdjust;
    }

    @Override
    public void setRemainContent(boolean isRemain) {
    }

    @Override
    public boolean isRemainContent() {
        return false;
    }

    @Override
    public Object getFieldValue(String field) {
        return this.getFieldValue(this.getDatasource(), field);
    }

    private static Image loadImage(Object value) {
        if (value != null) {
            byte[] imageData = null;
            if (value instanceof byte[]) {
                imageData = (byte[])value;
            } else if (value instanceof Blob) {
                imageData = PWPicture.blobToBytes((Blob)value);
            } else if (value instanceof String && StringUtils.isNotBlank((Object)value)) {
                imageData = ImageUtil.getImageByUrl((String)value);
            }
            if (imageData != null) {
                return ImageUtil.makeImage(imageData);
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static byte[] blobToBytes(Blob blob) {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
             InputStream is = blob.getBinaryStream();){
            if (is == null) return new byte[0];
            byte[] c = new byte[1024];
            int len = 0;
            while ((len = is.read(c, 0, c.length)) != -1) {
                baos.write(c, 0, len);
            }
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (SQLException sqlEx) {
            log.error((Throwable)sqlEx);
            return new byte[0];
        }
        catch (IOException ioEx) {
            log.error((Throwable)ioEx);
        }
        return new byte[0];
    }
}

