/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.print.engine.widget;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.util.Util;
import com.kingdee.bos.ctrl.reportone.r1.print.common.AdjustHeightRenderer;
import com.kingdee.bos.ctrl.reportone.r1.print.common.IAdjustHeightRenderSupport;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.ExecuteContext;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.IWidgetExecuteHelper;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.R1PrintEngine;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.exception.R1PrintException;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.AbstractPrintWidgetText;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.IAdjustHeightSupport;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.IPrintWidget;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.StyleAccess;
import java.awt.Rectangle;

public class PWText
extends AbstractPrintWidgetText
implements IAdjustHeightSupport,
IAdjustHeightRenderSupport {
    private boolean isAdjustHeightField;
    private int maxHeightToAdjust;

    @Override
    public void setAdjustHeight(boolean isAdjustHeight) {
        this.isAdjustHeightField = isAdjustHeight;
    }

    @Override
    public boolean isAdjustHeight() {
        return this.isAdjustHeightField;
    }

    @Override
    public void setMaxHeightToAdjust(int maxHeight) {
        this.maxHeightToAdjust = maxHeight;
    }

    @Override
    public int getMaxHeightToAdjust() {
        return this.maxHeightToAdjust;
    }

    @Override
    public void setRemainContent(boolean isRemain) {
    }

    @Override
    public boolean isRemainContent() {
        return false;
    }

    @Override
    public boolean isUseAdjustHeightRender() {
        return this.isAdjustHeight();
    }

    @Override
    protected void executing(IWidgetExecuteHelper helper, IPrintWidget outputWidget) throws R1PrintException {
        PWText output = (PWText)outputWidget;
        Variant outputValue = null;
        boolean isStatic = StringUtil.isEmptyString(this.getDatasource());
        Variant opValue = output.getOutputValue();
        if (opValue != null) {
            outputValue = opValue;
        } else if (isStatic) {
            outputValue = new Variant(output.getOriValue());
        } else {
            String ds = output.getDatasource();
            outputValue = this.getDataHelper(helper, ds).getFieldValue(ds, output.getOriValue());
        }
        if (outputValue != null) {
            Object formulaResult = null;
            if (isStatic) {
                formulaResult = R1PrintEngine.runFormula(helper, output, outputValue.toString());
            }
            if (formulaResult == null) {
                if (output.isAdjustHeight()) {
                    output.setOutputValue(outputValue);
                    this.executingLongText(output);
                } else {
                    output.setOutputValue(outputValue);
                    output.formatOutput();
                }
            } else {
                output.setValue(formulaResult);
            }
        }
    }

    private void executingLongText(PWText output) {
        String textRemain;
        String textToDraw;
        int maxH;
        int minH;
        int maxHeight;
        ExecuteContext cec = this.getContext();
        int widthLom = cec.getContainerWidth();
        int height = Util.lom2Pixel(cec.getContainerHeight()) - 1;
        if (height < (maxHeight = Util.lom2Pixel(cec.getMaxHeightToAdjust()) - 1)) {
            minH = height;
            maxH = maxHeight;
        } else {
            minH = maxH = maxHeight;
        }
        int width = Util.lom2Pixel(widthLom);
        String text = output.getOutputValue().toString();
        text = text == null ? "" : text;
        AdjustHeightRenderer.Result result = AdjustHeightRenderer.adjustHeight(text, StyleAccess.getStyle(output), minH, maxH, width);
        if (result.isTextCutOff()) {
            int nextStart = result.getCutPosition();
            textToDraw = text.substring(0, nextStart);
            textRemain = text.substring(nextStart);
        } else {
            textToDraw = text;
            textRemain = null;
        }
        int usedHeight = Util.pixel2Lom(result.getUsedHeight());
        output.setOutputText(textToDraw);
        output.setRectangle(new Rectangle(widthLom, usedHeight));
        this.setOutputText(textRemain);
        this.setRemainContent(textRemain != null);
        cec.setChildrenPaginating(this.isRemainContent());
    }
}

