/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.print.engine.widget;

import com.kingdee.bos.ctrl.kdf.util.style.LineStyle;
import com.kingdee.bos.ctrl.kdf.util.style.PenStyle;
import com.kingdee.bos.ctrl.kdf.util.style.Rect;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.exception.R1PrintRuntimeException;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.IPrintWidget;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class StyleAccess {
    private static final Log log = LogFactory.getLog(StyleAccess.class);
    private static final String FONT_NAME = "font-name";
    private static final String FONT_SIZE = "font-size";
    private static final String FONT_COLOR = "font-color";
    private static final String FONT_BOLD = "font-bold";
    private static final String FONT_ITALIC = "font-italic";
    private static final String FONT_UNDERLINE = "underline";
    private static final String FONT_STRIKETHROUGH = "strikethrough";
    private static final String BACKGROUND = "background";
    public static final String FORMAT = "format";
    private static final String HORIZONTAL_ALIGN = "horizontal-align";
    private static final String VERTICAL_ALIGN = "vertical-align";
    private static final String TEXT_WRAP = "text-wrap";
    private static final String TEXT_SHRINK = "text-shrink";
    private static final String ROTATION = "rotation";
    private static final String LINE_SPACE = "line-spacing";
    private static final String WORD_SPACE = "word-spacing";
    private static final String PADDING = "padding";
    private static final String BORDER_WIDTH = "border-width";
    private static final String BORDER_STYLE = "border-style";
    private static final String BORDER_COLOR = "border-color";
    private static final String BORDER_LEFT = "border-left-";
    private static final String BORDER_RIGHT = "border-right-";
    private static final String BORDER_TOP = "border-top-";
    private static final String BORDER_BOTTOM = "border-bottom-";
    private static final String BORDER_HORIZONTAL = "border-horizontal-";
    private static final String BORDER_VERTICAL = "border-vertical-";
    private static final String WIDTH = "width";
    private static final String STYLE = "style";
    private static final String COLOR = "color";
    private static final String BORDER_LEFT_WIDTH = "border-left-width";
    private static final String BORDER_LEFT_STYLE = "border-left-style";
    private static final String BORDER_LEFT_COLOR = "border-left-color";
    private static final String BORDER_RIGHT_WIDTH = "border-right-width";
    private static final String BORDER_RIGHT_STYLE = "border-right-style";
    private static final String BORDER_RIGHT_COLOR = "border-right-color";
    private static final String BORDER_TOP_WIDTH = "border-top-width";
    private static final String BORDER_TOP_STYLE = "border-top-style";
    private static final String BORDER_TOP_COLOR = "border-top-color";
    private static final String BORDER_BOTTOM_WIDTH = "border-bottom-width";
    private static final String BORDER_BOTTOM_STYLE = "border-bottom-style";
    private static final String BORDER_BOTTOM_COLOR = "border-bottom-color";
    private static final String BORDER_HORIZONTAL_WIDTH = "border-horizontal-width";
    private static final String BORDER_HORIZONTAL_STYLE = "border-horizontal-style";
    private static final String BORDER_HORIZONTAL_COLOR = "border-horizontal-color";
    private static final String BORDER_VERTICAL_WIDTH = "border-vertical-width";
    private static final String BORDER_VERTICAL_STYLE = "border-vertical-style";
    private static final String BORDER_VERTICAL_COLOR = "border-vertical-color";
    private static final int B_LEFT = 4096;
    private static final int B_RIGHT = 256;
    private static final int B_TOP = 16;
    private static final int B_BOTTOM = 1;
    private static final int B_INNERLEFT = 12288;
    private static final int B_INNERRIGHT = 768;
    private static final int B_INNERTOP = 48;
    private static final int B_INNERBOTTOM = 3;
    public static final int T_NorthWest = 4883;
    public static final int T_North = 13075;
    public static final int T_NorthEast = 12563;
    public static final int T_West = 4915;
    public static final int T_Navel = 13107;
    public static final int T_East = 12595;
    public static final int T_SouthWest = 4913;
    public static final int T_South = 13105;
    public static final int T_SouthEast = 12593;
    public static final int T_Top = 4371;
    public static final int T_Middle = 4403;
    public static final int T_Bottom = 4401;
    public static final int T_Left = 4881;
    public static final int T_Center = 13073;
    public static final int T_Right = 12561;
    public static final int T_Single = 4369;
    private static Map<String, StyleAttrAccess> Access = new HashMap<String, StyleAttrAccess>(36);
    private Map<String, Object> _attrs;
    private Style _style;

    public static Style getStyle(IPrintWidget widget) {
        return widget.getStyleAccess().getModifiedStyle(widget.getStyle());
    }

    public StyleAccess(Style style) {
        this._style = style == null ? Styles.getDefaultStyle() : style;
    }

    public void set(String key, Object value) {
        if (BORDER_WIDTH.equals(key) || BORDER_STYLE.equals(key) || BORDER_COLOR.equals(key)) {
            String subKey = key.substring(7);
            this.getAttrs().put(BORDER_LEFT + subKey, value);
            this.getAttrs().put(BORDER_RIGHT + subKey, value);
            this.getAttrs().put(BORDER_TOP + subKey, value);
            this.getAttrs().put(BORDER_BOTTOM + subKey, value);
        } else {
            this.getAttrs().put(key, value);
        }
    }

    public Object get(String key) {
        if (this._attrs == null) {
            StyleAttrAccess access = Access.get(key);
            if (access != null) {
                return access.getAttr(this._style);
            }
        } else {
            return this._attrs.get(key);
        }
        log.error("Invalid style property key: " + key);
        return null;
    }

    private Map getAttrs() {
        if (this._attrs == null) {
            this._attrs = new HashMap<String, Object>();
        }
        return this._attrs;
    }

    public Style getModifiedStyle(Style oriStyle) {
        if (oriStyle == null) {
            oriStyle = Styles.getDefaultStyle();
        }
        if (this._attrs == null || this._attrs.size() == 0) {
            return oriStyle;
        }
        StyleAttributes sa = Styles.getSA(oriStyle);
        for (Map.Entry<String, Object> entry : this._attrs.entrySet()) {
            String key = entry.getKey();
            StyleAttrAccess access = Access.get(key);
            if (access == null) {
                log.error("Invalid style property key: " + key);
                continue;
            }
            access.setAttr(sa, this._attrs.get(key));
        }
        return Styles.getStyle(sa);
    }

    public void merge(StyleAccess another, int borderTag) {
        if (another._attrs == null) {
            return;
        }
        for (String key : another.getAttrs().keySet()) {
            String[] newKeys = this.changeKey(key, borderTag);
            if (newKeys == null) continue;
            for (int i = 0; i < newKeys.length; ++i) {
                boolean toMerge = true;
                if (this.getAttrs().containsKey(newKeys[i])) {
                    toMerge = false;
                }
                if (!toMerge) continue;
                this.getAttrs().put(newKeys[i], another.getAttrs().get(key));
            }
        }
    }

    private String[] changeKey(String key, int borderTag) {
        if (!key.startsWith("border-")) {
            return new String[]{key};
        }
        ArrayList<String> result = new ArrayList<String>();
        result.add(key);
        if ((borderTag & 0x3000) == 12288) {
            if (key.startsWith(BORDER_LEFT)) {
                return null;
            }
            if (key.startsWith(BORDER_VERTICAL)) {
                result.add(BORDER_LEFT + key.substring(BORDER_VERTICAL.length()));
            }
        }
        if ((borderTag & 0x300) == 768) {
            if (key.startsWith(BORDER_RIGHT)) {
                return null;
            }
            if (key.startsWith(BORDER_VERTICAL)) {
                result.add(BORDER_RIGHT + key.substring(BORDER_VERTICAL.length()));
            }
        }
        if ((borderTag & 0x30) == 48) {
            if (key.startsWith(BORDER_TOP)) {
                return null;
            }
            if (key.startsWith(BORDER_HORIZONTAL)) {
                result.add(BORDER_TOP + key.substring(BORDER_HORIZONTAL.length()));
            }
        }
        if ((borderTag & 3) == 3) {
            if (key.startsWith(BORDER_BOTTOM)) {
                return null;
            }
            if (key.startsWith(BORDER_HORIZONTAL)) {
                result.add(BORDER_BOTTOM + key.substring(BORDER_HORIZONTAL.length()));
            }
        }
        return result.toArray(new String[0]);
    }

    private static Color string2Color(String cs) {
        if (cs != null && cs.startsWith("#") && cs.length() > 6) {
            cs = cs.substring(1);
            try {
                int r = Integer.decode("0x" + cs.substring(0, 2));
                int g = Integer.decode("0x" + cs.substring(2, 4));
                int b = Integer.decode("0x" + cs.substring(4, 6));
                return new Color(r, g, b);
            }
            catch (Exception e) {
                throw new R1PrintRuntimeException("Invalid color descriptoin: " + cs, e);
            }
        }
        throw new R1PrintRuntimeException("Invalid color descriptoin: " + cs);
    }

    private static String color2string(Color color) {
        String r = Integer.toHexString(color.getRed());
        String g = Integer.toHexString(color.getGreen());
        String b = Integer.toHexString(color.getBlue());
        if (r.length() == 1) {
            r = "0" + r;
        }
        if (g.length() == 1) {
            g = "0" + g;
        }
        if (b.length() == 1) {
            b = "0" + b;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("#");
        sb.append(r);
        sb.append(g);
        sb.append(b);
        return sb.toString();
    }

    private static Integer getBorderLineStyle(Style style, Styles.Position border) {
        return style.getBorderLineStyle(border).getWidth();
    }

    private static void setBorderLineStyle(StyleAttributes sa, Object value, Styles.Position border) {
        if (!(value instanceof Integer)) {
            throw new R1PrintRuntimeException("LineStyle must be int.");
        }
        sa.setBorderLineStyle(border, LineStyle.getLineStyle((Integer)value));
    }

    private static String getBorderPenStyle(Style style, Styles.Position border) {
        return style.getBorderPenStyle(border).getName();
    }

    private static void setBorderPenStyle(StyleAttributes sa, Object value, Styles.Position border) {
        PenStyle penStyle;
        if (value instanceof String) {
            penStyle = PenStyle.getPenStyle((String)value);
            if (penStyle == null) {
                throw new R1PrintRuntimeException("PenStyle must be \"Solid/Dash/Dot/DashDot/DashDotDot.\"");
            }
        } else {
            throw new R1PrintRuntimeException("PenStyle must be String.");
        }
        sa.setBorderPenStyle(border, penStyle);
    }

    private static String getBorderColor(Style style, Styles.Position border) {
        return StyleAccess.color2string(style.getBorderColor(border));
    }

    private static void setBorderColor(StyleAttributes sa, Object value, Styles.Position border) {
        Color color = null;
        if (value instanceof String) {
            color = StyleAccess.string2Color((String)value);
        } else if (value instanceof Color) {
            color = (Color)value;
        } else {
            throw new R1PrintRuntimeException("Invalid color. You can use string like \"#AABBCC.\"");
        }
        if (color != null) {
            sa.setBorderColor(border, color);
        }
    }

    static {
        Access.put(FONT_NAME, new AccessFontName());
        Access.put(FONT_SIZE, new AccessFontSize());
        Access.put(FONT_COLOR, new AccessFontColor());
        Access.put(FONT_BOLD, new AccessFontBold());
        Access.put(FONT_ITALIC, new AccessFontItalic());
        Access.put(FONT_UNDERLINE, new AccessFontUnderline());
        Access.put(FONT_STRIKETHROUGH, new AccessFontStrikeThrough());
        Access.put(BACKGROUND, new AccessBackground());
        Access.put(FORMAT, new AccessFormet());
        Access.put(HORIZONTAL_ALIGN, new AccessHorizontalAlign());
        Access.put(VERTICAL_ALIGN, new AccessVerticalAlign());
        Access.put(TEXT_WRAP, new AccessTextWrap());
        Access.put(TEXT_SHRINK, new AccessTextShrink());
        Access.put(ROTATION, new AccessRotation());
        Access.put(LINE_SPACE, new AccessLineSpace());
        Access.put(WORD_SPACE, new AccessWordSpace());
        Access.put(PADDING, new AccessPadding());
        Access.put(BORDER_LEFT_WIDTH, new AccessLeftLineStyle());
        Access.put(BORDER_LEFT_STYLE, new AccessLeftPenStyle());
        Access.put(BORDER_LEFT_COLOR, new AccessLeftColor());
        Access.put(BORDER_RIGHT_WIDTH, new AccessRightLineStyle());
        Access.put(BORDER_RIGHT_STYLE, new AccessRightPenStyle());
        Access.put(BORDER_RIGHT_COLOR, new AccessRightColor());
        Access.put(BORDER_TOP_WIDTH, new AccessTopLineStyle());
        Access.put(BORDER_TOP_STYLE, new AccessTopPenStyle());
        Access.put(BORDER_TOP_COLOR, new AccessTopColor());
        Access.put(BORDER_BOTTOM_WIDTH, new AccessBottomLineStyle());
        Access.put(BORDER_BOTTOM_STYLE, new AccessBottomPenStyle());
        Access.put(BORDER_BOTTOM_COLOR, new AccessBottomColor());
        Access.put(BORDER_HORIZONTAL_WIDTH, new AccessHorizontalLineStyle());
        Access.put(BORDER_HORIZONTAL_STYLE, new AccessHorizontalPenStyle());
        Access.put(BORDER_HORIZONTAL_COLOR, new AccessHorizontalColor());
        Access.put(BORDER_VERTICAL_WIDTH, new AccessVerticalLineStyle());
        Access.put(BORDER_VERTICAL_STYLE, new AccessVerticalPenStyle());
        Access.put(BORDER_VERTICAL_COLOR, new AccessVerticalColor());
    }

    private static class AccessVerticalColor
    extends StyleAttrAccess {
        private AccessVerticalColor() {
        }

        @Override
        Object getAttr(Style style) {
            return StyleAccess.getBorderColor(style, Styles.Position.DIAGONALRIGHT);
        }

        @Override
        void setAttr(StyleAttributes sa, Object value) {
            StyleAccess.setBorderColor(sa, value, Styles.Position.DIAGONALRIGHT);
        }
    }

    private static class AccessVerticalPenStyle
    extends StyleAttrAccess {
        private AccessVerticalPenStyle() {
        }

        @Override
        Object getAttr(Style style) {
            return StyleAccess.getBorderPenStyle(style, Styles.Position.DIAGONALRIGHT);
        }

        @Override
        void setAttr(StyleAttributes sa, Object value) {
            StyleAccess.setBorderPenStyle(sa, value, Styles.Position.DIAGONALRIGHT);
        }
    }

    private static class AccessVerticalLineStyle
    extends StyleAttrAccess {
        private AccessVerticalLineStyle() {
        }

        @Override
        Object getAttr(Style style) {
            return StyleAccess.getBorderLineStyle(style, Styles.Position.DIAGONALRIGHT);
        }

        @Override
        void setAttr(StyleAttributes sa, Object value) {
            StyleAccess.setBorderLineStyle(sa, value, Styles.Position.DIAGONALRIGHT);
        }
    }

    private static class AccessHorizontalColor
    extends StyleAttrAccess {
        private AccessHorizontalColor() {
        }

        @Override
        Object getAttr(Style style) {
            return StyleAccess.getBorderColor(style, Styles.Position.DIAGONALLEFT);
        }

        @Override
        void setAttr(StyleAttributes sa, Object value) {
            StyleAccess.setBorderColor(sa, value, Styles.Position.DIAGONALLEFT);
        }
    }

    private static class AccessHorizontalPenStyle
    extends StyleAttrAccess {
        private AccessHorizontalPenStyle() {
        }

        @Override
        Object getAttr(Style style) {
            return StyleAccess.getBorderPenStyle(style, Styles.Position.DIAGONALLEFT);
        }

        @Override
        void setAttr(StyleAttributes sa, Object value) {
            StyleAccess.setBorderPenStyle(sa, value, Styles.Position.DIAGONALLEFT);
        }
    }

    private static class AccessHorizontalLineStyle
    extends StyleAttrAccess {
        private AccessHorizontalLineStyle() {
        }

        @Override
        Object getAttr(Style style) {
            return StyleAccess.getBorderLineStyle(style, Styles.Position.DIAGONALLEFT);
        }

        @Override
        void setAttr(StyleAttributes sa, Object value) {
            StyleAccess.setBorderLineStyle(sa, value, Styles.Position.DIAGONALLEFT);
        }
    }

    private static class AccessBottomColor
    extends StyleAttrAccess {
        private AccessBottomColor() {
        }

        @Override
        Object getAttr(Style style) {
            return StyleAccess.getBorderColor(style, Styles.Position.BOTTOM);
        }

        @Override
        void setAttr(StyleAttributes sa, Object value) {
            StyleAccess.setBorderColor(sa, value, Styles.Position.BOTTOM);
        }
    }

    private static class AccessBottomPenStyle
    extends StyleAttrAccess {
        private AccessBottomPenStyle() {
        }

        @Override
        Object getAttr(Style style) {
            return StyleAccess.getBorderPenStyle(style, Styles.Position.BOTTOM);
        }

        @Override
        void setAttr(StyleAttributes sa, Object value) {
            StyleAccess.setBorderPenStyle(sa, value, Styles.Position.BOTTOM);
        }
    }

    private static class AccessBottomLineStyle
    extends StyleAttrAccess {
        private AccessBottomLineStyle() {
        }

        @Override
        Object getAttr(Style style) {
            return StyleAccess.getBorderLineStyle(style, Styles.Position.BOTTOM);
        }

        @Override
        void setAttr(StyleAttributes sa, Object value) {
            StyleAccess.setBorderLineStyle(sa, value, Styles.Position.BOTTOM);
        }
    }

    private static class AccessTopColor
    extends StyleAttrAccess {
        private AccessTopColor() {
        }

        @Override
        Object getAttr(Style style) {
            return StyleAccess.getBorderColor(style, Styles.Position.TOP);
        }

        @Override
        void setAttr(StyleAttributes sa, Object value) {
            StyleAccess.setBorderColor(sa, value, Styles.Position.TOP);
        }
    }

    private static class AccessTopPenStyle
    extends StyleAttrAccess {
        private AccessTopPenStyle() {
        }

        @Override
        Object getAttr(Style style) {
            return StyleAccess.getBorderPenStyle(style, Styles.Position.TOP);
        }

        @Override
        void setAttr(StyleAttributes sa, Object value) {
            StyleAccess.setBorderPenStyle(sa, value, Styles.Position.TOP);
        }
    }

    private static class AccessTopLineStyle
    extends StyleAttrAccess {
        private AccessTopLineStyle() {
        }

        @Override
        Object getAttr(Style style) {
            return StyleAccess.getBorderLineStyle(style, Styles.Position.TOP);
        }

        @Override
        void setAttr(StyleAttributes sa, Object value) {
            StyleAccess.setBorderLineStyle(sa, value, Styles.Position.TOP);
        }
    }

    private static class AccessRightColor
    extends StyleAttrAccess {
        private AccessRightColor() {
        }

        @Override
        Object getAttr(Style style) {
            return StyleAccess.getBorderColor(style, Styles.Position.RIGHT);
        }

        @Override
        void setAttr(StyleAttributes sa, Object value) {
            StyleAccess.setBorderColor(sa, value, Styles.Position.RIGHT);
        }
    }

    private static class AccessRightPenStyle
    extends StyleAttrAccess {
        private AccessRightPenStyle() {
        }

        @Override
        Object getAttr(Style style) {
            return StyleAccess.getBorderPenStyle(style, Styles.Position.RIGHT);
        }

        @Override
        void setAttr(StyleAttributes sa, Object value) {
            StyleAccess.setBorderPenStyle(sa, value, Styles.Position.RIGHT);
        }
    }

    private static class AccessRightLineStyle
    extends StyleAttrAccess {
        private AccessRightLineStyle() {
        }

        @Override
        Object getAttr(Style style) {
            return StyleAccess.getBorderLineStyle(style, Styles.Position.RIGHT);
        }

        @Override
        void setAttr(StyleAttributes sa, Object value) {
            StyleAccess.setBorderLineStyle(sa, value, Styles.Position.RIGHT);
        }
    }

    private static class AccessLeftColor
    extends StyleAttrAccess {
        private AccessLeftColor() {
        }

        @Override
        Object getAttr(Style style) {
            return StyleAccess.getBorderColor(style, Styles.Position.LEFT);
        }

        @Override
        void setAttr(StyleAttributes sa, Object value) {
            StyleAccess.setBorderColor(sa, value, Styles.Position.LEFT);
        }
    }

    private static class AccessLeftPenStyle
    extends StyleAttrAccess {
        private AccessLeftPenStyle() {
        }

        @Override
        Object getAttr(Style style) {
            return StyleAccess.getBorderPenStyle(style, Styles.Position.LEFT);
        }

        @Override
        void setAttr(StyleAttributes sa, Object value) {
            StyleAccess.setBorderPenStyle(sa, value, Styles.Position.LEFT);
        }
    }

    private static class AccessLeftLineStyle
    extends StyleAttrAccess {
        private AccessLeftLineStyle() {
        }

        @Override
        Object getAttr(Style style) {
            return StyleAccess.getBorderLineStyle(style, Styles.Position.LEFT);
        }

        @Override
        void setAttr(StyleAttributes sa, Object value) {
            StyleAccess.setBorderLineStyle(sa, value, Styles.Position.LEFT);
        }
    }

    private static class AccessPadding
    extends StyleAttrAccess {
        private AccessPadding() {
        }

        @Override
        Object getAttr(Style style) {
            return style.getPadding();
        }

        @Override
        void setAttr(StyleAttributes sa, Object value) {
            if (!(value instanceof Integer)) {
                throw new R1PrintRuntimeException("Padding must be int.");
            }
            sa.setPadding(new Rect((Integer)value, (Integer)value, (Integer)value, (Integer)value));
        }
    }

    private static class AccessWordSpace
    extends StyleAttrAccess {
        private AccessWordSpace() {
        }

        @Override
        Object getAttr(Style style) {
            return (int)style.getWordspacing();
        }

        @Override
        void setAttr(StyleAttributes sa, Object value) {
            if (!(value instanceof Integer)) {
                throw new R1PrintRuntimeException("WordSpace must be int.");
            }
            sa.setWordspacing(((Integer)value).intValue());
        }
    }

    private static class AccessLineSpace
    extends StyleAttrAccess {
        private AccessLineSpace() {
        }

        @Override
        Object getAttr(Style style) {
            return (int)style.getLinespacing();
        }

        @Override
        void setAttr(StyleAttributes sa, Object value) {
            if (!(value instanceof Integer)) {
                throw new R1PrintRuntimeException("LineSpace must be int.");
            }
            sa.setLinespacing(((Integer)value).intValue());
        }
    }

    private static class AccessRotation
    extends StyleAttrAccess {
        private AccessRotation() {
        }

        @Override
        Object getAttr(Style style) {
            return style.getRotation();
        }

        @Override
        void setAttr(StyleAttributes sa, Object value) {
            if (!(value instanceof Integer)) {
                throw new R1PrintRuntimeException("Rotation must be int.");
            }
            sa.setRotation((Integer)value);
        }
    }

    private static class AccessTextShrink
    extends StyleAttrAccess {
        private AccessTextShrink() {
        }

        @Override
        Object getAttr(Style style) {
            return style.isShrinkText();
        }

        @Override
        void setAttr(StyleAttributes sa, Object value) {
            if (!(value instanceof Boolean)) {
                throw new R1PrintRuntimeException("ShrinkText must be boolean.");
            }
            sa.setShrinkText((Boolean)value);
        }
    }

    private static class AccessTextWrap
    extends StyleAttrAccess {
        private AccessTextWrap() {
        }

        @Override
        Object getAttr(Style style) {
            return style.isWrapText();
        }

        @Override
        void setAttr(StyleAttributes sa, Object value) {
            if (!(value instanceof Boolean)) {
                throw new R1PrintRuntimeException("WrapText must be boolean.");
            }
            sa.setWrapText((Boolean)value);
        }
    }

    private static class AccessVerticalAlign
    extends StyleAttrAccess {
        private AccessVerticalAlign() {
        }

        @Override
        Object getAttr(Style style) {
            return style.getVerticalAlign();
        }

        @Override
        void setAttr(StyleAttributes sa, Object value) {
            if (!(value instanceof String)) {
                throw new R1PrintRuntimeException("The alignment value must be String. top/middle/bottom");
            }
            sa.setVerticalAlign(Styles.VerticalAlignment.getAlignment((String)value));
        }
    }

    private static class AccessHorizontalAlign
    extends StyleAttrAccess {
        private AccessHorizontalAlign() {
        }

        @Override
        Object getAttr(Style style) {
            return style.getHorizontalAlign();
        }

        @Override
        void setAttr(StyleAttributes sa, Object value) {
            if (!(value instanceof String)) {
                throw new R1PrintRuntimeException("The alignment value must be String. left/center/right");
            }
            sa.setHorizontalAlign(Styles.HorizontalAlignment.getAlignment((String)value));
        }
    }

    private static class AccessFormet
    extends StyleAttrAccess {
        private AccessFormet() {
        }

        @Override
        Object getAttr(Style style) {
            return style.getNumberFormat();
        }

        @Override
        void setAttr(StyleAttributes sa, Object value) {
            if (!(value instanceof String)) {
                throw new R1PrintRuntimeException("FormatString must be String.");
            }
            sa.setNumberFormat((String)value);
        }
    }

    private static class AccessBackground
    extends StyleAttrAccess {
        private AccessBackground() {
        }

        @Override
        Object getAttr(Style style) {
            return StyleAccess.color2string(style.getBackground());
        }

        @Override
        void setAttr(StyleAttributes sa, Object value) {
            Color color = null;
            if (value instanceof String) {
                color = StyleAccess.string2Color((String)value);
            } else if (value instanceof Color) {
                color = (Color)value;
            }
            if (color != null) {
                sa.setBackground(color);
            }
        }
    }

    private static class AccessFontStrikeThrough
    extends StyleAttrAccess {
        private AccessFontStrikeThrough() {
        }

        @Override
        Object getAttr(Style style) {
            return style.isStrikeThrough();
        }

        @Override
        void setAttr(StyleAttributes sa, Object value) {
            if (!(value instanceof Boolean)) {
                throw new R1PrintRuntimeException("StrikeThrough must be boolean.");
            }
            sa.setStrikeThrough((Boolean)value);
        }
    }

    private static class AccessFontUnderline
    extends StyleAttrAccess {
        private AccessFontUnderline() {
        }

        @Override
        Object getAttr(Style style) {
            return style.isUnderline();
        }

        @Override
        void setAttr(StyleAttributes sa, Object value) {
            if (!(value instanceof Boolean)) {
                throw new R1PrintRuntimeException("Underline must be boolean.");
            }
            sa.setUnderline((Boolean)value);
        }
    }

    private static class AccessFontItalic
    extends StyleAttrAccess {
        private AccessFontItalic() {
        }

        @Override
        Object getAttr(Style style) {
            return style.isItalic();
        }

        @Override
        void setAttr(StyleAttributes sa, Object value) {
            if (!(value instanceof Boolean)) {
                throw new R1PrintRuntimeException("Italic must be boolean.");
            }
            sa.setItalic((Boolean)value);
        }
    }

    private static class AccessFontBold
    extends StyleAttrAccess {
        private AccessFontBold() {
        }

        @Override
        Object getAttr(Style style) {
            return style.isBold();
        }

        @Override
        void setAttr(StyleAttributes sa, Object value) {
            if (!(value instanceof Boolean)) {
                throw new R1PrintRuntimeException("Bold must be boolean.");
            }
            sa.setBold((Boolean)value);
        }
    }

    private static class AccessFontColor
    extends StyleAttrAccess {
        private AccessFontColor() {
        }

        @Override
        Object getAttr(Style style) {
            return StyleAccess.color2string(style.getFontColor());
        }

        @Override
        void setAttr(StyleAttributes sa, Object value) {
            Color color = null;
            if (value instanceof String) {
                color = StyleAccess.string2Color((String)value);
            } else if (value instanceof Color) {
                color = (Color)value;
            }
            if (color != null) {
                sa.setFontColor(color);
            }
        }
    }

    private static class AccessFontSize
    extends StyleAttrAccess {
        private AccessFontSize() {
        }

        @Override
        Object getAttr(Style style) {
            return style.getFontSize();
        }

        @Override
        void setAttr(StyleAttributes sa, Object value) {
            if (!(value instanceof Integer)) {
                throw new R1PrintRuntimeException("Font size must be int.");
            }
            sa.setFontSize((Integer)value);
        }
    }

    private static class AccessFontName
    extends StyleAttrAccess {
        private AccessFontName() {
        }

        @Override
        Object getAttr(Style style) {
            return style.getFontName();
        }

        @Override
        void setAttr(StyleAttributes sa, Object value) {
            if (!(value instanceof String)) {
                throw new R1PrintRuntimeException("Font name must be String.");
            }
            sa.setFontName((String)value);
        }
    }

    private static abstract class StyleAttrAccess {
        private StyleAttrAccess() {
        }

        abstract Object getAttr(Style var1);

        abstract void setAttr(StyleAttributes var1, Object var2);
    }
}

