/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.datagrid;

import com.kingdee.bos.ctrl.reportone.r1.print.engine.IWidgetExecuteHelper;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.exception.R1PrintException;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.AbstractPrintWidget;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.IAdjustHeightSupport;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.IPrintWidget;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.datagrid.PWDataGridCell;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.datagrid.context.GridExecuteContext;
import java.util.ArrayList;

public abstract class AbstractPWDataGridRow
extends AbstractPrintWidget
implements IAdjustHeightSupport {
    public static final String PKey_GridContext = "gridContext";
    public static final int ROW_GROUP = 1;
    public static final int ROW_DETAIL = 2;
    public static final int ROW_EXTEND = 3;
    private ArrayList _cells;
    private int _height;
    private int _groupLevel;
    private boolean _isBackwardForward;
    private int _fromDesignIdx = -1;
    private boolean _isAdjustHeight;
    private int _maxHeightToAdjust;
    private boolean _isRemainContent;
    private boolean _isOutputOnce;

    public abstract int getRowType();

    public AbstractPWDataGridRow() {
        this(0);
    }

    AbstractPWDataGridRow(int size) {
        this._cells = new ArrayList(size);
        for (int i = 0; i < size; ++i) {
            this.addCell();
        }
    }

    PWDataGridCell addCell() {
        PWDataGridCell cell = new PWDataGridCell();
        return this.addCell(this._cells.size(), cell);
    }

    PWDataGridCell insertCell(int cellIndex) {
        PWDataGridCell cell = new PWDataGridCell();
        return this.addCell(cellIndex, cell);
    }

    void addCell(PWDataGridCell cell) {
        this.addCell(this._cells.size(), cell);
    }

    private PWDataGridCell addCell(int cellIndex, PWDataGridCell cell) {
        if (cellIndex < 0 || cellIndex > this._cells.size()) {
            return null;
        }
        this._cells.add(cellIndex, cell);
        return cell;
    }

    public PWDataGridCell getCell(int cellIndex) {
        if (cellIndex < 0 || cellIndex >= this._cells.size()) {
            return null;
        }
        return (PWDataGridCell)this._cells.get(cellIndex);
    }

    public int getCellCount() {
        return this._cells.size();
    }

    public void setHeight(int h) {
        this._height = h;
    }

    public int getHeight() {
        return this._height;
    }

    public void setGroupLevel(int level) {
        this._groupLevel = level;
    }

    public int getGroupLevel() {
        return this._groupLevel;
    }

    @Override
    public IPrintWidget copy() {
        AbstractPWDataGridRow newRow = (AbstractPWDataGridRow)super.copy();
        newRow.setHeight(this.getHeight());
        newRow.setGroupLevel(this.getGroupLevel());
        newRow.setAdjustHeight(this.isAdjustHeight());
        newRow.setBackwardForward(this.isBackwardForward());
        return newRow;
    }

    @Override
    public IPrintWidget execute(IWidgetExecuteHelper helper) throws R1PrintException {
        throw new R1PrintException("unsupported method");
    }

    @Override
    protected void executing(IWidgetExecuteHelper helper, IPrintWidget outputWidget) throws R1PrintException {
    }

    public void setFromDesignIdx(int designIdx) {
        this._fromDesignIdx = designIdx;
    }

    public int getFromDesignIdx() {
        return this._fromDesignIdx;
    }

    @Override
    public void setRemainContent(boolean isRemain) {
        this._isRemainContent = isRemain;
    }

    @Override
    public boolean isRemainContent() {
        return this._isRemainContent;
    }

    @Override
    public void setAdjustHeight(boolean isAdjustHeight) {
        this._isAdjustHeight = isAdjustHeight;
    }

    @Override
    public boolean isAdjustHeight() {
        return this._isAdjustHeight;
    }

    @Override
    public void setMaxHeightToAdjust(int maxHeight) {
        this._maxHeightToAdjust = maxHeight;
    }

    @Override
    public int getMaxHeightToAdjust() {
        return this._maxHeightToAdjust;
    }

    public void setBackwardForward(boolean is) {
        this._isBackwardForward = is;
    }

    public boolean isBackwardForward() {
        return this._isBackwardForward;
    }

    public void setOutputOnce(boolean isOnce) {
        this._isOutputOnce = isOnce;
    }

    public boolean isOutputOnce() {
        return this._isOutputOnce;
    }

    public int getRowNumber(int level) {
        GridExecuteContext ctx = (GridExecuteContext)this.getContext().getExt(PKey_GridContext);
        return ctx.getStatSet().getRowNumber(level);
    }

    public int getGroupNumber() {
        GridExecuteContext ctx = (GridExecuteContext)this.getContext().getExt(PKey_GridContext);
        return ctx.getStatSet().getGroupNumber(this.getGroupLevel());
    }
}

