/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.datagrid;

import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.merge.MergeBlock;
import com.kingdee.bos.ctrl.reportone.r1.print.barcode.PWBarcode;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.ExecuteContext;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.IWidgetExecuteHelper;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.R1PrintEngine;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.data.DataHelperExchanger;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.data.DataHelperWrapper;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.exception.R1PrintException;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.exception.R1PrintRuntimeException;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.AbstractPrintWidget;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.AbstractPrintWidgetText;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.IDatasourceSupport;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.IPaginationSupport;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.IPrintWidget;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.PWPicture;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.datagrid.AbstractPWDataGridRow;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.datagrid.PWDataGridCell;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.datagrid.PWDataGridColumn;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.datagrid.PWDetailRow;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.datagrid.PWExtendRow;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.datagrid.PWGroupRow;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.datagrid.context.CellExecuteContext;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.datagrid.context.GridExecuteContext;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.datagrid.context.GroupPageNumberManager;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.datagrid.context.GroupRuntimeValue;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.datagrid.context.TemporaryOutput;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.datagrid.merge.MergeHelper;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.layoutgrid.PWLayoutGrid;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.TreePath;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.args.OutputElementArgs;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class PWDataGrid
extends AbstractPrintWidget
implements IPaginationSupport,
IDatasourceSupport {
    private static final Log log = LogFactory.getLog(PWDataGrid.class);
    private static final String EXTPROP_DETAILROWMINLOOPTIMES = "minLoopTimes";
    public static final String ExtProp_SinkToBottom = "sinkToBottom";
    private ArrayList<AbstractPWDataGridRow> rows = new ArrayList();
    private ArrayList<PWDataGridColumn> columns = new ArrayList();
    private String ds;
    private List<MergeBlock> mergeBlocks;
    private ArrayList<AbstractPWDataGridRow> outputRows = new ArrayList();
    private ArrayList<IPrintWidget> outputColumns;
    private boolean isSubGridField = false;

    public boolean isSubGrid() {
        return this.isSubGridField;
    }

    public void setSubGrid(boolean isSubGrid) {
        this.isSubGridField = isSubGrid;
    }

    public PWDataGrid() {
        this.mergeBlocks = new ArrayList<MergeBlock>();
    }

    public AbstractPWDataGridRow addRow(int type) {
        return this.createRow(type, this.rows.size());
    }

    private AbstractPWDataGridRow createRow(int type, int rowIndex) {
        AbstractPWDataGridRow row;
        if (type == 2) {
            row = new PWDetailRow(this.columns.size());
        } else if (type == 3) {
            row = new PWExtendRow(this.columns.size());
        } else if (type == 1) {
            row = new PWGroupRow(this.columns.size());
        } else {
            throw new IllegalArgumentException("Type error.");
        }
        this.rows.add(rowIndex, row);
        return row;
    }

    public int getRowsCount() {
        return this.rows.size();
    }

    public AbstractPWDataGridRow getRow(int rowIndex) {
        return this.rows.get(rowIndex);
    }

    public int getIndexOfRow(AbstractPWDataGridRow row) {
        return this.rows.indexOf(row);
    }

    public PWDataGridColumn addColumn() {
        return this.createColumn(this.columns.size());
    }

    private PWDataGridColumn createColumn(int colIndex) {
        PWDataGridColumn col = new PWDataGridColumn();
        this.columns.add(colIndex, col);
        int c = this.getRowsCount();
        for (int i = 0; i < c; ++i) {
            this.getRow(i).insertCell(colIndex);
        }
        return col;
    }

    public int getColumnCount() {
        return this.columns.size();
    }

    public PWDataGridColumn getColumn(int colIndex) {
        return this.columns.get(colIndex);
    }

    public List<MergeBlock> getMergeBlocks() {
        return this.mergeBlocks;
    }

    public List<AbstractPWDataGridRow> getOutputRows() {
        return this.outputRows;
    }

    public AbstractPWDataGridRow getOutputRow(int idx) {
        return this.getOutputRows().get(idx);
    }

    public List<IPrintWidget> getOutputColumns() {
        return this.outputColumns;
    }

    public PWDataGridColumn getOutputColumn(int colIndex) {
        return (PWDataGridColumn)this.outputColumns.get(colIndex);
    }

    @Override
    public void setDatasource(String value) {
        this.ds = value;
    }

    @Override
    public String getDatasource() {
        return this.ds;
    }

    private int getFirstRowOfGroupLevel(int level) {
        int c = this.getRowsCount();
        for (int i = 0; i < c; ++i) {
            if (level != this.getRow(i).getGroupLevel()) continue;
            return i;
        }
        return -1;
    }

    private int getLastRowOfGroupLevel(int level) {
        for (int i = this.getRowsCount() - 1; i >= 0; --i) {
            if (level != this.getRow(i).getGroupLevel()) continue;
            return i;
        }
        return -1;
    }

    private void clearOutputOnceMark(int level) {
        int c = this.getRowsCount();
        for (int i = 0; i < c; ++i) {
            AbstractPWDataGridRow row = this.getRow(i);
            if (row.getGroupLevel() < level) continue;
            row.setOutputOnce(false);
        }
    }

    private int getDetailRowIndex() {
        int c = this.getRowsCount();
        for (int i = 0; i < c; ++i) {
            AbstractPWDataGridRow row = this.getRow(i);
            if (!(row instanceof PWDetailRow) || row.isBackwardForward()) continue;
            return i;
        }
        throw new R1PrintRuntimeException(ResManager.loadKDString((String)"PWDataGrid--getDetailRowIndex\uff0c\u6ca1\u6709\u6570\u636e\u884c\u3002", (String)"PWDataGrid_1", (String)"bos-print-engine", (Object[])new Object[0]));
    }

    private AbstractPWDataGridRow getForwardRow() {
        int detailIdx = this.getDetailRowIndex();
        int c = this.getRowsCount();
        for (int i = detailIdx + 1; i < c; ++i) {
            AbstractPWDataGridRow row = this.getRow(i);
            if (!row.isBackwardForward()) continue;
            return row;
        }
        return null;
    }

    private AbstractPWDataGridRow getBackwardRow() {
        int detailIdx = this.getDetailRowIndex();
        for (int i = detailIdx - 1; i >= 0; --i) {
            AbstractPWDataGridRow row = this.getRow(i);
            if (!row.isBackwardForward()) continue;
            return row;
        }
        return null;
    }

    private AbstractPWDataGridRow getExtendRow() {
        int c = this.getRowsCount();
        for (int i = 0; i < c; ++i) {
            AbstractPWDataGridRow row = this.getRow(i);
            if (!(row instanceof PWExtendRow)) continue;
            return row;
        }
        return null;
    }

    @Override
    public boolean isOutputEnd() {
        return this.getGridExecuteContext().isOutputEnd();
    }

    @Override
    public IPrintWidget copy() {
        int i;
        PWDataGrid outputGrid = (PWDataGrid)super.copy();
        outputGrid.rows = this.rows;
        outputGrid.columns = this.columns;
        outputGrid.setSubGrid(this.isSubGridField);
        outputGrid.outputColumns = new ArrayList();
        int c = this.columns.size();
        for (i = 0; i < c; ++i) {
            outputGrid.outputColumns.add(this.columns.get(i).copy());
        }
        outputGrid.setDatasource(this.getDatasource());
        if (this.getMergeBlocks() != null) {
            c = this.getMergeBlocks().size();
            for (i = 0; i < c; ++i) {
                outputGrid.getMergeBlocks().add((MergeBlock)this.getMergeBlocks().get(i).clone());
            }
        }
        return outputGrid;
    }

    @Override
    public ExecuteContext getContext() {
        return this.getGridExecuteContext();
    }

    private GridExecuteContext getGridExecuteContext() {
        if (this._executeContext == null) {
            this._executeContext = new GridExecuteContext(this);
        }
        return (GridExecuteContext)this._executeContext;
    }

    private void outputRow(AbstractPWDataGridRow rowToOutput, boolean isGrow, TemporaryOutput tempOutput) {
        this.getOutputRows().add(rowToOutput);
        tempOutput.addRow(rowToOutput);
        if (isGrow) {
            MergeHelper.adjustInserRow(this.getMergeBlocks(), this.getOutputRows().size() - 1, true);
        }
    }

    private void hideRow(AbstractPWDataGridRow oriRow) {
        this.hideRow(this.getOutputRows().size(), oriRow);
    }

    private void hideRow(int idx, AbstractPWDataGridRow oriRow) {
        MergeHelper.adjustDeleteRow(this.getMergeBlocks(), idx, this, oriRow);
    }

    @Override
    protected void executing(IWidgetExecuteHelper helper, IPrintWidget outputWidget) throws R1PrintException {
        int parentHeight;
        PWDataGrid outputGrid = (PWDataGrid)outputWidget;
        if (outputGrid.isSubGrid() && helper.getDataHelper().isBOF(this.ds) && !helper.getDataHelper().hasNext(this.ds)) {
            this.getGridExecuteContext().setOutputEnd(true);
            return;
        }
        if (this.getGridExecuteContext().isDead()) {
            if (outputGrid.isSubGrid()) {
                this.getGridExecuteContext().relive();
            } else {
                outputWidget.getRectangle().height = 0;
                this.getGridExecuteContext().setOutputEnd(true);
                return;
            }
        }
        int c = outputGrid.getOutputColumns().size();
        for (int i = 0; i < c; ++i) {
            IWidgetExecuteHelper.IDataHelper dhp = outputGrid.getDataHelper(helper, this.getMainDs());
            PWDataGridColumn currentCol = outputGrid.getOutputColumn(i);
            OutputElementArgs args = new OutputElementArgs(this, currentCol.getId(), this.ds, this.getMainDs(), dhp, currentCol);
            args.setMergeDetailCol(currentCol.isMergeDetailCol());
            if (helper.getPluginProxy() != null) {
                helper.getPluginProxy().fireBeforeOuputElement(args);
                currentCol.setSumColKeys(args.getSumColKeys());
                currentCol.setMergeDetailCol(args.isMergeDetailCol());
            }
            helper.runScript(outputGrid.getOutputColumn(i), 1);
        }
        R1PrintEngine.markOutputId(helper, outputGrid.outputColumns);
        int addedY = outputGrid.getRectangle().y;
        int n = parentHeight = this.getContext().isAdjustHeight() ? this.getContext().getMaxHeightToAdjust() : this.getContext().getContainerHeight();
        if (outputGrid.isSubGrid() && !this.getContext().isAdjustHeight()) {
            int designGridHeight = 0;
            for (AbstractPWDataGridRow r : this.rows) {
                designGridHeight += r.getHeight();
            }
            if (parentHeight < designGridHeight) {
                log.error("\u6253\u5370\uff1a\u7236\u6570\u636e\u884c\u6ca1\u6709\u52fe\u9009\u884c\u9ad8\u81ea\u9002\u5e94\uff0c\u5e76\u4e14\u5b50\u6570\u636e\u8868\u683c\u7684\u7684\u8bbe\u8ba1\u65f6\u9ad8\u5ea6\u5c0f\u4e8e\u7236\u6570\u636e\u884c\u7684\u9ad8\u5ea6, \u4e0d\u8f93\u51fa\u5b50\u6570\u636e\u8868\u683c\u3002");
                return;
            }
        }
        AuxExecuteDetail auxParam = new AuxExecuteDetail();
        int currentLevel = 0;
        int rowCursor = 0;
        int rowsCount = outputGrid.getRowsCount();
        boolean paginationByDetail = false;
        int paginationByGroup = -1;
        boolean isLastPageTailNotEnough = this.getGridExecuteContext().isNotEnoughOutputTailGroupRow();
        this.getGridExecuteContext().setNotEnoughOutputTailGroupRow(false);
        boolean firstNotEnough = true;
        int detailRowIdx = this.getDetailRowIndex();
        int levels = outputGrid.getRow(detailRowIdx).getGroupLevel() + 1;
        TemporaryOutput tempOutput = new TemporaryOutput(levels);
        AbstractPWDataGridRow backwardRow = this.getBackwardRow();
        AbstractPWDataGridRow forwardRow = this.getForwardRow();
        AbstractPWDataGridRow extendRow = this.getExtendRow();
        boolean isBackwardOccupyDetail = false;
        while (rowCursor < rowsCount) {
            AbstractPWDataGridRow row = outputGrid.getRow(rowCursor);
            currentLevel = row.getGroupLevel();
            if (row instanceof PWGroupRow) {
                PWGroupRow groupRow = (PWGroupRow)row;
                if (outputGrid.isSubGrid()) {
                    groupRow.setAppearEveryPage(true);
                }
                if (!row.isOutputOnce() && rowCursor == this.getFirstRowOfGroupLevel(currentLevel)) {
                    this.getGridExecuteContext().getGroupPageNumberManager().registGroupStart(currentLevel, outputGrid.getOwnerOutputPage().getPageIndex());
                }
                boolean isBeforeDetail = rowCursor < detailRowIdx;
                boolean forceNotToOutput = false;
                forceNotToOutput = !row.isPrintable();
                boolean unconditionalToOutput = false;
                if (this.isGroupRowAppearEveryPage(helper, groupRow)) {
                    unconditionalToOutput = true;
                } else if (row == forwardRow) {
                    row.setOutputOnce(true);
                    boolean bl = unconditionalToOutput = !this.isLevelGroupEnd(currentLevel, helper, this.getGridExecuteContext().getGroupRuntimeValue(), false) && !helper.getDataHelper().isEOF(this.getDatasource());
                    if (!unconditionalToOutput && backwardRow != null) {
                        backwardRow.setOutputOnce(false);
                    }
                }
                boolean turnToOutput = false;
                if (row == backwardRow) {
                    turnToOutput = row.isOutputOnce();
                    row.setOutputOnce(true);
                } else if (!row.isOutputOnce()) {
                    turnToOutput = isBeforeDetail ? true : this.isLevelGroupEnd(currentLevel);
                }
                if ((unconditionalToOutput || turnToOutput) && (paginationByGroup < 0 || paginationByGroup > currentLevel)) {
                    int tailHeight = 0;
                    int forwardRowOccupy = 0;
                    if (!forceNotToOutput) {
                        for (int i = outputGrid.getRowsCount() - 1; i > rowCursor; --i) {
                            AbstractPWDataGridRow tempRow = outputGrid.getRow(i);
                            if (!(tempRow instanceof PWGroupRow) || !tempRow.isPrintable() || !this.isGroupRowAppearEveryPage(helper, (PWGroupRow)tempRow)) continue;
                            tailHeight += tempRow.getHeight();
                        }
                        if (row != forwardRow && forwardRow != null && forwardRow.isPrintable() && rowCursor > detailRowIdx && rowCursor < this.getIndexOfRow(forwardRow) && !this.isLevelGroupEnd(forwardRow.getGroupLevel(), helper, this.getGridExecuteContext().getGroupRuntimeValue(), false)) {
                            forwardRowOccupy = forwardRow.getHeight();
                        }
                    }
                    if (!forceNotToOutput && addedY + row.getHeight() > parentHeight - forwardRowOccupy - tailHeight && !outputGrid.isSubGrid()) {
                        outputGrid.hideRow(row);
                        if (firstNotEnough && !isBeforeDetail) {
                            this.getGridExecuteContext().setNotEnoughOutputTailGroupRow(true);
                        }
                        firstNotEnough = false;
                        paginationByGroup = currentLevel;
                    } else {
                        DataHelperExchanger exchanger = new DataHelperExchanger();
                        if (!(isBeforeDetail && !isLastPageTailNotEnough && row != backwardRow || auxParam.isRemainContent())) {
                            DataHelperWrapper dataHelperWrapper = new DataHelperWrapper(helper, this.getDatasource());
                            exchanger.exchange(helper, dataHelperWrapper);
                        }
                        AbstractPWDataGridRow outputRow = PWDataGrid.executeRow(helper, this, outputGrid, row, false, false, row.getHeight(), isBeforeDetail);
                        exchanger.unExchange();
                        boolean bl = forceNotToOutput = forceNotToOutput || !outputRow.isPrintable();
                        if (forceNotToOutput) {
                            outputGrid.hideRow(row);
                        } else {
                            addedY += outputRow.getHeight();
                            outputGrid.outputRow(outputRow, false, tempOutput);
                        }
                        if (!isBeforeDetail) {
                            tempOutput.markContainsTailGroup(currentLevel);
                        }
                        if (turnToOutput) {
                            row.setOutputOnce(true);
                        }
                    }
                } else {
                    outputGrid.hideRow(row);
                }
                this.fillStat(rowCursor, rowsCount, outputGrid, currentLevel);
            } else if (row instanceof PWDetailRow) {
                if (row == backwardRow) {
                    if (row.isPrintable() && row.isOutputOnce()) {
                        DataHelperExchanger exchanger = new DataHelperExchanger();
                        DataHelperWrapper dataHelperWrapper = new DataHelperWrapper(helper, this.getDatasource());
                        exchanger.exchange(helper, dataHelperWrapper);
                        AbstractPWDataGridRow outputRow = PWDataGrid.executeRow(helper, this, outputGrid, row, false, false, row.getHeight(), true);
                        exchanger.unExchange();
                        addedY += outputRow.getHeight();
                        outputGrid.outputRow(outputRow, false, tempOutput);
                        isBackwardOccupyDetail = true;
                    } else {
                        outputGrid.hideRow(row);
                    }
                    row.setOutputOnce(true);
                } else if (row == forwardRow) {
                    if (row.isPrintable() && !this.isLevelGroupEnd(currentLevel, helper, this.getGridExecuteContext().getGroupRuntimeValue(), false) && !helper.getDataHelper().isEOF(this.getDatasource())) {
                        DataHelperExchanger exchanger = new DataHelperExchanger();
                        DataHelperWrapper dataHelperWrapper = new DataHelperWrapper(helper, this.getDatasource());
                        exchanger.exchange(helper, dataHelperWrapper);
                        AbstractPWDataGridRow outputRow = PWDataGrid.executeRow(helper, this, outputGrid, row, false, false, row.getHeight(), false);
                        exchanger.unExchange();
                        addedY += outputRow.getHeight();
                        outputGrid.outputRow(outputRow, false, tempOutput);
                        row.setOutputOnce(true);
                    } else {
                        outputGrid.hideRow(row);
                        if (backwardRow != null) {
                            backwardRow.setOutputOnce(false);
                        }
                    }
                } else if (isLastPageTailNotEnough || paginationByGroup >= 0) {
                    outputGrid.hideRow(row);
                    tempOutput.markContainsDetail();
                    auxParam.setDetailOutputed(true);
                } else {
                    PWDetailRow detailRow = (PWDetailRow)row;
                    auxParam.setAddedY(addedY);
                    paginationByDetail = PWDataGrid.executeDetailRows(helper, this, outputGrid, detailRow, auxParam, tempOutput, isBackwardOccupyDetail, forwardRow, extendRow);
                    addedY = auxParam.getAddedY();
                }
                if (rowCursor == rowsCount - 1) {
                    if (!helper.getDataHelper().isEOF(this.getDatasource())) {
                        this.fillAreaStat();
                    } else {
                        this.fillGroupStat(outputGrid, 0);
                    }
                }
            }
            int levelOfGroupEnd = this.getGridExecuteContext().getLevelOfGroupEnd();
            if (this.getGridExecuteContext().isNotEnoughOutputTailGroupRow()) {
                ++rowCursor;
                continue;
            }
            if (paginationByGroup >= 0) {
                if (currentLevel == levelOfGroupEnd && rowCursor == outputGrid.getLastRowOfGroupLevel(currentLevel)) {
                    this.backToGroupStart(currentLevel);
                    tempOutput.accept(currentLevel);
                    isLastPageTailNotEnough = false;
                    isBackwardOccupyDetail = false;
                }
                ++rowCursor;
                continue;
            }
            if (levelOfGroupEnd == 0) {
                ++rowCursor;
                continue;
            }
            if (currentLevel >= levelOfGroupEnd) {
                if (currentLevel == levelOfGroupEnd && rowCursor == outputGrid.getLastRowOfGroupLevel(currentLevel)) {
                    int n2 = paginationByGroup = ((PWGroupRow)row).getGroupDesc().isDividePageWhenDifferent() ? currentLevel : -1;
                    if (outputGrid.isSubGrid() && (paginationByGroup >= 0 || paginationByDetail)) {
                        this.backToGroupStart(currentLevel);
                        tempOutput.accept(currentLevel);
                        isLastPageTailNotEnough = false;
                        isBackwardOccupyDetail = false;
                        ++rowCursor;
                        continue;
                    }
                    rowCursor = this.backToGroupStart(currentLevel);
                    tempOutput.accept(currentLevel);
                    isLastPageTailNotEnough = false;
                    isBackwardOccupyDetail = false;
                    this.copyGroupMergeBlocks(outputGrid, currentLevel);
                    continue;
                }
                ++rowCursor;
                continue;
            }
            ++rowCursor;
        }
        outputGrid.dealIllogicalEnd(tempOutput);
        outputGrid.calculateMerge();
        outputGrid.syncOutputRectangle();
        outputGrid.clearReferCell(0, outputGrid.getRowsCount() - 1);
        outputGrid.checkSinkToBottom();
        this.getGridExecuteContext().setOutputEnd(this.getGridExecuteContext().getLevelOfGroupEnd() == 0 && !this.getGridExecuteContext().isNotEnoughOutputTailGroupRow());
        int c2 = outputGrid.getOutputColumns().size();
        for (int i = 0; i < c2; ++i) {
            helper.runScript(outputGrid.getOutputColumn(i), 2);
        }
        if (!outputGrid.getOutputRows().isEmpty()) {
            TreePath outputedPath = R1PrintEngine.createOutputedParent(outputGrid.getOutputedParent(), outputGrid);
            helper.getDataContext().addOverdoData(outputGrid.getDatasource(), outputedPath, this.getGridExecuteContext().isNotEnoughOutputTailGroupRow());
            if (this.getGridExecuteContext().isOutputEnd()) {
                helper.getDataContext().removeOverdoData(outputGrid);
            }
        }
    }

    private void syncOutputRectangle() {
        int height = 0;
        for (AbstractPWDataGridRow row : this.getOutputRows()) {
            height += row.getHeight();
        }
        this.getRectangle().height = height;
    }

    private boolean isLevelGroupEnd(int level) {
        return level >= this.getGridExecuteContext().getLevelOfGroupEnd() && this.getGridExecuteContext().getLevelOfGroupEnd() >= 0;
    }

    private boolean isLevelGroupEnd(int level, IWidgetExecuteHelper helper, GroupRuntimeValue grv, boolean prophetic) {
        int levelOfGroupEnd = prophetic ? PWDataGrid.getPropheticGroupEnd(helper, grv, this.getDatasource()) : grv.getLevelOfGroupEnd(helper, this.getDatasource());
        return level >= levelOfGroupEnd && levelOfGroupEnd > 0;
    }

    private void fillStat(int rowCursor, int rowsCount, PWDataGrid outputGrid, int currentLevel) throws R1PrintException {
        if (this.isLevelGroupEnd(currentLevel) && rowCursor == outputGrid.getLastRowOfGroupLevel(currentLevel) && !this.getGridExecuteContext().isNotEnoughOutputTailGroupRow()) {
            this.fillGroupStat(outputGrid, currentLevel);
        } else if (rowCursor == rowsCount - 1) {
            this.fillAreaStat();
        }
        if (rowCursor == rowsCount - 1 && currentLevel > 0 && this.isLevelGroupEnd(0) && !this.getGridExecuteContext().isNotEnoughOutputTailGroupRow()) {
            this.fillGroupStat(outputGrid, 0);
        }
    }

    private void fillAreaStat() throws R1PrintException {
        this.getGridExecuteContext().getStatSet().fillStatCell(-1);
        this.getGridExecuteContext().getStatSet().clearAreaStats();
        this.getGridExecuteContext().getComputedSet().fill(-1);
    }

    private void fillGroupStat(PWDataGrid outputGrid, int currentLevel) throws R1PrintException {
        this.getGridExecuteContext().getStatSet().fillStatCell(currentLevel);
        this.getGridExecuteContext().getStatSet().clearGroupStats(currentLevel);
        this.getGridExecuteContext().getComputedSet().fill(currentLevel);
        GroupPageNumberManager gpnm = this.getGridExecuteContext().getGroupPageNumberManager();
        String waitingKey = gpnm.createWaitingKey(this, currentLevel);
        int groupPageNumber = gpnm.getGroupPageNumber(currentLevel, outputGrid.getOwnerOutputPage().getPageIndex());
        Variant waitingValue = new Variant(groupPageNumber);
        this._executeHelper.getDelayVarProvider().fillValue(waitingKey, waitingValue);
    }

    private void dealIllogicalEnd(TemporaryOutput tempOutput) throws R1PrintException {
        boolean isIllogical = false;
        boolean[] isIllogicals = tempOutput.isIllogical();
        for (int i = 0; i < isIllogicals.length; ++i) {
            isIllogical = isIllogical || isIllogicals[i];
        }
        if (isIllogical) {
            int idx = this.getOutputRows().size() - 1;
            for (int tempIdx = tempOutput.getOutputsSize() - 1; tempIdx >= 0; --tempIdx) {
                AbstractPWDataGridRow row = this.getOutputRow(idx);
                if (isIllogicals[row.getGroupLevel()]) {
                    if (!row.isBackwardForward()) {
                        this.getOutputRows().remove(row);
                        this.hideRow(idx, null);
                        ((PWGroupRow)this.getRow(row.getFromDesignIdx())).setOutputOnce(false);
                    }
                    for (int i = 0; i < this.getRowsCount(); ++i) {
                        AbstractPWDataGridRow tempRow = this.getRow(i);
                        if (tempRow.getGroupLevel() != row.getGroupLevel() || tempRow.isPrintable()) continue;
                        tempRow.setOutputOnce(false);
                    }
                }
                --idx;
            }
            this.getGridExecuteContext().setNotEnoughOutputTailGroupRow(false);
        }
    }

    private int backToGroupStart(int level) {
        int rowCursor = this.getFirstRowOfGroupLevel(level);
        this.getGridExecuteContext().setLevelOfGroupEnd(Integer.MIN_VALUE);
        this.clearOutputOnceMark(level);
        return rowCursor;
    }

    private void copyGroupMergeBlocks(PWDataGrid outputGrid, int level) {
        int i;
        if (this.getMergeBlocks().isEmpty()) {
            return;
        }
        int firstRowOfLevel = this.getFirstRowOfGroupLevel(level);
        int lastRowOfLevel = this.getLastRowOfGroupLevel(level);
        int outputRowsCount = outputGrid.getOutputRows().size();
        for (i = firstRowOfLevel; i <= lastRowOfLevel; ++i) {
            MergeHelper.adjustInserRow(outputGrid.getMergeBlocks(), outputRowsCount, false);
        }
        outputGrid.clearReferCell(firstRowOfLevel, lastRowOfLevel);
        for (i = this.getMergeBlocks().size() - 1; i >= 0; --i) {
            MergeBlock mb = this.getMergeBlocks().get(i);
            if (mb.getTop() < firstRowOfLevel || mb.getBottom() > lastRowOfLevel) continue;
            int offset = mb.getTop() - firstRowOfLevel;
            int newTop = outputRowsCount + offset;
            int newBottom = newTop + (mb.getBottom() - mb.getTop());
            MergeBlock newMb = MergeBlock.create(mb.getLeft(), mb.getRight(), newTop, newBottom);
            outputGrid.getMergeBlocks().add(newMb);
        }
    }

    private void clearReferCell(int fromRow, int toRow) {
        for (int i = fromRow; i <= toRow; ++i) {
            AbstractPWDataGridRow row = this.getRow(i);
            int c = row.getCellCount();
            for (int j = 0; j < c; ++j) {
                row.getCell(j).setReferCell(null);
            }
        }
    }

    private Object[] getMergeInfos(int rowIdx, int colIdx, boolean isGrow) {
        boolean isHeightAdjust = false;
        for (MergeBlock mb : this.getMergeBlocks()) {
            if (mb.getLeft() != colIdx || mb.getTop() != rowIdx) continue;
            if (isGrow && mb.getBottom() > rowIdx) {
                return null;
            }
            int h = 0;
            for (int i = mb.getTop(); i <= mb.getBottom(); ++i) {
                if (this.getRow(i).isAdjustHeight()) {
                    isHeightAdjust = true;
                }
                h += this.getRow(i).getHeight();
            }
            int w = 0;
            for (int i = mb.getLeft(); i <= mb.getRight(); ++i) {
                w += this.getColumn(i).getWidth();
            }
            return new Object[]{isHeightAdjust, new Dimension(w, h)};
        }
        return null;
    }

    private static boolean executeDetailRows(IWidgetExecuteHelper helper, PWDataGrid grid, PWDataGrid outputGrid, PWDetailRow detailRow, AuxExecuteDetail auxParam, TemporaryOutput tempOutput, boolean isBackwardOccupyDetail, AbstractPWDataGridRow forwardRow, AbstractPWDataGridRow extendRow) throws R1PrintException {
        if (detailRow.getHeight() <= 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u884c\u884c\u9ad8\u4e0d\u5141\u8bb8\u5c0f\u4e8e0\uff0c\u8bf7\u68c0\u67e5\u6a21\u7248\u3002", (String)"PWDataGrid_0", (String)"bos-print-engine", (Object[])new Object[0]));
        }
        GridExecuteContext gridExecuteContext = outputGrid.getGridExecuteContext();
        String ds = outputGrid.getDatasource();
        int repeatTimes = detailRow.getRepeatAtPage();
        int minLoopTimes = detailRow.getContext().getExtProps().getInt(EXTPROP_DETAILROWMINLOOPTIMES, 0);
        if (minLoopTimes == 0) {
            minLoopTimes = outputGrid.getExtProps().getInt(EXTPROP_DETAILROWMINLOOPTIMES, 0);
        }
        boolean isGroupEnd = false;
        if (!gridExecuteContext.isChristmas() && helper.getDataHelper().isBOF(ds) && !helper.getDataHelper().hasNext(ds) && repeatTimes == 0) {
            if (minLoopTimes > 0) {
                isGroupEnd = true;
            } else {
                tempOutput.markContainsDetail();
                outputGrid.hideRow(detailRow);
                if (extendRow != null) {
                    outputGrid.hideRow(extendRow);
                }
                gridExecuteContext.setLevelOfGroupEnd(0);
                return true;
            }
        }
        int forwardRowHeight = 0;
        if (forwardRow != null && forwardRow.isPrintable()) {
            forwardRowHeight = forwardRow.getHeight();
        }
        int remainHeight = 0;
        if (repeatTimes == 0) {
            AbstractPWDataGridRow row;
            int tailHeight = 0;
            for (int i = outputGrid.getRowsCount() - 1; i >= 0 && !((row = outputGrid.getRow(i)) instanceof PWDetailRow) && !(row instanceof PWExtendRow); --i) {
                if (!row.isPrintable() || !((PWGroupRow)row).isAppearEveryPage()) continue;
                tailHeight += row.getHeight();
            }
            ExecuteContext ctx = grid.getContext();
            int parentHeight = ctx.isAdjustHeight() ? ctx.getMaxHeightToAdjust() : ctx.getContainerHeight();
            remainHeight = parentHeight - auxParam.getAddedY() - tailHeight;
            if (remainHeight - forwardRowHeight <= 0 && auxParam.isDetailOutputed()) {
                outputGrid.hideRow(detailRow);
                if (extendRow != null) {
                    outputGrid.hideRow(extendRow);
                }
                return true;
            }
        }
        int addedHeight = 0;
        boolean toRepeatRow = false;
        boolean isDataEnd = false;
        int repeatCount = 0;
        GroupRuntimeValue groupRuntimeValue = gridExecuteContext.getGroupRuntimeValue();
        do {
            int bf;
            int extendRowHeight;
            AbstractPrintWidget outputRow = null;
            AbstractPrintWidget outputExtendRow = null;
            boolean isAdjustHeight = detailRow.isAdjustHeight();
            int outputHeight = -1;
            int n = extendRowHeight = extendRow != null ? extendRow.getHeight() : 0;
            if (isAdjustHeight) {
                int maxHeightToAdjust = remainHeight - addedHeight - forwardRowHeight - extendRowHeight;
                if (maxHeightToAdjust < detailRow.getHeight() + extendRowHeight) {
                    outputRow = null;
                    outputExtendRow = null;
                } else {
                    outputRow = PWDataGrid.executeRow(helper, grid, outputGrid, detailRow, isGroupEnd, repeatCount > 0, maxHeightToAdjust, false);
                    outputRow.setHide(outputRow.isHide() && !isDataEnd && !isGroupEnd);
                    if (extendRow != null) {
                        extendRow.setAdjustHeight(true);
                        outputExtendRow = PWDataGrid.executeRow(helper, grid, outputGrid, extendRow, isGroupEnd, repeatCount > 0, maxHeightToAdjust - ((AbstractPWDataGridRow)outputRow).getHeight() + extendRowHeight, false);
                    }
                    outputHeight = ((AbstractPWDataGridRow)outputRow).getHeight();
                    if (outputExtendRow != null) {
                        outputHeight += ((AbstractPWDataGridRow)outputExtendRow).getHeight();
                    }
                    if (minLoopTimes == 0) {
                        minLoopTimes = outputRow.getExtProps().getInt(EXTPROP_DETAILROWMINLOOPTIMES, 0);
                    }
                }
            } else {
                outputHeight = detailRow.getHeight() + extendRowHeight;
            }
            if (repeatTimes == 0) {
                if (outputHeight >= 0) {
                    addedHeight += outputHeight;
                }
                int heightCanUse = remainHeight;
                GroupRuntimeValue newGRV = (GroupRuntimeValue)groupRuntimeValue.copy();
                newGRV.updateValue(helper, ds);
                if (forwardRow != null && !outputGrid.isLevelGroupEnd(forwardRow.getGroupLevel(), helper, newGRV, true)) {
                    heightCanUse -= forwardRowHeight;
                }
                if (outputHeight <= 0 || detailRow.isPrintable() && addedHeight > heightCanUse) {
                    if (repeatCount == 0) {
                        outputGrid.hideRow(detailRow);
                        if (extendRow != null) {
                            outputGrid.hideRow(extendRow);
                        }
                    }
                    if (minLoopTimes > 0 && !isGroupEnd) {
                        detailRow.getContext().putExt(EXTPROP_DETAILROWMINLOOPTIMES, minLoopTimes - repeatCount);
                    }
                    return true;
                }
            }
            if (!isAdjustHeight) {
                outputRow = PWDataGrid.executeRow(helper, grid, outputGrid, detailRow, isGroupEnd, repeatCount > 0, detailRow.getHeight(), false);
                if (extendRow != null) {
                    outputExtendRow = PWDataGrid.executeRow(helper, grid, outputGrid, extendRow, isGroupEnd, repeatCount > 0, extendRow.getHeight(), false);
                }
                if (minLoopTimes == 0) {
                    minLoopTimes = outputRow.getExtProps().getInt(EXTPROP_DETAILROWMINLOOPTIMES, 0);
                }
            }
            if (detailRow.isNotBlankRow() && outputRow != null && PWDataGrid.isEmptyDataRow(outputRow)) {
                if (outputRow != null) {
                    outputRow.setHide(true);
                }
                if (outputExtendRow != null) {
                    outputExtendRow.setHide(true);
                }
                ++repeatCount;
            }
            if (outputRow == null) {
                throw new KDException(ResManager.loadKDString((String)"\u89e3\u6790\u6570\u636e\u8868\u683c\u5185\u90e8\u9519\u8bef\u3002", (String)"PWDataGrid_2", (String)"bos-print-engine", (Object[])new Object[0]));
            }
            if (outputRow.isHide()) {
                addedHeight -= outputHeight;
            }
            gridExecuteContext.christmas();
            auxParam.setDetailOutputed(true);
            if (outputRow.isPrintable()) {
                boolean isExtendRowRemain;
                outputGrid.outputRow((AbstractPWDataGridRow)outputRow, repeatCount > 0, tempOutput);
                int extendRowHeight1 = 0;
                if (outputExtendRow != null) {
                    outputGrid.outputRow((AbstractPWDataGridRow)outputExtendRow, true, tempOutput);
                    extendRowHeight1 = ((AbstractPWDataGridRow)outputExtendRow).getHeight();
                }
                auxParam.setAddedY(auxParam.getAddedY() + ((AbstractPWDataGridRow)outputRow).getHeight() + extendRowHeight1);
                boolean bl = isExtendRowRemain = outputExtendRow != null && ((AbstractPWDataGridRow)outputExtendRow).isRemainContent();
                if (((AbstractPWDataGridRow)outputRow).isRemainContent() || isExtendRowRemain) {
                    auxParam.setRemainContent(true);
                    gridExecuteContext.setLevelOfGroupEnd(-1);
                    return true;
                }
            } else {
                tempOutput.markContainsDetail();
                if (repeatCount == 0) {
                    outputGrid.hideRow(detailRow);
                }
            }
            if (!isGroupEnd) {
                boolean hasNext;
                groupRuntimeValue.updateValue(helper, ds);
                gridExecuteContext.getStatSet().doStats(helper, ds);
                gridExecuteContext.getComputedSet().computing(helper, ds);
                gridExecuteContext.getComputedSet().fill(detailRow.getGroupLevel());
                if (helper.getDataHelper().isEOF(ds)) {
                    hasNext = false;
                } else if (helper.getDataHelper().hasNext(ds)) {
                    hasNext = true;
                    helper.getDataHelper().next(ds);
                } else {
                    hasNext = false;
                }
                if (hasNext) {
                    int levelOfGroupEnd = groupRuntimeValue.getLevelOfGroupEnd(helper, ds);
                    gridExecuteContext.setLevelOfGroupEnd(levelOfGroupEnd);
                    isGroupEnd = levelOfGroupEnd > 0;
                } else {
                    isGroupEnd = true;
                    isDataEnd = true;
                    gridExecuteContext.setLevelOfGroupEnd(0);
                }
            }
            if (!outputRow.isHide()) {
                ++repeatCount;
            }
            if (repeatTimes == 0) {
                toRepeatRow = !isGroupEnd || repeatCount < minLoopTimes;
                continue;
            }
            int n2 = bf = isBackwardOccupyDetail ? 1 : 0;
            if (repeatCount + 1 == repeatTimes - bf && forwardRow instanceof PWDetailRow && !outputGrid.isLevelGroupEnd(forwardRow.getGroupLevel(), helper, groupRuntimeValue, true)) {
                ++bf;
            }
            boolean bl = toRepeatRow = repeatCount < repeatTimes - bf;
        } while (toRepeatRow);
        if (minLoopTimes > 0) {
            detailRow.getContext().putExt(EXTPROP_DETAILROWMINLOOPTIMES, null);
        }
        return repeatTimes > 0;
    }

    private static int getPropheticGroupEnd(IWidgetExecuteHelper helper, GroupRuntimeValue groupRuntimeValue, String ds) {
        DataHelperExchanger exchanger = new DataHelperExchanger();
        DataHelperWrapper dataHelperWrapper = new DataHelperWrapper(helper, false, ds);
        exchanger.exchange(helper, dataHelperWrapper);
        int propheticGroupEnd = groupRuntimeValue.getLevelOfGroupEnd(helper, ds);
        exchanger.unExchange();
        return propheticGroupEnd;
    }

    private static AbstractPWDataGridRow executeRow(IWidgetExecuteHelper helper, PWDataGrid grid, PWDataGrid outputGrid, AbstractPWDataGridRow row, boolean isBlankRow, boolean isGrow, int maxHeightToAdjust, boolean isBeforeDetail) throws R1PrintException {
        int i;
        AbstractPWDataGridRow outputRow = (AbstractPWDataGridRow)row.copy();
        outputRow.setFromDesignIdx(outputGrid.getIndexOfRow(row));
        outputRow.getContext().putExt("gridContext", grid.getContext());
        helper.runScript(outputRow, 1);
        boolean isChildrenPaginating = false;
        boolean isThrowAway = false;
        int colIdxWhenThrowAway = 0;
        int realMaxHeight = row.getHeight();
        int c = row.getCellCount();
        for (i = 0; i < c; ++i) {
            int rowHeight;
            int colWidth;
            int designRowIdx = outputRow.getFromDesignIdx();
            PWDataGridCell cell = row.getCell(i);
            if (cell.getReferCell() != null) {
                int rowIdx = cell.getReferCell().getRow();
                int colIdx = cell.getReferCell().getCol();
                cell = outputGrid.getRow(rowIdx).getCell(colIdx);
                designRowIdx = rowIdx;
                ((CellExecuteContext)cell.getContext()).setOutputedWhenAdjustHeight(false);
            }
            boolean isAdjustHeight = false;
            if (cell.isBeMerged()) {
                Object[] mergeInfos = grid.getMergeInfos(designRowIdx, i, isGrow);
                if (mergeInfos == null) {
                    outputRow.addCell(null);
                    continue;
                }
                Dimension dim = (Dimension)mergeInfos[1];
                colWidth = dim.width;
                rowHeight = row.getHeight();
                isAdjustHeight = row.isAdjustHeight();
            } else {
                colWidth = outputGrid.getOutputColumn(i).getWidth();
                rowHeight = row.getHeight();
                isAdjustHeight = row.isAdjustHeight();
            }
            cell.setDatasource(outputGrid.getDatasource());
            GridExecuteContext gridExecuteContext = outputGrid.getGridExecuteContext();
            CellExecuteContext cellExecuteContext = (CellExecuteContext)cell.getContext();
            cellExecuteContext.setAdjustHeight(isAdjustHeight);
            cellExecuteContext.setMaxHeightToAdjust(maxHeightToAdjust);
            cellExecuteContext.setContainerHeight(rowHeight);
            cellExecuteContext.setContainerWidth(colWidth);
            if (row instanceof PWGroupRow) {
                cellExecuteContext.setRootRowType(1);
            }
            cellExecuteContext.setOwner(gridExecuteContext.getOwner());
            cellExecuteContext.setOutputedParent(R1PrintEngine.createOutputedParent(outputGrid.getOutputedParent(), outputGrid));
            int level = row.getGroupLevel();
            cellExecuteContext.setStatSet(gridExecuteContext.getStatSet());
            cellExecuteContext.setComputedSet(gridExecuteContext.getComputedSet());
            cellExecuteContext.setBackwardForwardCache(gridExecuteContext.getBackwardForwardCache());
            cellExecuteContext.setLevel(level);
            cellExecuteContext.setBlankRow(isBlankRow);
            cellExecuteContext.setLevelOfGroupEnd(gridExecuteContext.getLevelOfGroupEnd());
            GroupPageNumberManager gpnm = gridExecuteContext.getGroupPageNumberManager();
            gpnm.setCurrentLevel(level);
            gpnm.setCurrentWaitingKey(gpnm.createWaitingKey(grid, level));
            cellExecuteContext.setGroupPageNumberManager(gpnm);
            if (row.isBackwardForward()) {
                cellExecuteContext.setRowType(isBeforeDetail ? -1 : 1);
            }
            PWDataGridCell outputCell = (PWDataGridCell)cell.execute(helper);
            outputRow.addCell(outputCell);
            boolean bl = isChildrenPaginating = isChildrenPaginating || cell.getContext().isChildrenPaginating();
            if (!row.isAdjustHeight()) continue;
            if (outputCell.getOutputText() == "ThrowAway") {
                isThrowAway = true;
                colIdxWhenThrowAway = i;
                break;
            }
            if (realMaxHeight < outputCell.getRectangle().height) {
                realMaxHeight = outputCell.getRectangle().height;
            }
            if (!cell.isRemainContent()) continue;
            outputRow.setRemainContent(true);
        }
        if (outputRow.isAdjustHeight()) {
            if (isThrowAway) {
                for (i = 0; i < colIdxWhenThrowAway; ++i) {
                    PWDataGridCell outputCell = outputRow.getCell(i);
                    if (outputCell == null) continue;
                    PWDataGridCell cell = (PWDataGridCell)outputCell.getPeer();
                    String outputedText = outputCell.getOutputText();
                    String remainText = cell.getOutputText();
                    cell.setOutputText((outputedText == null ? "" : outputedText) + (remainText == null ? "" : remainText));
                    cell.setRemainContent(true);
                    ((CellExecuteContext)cell.getContext()).setOutputedWhenAdjustHeight(false);
                }
                outputRow.setHeight(999999);
            } else {
                if (!outputRow.isRemainContent()) {
                    c = row.getCellCount();
                    for (i = 0; i < c; ++i) {
                        PWDataGridCell cell = row.getCell(i);
                        CellExecuteContext cellExecuteContext = (CellExecuteContext)cell.getContext();
                        cellExecuteContext.setOutputedWhenAdjustHeight(false);
                    }
                }
                outputRow.setHeight(realMaxHeight);
                c = outputRow.getCellCount();
                for (i = 0; i < c; ++i) {
                    int delta;
                    PWDataGridCell outputCell = outputRow.getCell(i);
                    if (outputCell == null || (delta = realMaxHeight - outputCell.getRectangle().height) == 0) continue;
                    outputCell.getRectangle().height = realMaxHeight;
                    outputCell.recursionChildrenFill(false, 0, true, delta);
                }
            }
        }
        helper.markOutputId(outputRow);
        helper.runScript(outputRow, 2);
        return outputRow;
    }

    private void calculateMerge() {
        List<MergeBlock> mergeBlocks = this.getMergeBlocks();
        for (int i = mergeBlocks.size() - 1; i >= 0; --i) {
            MergeBlock mb = mergeBlocks.get(i);
            int blockHeight = 0;
            int blockWidth = 0;
            for (int h = mb.getTop(); h <= mb.getBottom(); ++h) {
                if (h >= this.getOutputRows().size()) {
                    return;
                }
                AbstractPWDataGridRow row = this.getOutputRow(h);
                blockHeight += row.getHeight();
            }
            for (int w = mb.getLeft(); w <= mb.getRight(); ++w) {
                blockWidth += this.getOutputColumn(w).getWidth();
            }
            PWDataGridCell firstCell = this.getOutputRow(mb.getTop()).getCell(mb.getLeft());
            Rectangle rect = firstCell.getRectangle();
            int deltaWidth = blockWidth - rect.width;
            int deltaHeight = blockHeight - rect.height;
            boolean isToDealH = false;
            boolean isToDealV = false;
            if (deltaWidth != 0) {
                rect.width = blockWidth;
                isToDealH = true;
            }
            if (deltaHeight != 0) {
                rect.height = blockHeight;
                isToDealV = true;
            }
            if (!isToDealH && !isToDealV) continue;
            firstCell.recursionChildrenFill(isToDealH, deltaWidth, isToDealV, deltaHeight);
        }
    }

    @Override
    public void recursionChildrenFill(boolean isDealHorizontal, int deltaHorizontal, boolean isDealVertical, int deltaVertical) {
        List<AbstractPWDataGridRow> outputRows = this.getOutputRows();
        List<IPrintWidget> outputCols = this.getOutputColumns();
        int rowsCount = outputRows.size();
        int colsCount = outputCols.size();
        int deltaEveryCol = (int)((double)deltaHorizontal / (double)colsCount + 0.5);
        int deltaEveryRow = (int)((double)deltaVertical / (double)rowsCount + 0.5);
        for (int i = 0; i < rowsCount; ++i) {
            int deltaV = deltaEveryRow;
            if (i == rowsCount - 1) {
                deltaV = deltaVertical - deltaEveryRow * (rowsCount - 1);
            }
            AbstractPWDataGridRow row = outputRows.get(i);
            if (isDealVertical) {
                row.setHeight(row.getHeight() + deltaV);
            }
            for (int j = 0; j < colsCount; ++j) {
                PWDataGridCell cell;
                int deltaH = deltaEveryCol;
                if (j == colsCount - 1) {
                    deltaH = deltaHorizontal - deltaEveryCol * (colsCount - 1);
                }
                if (i == 0 && isDealHorizontal) {
                    PWDataGridColumn col = (PWDataGridColumn)outputCols.get(j);
                    col.setWidth(col.getWidth() + deltaH);
                }
                if ((cell = row.getCell(j)) == null) continue;
                Rectangle rect = cell.getRectangle();
                if (isDealHorizontal) {
                    rect.width += deltaH;
                }
                if (isDealVertical) {
                    rect.height += deltaV;
                }
                cell.recursionChildrenFill(isDealHorizontal, deltaH, isDealVertical, deltaV);
            }
        }
    }

    @Override
    public Object getFieldValue(String field) {
        return this.getFieldValue(this.getDatasource(), field);
    }

    public void secondBirth() {
        this.getGridExecuteContext().requestSecondBirth();
    }

    public void relive() {
        this.getGridExecuteContext().requestRelive();
    }

    private void checkSinkToBottom() {
        if (this.getContext().isAdjustHeight()) {
            return;
        }
        List<AbstractPWDataGridRow> outputRows = this.getOutputRows();
        int addY = 0;
        boolean isBingo = false;
        for (int i = outputRows.size() - 1; i >= 0; --i) {
            AbstractPWDataGridRow row = outputRows.get(i);
            addY += row.getHeight();
            if (!row.getExtProps().getBoolean(ExtProp_SinkToBottom, false)) continue;
            isBingo = true;
        }
        if (isBingo) {
            int jump = this.getContext().getContainerHeight() - this.getRectangle().y - addY;
            this.getExtProps().put(ExtProp_SinkToBottom, jump);
        }
    }

    private boolean isGroupRowAppearEveryPage(IWidgetExecuteHelper helper, PWGroupRow row) {
        if (row.isAppearEveryPage()) {
            GroupRuntimeValue grv = this.getGridExecuteContext().getGroupRuntimeValue();
            int levelOfGroupEnd = grv.getLevelOfGroupEnd(helper, this.getDatasource());
            return levelOfGroupEnd < 0 || levelOfGroupEnd >= row.getGroupLevel();
        }
        return false;
    }

    private static boolean isEmptyDataRow(AbstractPWDataGridRow row) {
        int cellCount = row.getCellCount();
        for (int i = 0; i < cellCount; ++i) {
            PWDataGridCell cell = row.getCell(i);
            if (cell == null) continue;
            if (StringUtils.isNotBlank((CharSequence)cell.getOutputText())) {
                return false;
            }
            if (!cell.hasChildren()) continue;
            boolean isEmpty = true;
            for (IPrintWidget obj : cell.getChildren()) {
                if (obj instanceof AbstractPrintWidgetText) {
                    AbstractPrintWidgetText widg = (AbstractPrintWidgetText)obj;
                    if (!StringUtils.isNotBlank((CharSequence)widg.getOutputText())) continue;
                    isEmpty = false;
                    break;
                }
                if (obj instanceof PWPicture) {
                    PWPicture pic = (PWPicture)obj;
                    if (!StringUtils.isNotBlank((Object)pic.getOutputValue())) continue;
                    isEmpty = false;
                    break;
                }
                if (obj instanceof PWBarcode) {
                    PWBarcode bar = (PWBarcode)obj;
                    if (!StringUtils.isNotBlank((Object)bar.getOutputValue())) continue;
                    isEmpty = false;
                    break;
                }
                if (!(obj instanceof PWLayoutGrid)) continue;
                isEmpty = false;
                break;
            }
            return isEmpty;
        }
        return true;
    }

    private static class AuxExecuteDetail {
        private int _addedY;
        private boolean _isDetailOutputed = false;
        private boolean _isRemainContent = false;

        private AuxExecuteDetail() {
        }

        public int getAddedY() {
            return this._addedY;
        }

        public void setAddedY(int y) {
            this._addedY = y;
        }

        public boolean isDetailOutputed() {
            return this._isDetailOutputed;
        }

        public void setDetailOutputed(boolean isDetailOutputed) {
            this._isDetailOutputed = isDetailOutputed;
        }

        public boolean isRemainContent() {
            return this._isRemainContent;
        }

        public void setRemainContent(boolean isRemainContent) {
            this._isRemainContent = isRemainContent;
        }
    }
}

