/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.datagrid;

import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.util.Util;
import com.kingdee.bos.ctrl.reportone.r1.print.common.AdjustHeightRenderer;
import com.kingdee.bos.ctrl.reportone.r1.print.common.IAdjustHeightRenderSupport;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.DelayVarProvider;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.ExecuteContext;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.IWidgetExecuteHelper;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.R1PrintEngine;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.exception.R1PrintException;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.AbstractPrintWidgetText;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.IAdjustHeightSupport;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.IPrintWidget;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.IPrintWidgetContainer;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.StyleAccess;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.datagrid.cellvalue.ACellValue;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.datagrid.cellvalue.CellValueCompute;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.datagrid.cellvalue.CellValueField;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.datagrid.cellvalue.CellValueStat;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.datagrid.cellvalue.CellValueText;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.datagrid.context.CellExecuteContext;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.datagrid.context.GroupPageNumberManager;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.datagrid.merge.RowColIdx;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.datagrid.stat.StatRuntimeValue;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.datagrid.stat.StatSet;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;

public class PWDataGridCell
extends AbstractPrintWidgetText
implements IPrintWidgetContainer,
IAdjustHeightRenderSupport,
IAdjustHeightSupport {
    public static final String EXTPROP_SHOWGROUPSTATLAST = "showGroupStatLast";
    static final String MARK_THROW_AWAY = "ThrowAway";
    private ACellValue cellValue;
    private ArrayList<IPrintWidget> children;
    private boolean isBeMergedField = false;
    private RowColIdx referCell;
    private boolean isAdjustHeightField;
    private int maxHeightToAdjust;
    private boolean isRemainContentField;

    public PWDataGridCell() {
        this.setHFill(true);
        this.setVFill(true);
    }

    public void setCellValue(ACellValue cellValue) {
        this.cellValue = cellValue;
    }

    public ACellValue getCellValue() {
        return this.cellValue;
    }

    @Override
    public void setAdjustHeight(boolean isAdjustHeight) {
        this.isAdjustHeightField = isAdjustHeight;
    }

    @Override
    public boolean isAdjustHeight() {
        return this.isAdjustHeightField;
    }

    @Override
    public boolean isHFill() {
        return true;
    }

    @Override
    public IPrintWidget copy() {
        PWDataGridCell cell = (PWDataGridCell)super.copy();
        cell.setCellValue(this.getCellValue());
        return cell;
    }

    @Override
    public ExecuteContext getContext() {
        if (this._executeContext == null) {
            this._executeContext = new CellExecuteContext();
        }
        return this._executeContext;
    }

    @Override
    public IPrintWidget execute(IWidgetExecuteHelper helper) throws R1PrintException {
        IPrintWidget output = super.execute(helper);
        if (this.getCellValue() == null) {
            this.setRemainContent(this.getContext().isChildrenPaginating());
        }
        return output;
    }

    @Override
    protected void executing(IWidgetExecuteHelper helper, IPrintWidget outputWidget) throws R1PrintException {
        PWDataGridCell outputCell = (PWDataGridCell)outputWidget;
        CellExecuteContext cec = (CellExecuteContext)this.getContext();
        if (outputCell.getCellValue() == null) {
            int width = cec.getContainerWidth();
            int height = cec.getContainerHeight();
            outputCell.setRectangle(new Rectangle(width, height));
            return;
        }
        if (outputCell.isAdjustHeight() && cec.isOutputedWhenAdjustHeight()) {
            outputCell.setOutputText("");
        } else if (this.isRemainContent()) {
            outputCell.setOutputText(this.getOutputText());
        } else if (!cec.isBlankRow()) {
            this.executingCellValue(helper, outputCell, cec);
        } else if (outputCell.getDivideCharNums() >= 0) {
            outputCell.setValue(" ");
        }
        if (outputCell.isAdjustHeight()) {
            this.executingLongText(outputCell, cec);
        }
    }

    private void executingCellValue(IWidgetExecuteHelper helper, PWDataGridCell outputCell, CellExecuteContext cec) {
        ACellValue cellValue = outputCell.getCellValue();
        switch (cellValue.getCellType()) {
            case 1: {
                String text = ((CellValueText)cellValue).getValue();
                Object formulaResult = R1PrintEngine.runFormula(helper, outputCell, text);
                if (formulaResult == null) {
                    outputCell.setOutputValue(new Variant(text));
                    outputCell.formatOutput();
                    break;
                }
                outputCell.setValue(formulaResult);
                break;
            }
            case 2: {
                String field = ((CellValueField)cellValue).getField();
                Variant vi = helper.getDataHelper().getFieldValue(this.getDatasource(), field);
                outputCell.setOutputValue(vi);
                outputCell.setOriValue(vi.toString());
                outputCell.formatOutput();
                break;
            }
            case 3: {
                if (cec.getRowType() == -1) {
                    StatRuntimeValue statRuntimeValue = StatSet.createStatRuntimeValue(cec.getLevel(), outputCell);
                    PWDataGridCell associateCell = (PWDataGridCell)cec.getBackwardForwardCache().get(statRuntimeValue);
                    if (associateCell == null) break;
                    outputCell.setOutputValue(associateCell.getOutputValue());
                    outputCell.formatOutput();
                    break;
                }
                boolean toMark = true;
                if (((CellValueStat)cellValue).isContain(1) && outputCell.getExtProps().getBoolean(EXTPROP_SHOWGROUPSTATLAST, false)) {
                    boolean isGroupEnd;
                    boolean bl = isGroupEnd = cec.getLevel() >= cec.getLevelOfGroupEnd() && cec.getLevelOfGroupEnd() >= 0;
                    if (!isGroupEnd) {
                        toMark = false;
                    }
                }
                if (toMark) {
                    cec.getStatSet().markStatCell(cec.getLevel(), outputCell);
                }
                if (cec.getRowType() != 1) break;
                StatRuntimeValue statRuntimeValue = StatSet.createStatRuntimeValue(cec.getLevel(), outputCell);
                cec.getBackwardForwardCache().put(statRuntimeValue, outputCell);
                break;
            }
            case 4: {
                if (cec.getRowType() == -1) {
                    CellValueCompute compute = (CellValueCompute)cellValue;
                    PWDataGridCell associateCell = (PWDataGridCell)cec.getBackwardForwardCache().get(compute.getExpr());
                    if (associateCell == null) break;
                    outputCell.setOutputValue(associateCell.getOutputValue());
                    outputCell.formatOutput();
                    break;
                }
                boolean toMark = true;
                if (((CellValueCompute)cellValue).isExistGroupStat(cec.getLevel()) && outputCell.getExtProps().getBoolean(EXTPROP_SHOWGROUPSTATLAST, false)) {
                    boolean isGroupEnd;
                    boolean bl = isGroupEnd = cec.getLevel() >= cec.getLevelOfGroupEnd() && cec.getLevelOfGroupEnd() >= 0;
                    if (!isGroupEnd) {
                        toMark = false;
                    }
                }
                if (toMark) {
                    cec.getComputedSet().mark(outputCell);
                }
                if (cec.getRowType() != 1) break;
                CellValueCompute compute = (CellValueCompute)cellValue;
                cec.getBackwardForwardCache().put(compute.getExpr(), outputCell);
                break;
            }
        }
    }

    private void executingLongText(PWDataGridCell outputCell, CellExecuteContext cec) {
        String textRemain;
        String textToDraw;
        int widthLom = cec.getContainerWidth();
        int height = Util.lom2Pixel(cec.getContainerHeight()) - 1;
        int maxHeight = Util.lom2Pixel(cec.getMaxHeightToAdjust()) - 1;
        int width = Util.lom2Pixel(widthLom);
        String text = outputCell.getOutputText();
        text = text == null ? "" : text;
        AdjustHeightRenderer.Result result = AdjustHeightRenderer.adjustHeight(text, StyleAccess.getStyle(outputCell), height, maxHeight, width);
        if (result.isTextCutOff()) {
            int nextStart = result.getCutPosition();
            textToDraw = text.substring(0, nextStart);
            char sChar = text.charAt(nextStart);
            textRemain = sChar == '\n' ? text.substring(nextStart + 1) : text.substring(nextStart);
        } else {
            textToDraw = text;
            textRemain = null;
        }
        if (result.isThrowAway()) {
            textToDraw = MARK_THROW_AWAY;
        }
        int usedHeight = Util.pixel2Lom(result.getUsedHeight());
        outputCell.setOutputText(textToDraw);
        outputCell.setRectangle(new Rectangle(widthLom, usedHeight));
        this.setOutputText(textRemain);
        this.setRemainContent(textRemain != null);
        cec.setOutputedWhenAdjustHeight(textRemain == null);
    }

    @Override
    public void addChild(IPrintWidget w) {
        this.getChildren().add(w);
    }

    @Override
    public List<IPrintWidget> getChildren() {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        return this.children;
    }

    @Override
    public boolean hasChildren() {
        return this.children != null && this.children.size() != 0;
    }

    public void setReferCell(RowColIdx xy) {
        this.referCell = xy;
    }

    public RowColIdx getReferCell() {
        return this.referCell;
    }

    public void setBeMerged(boolean is) {
        this.isBeMergedField = is;
    }

    public boolean isBeMerged() {
        return this.isBeMergedField;
    }

    @Override
    public void setRemainContent(boolean isRemain) {
        this.isRemainContentField = isRemain;
    }

    @Override
    public boolean isRemainContent() {
        return this.isRemainContentField;
    }

    @Override
    public void setMaxHeightToAdjust(int maxHeight) {
        this.maxHeightToAdjust = maxHeight;
    }

    @Override
    public int getMaxHeightToAdjust() {
        return this.maxHeightToAdjust;
    }

    @Override
    public boolean isUseAdjustHeightRender() {
        return this.isAdjustHeight();
    }

    @Override
    public int getPageNumber() {
        int currentPageIndex = this.getOwnerOutputPage().getPageIndex();
        CellExecuteContext cec = (CellExecuteContext)this.getContext();
        GroupPageNumberManager gpnm = cec.getGroupPageNumberManager();
        return gpnm.getGroupPageNumber(gpnm.getCurrentLevel(), currentPageIndex);
    }

    @Override
    public Object getPageTotal() {
        CellExecuteContext cec = (CellExecuteContext)this.getContext();
        GroupPageNumberManager gpnm = cec.getGroupPageNumberManager();
        String key = gpnm.getCurrentWaitingKey();
        if (!this.hasChildren() && this.isContainsLastScript()) {
            this._executeHelper.getDelayVarProvider().markCell(key, this);
        }
        return DelayVarProvider.makeVarSign(key);
    }

    public int getRowNumber(int level) {
        return ((CellExecuteContext)this.getContext()).getStatSet().getRowNumber(level);
    }

    public int getRowNumber() {
        CellExecuteContext cec = (CellExecuteContext)this.getContext();
        return cec.getStatSet().getRowNumber(cec.getLevel());
    }

    public int getGroupNumber() {
        CellExecuteContext cec = (CellExecuteContext)this.getContext();
        return cec.getStatSet().getGroupNumber(cec.getLevel());
    }

    @Override
    public void setOriValue(String value) {
        super.setOriValue(value);
        this.setCellValue(new CellValueText(value));
    }
}

