/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.datagrid.compute;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.common.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.reportone.r1.print.common.gridcompute.AbstractExpr;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.IWidgetExecuteHelper;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.exception.R1PrintException;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.AbstractPrintWidgetText;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.datagrid.AbstractPWDataGridRow;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.datagrid.PWDataGrid;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.datagrid.PWDataGridCell;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.datagrid.cellvalue.ACellValue;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.datagrid.cellvalue.CellValueCompute;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;

public class ComputedSet {
    private static final String BOS_PRINT_ENGINE = "bos-print-engine";
    private static final String FIELD_NONSTAT = "r1-print.non-statistic";
    private HashMap<Object, AbstractExpr> exprs = new HashMap(16);

    public ComputedSet(PWDataGrid grid, int levels) {
        this.initStatsRuntimeValue(grid, levels);
    }

    public void reset() {
        Iterator<Map.Entry<Object, AbstractExpr>> itKeys = this.exprs.entrySet().iterator();
        while (itKeys.hasNext()) {
            Map.Entry<Object, AbstractExpr> entryPair = itKeys.next();
            Object key = entryPair.getKey();
            if (key instanceof String) {
                AbstractExpr expr = entryPair.getValue();
                expr.clearStat(0);
                continue;
            }
            itKeys.remove();
        }
    }

    private void initStatsRuntimeValue(PWDataGrid grid, int levelCount) {
        int rc = grid.getRowsCount();
        for (int i = 0; i < rc; ++i) {
            AbstractPWDataGridRow row = grid.getRow(i);
            int cc = row.getCellCount();
            for (int j = 0; j < cc; ++j) {
                PWDataGridCell cell = row.getCell(j);
                ACellValue cv = cell.getCellValue();
                if (cv == null || cv.getCellType() != 4) continue;
                this.exprs.put(cell.getId(), ((CellValueCompute)cv).getExpr());
            }
        }
    }

    public void computing(IWidgetExecuteHelper helper, String ds) throws R1PrintException {
        if (StringUtil.equalsIgnoreCase("true", helper.getDataHelper().getFieldValue(ds, FIELD_NONSTAT).toString())) {
            return;
        }
        Iterator it = this.allExprs();
        while (it.hasNext()) {
            AbstractExpr expr = (AbstractExpr)it.next();
            try {
                expr.computing(helper, ds);
            }
            catch (SyntaxErrorException e) {
                throw new R1PrintException(ResManager.loadKDString((String)"\u8868\u683c\u8fd0\u7b97\u8fc7\u7a0b\u53d1\u751f\u5f02\u5e38\u3002", (String)"ComputedSet_0", (String)BOS_PRINT_ENGINE, (Object[])new Object[0]), e);
            }
        }
    }

    public void mark(AbstractPrintWidgetText outputWidget) {
        AbstractExpr expr = this.exprs.get(outputWidget.getId());
        AbstractExpr newExpr = expr.runtimeClone();
        this.exprs.put(outputWidget, newExpr);
        outputWidget.getOwnerOutputPage().unsureIncrease();
    }

    public void fill(int level) throws R1PrintException {
        Iterator<Map.Entry<Object, AbstractExpr>> itKeys = this.exprs.entrySet().iterator();
        while (itKeys.hasNext()) {
            Map.Entry<Object, AbstractExpr> pair = itKeys.next();
            Object key = pair.getKey();
            AbstractExpr expr = pair.getValue();
            if (key instanceof String) {
                expr.clearStat(level);
                continue;
            }
            try {
                expr.confirmReturnValue(level);
            }
            catch (SyntaxErrorException ex) {
                throw new R1PrintException(ResManager.loadKDString((String)"\u8868\u683c\u8fd0\u7b97\u8fc7\u7a0b\u53d1\u751f\u5f02\u5e38\u3002", (String)"ComputedSet_0", (String)BOS_PRINT_ENGINE, (Object[])new Object[0]), ex);
            }
            if (expr.isReturnValueUnsure()) continue;
            AbstractPrintWidgetText outputWidget = (AbstractPrintWidgetText)key;
            outputWidget.setOutputValue(expr.getReturnValue());
            outputWidget.runLastScript();
            outputWidget.formatOutput();
            outputWidget.getOwnerOutputPage().unsureReduce();
            itKeys.remove();
        }
    }

    private Iterator allExprs() {
        return new Iterator(){
            Iterator itKey;
            {
                this.itKey = ComputedSet.this.exprs.keySet().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.itKey.hasNext();
            }

            public Object next() {
                return ComputedSet.this.exprs.get(this.itKey.next());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException(ResManager.loadKDString((String)"\u4e0d\u652f\u6301", (String)"ComputedSet_1", (String)ComputedSet.BOS_PRINT_ENGINE, (Object[])new Object[0]));
            }
        };
    }
}

