/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.datagrid.context;

import com.kingdee.bos.ctrl.reportone.r1.print.engine.ExecuteContext;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.IDatasourceSupport;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.IPaginationSupport;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.datagrid.AbstractPWDataGridRow;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.datagrid.PWDataGrid;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.datagrid.PWDetailRow;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.datagrid.PWGroupRow;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.datagrid.compute.ComputedSet;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.datagrid.context.GroupPageNumberManager;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.datagrid.context.GroupRuntimeValue;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.datagrid.stat.StatSet;
import java.util.ArrayList;
import java.util.HashMap;

public class GridExecuteContext
extends ExecuteContext
implements IPaginationSupport.IPaginationContext,
IDatasourceSupport.IDatasourceContext {
    private boolean isEnd;
    private GroupRuntimeValue groupRuntimeValue;
    private int levelOfGroupEnd;
    private StatSet stats;
    private ComputedSet computeds;
    private HashMap backwardForwardStats = new HashMap();
    private boolean isNotEnoughOutputTailGroupRowField;
    private boolean isDeadField;
    private GroupPageNumberManager groupPageNumberManager;
    private boolean christmasField;
    private PWDataGrid grid;
    private boolean requestReliveField;
    private boolean requestSecondBirthField;

    public GridExecuteContext(PWDataGrid dataGrid) {
        this.grid = dataGrid;
        this.initState();
        this.initGroupRuntimeValue(dataGrid);
        int levels = this.getGroupRuntimeValue().getLevels();
        this.stats = new StatSet(dataGrid, levels);
        this.computeds = new ComputedSet(dataGrid, levels);
        this.groupPageNumberManager = new GroupPageNumberManager(levels + 1);
    }

    private void initState() {
        this.isEnd = false;
        this.levelOfGroupEnd = Integer.MIN_VALUE;
        this.isNotEnoughOutputTailGroupRowField = false;
    }

    @Override
    public void resetState() {
        this.initState();
        this.groupRuntimeValue.clearValues();
        this.stats.reset();
        this.computeds.reset();
        this.christmasField = false;
        this.requestReliveField = false;
        this.requestSecondBirthField = false;
        int c = this.grid.getRowsCount();
        for (int i = 0; i < c; ++i) {
            this.grid.getRow(i).setOutputOnce(false);
        }
    }

    public void setNotEnoughOutputTailGroupRow(boolean is) {
        this.isNotEnoughOutputTailGroupRowField = is;
    }

    public boolean isNotEnoughOutputTailGroupRow() {
        return this.isNotEnoughOutputTailGroupRowField;
    }

    public void setOutputEnd(boolean end) {
        this.isEnd = end;
    }

    public boolean isOutputEnd() {
        return this.isEnd;
    }

    private void initGroupRuntimeValue(PWDataGrid grid) {
        AbstractPWDataGridRow row;
        ArrayList<String> listGroupFields = new ArrayList<String>();
        listGroupFields.add(null);
        int c = grid.getRowsCount();
        for (int i = 0; i < c && !((row = grid.getRow(i)) instanceof PWDetailRow); ++i) {
            String gf = ((PWGroupRow)row).getGroupDesc().getGroupField();
            if (listGroupFields.contains(gf)) continue;
            listGroupFields.add(gf);
        }
        int groupCount = listGroupFields.size();
        this.groupRuntimeValue = new GroupRuntimeValue(groupCount);
        for (int i = 1; i < groupCount; ++i) {
            this.groupRuntimeValue.setGroupField(i, (String)listGroupFields.get(i));
        }
        this.groupRuntimeValue.setGroupField(0, null);
    }

    public GroupRuntimeValue getGroupRuntimeValue() {
        return this.groupRuntimeValue;
    }

    public int getLevelOfGroupEnd() {
        return this.levelOfGroupEnd;
    }

    public void setLevelOfGroupEnd(int l) {
        this.levelOfGroupEnd = l;
    }

    public StatSet getStatSet() {
        return this.stats;
    }

    public ComputedSet getComputedSet() {
        return this.computeds;
    }

    public HashMap getBackwardForwardCache() {
        return this.backwardForwardStats;
    }

    public GroupPageNumberManager getGroupPageNumberManager() {
        return this.groupPageNumberManager;
    }

    @Override
    public void relive() {
        this.isDeadField = false;
    }

    @Override
    public void dead() {
        this.isDeadField = true;
    }

    @Override
    public boolean isDead() {
        return this.isDeadField;
    }

    public void christmas() {
        this.christmasField = true;
    }

    public boolean isChristmas() {
        return this.christmasField;
    }

    @Override
    public String secondSpringDatasource() {
        return this.grid.getDatasource();
    }

    public void requestSecondBirth() {
        this.requestSecondBirthField = true;
    }

    @Override
    public boolean isRequestSecondBirth() {
        return this.requestSecondBirthField;
    }

    public void requestRelive() {
        this.requestReliveField = true;
    }

    @Override
    public boolean isRequestRelive() {
        return this.requestReliveField;
    }

    public PWDataGrid getGrid() {
        return this.grid;
    }
}

