/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.datagrid.stat;

import com.kingdee.bos.ctrl.common.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.common.variant.VariantExt;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.IWidgetExecuteHelper;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.datagrid.cellvalue.CellValueStat;
import java.math.BigDecimal;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.property.DecimalProp;

public class StatRuntimeValue {
    private int _level;
    private CellValueStat _designInfo;
    private int _count;
    private Variant _value;
    private Variant _value2;
    private String displayValue;
    private int maxScale = -1;

    public StatRuntimeValue(int level, CellValueStat designInfo) {
        this._level = level;
        this._designInfo = designInfo;
        this.clearValue(level);
    }

    public int getLevel() {
        return this._level;
    }

    public CellValueStat getDesignInfo() {
        return this._designInfo;
    }

    public void clearValue(int level) {
        if (level == this._level) {
            this._value2 = null;
        }
        this._count = 0;
        this._value = null;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof StatRuntimeValue)) {
            return false;
        }
        StatRuntimeValue another = (StatRuntimeValue)obj;
        return this._level == another.getLevel() && this._designInfo.equals(another.getDesignInfo());
    }

    public int hashCode() {
        int result = 7;
        result = 21 * result + this._level;
        result = 21 * result + this._designInfo.hashCode();
        return result;
    }

    public void stat(IWidgetExecuteHelper helper, String ds) throws SyntaxErrorException {
        Variant value = null;
        boolean isNullValue = true;
        if (!this.getDesignInfo().isContain(256)) {
            VariantExt variantExt;
            VariantExt variantExt2;
            Object fieldType;
            int curScale;
            value = helper.getDataHelper().getFieldValue(ds, this.getDesignInfo().getStatField());
            if (value != null && value.getValue() instanceof BigDecimal && (curScale = ((BigDecimal)value.getValue()).scale()) > this.maxScale) {
                this.maxScale = curScale;
            }
            if (StringUtils.isNotBlank((CharSequence)this.getDesignInfo().getStatField()) && (fieldType = helper.getDataHelper().getFieldType(ds, this.getDesignInfo().getStatField())) instanceof DecimalProp && !this.getDesignInfo().isSumAfterFormat() && this.getDesignInfo().isContain(16)) {
                Variant oriValue;
                String oriKey = this.getDesignInfo().getStatField() + "_ori_";
                if (helper.getDataHelper().getFieldType(ds, oriKey) != null && (oriValue = helper.getDataHelper().getFieldValue(ds, oriKey)) != null && !oriValue.isNull() && StringUtils.isNotBlank((Object)oriValue.getValue())) {
                    value = oriValue;
                }
            }
            if (value != null) {
                boolean bl = isNullValue = value.isNull() || value.getValue() == null;
            }
            if (value instanceof VariantExt && !(variantExt2 = (VariantExt)value).isCanPrint()) {
                if (this.displayValue == null) {
                    this.displayValue = variantExt2.getDisplayValue();
                }
                return;
            }
            Variant variantObject = helper.getDataHelper().getFieldValue(ds, this.getDesignInfo().getStatField());
            if (variantObject instanceof VariantExt && !(variantExt = (VariantExt)variantObject).isCanPrint()) {
                if (this.displayValue == null) {
                    this.displayValue = variantExt.getDisplayValue();
                }
                return;
            }
        }
        if (this.getDesignInfo().isContain(16)) {
            if (!isNullValue) {
                this.getSum().add(value);
                this.getSum2().add(value);
            }
        } else if (this.getDesignInfo().isContain(32)) {
            if (!isNullValue) {
                this.getSum().add(value);
            }
            ++this._count;
        } else if (this.getDesignInfo().isContain(256)) {
            ++this._count;
        } else if (this.getDesignInfo().isContain(64)) {
            if (!isNullValue && this.getExtremum().lessThan(value)) {
                this._value = value;
            }
        } else if (this.getDesignInfo().isContain(128) && !isNullValue && this.getExtremum().greaterThan(value)) {
            this._value = value;
        }
    }

    public Variant getValue() throws SyntaxErrorException {
        if (StringUtils.isNotBlank((CharSequence)this.displayValue)) {
            Variant variant = new Variant();
            variant.setObject(this.displayValue, 11);
            return variant;
        }
        if (StringUtils.isBlank((CharSequence)this.getDesignInfo().getStatField())) {
            return null;
        }
        if (this.getDesignInfo().isContain(16)) {
            Variant variant = this.getSum();
            if (variant.getType() == BigDecimal.class) {
                BigDecimal bigDecimal = (BigDecimal)variant.getValue();
                if (this.maxScale != -1) {
                    BigDecimal decimal = bigDecimal.setScale(this.maxScale, 4);
                    variant.setBigDecimal(decimal);
                }
            }
            return variant;
        }
        if (this.getDesignInfo().isContain(32)) {
            return this.getAvg();
        }
        if (this.getDesignInfo().isContain(256)) {
            return new Variant(this.getCount());
        }
        if (this.getDesignInfo().isContain(64)) {
            return this.getMax();
        }
        if (this.getDesignInfo().isContain(128)) {
            return this.getMin();
        }
        return null;
    }

    private Variant getAvg() throws SyntaxErrorException {
        if (this.getCount() == 0) {
            return new Variant(0);
        }
        Variant variant = new Variant(this.getSum()).divide(new Variant(this.getCount()));
        if (variant.getType() == BigDecimal.class) {
            BigDecimal bigDecimal = (BigDecimal)variant.getValue();
            if (this.maxScale != -1) {
                BigDecimal decimal = bigDecimal.setScale(this.maxScale, 4);
                variant.setBigDecimal(decimal);
            }
        }
        return variant;
    }

    int getCount() {
        return this._count;
    }

    private Variant getSum() {
        if (this._value == null) {
            this._value = new Variant(0);
        }
        return this._value;
    }

    public Variant getSum2() {
        if (this._value2 == null) {
            this._value2 = new Variant(0);
        }
        return this._value2;
    }

    private Variant getMax() {
        if (this.getExtremum().equals(new Variant(-1.7976931348623157E308))) {
            return null;
        }
        return this.getExtremum();
    }

    private Variant getMin() {
        if (this.getExtremum().equals(new Variant((double)Double.MAX_VALUE))) {
            return null;
        }
        return this.getExtremum();
    }

    private Variant getExtremum() {
        if (this._value == null) {
            this._value = this.getDesignInfo().isContain(64) ? new Variant(-1.7976931348623157E308) : new Variant((double)Double.MAX_VALUE);
        }
        return this._value;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append(this.getLevel());
        sb.append("|");
        sb.append(this.getDesignInfo().getStatField());
        sb.append("|");
        sb.append(this.getDesignInfo().getStatType());
        sb.append(")=(");
        sb.append(this.getCount());
        sb.append("|");
        sb.append(this._value == null ? "null" : this._value.getValue());
        sb.append(")");
        return sb.toString();
    }

    public void confirmReturnValue() {
        if (this._value2 != null) {
            this._value = this._value2;
        }
    }
}

