/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.datagrid.stat;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.common.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.IWidgetExecuteHelper;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.exception.R1PrintException;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.datagrid.AbstractPWDataGridRow;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.datagrid.PWDataGrid;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.datagrid.PWDataGridCell;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.datagrid.cellvalue.CellValueStat;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.datagrid.stat.StatRuntimeValue;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;

public class StatSet {
    private static final String FIELD_NOTSTAT = "r1-print.non-statistic";
    private static final String FIELD_USED4ROWNUMBER = "r1-print.ForRowNumber_";
    private List _stats = new ArrayList();
    private HashMap _cellsToFill = new HashMap();
    private int[] _groupNumber;
    private int _levels;

    public StatSet(PWDataGrid grid, int levels) {
        this.prepareDefault(grid, levels);
        this.initStatsRuntimeValue(grid);
        this._groupNumber = new int[levels];
        for (int i = 0; i < levels; ++i) {
            this._groupNumber[i] = 1;
        }
        this._levels = levels;
    }

    public void reset() {
        this._cellsToFill.clear();
        for (StatRuntimeValue statRuntimeValue : this.getStats()) {
            statRuntimeValue.clearValue(-1);
        }
    }

    public List getStats() {
        return this._stats;
    }

    private void prepareDefault(PWDataGrid grid, int levelCount) {
        for (int i = 0; i < levelCount; ++i) {
            SecureRandom r = new SecureRandom();
            CellValueStat designInfo = new CellValueStat(FIELD_USED4ROWNUMBER + r.nextDouble());
            designInfo.setStatType(257);
            StatRuntimeValue statRuntimeValue = new StatRuntimeValue(i, designInfo);
            this.getStats().add(statRuntimeValue);
        }
    }

    private void initStatsRuntimeValue(PWDataGrid grid) {
        int rc = grid.getRowsCount();
        for (int i = 0; i < rc; ++i) {
            AbstractPWDataGridRow row = grid.getRow(i);
            int level = row.getGroupLevel();
            int cc = row.getCellCount();
            for (int j = 0; j < cc; ++j) {
                PWDataGridCell cell = row.getCell(j);
                if (cell.getCellValue() == null || cell.getCellValue().getCellType() != 3) continue;
                StatRuntimeValue statRuntimeValue = StatSet.createStatRuntimeValue(level, cell);
                if (this.getStats().contains(statRuntimeValue)) continue;
                this.getStats().add(statRuntimeValue);
            }
        }
    }

    public static StatRuntimeValue createStatRuntimeValue(int level, PWDataGridCell cell) {
        return new StatRuntimeValue(level, (CellValueStat)cell.getCellValue());
    }

    public void doStats(IWidgetExecuteHelper helper, String ds) throws R1PrintException {
        if (StringUtil.equalsIgnoreCase("true", helper.getDataHelper().getFieldValue(ds, FIELD_NOTSTAT).toString())) {
            return;
        }
        for (StatRuntimeValue statRuntimeValue : this.getStats()) {
            try {
                statRuntimeValue.stat(helper, ds);
            }
            catch (SyntaxErrorException e) {
                throw new R1PrintException(ResManager.loadKDString((String)"\u7edf\u8ba1\u8fc7\u7a0b\u53d1\u751f\u5f02\u5e38\u3002", (String)"StatSet_0", (String)"bos-print-engine", (Object[])new Object[0]), e);
            }
        }
    }

    public void clearAreaStats() {
        for (StatRuntimeValue statRuntimeValue : this.getStats()) {
            if (!statRuntimeValue.getDesignInfo().isContain(2) && !statRuntimeValue.getDesignInfo().isContain(8)) continue;
            statRuntimeValue.clearValue(-1);
        }
    }

    public void clearGroupStats(int level) {
        for (StatRuntimeValue statRuntimeValue : this.getStats()) {
            if (statRuntimeValue.getLevel() != level) continue;
            statRuntimeValue.clearValue(level);
        }
        this.updateGroupNumber(level);
    }

    private void updateGroupNumber(int level) {
        int n = level;
        this._groupNumber[n] = this._groupNumber[n] + 1;
        for (int i = level + 1; i < this._groupNumber.length; ++i) {
            this._groupNumber[i] = 1;
        }
    }

    public void markStatCell(int level, PWDataGridCell outputCell) {
        StatRuntimeValue statRuntimeValue = StatSet.createStatRuntimeValue(level, outputCell);
        int idx = this.getStats().indexOf(statRuntimeValue);
        statRuntimeValue = (StatRuntimeValue)this.getStats().get(idx);
        ArrayList<PWDataGridCell> associateCells = (ArrayList<PWDataGridCell>)this._cellsToFill.get(statRuntimeValue);
        if (associateCells == null) {
            associateCells = new ArrayList<PWDataGridCell>();
            this._cellsToFill.put(statRuntimeValue, associateCells);
        }
        associateCells.add(outputCell);
        outputCell.getOwnerOutputPage().unsureIncrease();
    }

    public void fillStatCell(int level) throws R1PrintException {
        for (StatRuntimeValue statRuntimeValue : this.getStats()) {
            if (level == -1) {
                CellValueStat stat = statRuntimeValue.getDesignInfo();
                if (!stat.isContain(2) && !stat.isContain(4) && !stat.isContain(8)) continue;
                this.fillStatCell(statRuntimeValue);
                continue;
            }
            if (level != statRuntimeValue.getLevel()) continue;
            if (statRuntimeValue.getDesignInfo().isContain(8)) {
                statRuntimeValue.confirmReturnValue();
            }
            this.fillStatCell(statRuntimeValue);
        }
    }

    private void fillStatCell(StatRuntimeValue statRuntimeValue) throws R1PrintException {
        ArrayList associateCells = (ArrayList)this._cellsToFill.get(statRuntimeValue);
        if (associateCells == null) {
            return;
        }
        for (PWDataGridCell outputCell : associateCells) {
            try {
                outputCell.setOutputValue(statRuntimeValue.getValue());
            }
            catch (SyntaxErrorException e) {
                throw new R1PrintException(ResManager.loadKDString((String)"\u53d6\u7edf\u8ba1\u503c\u53d1\u751f\u5f02\u5e38\u3002", (String)"StatSet_1", (String)"bos-print-engine", (Object[])new Object[0]), e);
            }
            outputCell.runLastScript();
            outputCell.formatOutput();
            outputCell.getOwnerOutputPage().unsureReduce();
        }
        associateCells.clear();
    }

    public int getRowNumber(int level) {
        if (level == this._levels) {
            --level;
        }
        int length = FIELD_USED4ROWNUMBER.length();
        for (StatRuntimeValue statRuntimeValue : this.getStats()) {
            String field;
            if (level != statRuntimeValue.getLevel() || (field = statRuntimeValue.getDesignInfo().getStatField()) == null || field.length() <= length || !field.startsWith(FIELD_USED4ROWNUMBER)) continue;
            return statRuntimeValue.getCount() + 1;
        }
        return -1;
    }

    public int getGroupNumber(int level) {
        if (level == this._levels) {
            --level;
        }
        return this._groupNumber[level];
    }
}

