/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.layoutgrid;

import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.util.Util;
import com.kingdee.bos.ctrl.reportone.r1.print.common.AdjustHeightRenderer;
import com.kingdee.bos.ctrl.reportone.r1.print.common.IAdjustHeightRenderSupport;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.ExecuteContext;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.IWidgetExecuteHelper;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.R1PrintEngine;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.exception.R1PrintException;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.AbstractPrintWidgetText;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.IAdjustHeightSupport;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.IPrintWidget;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.IPrintWidgetContainer;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.StyleAccess;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.datagrid.cellvalue.ACellValue;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.datagrid.cellvalue.CellValueField;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.datagrid.cellvalue.CellValueText;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.datagrid.merge.RowColIdx;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.layoutgrid.context.LayoutGridCellExecuteContext;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;

public class PWLayoutGridCell
extends AbstractPrintWidgetText
implements IPrintWidgetContainer,
IAdjustHeightRenderSupport,
IAdjustHeightSupport {
    private ArrayList _children;
    private boolean _isAdjustHeight;
    private int _maxHeightToAdjust;
    private boolean _isRemainContent;
    private boolean _isBeMerged = false;
    private RowColIdx _referCell;
    private ACellValue _cellValue;

    public PWLayoutGridCell() {
        this.setHFill(true);
        this.setVFill(true);
    }

    public void setCellValue(ACellValue cellValue) {
        this._cellValue = cellValue;
    }

    public ACellValue getCellValue() {
        return this._cellValue;
    }

    @Override
    public void setAdjustHeight(boolean isAdjustHeight) {
        this._isAdjustHeight = isAdjustHeight;
    }

    @Override
    public boolean isAdjustHeight() {
        return this._isAdjustHeight;
    }

    @Override
    public IPrintWidget copy() {
        PWLayoutGridCell cell = (PWLayoutGridCell)super.copy();
        cell.setCellValue(this.getCellValue());
        return cell;
    }

    @Override
    public ExecuteContext getContext() {
        if (this._executeContext == null) {
            this._executeContext = new LayoutGridCellExecuteContext();
        }
        return this._executeContext;
    }

    @Override
    protected void executing(IWidgetExecuteHelper helper, IPrintWidget outputWidget) throws R1PrintException {
        PWLayoutGridCell outputCell = (PWLayoutGridCell)outputWidget;
        LayoutGridCellExecuteContext cec = (LayoutGridCellExecuteContext)this.getContext();
        if (outputCell.getCellValue() == null) {
            return;
        }
        if (outputCell.isAdjustHeight() && cec.isOutputedWhenAdjustHeight()) {
            outputCell.setOutputText("");
        } else if (this.isRemainContent()) {
            outputCell.setOutputText(this.getOutputText());
        } else {
            this.executingCellValue(helper, outputCell);
        }
        if (outputCell.isAdjustHeight()) {
            this.executingLongText(outputCell, cec);
        }
    }

    private void executingCellValue(IWidgetExecuteHelper helper, PWLayoutGridCell outputCell) {
        Variant outputVal = outputCell.getOutputValue();
        ACellValue cellValue = outputCell.getCellValue();
        switch (cellValue.getCellType()) {
            case 1: {
                Object formulaResult;
                String text = ((CellValueText)cellValue).getValue();
                if (outputVal != null) {
                    text = (String)outputVal.getValue();
                }
                if ((formulaResult = R1PrintEngine.runFormula(helper, outputCell, text)) == null) {
                    outputCell.setOutputValue(new Variant(text));
                    outputCell.formatOutput();
                    break;
                }
                outputCell.setValue(formulaResult);
                break;
            }
            case 2: {
                if (outputVal != null) {
                    outputCell.setOutputValue(outputVal);
                    outputCell.formatOutput();
                    break;
                }
                String field = ((CellValueField)cellValue).getField();
                outputCell.setOutputValue(this.getDataHelper(helper, this.getDatasource()).getFieldValue(this.getDatasource(), field));
                outputCell.formatOutput();
                break;
            }
        }
    }

    private void executingLongText(PWLayoutGridCell outputCell, LayoutGridCellExecuteContext cec) {
        String textRemain;
        String textToDraw;
        int maxH;
        int minH;
        int maxHeight;
        int widthLom = cec.getContainerWidth();
        int height = Util.lom2Pixel(cec.getContainerHeight()) - 1;
        if (height < (maxHeight = Util.lom2Pixel(cec.getMaxHeightToAdjust()) - 1)) {
            minH = height;
            maxH = maxHeight;
        } else {
            minH = maxH = maxHeight;
        }
        int width = Util.lom2Pixel(widthLom);
        String text = outputCell.getOutputText();
        text = text == null ? "" : text;
        AdjustHeightRenderer.Result result = AdjustHeightRenderer.adjustHeight(text, StyleAccess.getStyle(outputCell), minH, maxH, width);
        if (result.isTextCutOff()) {
            int nextStart = result.getCutPosition();
            textToDraw = text.substring(0, nextStart);
            textRemain = text.substring(nextStart);
        } else {
            textToDraw = text;
            textRemain = null;
        }
        int usedHeight = Util.pixel2Lom(result.getUsedHeight());
        outputCell.setOutputText(textToDraw);
        outputCell.setRectangle(new Rectangle(widthLom, usedHeight));
        this.setOutputText(textRemain);
        this.setRemainContent(textRemain != null);
        cec.setOutputedWhenAdjustHeight(textRemain == null);
        cec.setChildrenPaginating(this.isRemainContent());
    }

    @Override
    public boolean hasChildren() {
        return this._children != null && this._children.size() != 0;
    }

    @Override
    public void addChild(IPrintWidget w) {
        this.getChildren().add(w);
    }

    @Override
    public List getChildren() {
        if (this._children == null) {
            this._children = new ArrayList();
        }
        return this._children;
    }

    @Override
    public void setRemainContent(boolean isRemain) {
        this._isRemainContent = isRemain;
    }

    @Override
    public boolean isRemainContent() {
        return this._isRemainContent;
    }

    public void setBeMerged(boolean is) {
        this._isBeMerged = is;
    }

    public boolean isBeMerged() {
        return this._isBeMerged;
    }

    public void setReferCell(RowColIdx xy) {
        this._referCell = xy;
    }

    public RowColIdx getReferCell() {
        return this._referCell;
    }

    @Override
    public void setMaxHeightToAdjust(int maxHeight) {
        this._maxHeightToAdjust = maxHeight;
    }

    @Override
    public int getMaxHeightToAdjust() {
        return this._maxHeightToAdjust;
    }

    @Override
    public boolean isUseAdjustHeightRender() {
        return this.isAdjustHeight();
    }

    public PWLayoutGridCell copyOutput() {
        PWLayoutGridCell cell = (PWLayoutGridCell)this.copy();
        cell.setOutputText(this.getOutputText());
        return cell;
    }

    @Override
    public void setOriValue(String value) {
        super.setOriValue(value);
        this.setCellValue(new CellValueText(value));
    }
}

