/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.loop;

import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.IWidgetExecuteHelper;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.data.R1PDataVisitor;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.exception.R1PrintDataException;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.exception.R1PrintRuntimeException;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.LongProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

class TransposedDataHelper
implements IWidgetExecuteHelper.IDataHelper {
    private static final Log log = LogFactory.getLog(TransposedDataHelper.class);
    private R1PDataVisitor _dataVisitor;

    public TransposedDataHelper(List<DynamicObject> rowSet) {
        try {
            this._dataVisitor = R1PDataVisitor.create(rowSet);
        }
        catch (R1PrintDataException e) {
            log.error("", (Throwable)e);
            throw new R1PrintRuntimeException("Create transpose data error.", e);
        }
    }

    @Override
    public int getCurrentPositon(String ds) {
        return this._dataVisitor.getCurrentPositon();
    }

    @Override
    public Variant getFieldValue(String ds, String field) {
        try {
            if (this._dataVisitor.isBOF() && this._dataVisitor.isDataChanged()) {
                this._dataVisitor.next();
            }
            return this._dataVisitor.getFieldData(field);
        }
        catch (R1PrintDataException e) {
            log.error("", (Throwable)e);
            return null;
        }
    }

    @Override
    public Object getValue(String ds, String field) {
        try {
            if (this._dataVisitor.isBOF() && this._dataVisitor.isDataChanged()) {
                this._dataVisitor.next();
            }
            return this._dataVisitor.getFieldData(field);
        }
        catch (R1PrintDataException e) {
            log.error("", (Throwable)e);
            return null;
        }
    }

    @Override
    public Object getFieldType(String ds, String field) {
        try {
            if (this._dataVisitor.isBOF() && this._dataVisitor.isDataChanged()) {
                this._dataVisitor.next();
            }
            return this._dataVisitor.getFieldType(field);
        }
        catch (R1PrintDataException e) {
            log.error("", (Throwable)e);
            return null;
        }
    }

    @Override
    public Variant getPreviousRowFieldValue(String ds, String field) {
        try {
            return this._dataVisitor.getPreviousRowFieldData(field);
        }
        catch (R1PrintDataException e) {
            log.error("", (Throwable)e);
            return null;
        }
    }

    @Override
    public Variant getPropheticRowFieldData(String ds, String field) {
        try {
            return this._dataVisitor.getPropheticRowFieldData(field);
        }
        catch (R1PrintDataException e) {
            log.error("", (Throwable)e);
            return null;
        }
    }

    @Override
    public boolean hasNext(String ds) {
        try {
            return this._dataVisitor.hasNext();
        }
        catch (R1PrintDataException e) {
            log.error("", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean isBOF(String ds) {
        try {
            return this._dataVisitor.isBOF();
        }
        catch (R1PrintDataException e) {
            log.error("", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean isEOF(String ds) {
        try {
            return this._dataVisitor.isEOF();
        }
        catch (R1PrintDataException e) {
            log.error("", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean isNumberField(String ds, String field) {
        Object type;
        try {
            type = this._dataVisitor.getFieldType(field);
        }
        catch (R1PrintDataException e) {
            log.error("", (Throwable)e);
            return false;
        }
        return type instanceof DecimalProp || type instanceof LongProp;
    }

    @Override
    public boolean next(String ds) {
        try {
            return this._dataVisitor.next();
        }
        catch (R1PrintDataException e) {
            log.error("", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean isContextRelative() {
        return true;
    }

    @Override
    public int getRowsCount(String ds) {
        try {
            return this._dataVisitor.getRowsCount();
        }
        catch (R1PrintDataException e) {
            log.error("", (Throwable)e);
            return -1;
        }
    }
}

