/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.script.miniscript.exec;

import com.kingdee.bos.ctrl.common.util.FileUtil;
import com.kingdee.bos.ctrl.script.miniscript.ScriptContext;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class RunJava {
    public static final String STR = "\r\n }";
    private static TempClassLoader loader = new TempClassLoader(RunJava.class.getClassLoader());
    private static final Log log = LogFactory.getLog(RunJava.class);

    private RunJava() {
    }

    public static String aroundCode(String code, String classname, String imports) {
        StringBuilder s = new StringBuilder();
        if (imports == null) {
            s.append("\r\n import java.awt.*;");
            s.append("\r\n import javax.swing.*;");
            s.append("\r\n import java.util.*;");
            s.append("\r\n import java.text.*;");
        } else {
            String[] ss = imports.split(";");
            int n = ss.length;
            for (int i = 0; i < n; ++i) {
                if (ss[i].length() <= 0) continue;
                s.append("\r\n import ").append(ss[i]).append(";");
            }
        }
        s.append("\r\n import com.kingdee.bos.ctrl.script.miniscript.*;");
        s.append("\r\n public class ").append(classname).append("{").append("\r\n private ScriptContext context=null;").append("\r\n public Object set(String key,Object value){").append("\r\n return context.getScriptResult().setVar(key,value);").append(STR).append("\r\n public Object get(String key){").append("\r\n return context.getScriptResult().getVar(key);").append(STR).append("\r\n public ").append(classname).append("(ScriptContext context){").append("\r\n this.context=context;").append(STR).append("\r\n public void call()throws Exception{").append(code).append(STR).append(STR);
        return s.toString();
    }

    public static Class<?> defineClass(String code, String imports) throws Exception {
        File file = File.createTempFile("MiniScriptRuntime", ".java", new File(FileUtil.normalize(System.getProperty("user.dir"))));
        String filename = file.getCanonicalPath();
        if (filename.contains("\\")) {
            filename = filename.replace('\\', '/');
            file = new File(filename);
        }
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        String classname = RunJava.getClassName(filename);
        try (PrintWriter out = new PrintWriter(new FileOutputStream(file));){
            String s = RunJava.aroundCode(code, classname, imports);
            out.print(s);
            file.deleteOnExit();
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        String[] args = new String[]{"-d", System.getProperty("user.dir"), filename};
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        Class<?> javac = Class.forName("com.sun.tools.javac.Main");
        Method m = javac.getMethod("compile", String[].class, PrintWriter.class);
        int status = (Integer)m.invoke(null, args, pw);
        if (status != 0) {
            throw new KDException(sw.toString());
        }
        String classfile = filename.substring(0, filename.length() - 4) + "class";
        byte[] bs = new byte[]{};
        try (FileInputStream fis = new FileInputStream(classfile);){
            bs = new byte[fis.available()];
            int read = fis.read(bs);
            if (read == -1) {
                throw new KDException("no data can be read");
            }
        }
        if (!new File(classfile).delete()) {
            log.error(classfile + "can not be delete");
        }
        if (!file.delete()) {
            log.error(file + "can not be delete");
        }
        return loader.defineTempClass(classname, bs);
    }

    private static String getClassName(String filename) {
        filename = filename.replace('\\', '/');
        return filename.substring(filename.lastIndexOf(47) + 1, filename.length() - 5);
    }

    public static Object runJavaCode(String js, String imports, ScriptContext ctx) throws Exception {
        Class<?> cl = RunJava.defineClass(js, imports);
        Object obj = cl.getConstructor(ScriptContext.class).newInstance(ctx);
        Method main = cl.getMethod("call", new Class[0]);
        main.invoke(obj, new Object[0]);
        return obj;
    }

    static class TempClassLoader
    extends ClassLoader {
        protected TempClassLoader(ClassLoader parent) {
            super(parent);
        }

        public Class<?> defineTempClass(String className, byte[] bs) {
            return super.defineClass(className, bs, 0, bs.length);
        }
    }
}

