/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.script.miniscript.parser.syntaxtree;

import com.kingdee.bos.ctrl.script.miniscript.parser.syntaxtree.Node;
import com.kingdee.bos.ctrl.script.miniscript.parser.visitor.ObjectVisitor;
import com.kingdee.bos.ctrl.script.miniscript.parser.visitor.Visitor;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;

public class NodeToken
implements Node {
    private Node parent;
    private String tokenImage;
    private Vector specialTokens;
    private int beginLine;
    private int beginColumn;
    private int endLine;
    private int endColumn;
    private int kind;

    public NodeToken(String s) {
        this(s, -1, -1, -1, -1, -1);
    }

    public String getTokenImage() {
        return this.tokenImage;
    }

    public void setTokenImage(String tokenImage) {
        this.tokenImage = tokenImage;
    }

    public Vector getSpecialTokens() {
        return this.specialTokens;
    }

    public void setSpecialTokens(Vector specialTokens) {
        this.specialTokens = specialTokens;
    }

    public int getBeginLine() {
        return this.beginLine;
    }

    public void setBeginLine(int beginLine) {
        this.beginLine = beginLine;
    }

    public int getBeginColumn() {
        return this.beginColumn;
    }

    public void setBeginColumn(int beginColumn) {
        this.beginColumn = beginColumn;
    }

    public int getEndLine() {
        return this.endLine;
    }

    public void setEndLine(int endLine) {
        this.endLine = endLine;
    }

    public int getEndColumn() {
        return this.endColumn;
    }

    public void setEndColumn(int endColumn) {
        this.endColumn = endColumn;
    }

    public int getKind() {
        return this.kind;
    }

    public void setKind(int kind) {
        this.kind = kind;
    }

    public NodeToken(String s, int kind, int beginLine, int beginColumn, int endLine, int endColumn) {
        this.tokenImage = s;
        this.specialTokens = null;
        this.kind = kind;
        this.beginLine = beginLine;
        this.beginColumn = beginColumn;
        this.endLine = endLine;
        this.endColumn = endColumn;
    }

    public NodeToken getSpecialAt(int i) {
        if (this.specialTokens == null) {
            throw new NoSuchElementException("No specials in token");
        }
        return (NodeToken)this.specialTokens.elementAt(i);
    }

    public int numSpecials() {
        if (this.specialTokens == null) {
            return 0;
        }
        return this.specialTokens.size();
    }

    public void addSpecial(NodeToken s) {
        if (this.specialTokens == null) {
            this.specialTokens = new Vector();
        }
        this.specialTokens.addElement(s);
        s.setParent(this);
    }

    public void trimSpecials() {
        if (this.specialTokens == null) {
            return;
        }
        this.specialTokens.trimToSize();
    }

    public String toString() {
        return this.tokenImage;
    }

    public String withSpecials() {
        if (this.specialTokens == null) {
            return this.tokenImage;
        }
        StringBuilder buf = new StringBuilder();
        Enumeration e = this.specialTokens.elements();
        while (e.hasMoreElements()) {
            buf.append(e.nextElement().toString());
        }
        buf.append(this.tokenImage);
        return buf.toString();
    }

    @Override
    public void accept(Visitor v) {
        v.visit(this);
    }

    @Override
    public Object accept(ObjectVisitor v, Object argu) {
        return v.visit(this, argu);
    }

    @Override
    public void setParent(Node n) {
        this.parent = n;
    }

    @Override
    public Node getParent() {
        return this.parent;
    }
}

