/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.script.varscript;

import com.kingdee.bos.ctrl.script.miniscript.MiniScriptEngine;
import com.kingdee.bos.ctrl.script.miniscript.MiniScriptParseException;
import com.kingdee.bos.ctrl.script.miniscript.ScriptResult;
import com.kingdee.bos.ctrl.script.miniscript.exec.IVarRequestor;
import com.kingdee.bos.ctrl.script.varscript.IVarProvider;
import com.kingdee.bos.ctrl.script.varscript.MacroReplacer;
import com.kingdee.bos.ctrl.script.varscript.VarNotExistsException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class VarScript2MiniScript {
    private static final Log log = LogFactory.getLog(VarScript2MiniScript.class);

    public static String transVar(String script, Map env) throws MiniScriptParseException {
        return VarScript2MiniScript.transVar(script, env, null);
    }

    public static String transVar(String script, Map env, final IVarProvider varProvider) throws MiniScriptParseException {
        if (script == null) {
            return "";
        }
        try {
            script = MacroReplacer.replaceMacroFastest(script, env, varProvider);
        }
        catch (VarNotExistsException e1) {
            throw new MiniScriptParseException(e1);
        }
        char[] chs = script.toCharArray();
        boolean inQuote1 = false;
        boolean inQuote2 = false;
        StringBuilder s = new StringBuilder();
        IVarRequestor vr = null;
        if (varProvider != null) {
            vr = new IVarRequestor(){
                private Map cache = new HashMap();

                @Override
                public boolean existVar(String name) {
                    return !name.equals(StmtScript.RET);
                }

                @Override
                public Object getVar(String name) {
                    if (!this.cache.containsKey(name)) {
                        try {
                            this.cache.put(name, varProvider.getVar(name));
                        }
                        catch (Exception e) {
                            throw new KDException((Throwable)e, BosErrorCode.classConversion, new Object[]{""});
                        }
                    }
                    return this.cache.get(name);
                }
            };
        }
        int n = chs.length;
        for (int i = 0; i < n; ++i) {
            char ch = chs[i];
            if (!(ch != '@' && ch != '$' || inQuote1 || inQuote2)) {
                StmtScript is = new StmtScript();
                String ret = is.execute(is.searchStatement(script.substring(i + 1)), env, vr, ch == '@');
                s.append(ret);
                i += is.getStmtEndPos();
                continue;
            }
            if (ch == '\'') {
                if (inQuote1) {
                    inQuote1 = false;
                } else if (!inQuote2) {
                    inQuote1 = true;
                }
            } else if (ch == '\"') {
                if (inQuote2) {
                    inQuote2 = false;
                } else if (!inQuote1) {
                    inQuote2 = true;
                }
            }
            s.append(ch);
        }
        return s.toString();
    }

    static class StmtScript {
        static final String RET = "__$RET__" + StmtScript.class.getName().replace('.', '_');
        int pos = -1;

        StmtScript() {
        }

        String searchStatement(String source) {
            int i;
            StringBuilder s = new StringBuilder();
            char[] chs = source.toCharArray();
            boolean inQuote1 = false;
            boolean inQuote2 = false;
            int n = chs.length;
            for (i = 0; i < n; ++i) {
                char ch = chs[i];
                if (!inQuote1 && !inQuote2) {
                    if (ch == '\'') {
                        if (inQuote1) {
                            inQuote1 = false;
                        } else if (!inQuote2) {
                            inQuote1 = true;
                        }
                    } else if (ch == '\"') {
                        if (inQuote2) {
                            inQuote2 = false;
                        } else if (!inQuote1) {
                            inQuote2 = true;
                        }
                    } else {
                        if (ch == '(') {
                            s.append(ch);
                            int lp = 1;
                            boolean inQ1 = false;
                            boolean inQ2 = false;
                            while (lp > 0 && i++ < n) {
                                ch = chs[i];
                                if (!inQ1 && !inQ2) {
                                    if (ch == '\'') {
                                        if (inQ1) {
                                            inQ1 = false;
                                        } else if (!inQ2) {
                                            inQ1 = true;
                                        }
                                    } else if (ch == '\"') {
                                        if (inQ2) {
                                            inQ2 = false;
                                        } else if (!inQ1) {
                                            inQ2 = true;
                                        }
                                    } else if (ch == '(') {
                                        ++lp;
                                    } else if (ch == ')') {
                                        --lp;
                                    }
                                }
                                s.append(ch);
                            }
                            continue;
                        }
                        if (ch == '.') {
                            String sub = this.searchStatement(source.substring(i + 1));
                            s.append(".").append(sub);
                            i += sub.length();
                            continue;
                        }
                        if (ch == '@' || ch == '$' || ch == '+' || ch == '-' || ch == '*' || ch == '/' || ch == '=' || ch == '>' || ch == '<' || ch == '~' || ch == '!' || ch == '|' || ch == ':' || ch == '&' || ch == '^' || ch == '%' || ch == ' ' || ch == ';' || ch == ',' || ch == '?' || ch == ')' || ch == '\t' || ch == '\n' || ch == '\r' || ch == '[' || ch == ']' || ch == '{' || ch == '}') break;
                    }
                }
                s.append(ch);
            }
            this.pos = i;
            return s.toString();
        }

        String execute(String stmt, Map env, IVarRequestor varRequestor, boolean hasSign) throws MiniScriptParseException {
            String roundStmt = RET + "=" + stmt;
            MiniScriptEngine se = new MiniScriptEngine();
            se.parseScript(roundStmt);
            if (varRequestor != null) {
                se.setVarRequestor(varRequestor);
            }
            se.executeSync(env);
            ScriptResult rs = se.getScriptContext().getScriptResult();
            Object obj = rs.getVar(RET);
            String retString = "";
            if (obj instanceof Number) {
                retString = String.valueOf(obj);
            } else if (obj instanceof Date) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                retString = sdf.format((Date)obj);
                if (hasSign) {
                    retString = "{" + retString + "}";
                }
            } else {
                retString = String.valueOf(obj).replaceAll("'", "''");
                if (hasSign) {
                    retString = "'" + retString + "'";
                }
            }
            return retString;
        }

        int getStmtEndPos() {
            return this.pos;
        }
    }
}

