/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.swing;

import com.kingdee.bos.ctrl.common.KDToolkit;
import com.kingdee.bos.ctrl.common.util.FileUtil;
import com.kingdee.bos.ctrl.common.util.PrintFontUtil;
import com.kingdee.bos.ctrl.common.util.PrtFont;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.GraphicsEnvironment;
import java.awt.font.TextAttribute;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.AttributedCharacterIterator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class KDFont
extends Font {
    private static final Log log = LogFactory.getLog(KDFont.class);
    private static final long serialVersionUID = -5008956562051634709L;
    private static int currentDpi = -1;
    private static Properties fontProperties = null;
    private static String[] sysFamilyName;
    private static Map<String, Font> cacheFont;
    private int realSize;
    private static boolean isTableMode;
    private static boolean isFormDrawing;
    private Font formFont = null;

    private static int getCurrentDpi() {
        if (currentDpi == -1) {
            currentDpi = KDToolkit.getCurrentDpi();
        }
        return currentDpi;
    }

    public KDFont(String name, int style, int size) {
        super(name, style, Math.round((float)size * (float)KDFont.getCurrentDpi() / 72.0f));
        this.realSize = size;
    }

    public KDFont(Map attributes) {
        super(attributes);
        Object obj = attributes.get(TextAttribute.SIZE);
        if (obj instanceof Integer) {
            this.realSize = (Integer)obj;
            this.realSize = Math.round((float)this.realSize * 72.0f / (float)KDFont.getCurrentDpi());
        }
    }

    @Override
    public int getSize() {
        return this.realSize;
    }

    public int getDrawingSize() {
        return super.getSize();
    }

    public Font deriveFont(Map attributes) {
        Map<TextAttribute, ?> newAttrs = this.getAttributes();
        AttributedCharacterIterator.Attribute[] validAttribs = this.getAvailableAttributes();
        for (int i = 0; i < validAttribs.length; ++i) {
            Object obj = attributes.get(validAttribs[i]);
            if (obj == null) continue;
            newAttrs.put((TextAttribute)validAttribs[i], obj);
        }
        return new KDFont(newAttrs);
    }

    public static void setTableMode(boolean is) {
        isTableMode = is;
    }

    public static void setFormDrawing(boolean is) {
        isFormDrawing = is;
    }

    public Font getFont() {
        if (isTableMode || !isFormDrawing) {
            return this;
        }
        if (this.formFont == null) {
            this.formFont = this.deriveFont((float)this.realSize);
        }
        return this.formFont;
    }

    public static Font createFont(String name, int style, int size) {
        Font font = null;
        try {
            font = KDFont.isSystemDefineFont(name) ? new Font(name, style, size * KDFont.getCurrentDpi() / 72) : KDFont.loadFont(name, style, size);
        }
        catch (Exception e) {
            font = KDFont.loadFont(name, style, size);
        }
        return font;
    }

    public static Font createFont(Map attributes) {
        String name = (String)attributes.get(TextAttribute.FAMILY);
        int style = 0;
        Font font = null;
        try {
            if (KDFont.isSystemDefineFont(name)) {
                font = new Font(attributes);
            } else {
                float pointSize = ((Float)attributes.get(TextAttribute.SIZE)).floatValue();
                int size = (int)((double)pointSize + 0.5);
                Object obj = attributes.get(TextAttribute.WEIGHT);
                if (obj != null && obj.equals(TextAttribute.WEIGHT_BOLD)) {
                    style |= 1;
                }
                if ((obj = attributes.get(TextAttribute.POSTURE)) != null && obj.equals(TextAttribute.POSTURE_OBLIQUE)) {
                    style |= 2;
                }
                font = KDFont.loadFont(name, style, size);
            }
        }
        catch (Exception e) {
            float pointSize = ((Float)attributes.get(TextAttribute.SIZE)).floatValue();
            int size = (int)((double)pointSize + 0.5);
            Object obj = attributes.get(TextAttribute.WEIGHT);
            if (obj != null && obj.equals(TextAttribute.WEIGHT_BOLD)) {
                style |= 1;
            }
            if ((obj = attributes.get(TextAttribute.POSTURE)) != null && obj.equals(TextAttribute.POSTURE_OBLIQUE)) {
                style |= 2;
            }
            font = KDFont.loadFont(name, style, size);
        }
        return font;
    }

    public static Font loadFontFromJAR(String name, int style, int size) {
        Font font;
        block41: {
            font = null;
            List<PrtFont> fonts = PrintFontUtil.getFonts();
            Map<String, PrtFont> fontMapping = fonts.stream().collect(Collectors.toMap(item -> item.getFontName(), item -> item));
            PrtFont prtFont = fontMapping.get(name);
            if (prtFont == null) {
                name = "\u601d\u6e90\u5b8b\u4f53 CN";
            }
            if (cacheFont.containsKey(name)) {
                font = cacheFont.get(name);
            } else {
                block42: {
                    String fontDir = KDFont.getFontFilesDir();
                    if (name.equals("\u601d\u6e90\u5b8b\u4f53 CN")) {
                        String fileName = "source han serif cn.ttf";
                        String fullFontPath = fontDir + File.separatorChar + fileName;
                        File fontFile = new File(fullFontPath);
                        try {
                            if (!fontFile.exists()) {
                                try (InputStream ios = KDFont.class.getClassLoader().getResourceAsStream(fileName);){
                                    fontFile.createNewFile();
                                    try (FileOutputStream fos = new FileOutputStream(fontFile);){
                                        byte[] bytes = new byte[1024];
                                        int index = 0;
                                        while ((index = ios.read(bytes)) != -1) {
                                            fos.write(bytes, 0, index);
                                            fos.flush();
                                        }
                                        ios.close();
                                    }
                                }
                                log.debug("\u6253\u5370\uff1a \u5df2\u6210\u529f\u5c06\u5b8b\u4f53\u5199\u5165\u5b57\u4f53\u76ee\u5f55 :" + fontFile.getPath());
                            }
                            font = Font.createFont(0, fontFile);
                            if (!cacheFont.containsKey((font = font.deriveFont(1, size)).getFontName())) {
                                cacheFont.put(name, font);
                            }
                            break block41;
                        }
                        catch (Exception e) {
                            log.error((Throwable)e);
                            if ((e instanceof FontFormatException || e instanceof IOException) && fontFile.exists()) {
                                fontFile.delete();
                            }
                            break block41;
                        }
                    }
                    if (prtFont != null) {
                        String fileName = prtFont.getFontFileName();
                        String fileFullName = fontDir + File.separator + fileName;
                        File fontFile = new File(fileFullName);
                        boolean fontExist = fontFile.exists();
                        if (!fontExist) {
                            fontFile = PrintFontUtil.downloadFont(prtFont);
                            fontExist = fontFile.exists();
                        }
                        if (fontExist) {
                            try {
                                font = Font.createFont(0, fontFile);
                                cacheFont.put(name, font);
                            }
                            catch (Exception e) {
                                log.error("\u521b\u5efa\u5b57\u4f53\u5931\u8d25:" + e);
                                if (!(e instanceof FontFormatException) && !(e instanceof IOException) || !fontFile.exists()) break block42;
                                fontFile.delete();
                            }
                        }
                    }
                }
                if (font == null) {
                    font = KDFont.loadFontFromJAR("\u601d\u6e90\u5b8b\u4f53 CN", style, size);
                }
            }
        }
        return font != null ? font.deriveFont(style, size) : KDFont.loadFont(name, style, size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized Font loadFont(String name, int style, int size) {
        FileInputStream deffis = null;
        try {
            String filePath = System.getProperty("user.dir");
            filePath = FileUtil.normalize(filePath);
            String fileSeparator = System.getProperty("file.separator");
            String fileName = "";
            if (fontProperties == null) {
                fileName = filePath + fileSeparator + "font" + fileSeparator + "fonts.properties";
                fontProperties = new Properties();
                deffis = new FileInputStream(fileName);
                fontProperties.load(deffis);
                deffis.close();
            }
            String path = KDFont.getFontFilesDir();
            String fontNm = fontProperties.getProperty(name);
            fileName = path + fileSeparator + fontNm;
            Font font = null;
            try (FileInputStream fis = new FileInputStream(fileName);
                 BufferedInputStream bis = new BufferedInputStream(fis);){
                font = Font.createFont(0, bis);
                font = font.deriveFont(style, size);
            }
            catch (Exception e) {
                log.error((Throwable)e);
            }
            Font font2 = font;
            return font2;
        }
        catch (Exception e) {
            Font font = null;
            return font;
        }
        finally {
            if (deffis != null) {
                try {
                    deffis.close();
                }
                catch (IOException e) {
                    log.error((Throwable)e);
                }
            }
        }
    }

    public static synchronized boolean isSystemDefineFont(String name) {
        if (sysFamilyName == null || sysFamilyName.length != 0) {
            sysFamilyName = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        }
        for (int i = 0; i < sysFamilyName.length; ++i) {
            if (!sysFamilyName[i].equals(name)) continue;
            return true;
        }
        return false;
    }

    public static String getFontFilesDir() {
        String result = "";
        String filePath = System.getProperty("user.dir");
        String fileSeparator = System.getProperty("file.separator");
        String fileName = filePath + fileSeparator + "font" + fileSeparator + "fonts.properties" + fileSeparator + RequestContext.get().getTenantId();
        File file = new File(fileName = FileUtil.normalize(fileName));
        if (!file.exists()) {
            file.mkdirs();
        }
        try {
            result = file.getCanonicalPath();
        }
        catch (IOException e) {
            log.error("io", (Throwable)e);
        }
        return result;
    }

    public static Set<String> getFontFileNames() {
        File file;
        File[] tempList;
        String path = KDFont.getFontFilesDir();
        HashSet<String> files = new HashSet<String>();
        if (path.contains("\\")) {
            path = path.replace('\\', '/');
        }
        if ((tempList = (file = new File(path)).listFiles()) != null) {
            for (int i = 0; i < tempList.length; ++i) {
                if (!tempList[i].isFile()) continue;
                files.add(tempList[i].getName());
            }
        }
        return files;
    }

    static {
        cacheFont = new HashMap<String, Font>();
        isTableMode = false;
        isFormDrawing = false;
    }
}

