/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.plugin;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AbstractKsPrintServicePlugin;
import kd.bos.entity.plugin.IPrintServicePlugin;
import kd.bos.entity.plugin.args.BeforeLoadDataArgs;
import kd.bos.entity.plugin.args.CustomPrintDataEntitiesArgs;
import kd.bos.entity.plugin.args.DynamicColumnArgs;
import kd.bos.entity.plugin.args.OutputElementArgs;
import kd.bos.entity.plugin.args.SensitiveArgs;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.script.ScriptExecutor;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class PrintServicePluginProxy
implements Serializable {
    private static final String BOS_PRINT_ENGINE = "bos-print-engine";
    private static final long serialVersionUID = 1L;
    private static Log log = LogFactory.getLog(PrintServicePluginProxy.class);
    private ScriptExecutor scriptExecutor;
    private List<IPrintServicePlugin> plugIns = new ArrayList<IPrintServicePlugin>();

    public PrintServicePluginProxy(List<Map<String, Object>> plugins) {
        for (Map<String, Object> ins : plugins) {
            IPrintServicePlugin splugin;
            int type = (Integer)ins.get("type");
            String className = (String)ins.get("className");
            if (0 == type) {
                try {
                    splugin = (IPrintServicePlugin)TypesContainer.createInstance((String)className);
                    this.plugIns.add(splugin);
                }
                catch (Exception e) {
                    log.error("##printerror:className:" + className + e.getMessage());
                }
                continue;
            }
            if (1 != type) continue;
            try {
                splugin = this.createScriptPlugin1(className);
                if (splugin == null) continue;
                this.plugIns.add(splugin);
            }
            catch (Exception e) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"KS\u6253\u5370\u63d2\u4ef6\u8f6c\u6362\u5f02\u5e38:%s\u3002", (String)"PrintServicePluginProxy_0", (String)BOS_PRINT_ENGINE, (Object[])new Object[0]), e.getMessage()));
            }
        }
    }

    public IPrintServicePlugin createScriptPlugin(String scriptName) {
        return this.createScriptPlugin1(scriptName);
    }

    private IPrintServicePlugin createScriptPlugin1(String scriptName) {
        String script = EntityMetadataCache.getPluginScripts((String)scriptName);
        this.scriptExecutor = ScriptExecutor.getOrCreate();
        this.scriptExecutor.init(ctx -> ctx.require(new String[]{AbstractKsPrintServicePlugin.class.getName()}));
        this.scriptExecutor.begin();
        this.scriptExecutor.exec(new String[]{script});
        return (IPrintServicePlugin)this.scriptExecutor.getContext().get("plugin");
    }

    public void destory() {
        if (this.scriptExecutor != null) {
            this.scriptExecutor.end();
        }
    }

    public void registerPlugIn(IPrintServicePlugin plugIn) {
        this.plugIns.add(plugIn);
    }

    public void setContext(MainEntityType billEntityType) {
        for (IPrintServicePlugin plugIn : this.plugIns) {
            plugIn.setContext(billEntityType);
        }
    }

    public void fireBeforeLoadData(BeforeLoadDataArgs e) {
        for (IPrintServicePlugin pl : this.plugIns) {
            pl.beforeLoadData(e);
        }
    }

    public void fireBeforeOuputElement(OutputElementArgs e) {
        for (IPrintServicePlugin pl : this.plugIns) {
            pl.beforeOuputElement(e);
        }
    }

    public void fireAfterOuputElement(OutputElementArgs e) {
        for (IPrintServicePlugin pl : this.plugIns) {
            pl.afterOutputElement(e);
        }
    }

    public void fireCustomPrintDataEntities(CustomPrintDataEntitiesArgs e) {
        for (IPrintServicePlugin pl : this.plugIns) {
            pl.customPrintDataEntities(e);
        }
    }

    public void fireAddDynamicColumns(DynamicColumnArgs e) {
        for (IPrintServicePlugin pl : this.plugIns) {
            pl.addDynamicColumns(e);
        }
    }

    public void fireBeforeDesensitive(SensitiveArgs e) {
        for (IPrintServicePlugin pl : this.plugIns) {
            pl.beforeDesensitive(e);
        }
    }
}

