/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.typeparse;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.SubEntryProp;

public abstract class AbstractTypeParser {
    protected Map<String, Object> itemMap = new HashMap<String, Object>();
    protected DynamicObjectType dt;
    protected Class<?>[] clazzes;
    protected Set<String> targetFields;

    protected AbstractTypeParser(DynamicObjectType dt, Set<String> targetFields, Class<?> ... clazz) {
        this.dt = dt;
        this.clazzes = clazz;
        this.targetFields = targetFields;
    }

    public abstract void recordParseMsg(String var1, IDataEntityProperty var2);

    public abstract void consumeParseMsg(String var1, String var2, Object var3);

    public void setItemMap(Map<String, Object> itemMap) {
        this.itemMap = itemMap;
    }

    public void scanTypeFields() {
        this.scanTypeFields((IDataEntityType)this.dt, "");
    }

    protected void scanTypeFields(IDataEntityType entityType, String puffix) {
        this.scanTypeFields(entityType, puffix, 1);
    }

    protected void scanTypeFields(IDataEntityType entityType, String prefix, int level) {
        if (entityType == null || level >= 4) {
            return;
        }
        DataEntityPropertyCollection properties = entityType.getProperties();
        String propName = null;
        for (IDataEntityProperty prop : properties) {
            propName = prop.getName();
            String newPrefix = prefix + propName;
            if (!this.isUseFieldWithPrefix(newPrefix)) continue;
            if (prop instanceof SubEntryProp) {
                this.scanTypeFields((IDataEntityType)((EntryProp)prop).getDynamicCollectionItemPropertyType(), propName + ".", level + 1);
            }
            if (prop instanceof EntryProp) {
                this.scanTypeFields((IDataEntityType)((EntryProp)prop).getDynamicCollectionItemPropertyType(), newPrefix + ".", level + 1);
            }
            if (prop instanceof ItemClassProp && this.isInstanceOf(prop)) {
                this.recordParseMsgWhenMeetTarget(newPrefix + ".number", prop);
                this.recordParseMsgWhenMeetTarget(newPrefix + ".name", prop);
                continue;
            }
            if (prop instanceof BasedataProp && !(prop instanceof FlexProp)) {
                MainEntityType baseType = EntityMetadataCache.getDataEntityType((String)((BasedataProp)prop).getComplexType().getName());
                if (baseType == null) continue;
                this.scanTypeFields((IDataEntityType)baseType, newPrefix + ".", level + 1);
                continue;
            }
            if (!this.isInstanceOf(prop)) continue;
            this.recordParseMsgWhenMeetTarget(newPrefix, prop);
        }
    }

    protected boolean isUseFieldWithPrefix(String prefix) {
        return true;
    }

    protected void recordParseMsgWhenMeetTarget(String field, IDataEntityProperty prop) {
        this.recordParseMsg(field, prop);
    }

    protected boolean isInstanceOf(IDataEntityProperty prop) {
        for (Class<?> clazz : this.clazzes) {
            if (!clazz.isInstance(prop)) continue;
            return true;
        }
        return false;
    }

    public void processTypeField(DynamicObject obj, Set<String> usedFields) {
        this.processTypeField((Object)obj, usedFields);
    }

    public void processTypeField(Object obj, Set<String> usedFields) {
        if (obj == null || usedFields == null || usedFields.isEmpty()) {
            return;
        }
        if (this.itemMap.isEmpty()) {
            return;
        }
        Set<String> keySet = this.getTypeFields();
        keySet.retainAll(usedFields);
        if (keySet.size() > 0) {
            keySet.forEach(usedEnumField -> this.consumeParseMsg((String)usedEnumField, (String)usedEnumField, obj));
        }
    }

    public void processTypeField(List<DynamicObject> objs, Set<String> usedEnumFields) {
        if (objs == null || objs.isEmpty()) {
            return;
        }
        for (DynamicObject dynObj : objs) {
            this.processTypeField(dynObj, usedEnumFields);
        }
    }

    public Set<String> getTypeFields() {
        HashSet<String> keySet = new HashSet<String>();
        keySet.addAll(this.itemMap.keySet());
        return keySet;
    }

    public Class<?>[] getClazz() {
        return this.clazzes;
    }

    public void setClazz(Class<?>[] clazz) {
        this.clazzes = clazz;
    }

    public Map<String, Object> getItemMap() {
        return this.itemMap;
    }

    public DynamicObjectType getDt() {
        return this.dt;
    }

    public void setDt(DynamicObjectType dt) {
        this.dt = dt;
    }
}

