/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.typeparse;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.ItemClassTypeProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.print.typeparse.AbstractTypeParser;
import org.apache.commons.lang.StringUtils;

public class EnumTypeParser
extends AbstractTypeParser {
    private static Log log = LogFactory.getLog(EnumTypeParser.class);

    protected EnumTypeParser(DynamicObjectType dt, Set<String> targetFields, Class<?> ... clazz) {
        super(dt, targetFields, clazz);
    }

    @Override
    public void recordParseMsg(String propQulifiedName, IDataEntityProperty prop) {
        if (prop instanceof ComboProp && !(prop instanceof ItemClassTypeProp)) {
            this.itemMap.put(propQulifiedName, ((ComboProp)prop).getComboItems());
        }
    }

    @Override
    public void consumeParseMsg(String propQulifiedName, String curKey, Object object) {
        DynamicObject obj = (DynamicObject)object;
        IDataEntityType dataEntityType = obj.getDataEntityType();
        String entityName = dataEntityType.getName();
        if ("PlainObject".equals(entityName)) {
            String enumValue = obj.getString(curKey);
            String enumName = this.getEnumKeyByValue(propQulifiedName, enumValue);
            obj.set(curKey, (Object)enumName);
        } else if (curKey.indexOf(46) == -1) {
            String enumValue = obj.getString(curKey);
            String enumName = this.getEnumKeyByValue(propQulifiedName, enumValue);
            obj.set(curKey, (Object)enumName);
        } else {
            DynamicObject baseData;
            String mainPropName = StringUtils.substringBefore((String)curKey, (String)".");
            String subPropName = StringUtils.substringAfter((String)curKey, (String)".");
            Object element = obj.get(mainPropName);
            if (element instanceof DynamicObjectCollection) {
                DynamicObjectCollection entry = obj.getDynamicObjectCollection(mainPropName);
                for (DynamicObject entryRowObj : entry) {
                    this.consumeParseMsg(propQulifiedName, subPropName, entryRowObj);
                }
            } else if (element instanceof DynamicObject && (baseData = (DynamicObject)element).getDataEntityType() instanceof BasedataEntityType) {
                this.consumeParseMsg(propQulifiedName, subPropName, baseData);
            }
        }
    }

    private String getEnumKeyByValue(String propName, String value) {
        List comboItems = (List)this.itemMap.get(propName);
        if (comboItems != null) {
            if (value == null) {
                log.debug("\u6253\u5370\uff1a\u540d\u79f0\u4e3a(" + propName + ")\u7684\u679a\u4e3e\u5c5e\u6027\u7684\u503c\u4e3aNull, \u8bf7\u68c0\u67e5\u3002");
            } else {
                String[] enumValues = new String[]{value};
                if (value.contains(",")) {
                    enumValues = value.split(",");
                }
                ArrayList<String> values = new ArrayList<String>();
                for (ValueMapItem comboItem : comboItems) {
                    for (int i = 0; i < enumValues.length; ++i) {
                        String v;
                        if (!Objects.equals(enumValues[i], comboItem.getValue()) || !StringUtils.isNotBlank((String)(v = comboItem.getName().toString()))) continue;
                        values.add(comboItem.getName().toString());
                    }
                }
                return StringUtils.join((Object[])values.toArray(new String[values.size()]), (String)",");
            }
        }
        return "";
    }
}

