/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.validation;

import com.kingdee.bos.ctrl.reportone.r1.common.designercore.data.DataExtend;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.metadata.form.PrintMetadata;
import kd.bos.metadata.print.control.BaseControl;
import kd.bos.metadata.print.control.DataCell;
import kd.bos.metadata.print.control.DataGrid;
import kd.bos.metadata.print.control.DataRow;
import kd.bos.metadata.print.control.LayoutCell;
import kd.bos.metadata.print.control.Text;
import kd.bos.print.typeparse.AbstractTypeParser;
import kd.bos.print.typeparse.TypeParserFactory;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class FieldScanner {
    private static final String CUSTOM = "custom";
    AbstractTypeParser billFieldParser;
    private PrintMetadata ptMeta;

    public FieldScanner() {
    }

    public FieldScanner(PrintMetadata meta) {
        this.ptMeta = meta;
        this.initDataCellDs(this.ptMeta);
    }

    public FieldScanner(DynamicObjectType dt) {
        this.billFieldParser = TypeParserFactory.getTypeParser(3, null, dt);
        this.billFieldParser.scanTypeFields();
    }

    public FieldScanner(String formId) {
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)formId);
        this.billFieldParser = TypeParserFactory.getTypeParser(3, null, (DynamicObjectType)dt);
        this.billFieldParser.scanTypeFields();
    }

    public Set<String> getInvalidFields(PrintMetadata meta) {
        this.initDataCellDs(meta);
        Set<String> fieldFromTemplate = this.scanBindFields(meta);
        HashSet fieldFromDT = new HashSet();
        this.billFieldParser.consumeParseMsg("", "", fieldFromDT);
        fieldFromTemplate.removeAll(fieldFromDT);
        return fieldFromTemplate;
    }

    public Set<String> isValid(DataExtend[] dxts) {
        HashSet<String> invalidField = new HashSet<String>();
        for (DataExtend dxt : dxts) {
            Set<String> usedFields = dxt.getUsedFields();
            HashSet nameSet = new HashSet();
            this.billFieldParser.consumeParseMsg("", "", nameSet);
            for (String templateBindField : usedFields) {
                if (nameSet.contains(templateBindField) || templateBindField.matches(".*\\.id||id")) continue;
                invalidField.add(templateBindField);
            }
        }
        return invalidField;
    }

    private void initDataCellDs(PrintMetadata meta) {
        HashMap dataSource = new HashMap();
        HashMap rowDataSource = new HashMap();
        List items = meta.getItems();
        items.forEach(item -> {
            if (item instanceof DataGrid) {
                dataSource.put(item.getId(), item.getDataSource());
            }
        });
        items.forEach(item -> {
            if (item instanceof DataRow) {
                String dataGridID = item.getParentId();
                String ds = (String)dataSource.get(dataGridID);
                rowDataSource.put(item.getId(), ds);
            }
        });
        items.forEach(item -> {
            if (item instanceof DataCell) {
                String rowID = item.getParentId();
                if ((StringUtils.isNotBlank((CharSequence)item.getBindField()) || StringUtils.isNotBlank((CharSequence)item.getCustomField())) && StringUtils.isBlank((CharSequence)item.getDataSource())) {
                    item.setDataSource((String)rowDataSource.get(rowID));
                }
            }
        });
    }

    private Set<String> scanBindFields(PrintMetadata meta) {
        String mainDs = this.billFieldParser.getDt().getName();
        List items = meta.getItems();
        String ds = null;
        String bindField = null;
        HashSet<String> usedFields = new HashSet<String>();
        for (BaseControl control : items) {
            ds = control.getDataSource();
            bindField = control.getBindField();
            String customeField = control.getCustomField();
            if (StringUtils.isBlank((CharSequence)ds) || StringUtils.isBlank((CharSequence)bindField) || StringUtils.isNotBlank((CharSequence)customeField)) continue;
            if (ds.equals(mainDs)) {
                usedFields.add(bindField);
                continue;
            }
            usedFields.add(String.format("%s.%s", ds, bindField));
        }
        return usedFields;
    }

    public Set<String> scanBindedFields(PrintMetadata meta) {
        this.initDataCellDs(meta);
        List items = meta.getItems();
        String bindField = "";
        HashSet<String> usedFields = new HashSet<String>();
        for (BaseControl control : items) {
            DataCell dc;
            Text t;
            if (control instanceof Text && "field".equals((t = (Text)control).getBindType())) {
                usedFields.add(bindField);
            }
            if (!(control instanceof DataCell) || !"field".equals((dc = (DataCell)control).getCellType()) && !"stat".equals(dc.getCellType())) continue;
            usedFields.add(String.format("%s.%s", dc.getDataSource(), bindField));
        }
        return usedFields;
    }

    public Set<String> scanCustomFields(PrintMetadata meta, String dataSourceName) {
        this.initDataCellDs(meta);
        List items = meta.getItems();
        HashSet<String> customeFields = new HashSet<String>();
        for (BaseControl control : items) {
            Text txt;
            String ds = control.getDataSource();
            String customeField = control.getCustomField();
            if (StringUtils.isBlank((CharSequence)ds) || StringUtils.isBlank((CharSequence)customeField) || !ds.equalsIgnoreCase(dataSourceName)) continue;
            if (control instanceof DataCell) {
                DataCell dc = (DataCell)control;
                if (!dc.getCellType().equalsIgnoreCase(CUSTOM)) continue;
                customeFields.add(customeField);
                continue;
            }
            if (!(control instanceof Text) || !(txt = (Text)control).getBindType().equalsIgnoreCase(CUSTOM)) continue;
            customeFields.add(customeField);
        }
        return customeFields;
    }

    public Map<String, Set<String>> scanCustomFields(PrintMetadata meta) {
        HashMap<String, Set<String>> customFieldsMap = new HashMap<String, Set<String>>();
        this.initDataCellDs(meta);
        for (BaseControl control : meta.getItems()) {
            Text txt;
            String ds = control.getDataSource();
            String customeField = control.getCustomField();
            if (StringUtils.isBlank((CharSequence)ds) || StringUtils.isBlank((CharSequence)customeField)) continue;
            if (!customFieldsMap.containsKey(ds)) {
                HashSet newFields = new HashSet();
                customFieldsMap.put(ds, newFields);
            }
            Set customeFields = (Set)customFieldsMap.get(ds);
            if (control instanceof DataCell) {
                DataCell dc = (DataCell)control;
                if (dc.getCellType().equalsIgnoreCase(CUSTOM)) {
                    customeFields.add(customeField);
                }
            } else if (control instanceof Text && (txt = (Text)control).getBindType().equalsIgnoreCase(CUSTOM)) {
                customeFields.add(customeField);
            }
            if (customeFields.size() <= 0) continue;
            customFieldsMap.put(ds, customeFields);
        }
        return customFieldsMap;
    }

    public Map<String, Set<String>> scanCustomFields() {
        HashMap<String, Set<String>> customFieldsMap = new HashMap<String, Set<String>>();
        for (BaseControl control : this.ptMeta.getItems()) {
            String bindDs = control.getDataSource();
            if (StringUtils.isBlank((CharSequence)bindDs)) continue;
            String ds = "";
            String dsType = "1";
            try {
                Map mapData = (Map)SerializationUtils.fromJsonString((String)bindDs, Map.class);
                ds = (String)mapData.get("key");
                dsType = (String)mapData.get("type");
            }
            catch (Exception e) {
                ds = bindDs;
            }
            String customeField = "";
            customeField = "5".equals(dsType) ? control.getBindField() : control.getCustomField();
            if (StringUtils.isBlank((CharSequence)customeField)) continue;
            if (!customFieldsMap.containsKey(ds)) {
                HashSet newFields = new HashSet();
                customFieldsMap.put(ds, newFields);
            }
            Set customeFields = (Set)customFieldsMap.get(ds);
            if (control instanceof LayoutCell) {
                LayoutCell dc = (LayoutCell)control;
                if ("5".equals(dsType) || dc.getCellType().equalsIgnoreCase(CUSTOM)) {
                    customeFields.add(customeField);
                }
            } else if (control instanceof Text) {
                Text txt = (Text)control;
                if ("5".equals(dsType) || txt.getBindType().equalsIgnoreCase(CUSTOM)) {
                    customeFields.add(customeField);
                }
            }
            if (customeFields.size() <= 0) continue;
            customFieldsMap.put(ds, customeFields);
        }
        return customFieldsMap;
    }
}

