/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import kd.bos.openapi.common.custom.annotation.ApiModel;
import kd.bos.openapi.common.custom.annotation.ApiParam;
import kd.bos.print.api.FileStorageType;
import kd.bos.print.api.IPrintWorkExt;
import kd.bos.print.api.PrintTask;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
@ApiModel
public class PrintWork
implements IPrintWorkExt {
    @ApiParam(value="\u5e94\u7528\u7f16\u7801")
    private @ApiParam(value="\u5e94\u7528\u7f16\u7801") String appNumber;
    private String pageId;
    @ApiParam(value="\u6253\u5370\u8bed\u8a00\uff1azh_CN\u3001en_US\u7b49\uff0cLang.zh_CN.toString()")
    private @ApiParam(value="\u6253\u5370\u8bed\u8a00\uff1azh_CN\u3001en_US\u7b49\uff0cLang.zh_CN.toString()") String printLang;
    @ApiParam(value="\u8f93\u51fa\u7c7b\u578b\uff1apdf\u3001xls\u3001png\u3002 \u8bf7\u4f7f\u7528EXP_TYPE.getCode")
    private @ApiParam(value="\u8f93\u51fa\u7c7b\u578b\uff1apdf\u3001xls\u3001png\u3002 \u8bf7\u4f7f\u7528EXP_TYPE.getCode") String expType = "pdf";
    @ApiParam(value="\u6253\u5370\u673a")
    private @ApiParam(value="\u6253\u5370\u673a") String printerId;
    @ApiParam(value="\u662f\u5426\u7eb5\u5411\u8282\u7eb8\u6253\u5370")
    private @ApiParam(value="\u662f\u5426\u7eb5\u5411\u8282\u7eb8\u6253\u5370") boolean isVerEconomizePaper;
    @ApiParam(value="\u662f\u5426\u6a2a\u5411\u8282\u7eb8\u6253\u5370")
    private @ApiParam(value="\u662f\u5426\u6a2a\u5411\u8282\u7eb8\u6253\u5370") boolean isHorEconomizePaper;
    @ApiParam(value="\u662f\u5426\u6309\u5355\u8282\u7eb8\u6253\u5370")
    private @ApiParam(value="\u662f\u5426\u6309\u5355\u8282\u7eb8\u6253\u5370") boolean economizeByBill;
    @ApiParam(value="1\u3001\u6309\u5355\u4e2a\u5355\u636e\u751f\u6210\u9875\u7801 2\u3001\u6309\u6240\u9009\u5355\u636e\u751f\u6210\u9875\u7801")
    private @ApiParam(value="1\u3001\u6309\u5355\u4e2a\u5355\u636e\u751f\u6210\u9875\u7801 2\u3001\u6309\u6240\u9009\u5355\u636e\u751f\u6210\u9875\u7801") String pageNumType;
    @ApiParam(value="\u662f\u5426\u5f00\u542f\u5355\u636e\u9875\u9762\u95f4\u9694")
    private @ApiParam(value="\u662f\u5426\u5f00\u542f\u5355\u636e\u9875\u9762\u95f4\u9694") boolean isPageSeparation;
    @ApiParam(value="1\u3001\u6309\u6240\u9009\u5355\u636e\u751f\u6210\u4e00\u4e2aPDF 2\u3001\u6309\u4e0d\u540c\u5355\u636e\u751f\u6210\u591a\u4e2aPDF")
    private @ApiParam(value="1\u3001\u6309\u6240\u9009\u5355\u636e\u751f\u6210\u4e00\u4e2aPDF 2\u3001\u6309\u4e0d\u540c\u5355\u636e\u751f\u6210\u591a\u4e2aPDF") String fileCreateType;
    @ApiParam(value="\u6269\u5c55\u53c2\u6570")
    private @ApiParam(value="\u6269\u5c55\u53c2\u6570") Map<String, Object> extParam;
    @Valid
    @NotEmpty
    @ApiParam(value="\u6253\u5370\u4efb\u52a1\uff0c\u4e00\u4e2a\u6a21\u7248\u5bf9\u5e94\u4e00\u4e2aPrintTask")
    private @Valid @NotEmpty @ApiParam(value="\u6253\u5370\u4efb\u52a1\uff0c\u4e00\u4e2a\u6a21\u7248\u5bf9\u5e94\u4e00\u4e2aPrintTask") List<PrintTask> taskList;
    private FileStorageType fileStorageType;
    private boolean isBizOp;
    @ApiParam(value="\u6253\u5370\u8bbe\u5907DPI\uff08\u4ec5\u5f53expType=cpcl\u65f6\u751f\u6548\uff09")
    private @ApiParam(value="\u6253\u5370\u8bbe\u5907DPI\uff08\u4ec5\u5f53expType=cpcl\u65f6\u751f\u6548\uff09") int dpi = 0;

    public void add(PrintTask task) {
        if (this.taskList == null) {
            this.taskList = new ArrayList<PrintTask>(10);
        }
        this.taskList.add(task);
    }

    public String getAppNumber() {
        return this.appNumber;
    }

    public void setAppNumber(String appNumber) {
        this.appNumber = appNumber;
    }

    public String getPageId() {
        return this.pageId;
    }

    public void setPageId(String pageId) {
        this.pageId = pageId;
    }

    public String getExpType() {
        return this.expType;
    }

    public void setExpType(String expType) {
        this.expType = expType;
        if (!("pdf".equalsIgnoreCase(expType) || "xls".equalsIgnoreCase(expType) || "1".equalsIgnoreCase(expType) || this.fileStorageType != null)) {
            this.fileStorageType = FileStorageType.TEMP_FILE;
        }
    }

    public boolean isVerEconomizePaper() {
        return this.isVerEconomizePaper;
    }

    public void setVerEconomizePaper(boolean verEconomizePaper) {
        this.isVerEconomizePaper = verEconomizePaper;
    }

    public boolean isHorEconomizePaper() {
        return this.isHorEconomizePaper;
    }

    public String getPrintLang() {
        return this.printLang;
    }

    public void setPrintLang(String printLang) {
        this.printLang = printLang;
    }

    public void setHorEconomizePaper(boolean horEconomizePaper) {
        this.isHorEconomizePaper = horEconomizePaper;
    }

    public String getPageNumType() {
        return this.pageNumType;
    }

    public void setPageNumType(String pageNumType) {
        this.pageNumType = pageNumType;
    }

    public boolean isPageSeparation() {
        if (this.isHorEconomizePaper() || this.isVerEconomizePaper()) {
            return false;
        }
        return this.isPageSeparation;
    }

    public void setPageSeparation(boolean isPageSeparation) {
        this.isPageSeparation = isPageSeparation;
    }

    public List<PrintTask> getTaskList() {
        if (this.taskList == null) {
            return Collections.EMPTY_LIST;
        }
        return this.taskList;
    }

    public void setTaskList(List<PrintTask> taskList) {
        this.taskList = taskList;
    }

    public Map<String, Object> getExtParam() {
        if (this.extParam == null) {
            return new HashMap<String, Object>(0);
        }
        return this.extParam;
    }

    public void setExtParam(Map<String, Object> extParam) {
        this.extParam = extParam;
    }

    public boolean isBizOp() {
        return this.isBizOp;
    }

    public void setBizOp(boolean bizOp) {
        this.isBizOp = bizOp;
    }

    public FileStorageType getFileStorageType() {
        return this.fileStorageType;
    }

    public String getPrinterId() {
        return this.printerId;
    }

    public void setPrinterId(String printerId) {
        this.printerId = printerId;
    }

    public void setFileStorageType(FileStorageType fileStorageType) {
        this.fileStorageType = fileStorageType;
    }

    public int getDpi() {
        return this.dpi;
    }

    public void setDpi(int dpi) {
        this.dpi = dpi;
    }

    public String getFileCreateType() {
        return this.fileCreateType;
    }

    public void setFileCreateType(String fileCreateType) {
        this.fileCreateType = fileCreateType;
    }

    public boolean isEconomizeByBill() {
        return this.economizeByBill;
    }

    public void setEconomizeByBill(boolean economizeByBill) {
        this.economizeByBill = economizeByBill;
    }

    public static enum EXP_TYPE {
        EXP_PDF("pdf"),
        EXP_XLS("xls"),
        EXP_CLIENT("client"),
        EXP_SCPT("scpt"),
        EXP_CLIENTPREVIEW("clientpreview"),
        EXP_ESCPOS("escpos"),
        EXP_ESCPOS_O("escpos_o"),
        EXP_ESCP("escp"),
        EXP_MOBILEPREVIEW("mobilepreview"),
        EXP_PNG("png"),
        EXP_CPCL("cpcl");

        private String code;

        private EXP_TYPE(String code) {
            this.code = code;
        }

        public String getCode() {
            return this.code;
        }
    }
}

