/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.api.facade;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.print.api.facade.FacadeClassType;
import kd.bos.print.api.facade.IPrintControlModelFacade;
import kd.bos.print.api.facade.IPrintServiceFacade;
import kd.bos.print.api.facade.IPrintTemplateFacade;
import kd.bos.print.api.facade.IPrtDataSourceFacade;
import kd.bos.print.api.facade.ITemplateUpgradeFacade;

public class PrtFacadeFactory {
    private static Map<FacadeClassType, List<String>> facadeImplClass = new EnumMap<FacadeClassType, List<String>>(FacadeClassType.class);
    private static final Log log = LogFactory.getLog(PrtFacadeFactory.class);

    public static void register(FacadeClassType classType, String className) {
        if (StringUtils.isEmpty((CharSequence)className)) {
            return;
        }
        List<String> facadeClassList = facadeImplClass.get((Object)classType);
        if (facadeClassList == null) {
            facadeClassList = new ArrayList<String>();
            facadeImplClass.put(classType, facadeClassList);
        }
        facadeClassList.add(className);
    }

    public static void unRegister(FacadeClassType classType, String className) {
        List<String> facadeClassList = facadeImplClass.get((Object)classType);
        if (facadeClassList != null) {
            facadeClassList.remove(className);
        }
    }

    public static List<String> getRegisterClass(FacadeClassType classType) {
        List<String> facadeClassList = facadeImplClass.get((Object)classType);
        if (facadeClassList != null) {
            return facadeClassList;
        }
        return Collections.EMPTY_LIST;
    }

    public static List<?> getAllPrtFacades(FacadeClassType facadeClassType) {
        return PrtFacadeFactory.getRegisterClass(facadeClassType).stream().filter(kd.bos.util.StringUtils::isNotEmpty).distinct().map(facadeName -> {
            try {
                return TypesContainer.createInstance((String)facadeName);
            }
            catch (Exception e) {
                log.error("\u53cd\u5c04\u521b\u5efa\u7c7b\u5f02\u5e38", (Throwable)e);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static List<IPrintServiceFacade> getAllPrtServiceFacades() {
        return PrtFacadeFactory.getAllPrtFacades(FacadeClassType.PRINT_SERVICE);
    }

    public static List<IPrtDataSourceFacade> getAllPrtDataSourceFacades() {
        return PrtFacadeFactory.getAllPrtFacades(FacadeClassType.DATASOURCE);
    }

    public static List<ITemplateUpgradeFacade> getAllTemplateUpgradeFacades() {
        return PrtFacadeFactory.getAllPrtFacades(FacadeClassType.TEMPLATE_UPGRADE);
    }

    public static List<IPrintTemplateFacade> getAllPrintTemplateFacades() {
        return PrtFacadeFactory.getAllPrtFacades(FacadeClassType.PRINT_TEMPLATE);
    }

    public static List<IPrintControlModelFacade> getControlModelFacades() {
        return PrtFacadeFactory.getAllPrtFacades(FacadeClassType.PRINT_CONTROL);
    }
}

