/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.api.metedata;

import java.lang.reflect.Array;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Consumer;
import kd.bos.print.api.PrintContext;

public class LocaleValue<T>
implements Map<String, T> {
    public static final String DEFAULT_LANG = "zh_CN";
    private static int langCapacity = 3;
    private String[] keys = new String[langCapacity];
    private T[] values = new Object[langCapacity];
    private int size = 0;
    private String defaultLang = "zh_CN";

    public LocaleValue() {
    }

    @Deprecated
    public LocaleValue(String localeId, T value) {
        this();
        this.putVal(localeId, value);
    }

    public LocaleValue(String localeId, T value, String defaultLang) {
        this(localeId, value);
        this.defaultLang = defaultLang;
    }

    public LocaleValue(T value) {
        this();
        this.putVal(this.getDefaultLang(), value);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof LocaleValue) {
            LocaleValue objValue = (LocaleValue)obj;
            for (Map.Entry<String, T> v : this.entrySet()) {
                if (v.getValue() == null && objValue.get(v.getKey()) != null) {
                    return false;
                }
                if (v.getValue().equals(objValue.get(v.getKey()))) continue;
                return false;
            }
            for (Map.Entry<String, T> v : objValue.entrySet()) {
                if (v.getValue() == null && this.get(v.getKey()) != null) {
                    return false;
                }
                if (v.getValue().equals(this.get(v.getKey()))) continue;
                return false;
            }
            return objValue.toString().length() == this.toString().length();
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hashcode = Integer.MIN_VALUE;
        for (Map.Entry<String, T> item : this.entrySet()) {
            hashcode = hashcode ^ item.getKey().hashCode() ^ (item.getValue() == null ? 0 : item.getValue().hashCode());
        }
        return hashcode;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        for (int i = 0; i < this.size; ++i) {
            if (this.keys[i] != null && this.keys[i].equals(key)) {
                return true;
            }
            if (this.keys[i] != null || key != null) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        for (int i = 0; i < this.size; ++i) {
            if (this.values[i] != null && this.values[i].equals(value)) {
                return true;
            }
            if (this.values[i] != null || value != null) continue;
            return true;
        }
        return false;
    }

    @Override
    public T get(Object key) {
        for (int i = 0; i < this.size; ++i) {
            if (this.keys[i] != null && !this.keys[i].equals(key)) continue;
            return this.values[i];
        }
        return null;
    }

    public T getDefaultValue() {
        return this.get(this.getDefaultLang());
    }

    public T getValueIfPresent() {
        T result = this.get(this.getDefaultLang());
        if (result == null) {
            result = this.values[0];
        }
        return result;
    }

    public T getLocaleValue() {
        T value;
        String lang = PrintContext.get().getLang();
        if (lang == null || lang.length() == 0) {
            lang = this.getDefaultLang();
        }
        if ((value = this.get(lang)) == null) {
            value = this.getDefaultValue();
        }
        if (value == null) {
            value = this.values[0];
        }
        return value;
    }

    @Override
    public T put(String key, T value) {
        return this.putVal(key, value);
    }

    public T putDefault() {
        T defaultValue = this.get(this.getDefaultLang());
        if (defaultValue == null && this.size == 1) {
            defaultValue = this.values[0];
            this.put(this.getDefaultLang(), defaultValue);
        }
        return defaultValue;
    }

    public void putTrimSample(String key, T value) {
        if (value == null) {
            return;
        }
        T defaultValue = this.get(this.getDefaultLang());
        if (defaultValue == null) {
            this.putVal(this.getDefaultLang(), value);
        } else if (!defaultValue.equals(value)) {
            this.putVal(key, value);
        } else if (defaultValue.equals(value) && !value.equals(this.get(key))) {
            this.remove(key);
        }
    }

    public void trimSample() {
        T defaultValue = this.get(this.getDefaultLang());
        if (defaultValue == null && this.size == 1) {
            defaultValue = this.values[0];
            this.remove(this.keys[0]);
            this.put(this.getDefaultLang(), defaultValue);
        }
        if (defaultValue == null) {
            return;
        }
        Set<String> keySet = this.keySet();
        for (String key : keySet) {
            if (this.getDefaultLang().equals(key) || !defaultValue.equals(this.get(key))) continue;
            this.remove(key);
        }
    }

    final T putVal(String key, T value) {
        if (value == null) {
            return null;
        }
        int i = 0;
        for (i = 0; i < this.size; ++i) {
            if (!this.keys[i].equals(key)) continue;
            this.values[i] = value;
            return value;
        }
        ++this.size;
        if (this.size > this.keys.length) {
            this.values = Arrays.copyOf(this.values, this.size);
            this.keys = Arrays.copyOf(this.keys, this.size);
        }
        this.keys[i] = key;
        this.values[i] = value;
        return value;
    }

    @Override
    public T remove(Object key) {
        for (int i = 0; i < this.size; ++i) {
            if (this.keys[i] == null || !this.keys[i].equals(key)) continue;
            T value = this.values[i];
            this.values = this.removeByIndex(this.values, i);
            this.keys = this.removeByIndex(this.keys, i);
            --this.size;
            return value;
        }
        return null;
    }

    private <A> A[] removeByIndex(A[] oldArr, int index) {
        ArrayList<A> list = new ArrayList<A>(oldArr.length);
        for (A i : oldArr) {
            list.add(i);
        }
        list.remove(index);
        if (list.size() < langCapacity) {
            list.add(null);
        }
        return list.toArray((Object[])Array.newInstance(oldArr.getClass().getComponentType(), list.size()));
    }

    @Override
    public void putAll(Map<? extends String, ? extends T> m) {
        for (Map.Entry<String, T> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.size; ++i) {
            this.values[i] = null;
            this.keys[i] = null;
        }
        this.size = 0;
    }

    @Override
    public Set<String> keySet() {
        HashSet<String> set = new HashSet<String>(this.size);
        for (int i = 0; i < this.size; ++i) {
            set.add(this.keys[i]);
        }
        return set;
    }

    @Override
    public Collection<T> values() {
        ArrayList<T> cv = new ArrayList<T>(this.size);
        for (int i = 0; i < this.size; ++i) {
            cv.add(this.values[i]);
        }
        return cv;
    }

    @Override
    public Set<Map.Entry<String, T>> entrySet() {
        return new EntrySet();
    }

    final String getDefaultLang() {
        return this.defaultLang;
    }

    public void setDefaultLang(String defaultLang) {
        this.defaultLang = defaultLang;
    }

    final class EntrySet
    extends AbstractSet<Map.Entry<String, T>> {
        EntrySet() {
        }

        @Override
        public final int size() {
            return LocaleValue.this.size;
        }

        @Override
        public final void clear() {
            LocaleValue.this.clear();
        }

        @Override
        public final Iterator<Map.Entry<String, T>> iterator() {
            return new EntryIterator();
        }

        @Override
        public final boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object key = e.getKey();
            return this.contains(key);
        }

        @Override
        public final boolean remove(Object o) {
            if (o instanceof Map.Entry) {
                Map.Entry e = (Map.Entry)o;
                Object key = e.getKey();
                return this.remove(key);
            }
            return false;
        }

        @Override
        public final void forEach(Consumer<? super Map.Entry<String, T>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (LocaleValue.this.size > 0) {
                int mc = LocaleValue.this.size;
                for (int i = 0; i < LocaleValue.this.size; ++i) {
                    action.accept(new EntryNode<Object>(LocaleValue.this.keys[i], LocaleValue.this.values[i]));
                }
                if (LocaleValue.this.size != mc) {
                    throw new ConcurrentModificationException();
                }
            }
        }
    }

    final class EntryIterator
    implements Iterator<Map.Entry<String, T>> {
        private int expectedModCount;
        private int index;

        EntryIterator() {
            this.expectedModCount = LocaleValue.this.size;
            this.index = 0;
        }

        @Override
        public boolean hasNext() {
            return this.index != LocaleValue.this.size;
        }

        @Override
        public Map.Entry<String, T> next() {
            if (LocaleValue.this.size != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            int i = this.index;
            if (i >= LocaleValue.this.size) {
                throw new NoSuchElementException();
            }
            this.index = i + 1;
            return new EntryNode<Object>(LocaleValue.this.keys[this.index - 1], LocaleValue.this.values[this.index - 1]);
        }
    }

    static class EntryNode<T>
    implements Map.Entry<String, T> {
        private final String key;
        private T value;

        public EntryNode(String key, T value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public final String getKey() {
            return this.key;
        }

        @Override
        public final T getValue() {
            return this.value;
        }

        @Override
        public final T setValue(T newValue) {
            T oldValue = this.value;
            this.value = newValue;
            return oldValue;
        }
    }
}

