/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.api.metedata;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlParameter;
import kd.bos.print.api.PrintContext;
import kd.bos.print.api.metedata.DesignerMetadata;
import kd.bos.print.api.metedata.LocaleValue;
import kd.bos.print.api.metedata.PrintMetadata;
import kd.bos.print.api.metedata.control.Control;
import kd.bos.print.api.metedata.control.grid.datagrid.DataGrid;
import kd.bos.print.api.metedata.control.grid.datagrid.SubDataGrid;
import kd.bos.print.api.metedata.control.grid.layoutgrid.LayoutGridRow;
import kd.bos.print.business.metedata.bean.AbstractDesignMetadataL;
import kd.bos.print.business.metedata.bean.DesignMetadata;
import kd.bos.print.business.metedata.bean.DesignMetadataL;
import kd.bos.print.business.metedata.convert.PrintMetadataProxy;

public class MetadataUtil {
    public static PrintMetadata getMetadata(String tplId) {
        DesignMetadata designMetadata = (DesignMetadata)BusinessDataReader.read((Object)tplId, (IDataEntityType)OrmUtils.getDataEntityType(DesignMetadata.class), (Boolean)Boolean.FALSE);
        String metaData = designMetadata.getData();
        if (StringUtils.isBlank((CharSequence)metaData)) {
            return null;
        }
        PrintMetadata printMetadata = MetadataUtil.parseMetadata(metaData);
        String version = designMetadata.getVersion();
        if (version != null && printMetadata.getVersion() != null && version.compareTo(printMetadata.getVersion()) > 0) {
            printMetadata.setVersion(version);
        }
        Object[] metaL = BusinessDataReader.load((Object[])new String[]{tplId}, (IDataEntityType)OrmUtils.getDataEntityType(DesignMetadataL.class));
        HashMap<String, Map<String, Object>> localeDataMap = new HashMap<String, Map<String, Object>>(metaL.length);
        LocaleValue<String> name = printMetadata.getName();
        if (name == null) {
            name = new LocaleValue();
        }
        for (Object localValue : metaL) {
            AbstractDesignMetadataL designMetadataL = (AbstractDesignMetadataL)localValue;
            String data = designMetadataL.getData();
            if (StringUtils.isNotBlank((CharSequence)data)) {
                Map value = (Map)SerializationUtils.fromJsonString((String)data, Map.class);
                localeDataMap.put(designMetadataL.getLocaleId(), value);
            }
            name.put(designMetadataL.getLocaleId(), designMetadataL.getName());
        }
        MetadataUtil.mergeLocaleDataMap(printMetadata, localeDataMap);
        return printMetadata;
    }

    public static PrintMetadata getMetadata(String tplId, String lang) {
        DesignMetadata designMetadata = (DesignMetadata)BusinessDataReader.read((Object)tplId, (IDataEntityType)OrmUtils.getDataEntityType(DesignMetadata.class), (Boolean)Boolean.FALSE);
        String metaData = designMetadata.getData();
        if (StringUtils.isBlank((CharSequence)metaData)) {
            return null;
        }
        PrintMetadata printMetadata = MetadataUtil.parseMetadata(metaData);
        String version = designMetadata.getVersion();
        if (version != null && printMetadata.getVersion() != null && version.compareTo(printMetadata.getVersion()) > 0) {
            printMetadata.setVersion(version);
        }
        Object[] metaL = BusinessDataReader.load((Object[])new String[]{tplId}, (IDataEntityType)OrmUtils.getDataEntityType(DesignMetadataL.class));
        String select = String.format("select flocaleid,fdata,fname from %s where fid=? and flocaleid=?", "t_svc_printmeta_l");
        Object[] parameters = new SqlParameter[]{new SqlParameter("fid", 12, (Object)tplId), new SqlParameter("flocaleid", 12, (Object)lang)};
        HashMap<String, Map<String, Object>> localeDataMap = new HashMap<String, Map<String, Object>>(metaL.length);
        LocaleValue<String> name = printMetadata.getName();
        if (name == null) {
            name = new LocaleValue();
        }
        LocaleValue<String> finalName = name;
        DB.query((DBRoute)DBRoute.basedata, (String)select, (Object[])parameters, rs -> {
            while (rs.next()) {
                String data = rs.getString(2);
                if (StringUtils.isNotBlank((CharSequence)data)) {
                    Map value = (Map)SerializationUtils.fromJsonString((String)data, Map.class);
                    localeDataMap.put(rs.getString(1), value);
                }
                finalName.put(rs.getString(1), rs.getString(3));
            }
            return null;
        });
        MetadataUtil.mergeLocaleDataMap(printMetadata, localeDataMap);
        return printMetadata;
    }

    public static PrintMetadata parseMetadata(String str, String lang) {
        PrintContext.get().setLang(lang);
        Map metadataMap = (Map)JSONObject.parseObject((String)str, Map.class);
        return MetadataUtil.parseMetadata(metadataMap, lang);
    }

    public static PrintMetadata parseMetadata(String str) {
        return MetadataUtil.parseMetadata(str, null);
    }

    public static PrintMetadata parseMetadata(Map metadataMap, String lang) {
        PrintContext.get().setLang(lang);
        PrintMetadataProxy proxy = new PrintMetadataProxy("PrintMetadata");
        PrintMetadata metadata = (PrintMetadata)proxy.convert(metadataMap, lang);
        return metadata;
    }

    public static Map<String, LocaleValue> mergeMetedata(PrintMetadata printMetadata, Map<String, Map<String, Object>> localeValueMap, String lang) {
        PrintContext.get().setLang(lang);
        PrintMetadataProxy proxy = new PrintMetadataProxy("PrintMetadata");
        Map<String, LocaleValue> valueMap = proxy.mergeMetedata(printMetadata, localeValueMap, lang);
        return valueMap;
    }

    public static Tuple<Map<String, String>, Map<String, LocaleValue>> mergeBuildDataMap(PrintMetadata printMetadata, Map<String, Map<String, Object>> localeValueMap, String lang) {
        PrintMetadataProxy proxy = new PrintMetadataProxy("PrintMetadata");
        return proxy.mergeBuildDataMap(printMetadata, localeValueMap, lang);
    }

    public static Map<String, String> buildLocaleDataMap(PrintMetadata printMetadata, Map<String, Map<String, Object>> key2LocaleValueMap, String[] langArr, String defaultLang) {
        PrintMetadataProxy proxy = new PrintMetadataProxy("PrintMetadata");
        return proxy.buildLocalDataMap(printMetadata, key2LocaleValueMap, langArr, defaultLang);
    }

    public static void mergeLocaleDataMap(PrintMetadata metadata, Map<String, Map<String, Object>> localeDataMap) {
        PrintMetadataProxy<PrintMetadata> proxy = new PrintMetadataProxy<PrintMetadata>("PrintMetadata");
        proxy.mergeLocaleDataMap(metadata, localeDataMap);
    }

    public static DesignerMetadata toDesignerMetadata(PrintMetadata printMetadata, String lang) {
        PrintContext.get().setLang(lang);
        MetadataUtil.handMetadata(printMetadata, lang);
        PrintMetadataProxy<PrintMetadata> proxy = new PrintMetadataProxy<PrintMetadata>("PrintMetadata");
        DesignerMetadata meta = proxy.toDesignerMetadata(printMetadata, lang);
        Map paper = (Map)meta.getMetadata().get("paper");
        paper.put("language", lang);
        return meta;
    }

    private static void handMetadata(PrintMetadata metadata, String lang) {
        PrintContext.get().setLang(lang);
        List<List<Control>> pages = metadata.getPages();
        HashMap<String, DataGrid> gridMap = new HashMap<String, DataGrid>();
        HashMap<String, ArrayList<Control>> gridRowMap = new HashMap<String, ArrayList<Control>>();
        for (List<Control> controls : pages) {
            for (Control control : controls) {
                if (control instanceof DataGrid) {
                    gridMap.put(control.getId(), (DataGrid)control);
                    continue;
                }
                if (!(control instanceof LayoutGridRow)) continue;
                ArrayList<Control> gridRowList = (ArrayList<Control>)gridRowMap.get(control.getParentId());
                if (gridRowList == null) {
                    gridRowList = new ArrayList<Control>();
                    gridRowMap.put(control.getParentId(), gridRowList);
                }
                gridRowList.add(control);
            }
        }
        Collection gridList = gridMap.values();
        for (Control grid : gridList) {
            DataGrid dataGrid = (DataGrid)grid;
            boolean fixedRowAtPage = dataGrid.isFixedRowAtPage();
            float fixedRowCount = dataGrid.getFixedRowCount();
            List gridRowList = (List)gridRowMap.get(grid.getId());
            float gridHeight = 0.0f;
            for (Control control : gridRowList) {
                LayoutGridRow gridRow = (LayoutGridRow)control;
                LocaleValue<Number> rowHeight = gridRow.getRowHeight();
                float rowH = rowHeight.getLocaleValue().floatValue();
                if (fixedRowAtPage && "Detail".equals(gridRow.getRowType())) {
                    gridHeight += fixedRowCount * rowH;
                    continue;
                }
                gridHeight += rowH;
            }
            dataGrid.getHeight().put(lang, Float.valueOf(gridHeight));
        }
        for (Control grid : gridList) {
            if (!(grid instanceof SubDataGrid)) continue;
            SubDataGrid subDataGrid = (SubDataGrid)grid;
            DataGrid dataGrid = (DataGrid)gridMap.get(subDataGrid.getParentGridId());
            String direction = subDataGrid.getSubGridDirection();
            if (dataGrid == null || subDataGrid.getY() == null || subDataGrid.getX() == null) continue;
            if ("right".equals(direction)) {
                subDataGrid.getY().putAll((Map<String, Number>)dataGrid.getY());
                subDataGrid.getX().put(lang, Float.valueOf(dataGrid.getX().getLocaleValue().floatValue() + dataGrid.getWidth().getLocaleValue().floatValue()));
                continue;
            }
            subDataGrid.getX().putAll((Map<String, Number>)dataGrid.getX());
            subDataGrid.getY().put(lang, Float.valueOf(dataGrid.getY().getLocaleValue().floatValue() + dataGrid.getHeight().getLocaleValue().floatValue()));
        }
    }
}

