/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.api.metedata.control;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.print.api.metedata.LocaleValue;
import kd.bos.print.api.metedata.control.BaseDsControl;
import kd.bos.print.api.metedata.control.ControlField;
import kd.bos.print.api.metedata.control.prop.AnchorField;
import kd.bos.print.api.metedata.control.prop.Border;
import kd.bos.print.api.metedata.control.prop.Padding;
import kd.bos.print.api.metedata.control.prop.UpperCase;
import kd.bos.print.api.metedata.control.support.IBorderSupport;

public class Text
extends BaseDsControl
implements IBorderSupport {
    @ControlField(replaceField="showText")
    private String viewText;
    @JsonIgnore
    @ControlField(langConvert=true, frontendIgnore=true)
    private LocaleValue<String> showText;
    private String textFormat;
    private String textOverFlow;
    private int lineWrapRule;
    private int precision;
    private String negativeType;
    private boolean showRedNegative;
    private boolean ignoreZero;
    private String currencyCode;
    private boolean ignoreTailZero;
    private boolean thousandSplit;
    private boolean jiaoZheng;
    @ControlField(type=ControlField.Type.SPECIAL, target=UpperCase.class)
    private String uppercaseType;
    private boolean uppercase;
    private boolean showPercentage;
    private boolean showCurrencyCode;
    private boolean showCurrencySymbol = true;
    private String dateFormat;
    private String timeFormat;
    private boolean divideModel;
    private int divideCharNums;
    @Deprecated
    private boolean showDivideLine;
    private LocaleValue<String> fontName;
    private LocaleValue<Float> fontSize;
    private LocaleValue<Number> lineSpace;
    private LocaleValue<Boolean> bold;
    private LocaleValue<Boolean> italic;
    private LocaleValue<Boolean> underLine;
    private LocaleValue<Boolean> strike;
    private LocaleValue<String> horAlignment;
    private LocaleValue<String> verAlignment;
    private LocaleValue<String> foreColor;
    private LocaleValue<String> backColor;
    @ControlField(type=ControlField.Type.OBJECT, target=Padding.class)
    private LocaleValue<Padding> padding;
    @ControlField(type=ControlField.Type.SPECIAL, target=Border.class)
    private LocaleValue<Border> border;
    private String borderType;
    @ControlField(type=ControlField.Type.OBJECT, target=AnchorField.class)
    private AnchorField anchorField;
    private String anchorText;

    @Override
    public LocaleValue<Border> getBorder() {
        return this.border;
    }

    @Override
    public void setBorder(LocaleValue<Border> border) {
        this.border = border;
    }

    @Override
    public String getBorderType() {
        return this.borderType;
    }

    @Override
    public void setBorderType(String borderType) {
        this.borderType = borderType;
    }

    public boolean isShowCurrencySymbol() {
        return this.showCurrencySymbol;
    }

    public void setShowCurrencySymbol(boolean showCurrencySymbol) {
        this.showCurrencySymbol = showCurrencySymbol;
    }

    public String getViewText() {
        String value;
        if (this.showText != null && StringUtils.isNotBlank((CharSequence)(value = this.showText.getLocaleValue()))) {
            return value;
        }
        return this.viewText == null ? "" : this.viewText;
    }

    public void setViewText(String viewText) {
        this.viewText = viewText;
    }

    public LocaleValue<String> getShowText() {
        return this.showText;
    }

    public void setShowText(LocaleValue<String> showText) {
        this.showText = showText;
    }

    public String getTextFormat() {
        return this.textFormat;
    }

    public void setTextFormat(String textFormat) {
        this.textFormat = textFormat;
    }

    public String getTextOverFlow() {
        return this.textOverFlow;
    }

    public void setTextOverFlow(String textOverFlow) {
        this.textOverFlow = textOverFlow;
    }

    public int getLineWrapRule() {
        return this.lineWrapRule;
    }

    public void setLineWrapRule(int lineWrapRule) {
        this.lineWrapRule = lineWrapRule;
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int precision) {
        this.precision = precision;
    }

    public String getNegativeType() {
        return this.negativeType;
    }

    public void setNegativeType(String negativeType) {
        this.negativeType = negativeType;
    }

    public boolean isShowRedNegative() {
        return this.showRedNegative;
    }

    public void setShowRedNegative(boolean showRedNegative) {
        this.showRedNegative = showRedNegative;
    }

    public boolean isIgnoreZero() {
        return this.ignoreZero;
    }

    public void setIgnoreZero(boolean ignoreZero) {
        this.ignoreZero = ignoreZero;
    }

    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public boolean isShowCurrencyCode() {
        return this.showCurrencyCode;
    }

    public void setShowCurrencyCode(boolean showCurrencyCode) {
        this.showCurrencyCode = showCurrencyCode;
    }

    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    public boolean isIgnoreTailZero() {
        return this.ignoreTailZero;
    }

    public void setIgnoreTailZero(boolean ignoreTailZero) {
        this.ignoreTailZero = ignoreTailZero;
    }

    public boolean isThousandSplit() {
        return this.thousandSplit;
    }

    public void setThousandSplit(boolean thousandSplit) {
        this.thousandSplit = thousandSplit;
    }

    public String getUppercaseType() {
        if (StringUtils.isBlank((CharSequence)this.uppercaseType)) {
            return UpperCase.convert(this.uppercase);
        }
        return this.uppercaseType;
    }

    public boolean isUppercase() {
        return this.judgeUppercase();
    }

    public void setUppercase(boolean uppercase) {
        this.uppercase = uppercase;
    }

    public void setUppercaseType(String uppercaseType) {
        this.uppercaseType = uppercaseType;
    }

    public boolean judgeUppercase() {
        return this.uppercase || UpperCase.judgeUpperCase(this.uppercaseType);
    }

    public boolean isShowPercentage() {
        return this.showPercentage;
    }

    public void setShowPercentage(boolean showPercentage) {
        this.showPercentage = showPercentage;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public String getTimeFormat() {
        return this.timeFormat;
    }

    public void setTimeFormat(String timeFormat) {
        this.timeFormat = timeFormat;
    }

    public boolean isDivideModel() {
        return this.divideModel;
    }

    public void setDivideModel(boolean divideModel) {
        this.divideModel = divideModel;
    }

    public int getDivideCharNums() {
        return this.divideCharNums;
    }

    public void setDivideCharNums(int divideCharNums) {
        this.divideCharNums = divideCharNums;
    }

    public boolean isShowDivideLine() {
        return this.showDivideLine;
    }

    public void setShowDivideLine(boolean showDivideLine) {
        this.showDivideLine = showDivideLine;
    }

    public LocaleValue<String> getFontName() {
        return this.fontName;
    }

    public void setFontName(LocaleValue<String> fontName) {
        this.fontName = fontName;
    }

    @Deprecated
    @JsonIgnore
    public LocaleValue<Integer> getFontSize() {
        LocaleValue<Integer> iFontSize = new LocaleValue<Integer>();
        Set<Map.Entry<String, Float>> entrySet = this.fontSize.entrySet();
        for (Map.Entry<String, Float> entry : entrySet) {
            iFontSize.put(entry.getKey(), entry.getValue().intValue());
        }
        return iFontSize;
    }

    @JsonGetter(value="fontSize")
    public LocaleValue<Float> getFontSizeF() {
        return this.fontSize;
    }

    @Deprecated
    public void setFontSize(LocaleValue<Integer> fontSize) {
        LocaleValue<Float> fFontSize = new LocaleValue<Float>();
        Set<Map.Entry<String, Integer>> entrySet = fontSize.entrySet();
        for (Map.Entry<String, Integer> entry : entrySet) {
            Integer value = entry.getValue();
            if (null == value) continue;
            fFontSize.put(entry.getKey(), Float.valueOf(((Object)value).toString()));
        }
        this.fontSize = fFontSize;
    }

    public void setFontSizeF(LocaleValue<Float> fontSize) {
        this.fontSize = fontSize;
    }

    public LocaleValue<Boolean> getBold() {
        return this.bold;
    }

    public void setBold(LocaleValue<Boolean> bold) {
        this.bold = bold;
    }

    public LocaleValue<Boolean> getItalic() {
        return this.italic;
    }

    public void setItalic(LocaleValue<Boolean> italic) {
        this.italic = italic;
    }

    public LocaleValue<Boolean> getUnderLine() {
        return this.underLine;
    }

    public void setUnderLine(LocaleValue<Boolean> underLine) {
        this.underLine = underLine;
    }

    public LocaleValue<Number> getLineSpace() {
        return this.lineSpace;
    }

    public void setLineSpace(LocaleValue<Number> lineSpace) {
        this.lineSpace = lineSpace;
    }

    public LocaleValue<Boolean> getStrike() {
        return this.strike;
    }

    public void setStrike(LocaleValue<Boolean> strike) {
        this.strike = strike;
    }

    public LocaleValue<String> getHorAlignment() {
        return this.horAlignment;
    }

    public void setHorAlignment(LocaleValue<String> horAlignment) {
        this.horAlignment = horAlignment;
    }

    public LocaleValue<String> getVerAlignment() {
        return this.verAlignment;
    }

    public void setVerAlignment(LocaleValue<String> verAlignment) {
        this.verAlignment = verAlignment;
    }

    public LocaleValue<String> getForeColor() {
        return this.foreColor;
    }

    public void setForeColor(LocaleValue<String> foreColor) {
        this.foreColor = foreColor;
    }

    public LocaleValue<String> getBackColor() {
        return this.backColor;
    }

    public void setBackColor(LocaleValue<String> backColor) {
        this.backColor = backColor;
    }

    public LocaleValue<Padding> getPadding() {
        return this.padding;
    }

    public void setPadding(LocaleValue<Padding> padding) {
        this.padding = padding;
    }

    public boolean isWordFlex() {
        return this.horAlignment != null && "justify".equals(this.horAlignment.getLocaleValue());
    }

    public void setWordFlex(boolean wordFlex) {
    }

    public boolean isAnchor() {
        return "Anchor".equals(this.textFormat);
    }

    public AnchorField getAnchorField() {
        return this.anchorField;
    }

    public void setAnchorField(AnchorField anchorField) {
        this.anchorField = anchorField;
    }

    public String getAnchorText() {
        return this.anchorText;
    }

    public void setAnchorText(String anchorText) {
        this.anchorText = anchorText;
    }

    public boolean isJiaoZheng() {
        return this.jiaoZheng;
    }

    public void setJiaoZheng(boolean jiaoZheng) {
        this.jiaoZheng = jiaoZheng;
    }
}

