/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.api.utils;

import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.param.ParameterReader;
import kd.bos.portal.service.InitailVersionService;
import kd.bos.service.ServiceFactory;
import kd.bos.session.SystemPropertyUtils;

public class ConfigConstUtil {
    public static final int PAGE_LIMIT = 5000;
    public static final String HELP_URL = "https://vip.kingdee.com/knowledge/specialDetail/164785655732573952";
    public static final String DEFAULT_FONT = "source han serif cn.ttf";
    public static final String DEFAULT_FONTNAME = "\u601d\u6e90\u5b8b\u4f53 CN";
    public static final String DEFAULT_FONTNUM = "Source Han Serif CN";
    public static final boolean IS_SHOWEX = false;
    public static final int MAX_QUERY_COUNT = 500;
    public static final String DS_CACHE_REGION = "PrtDsRegion";
    public static final String DS_CACHE_GROUP = "PrtDsGroup";
    public static final String CACHE_PRT_REGION = "CachePrtRegion";
    public static final int DS_CACHE_TIMEOUT = 432000;
    public static final String FONT_CACHE_GROUP = "FontCacheGroup";
    public static final int FONT_CACHE_TIMEOUT = 1800;
    public static final int MODEL_CACHE_TIMEOUT = 432000;
    public static final String PRINT_OP_PREFIX = "PT_";
    private static final int REF_QUERY_COUNT = 500;

    public static int getRefQueryCount() {
        String refLimit = SystemPropertyUtils.getProptyByTenant((String)"REF_QUERY_COUNT", (String)RequestContext.get().getTenantId());
        if (StringUtils.isBlank((CharSequence)refLimit)) {
            return 500;
        }
        int refQueryCount = 0;
        try {
            refQueryCount = Integer.parseInt(refLimit);
        }
        catch (Exception ignore) {
            refQueryCount = 500;
        }
        return refQueryCount;
    }

    public static boolean isShowStackTrace() {
        Object isShowStackTrace;
        String showStackTrace = System.getProperty("exception_showstacktrace");
        if (showStackTrace != null && "true".equals(showStackTrace)) {
            return true;
        }
        Map cache = ParameterReader.loadPublicParameterFromCache();
        if (cache != null && cache.size() > 0 && (isShowStackTrace = cache.get("showstacktrace")) != null) {
            return (Boolean)isShowStackTrace;
        }
        return false;
    }

    public static int getPageLimit() {
        String pageLimit = SystemPropertyUtils.getProptyByTenant((String)"PRINT_PAGE_LIMIT", (String)RequestContext.get().getTenantId());
        if (StringUtils.isBlank((CharSequence)pageLimit)) {
            return 5000;
        }
        int onePageLimit = 0;
        try {
            onePageLimit = Integer.parseInt(pageLimit);
        }
        catch (Exception ignore) {
            onePageLimit = 5000;
        }
        return onePageLimit;
    }

    public static boolean isUseSimpleDs() {
        return true;
    }

    public static boolean isOldPrintClose() {
        boolean closed = Boolean.parseBoolean(System.getProperty(RequestContext.get().getTenantId() + "_CLOSE_OLDPRINT_CREATETPL", "true"));
        return closed;
    }

    public static boolean isNewTenantOfVersion(int version) {
        InitailVersionService service = (InitailVersionService)ServiceFactory.getService(InitailVersionService.class);
        return service.isInitailVersion(version);
    }
}

