/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.api.utils.localcache;

import java.util.Iterator;
import java.util.WeakHashMap;
import kd.bos.print.api.utils.localcache.LocalCacheData;

public class LocalCache<V>
extends WeakHashMap<String, LocalCacheData<V>> {
    private long timeOut;
    private int cacheNum;

    public LocalCache(long timeOut) {
        this.timeOut = timeOut * 1000L;
    }

    public LocalCache(long timeOut, int cacheNum) {
        this.timeOut = timeOut * 1000L;
        this.cacheNum = cacheNum;
    }

    @Override
    public void put(String key, V value) {
        if (this.cacheNum > 0 && this.size() > this.cacheNum) {
            long t2 = System.currentTimeMillis();
            String firstkey = null;
            Iterator iterator = this.keySet().iterator();
            while (iterator.hasNext()) {
                String next;
                firstkey = next = (String)iterator.next();
                if (t2 - ((LocalCacheData)super.get(next)).getStartTime() <= this.timeOut) continue;
                iterator.remove();
            }
            if (firstkey != null) {
                this.remove(firstkey);
            }
        }
        LocalCacheData<V> data = new LocalCacheData<V>(value);
        this.put(key, data);
    }

    public V get(String key) {
        long t2 = System.currentTimeMillis();
        LocalCacheData cacheData = (LocalCacheData)super.get(key);
        if (cacheData == null) {
            return null;
        }
        if (t2 - cacheData.getStartTime() > this.timeOut) {
            super.remove(key);
            return null;
        }
        return cacheData.getValue();
    }
}

