/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.business.metedata.convert;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.print.api.metedata.DesignerMetadata;
import kd.bos.print.api.metedata.LocaleValue;
import kd.bos.print.api.metedata.PrintMetadata;
import kd.bos.print.api.metedata.control.Control;
import kd.bos.print.api.metedata.control.Paper;
import kd.bos.print.business.metedata.convert.AbstractMetatataConvert;
import kd.bos.print.business.metedata.convert.PrintMetadataProxy;

public class PrintMetadataConvert
extends AbstractMetatataConvert<PrintMetadata> {
    @Override
    protected PrintMetadata getControl() {
        return new PrintMetadata();
    }

    @Override
    protected PrintMetadata convert(Map<String, Object> sourceObj, String lang) {
        PrintMetadata printMetadata = (PrintMetadata)super.convert(sourceObj, lang);
        Paper paper = printMetadata.getPaper();
        printMetadata.setKey(paper.getKey());
        printMetadata.setName(paper.getName());
        return printMetadata;
    }

    @Override
    protected void convertChilds(PrintMetadata bean, List childs, String curLang) {
        if (childs == null || childs.isEmpty()) {
            bean.setPages(Collections.EMPTY_LIST);
            return;
        }
        List pagesList = childs;
        ArrayList<List<Control>> pages = new ArrayList<List<Control>>(10);
        for (List page : pagesList) {
            ArrayList items = new ArrayList(10);
            for (Map obj : page) {
                String cellType;
                String rowType;
                String convertType = (String)obj.get("type");
                if ("DataRow".equals(convertType) && ("Detail".equals(rowType = (String)obj.get("rowType")) || "Group".equals(rowType))) {
                    convertType = "DataGridRow";
                }
                if ("DataCell".equals(convertType) && "Layout".equals(cellType = (String)obj.get("cellType"))) {
                    convertType = "LayoutCell";
                }
                AbstractMetatataConvert dataConvert = PrintMetadataProxy.getDataConvert(convertType);
                dataConvert.setOriLang(this.oriLang);
                items.add(dataConvert.convert(obj, curLang));
            }
            pages.add(items);
        }
        bean.setPages(pages);
    }

    @Override
    protected void childsToDesign(Map<String, Object> metadata, List childs, Map<String, LocaleValue<?>> localValueMap, String curLang) {
        if (childs == null || childs.isEmpty()) {
            metadata.put("pages", Collections.singletonList(Collections.EMPTY_LIST));
            return;
        }
        List pages = childs;
        ArrayList pageList = new ArrayList(10);
        for (List page : pages) {
            ArrayList<Map<String, Object>> items = new ArrayList<Map<String, Object>>(10);
            for (Control control : page) {
                AbstractMetatataConvert dataConvert = PrintMetadataProxy.getDataConvert(control.getType());
                DesignerMetadata item = dataConvert.toDesignerMetadata(control, curLang);
                items.add(item.getMetadata());
                localValueMap.putAll(item.getLocaleValueMap());
            }
            pageList.add(items);
        }
        metadata.put("pages", pageList);
    }

    @Override
    protected Map<String, LocaleValue> mergeChilds(Control control, List childs, Map<String, Map<String, Object>> localeValueMap, String lang) {
        HashMap<String, LocaleValue> newLocalValueMap = new HashMap<String, LocaleValue>(16);
        if (childs == null || childs.isEmpty()) {
            return newLocalValueMap;
        }
        List pages = childs;
        for (List page : pages) {
            for (Control item : page) {
                AbstractMetatataConvert dataConvert = PrintMetadataProxy.getDataConvert(item.getType());
                dataConvert.setLangLayout(this.langLayout);
                dataConvert.setOriLang(this.oriLang);
                newLocalValueMap.putAll(dataConvert.mergeMetedata(item, localeValueMap, lang));
            }
        }
        return newLocalValueMap;
    }
}

