/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.business.metedata.convert;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.print.api.metedata.DesignerMetadata;
import kd.bos.print.api.metedata.LocaleValue;
import kd.bos.print.api.metedata.PrintMetadata;
import kd.bos.print.api.metedata.control.Barcode;
import kd.bos.print.api.metedata.control.Control;
import kd.bos.print.api.metedata.control.Image;
import kd.bos.print.api.metedata.control.QRCode;
import kd.bos.print.api.metedata.control.grid.cardgrid.CardGrid;
import kd.bos.print.api.metedata.control.grid.datagrid.DataGrid;
import kd.bos.print.api.metedata.control.grid.datagrid.DataGridCell;
import kd.bos.print.api.metedata.control.grid.datagrid.DataGridRow;
import kd.bos.print.api.metedata.control.grid.datagrid.SubDataGrid;
import kd.bos.print.api.metedata.control.grid.layoutgrid.LayoutGrid;
import kd.bos.print.api.metedata.control.grid.layoutgrid.LayoutGridCell;
import kd.bos.print.api.metedata.control.grid.layoutgrid.LayoutGridColumn;
import kd.bos.print.api.metedata.control.grid.layoutgrid.LayoutGridRow;
import kd.bos.print.api.metedata.control.grid.tabletail.TableTail;
import kd.bos.print.business.metedata.LangLayout;
import kd.bos.print.business.metedata.convert.AbstractMetatataConvert;
import kd.bos.print.business.metedata.convert.BaseMetadataConvert;
import kd.bos.print.business.metedata.convert.ConvertThreadFactory;
import kd.bos.print.business.metedata.convert.HeaderFooterConvert;
import kd.bos.print.business.metedata.convert.LineConvert;
import kd.bos.print.business.metedata.convert.PaperConvert;
import kd.bos.print.business.metedata.convert.PrintMetadataConvert;
import kd.bos.print.business.metedata.convert.RichTextConvert;
import kd.bos.print.business.metedata.convert.TextConvert;

public class PrintMetadataProxy<T extends Control> {
    private AbstractMetatataConvert<T> dataConvert;

    public PrintMetadataProxy(String convertType) {
        AbstractMetatataConvert dataConvert;
        this.dataConvert = dataConvert = PrintMetadataProxy.getDataConvert(convertType);
    }

    public T convert(Map<String, Object> sourceObj, String lang) {
        Object oriLang = null;
        if (sourceObj != null && (oriLang = sourceObj.get("oriLang")) != null) {
            this.dataConvert.setOriLang(oriLang.toString());
        }
        return this.dataConvert.convert(sourceObj, lang);
    }

    public Map<String, String> buildLocalDataMap(PrintMetadata printMetadata, Map<String, Map<String, Object>> key2LocaleValueMap, String[] langArr, String defaultLang) {
        HashMap<String, String> result = new HashMap<String, String>(langArr.length);
        for (String lang : langArr) {
            if (!StringUtils.isNotBlank((CharSequence)lang)) continue;
            result.put(lang, SerializationUtils.toJsonString(this.dataConvert.buildLocaleData(printMetadata, key2LocaleValueMap, lang, defaultLang)));
        }
        return result;
    }

    public Tuple<Map<String, String>, Map<String, LocaleValue>> mergeBuildDataMap(PrintMetadata printMetadata, Map<String, Map<String, Object>> localeValueMap, String lang) {
        HashMap resultData = new HashMap(2);
        HashMap<String, Map<String, Object>> localeDataMap = new HashMap<String, Map<String, Object>>(2);
        String oriLang = printMetadata.getOriLang();
        localeDataMap.put(oriLang, new HashMap(16));
        if (!oriLang.equals(lang)) {
            localeDataMap.put(lang, new HashMap(16));
        }
        this.dataConvert.setLangLayout(LangLayout.getInstance(printMetadata.getPaper().getLangLayout()));
        this.dataConvert.setOriLang(printMetadata.getOriLang());
        Map<String, LocaleValue> newCacheMap = this.dataConvert.mergeBuildDataMap(printMetadata, localeValueMap, localeDataMap, lang);
        localeDataMap.forEach((localeId, localeData) -> resultData.put(localeId, SerializationUtils.toJsonString((Object)localeData)));
        return Tuple.create(resultData, newCacheMap);
    }

    public void mergeLocaleDataMap(T metadata, Map<String, Map<String, Object>> localeDataMap) {
        this.dataConvert.mergeLocaleDataMap((Control)metadata, localeDataMap);
    }

    public DesignerMetadata toDesignerMetadata(T bean, String lang) {
        return this.dataConvert.toDesignerMetadata(bean, lang);
    }

    public Map<String, LocaleValue> mergeMetedata(Control control, Map<String, Map<String, Object>> localeValueMap, String lang) {
        if (control instanceof PrintMetadata) {
            PrintMetadata metadata = (PrintMetadata)control;
            this.dataConvert.setLangLayout(LangLayout.getInstance(metadata.getPaper().getLangLayout()));
            this.dataConvert.setOriLang(metadata.getOriLang());
        }
        return this.dataConvert.mergeMetedata(control, localeValueMap, lang);
    }

    public static AbstractMetatataConvert getDataConvert(String convertType) {
        AbstractMetatataConvert convert = PrintMetadataProxy.getConvertMap().get(convertType);
        if (convert != null) {
            return convert;
        }
        if ("PrintMetadata".equals(convertType) || "PrintTplMetadata".equals(convertType)) {
            convert = new PrintMetadataConvert();
        } else if ("Paper".equals(convertType)) {
            convert = new PaperConvert();
        } else if ("Text".equals(convertType)) {
            convert = new TextConvert();
        } else if ("RichText".equals(convertType)) {
            convert = new RichTextConvert();
        } else if ("Image".equals(convertType)) {
            convert = new BaseMetadataConvert<Image>(Image.class);
        } else if ("Barcode".equals(convertType)) {
            convert = new BaseMetadataConvert<Barcode>(Barcode.class);
        } else if ("Header".equals(convertType) || "Footer".equals(convertType)) {
            convert = new HeaderFooterConvert();
        } else if ("QRCode".equals(convertType)) {
            convert = new BaseMetadataConvert<QRCode>(QRCode.class);
        } else if ("LayoutGrid".equals(convertType)) {
            convert = new BaseMetadataConvert<LayoutGrid>(LayoutGrid.class);
        } else if ("DataRow".equals(convertType)) {
            convert = new BaseMetadataConvert<LayoutGridRow>(LayoutGridRow.class);
        } else if ("DataGridRow".equals(convertType)) {
            convert = new BaseMetadataConvert<DataGridRow>(DataGridRow.class);
        } else if ("DataColumn".equals(convertType)) {
            convert = new BaseMetadataConvert<LayoutGridColumn>(LayoutGridColumn.class);
        } else if ("LayoutCell".equals(convertType)) {
            convert = new BaseMetadataConvert<LayoutGridCell>(LayoutGridCell.class);
        } else if ("DataGrid".equals(convertType)) {
            convert = new BaseMetadataConvert<DataGrid>(DataGrid.class);
        } else if ("DataCell".equals(convertType)) {
            convert = new BaseMetadataConvert<DataGridCell>(DataGridCell.class);
        } else if ("SubDataGrid".equals(convertType)) {
            convert = new BaseMetadataConvert<SubDataGrid>(SubDataGrid.class);
        } else if ("CardGrid".equals(convertType)) {
            convert = new BaseMetadataConvert<CardGrid>(CardGrid.class);
        } else if ("TableTail".equals(convertType)) {
            convert = new BaseMetadataConvert<TableTail>(TableTail.class);
        } else if ("Line".equals(convertType)) {
            convert = new LineConvert();
        } else {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u8f6c\u6362\u670d\u52a1\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u5408\u6cd5\u6027:%s", (String)"PrintMetadataProxy_0", (String)"bos-print-api", (Object[])new Object[0]), convertType));
        }
        PrintMetadataProxy.getConvertMap().put(convertType, convert);
        return convert;
    }

    private static Map<String, AbstractMetatataConvert> getConvertMap() {
        return ConvertThreadFactory.get().getConvertMap();
    }
}

