/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.business.utils;

import java.awt.Color;
import java.util.HashMap;
import kd.bos.dataentity.resource.ResManager;

public class PrintColorUtil {
    private static final HashMap<String, Color> _colors = new HashMap();

    public static String colorToHex(Color color) {
        StringBuilder sb = new StringBuilder("#");
        String str = Integer.toHexString(color.getRed());
        if (str.length() < 2) {
            sb.append('0');
        }
        sb.append(str);
        str = Integer.toHexString(color.getGreen());
        if (str.length() < 2) {
            sb.append('0');
        }
        sb.append(str);
        str = Integer.toHexString(color.getBlue());
        if (str.length() < 2) {
            sb.append('0');
        }
        sb.append(str);
        if (color.getAlpha() != 255) {
            str = Integer.toHexString(color.getAlpha());
            if (str.length() < 2) {
                sb.append('0');
            }
            sb.append(str);
        }
        return sb.toString();
    }

    public static Color stringToColor(String str) {
        Color obj;
        Color color = null;
        if (str == null || str.length() == 0) {
            return color;
        }
        color = str.startsWith("rgb(") ? PrintColorUtil.parseRGB(str) : (str.charAt(0) == '#' ? PrintColorUtil.hexToColor(str) : ((obj = _colors.get(str.toLowerCase())) != null ? obj : PrintColorUtil.hexToColor(str)));
        return color;
    }

    private static Color hexToColor(String strColor) {
        Color color = null;
        try {
            String strR = strColor.substring(1, 3);
            String strG = strColor.substring(3, 5);
            String strB = strColor.substring(5, 7);
            if (strColor.length() > 7) {
                String strA = strColor.substring(7, 9);
                color = new Color(Integer.parseInt(strR, 16), Integer.parseInt(strG, 16), Integer.parseInt(strB, 16), Integer.parseInt(strA, 16));
            } else {
                color = new Color(Integer.parseInt(strR, 16), Integer.parseInt(strG, 16), Integer.parseInt(strB, 16));
            }
        }
        catch (Exception err) {
            throw new IllegalArgumentException(ResManager.loadKDString((String)"\u8f93\u5165\u7684\u989c\u8272\u8868\u8fbe\u5f0f\u4e0d\u5408\u6cd5\uff0c\u6b63\u786e\u683c\u5f0f\u5982\uff1a#00ff99", (String)"StyleParser_0", (String)"bos-print-service", (Object[])new Object[0]), err);
        }
        return color;
    }

    private static Color parseRGB(String string) {
        int[] index = new int[]{4};
        int red = PrintColorUtil.getColorComponent(string, index);
        int green = PrintColorUtil.getColorComponent(string, index);
        int blue = PrintColorUtil.getColorComponent(string, index);
        return new Color(red, green, blue);
    }

    private static int getColorComponent(String string, int[] index) {
        char aChar;
        int length = string.length();
        while (index[0] < length && (aChar = string.charAt(index[0])) != '-' && !Character.isDigit(aChar) && aChar != '.') {
            index[0] = index[0] + 1;
        }
        int start = index[0];
        if (start < length && string.charAt(index[0]) == '-') {
            index[0] = index[0] + 1;
        }
        while (index[0] < length && Character.isDigit(string.charAt(index[0]))) {
            index[0] = index[0] + 1;
        }
        if (index[0] < length && string.charAt(index[0]) == '.') {
            index[0] = index[0] + 1;
            while (index[0] < length && Character.isDigit(string.charAt(index[0]))) {
                index[0] = index[0] + 1;
            }
        }
        if (start != index[0]) {
            try {
                float value = Float.parseFloat(string.substring(start, index[0]));
                if (index[0] < length && string.charAt(index[0]) == '%') {
                    index[0] = index[0] + 1;
                    value = value * 255.0f / 100.0f;
                }
                return Math.min(255, Math.max(0, (int)value));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0;
    }

    static {
        _colors.put("black", Color.BLACK);
        _colors.put("silver", new Color(192, 192, 192));
        _colors.put("gray", Color.GRAY);
        _colors.put("white", Color.WHITE);
        _colors.put("maroon", new Color(128, 0, 0));
        _colors.put("red", Color.RED);
        _colors.put("purple", new Color(128, 0, 128));
        _colors.put("fuchsia", new Color(255, 0, 255));
        _colors.put("green", Color.GREEN);
        _colors.put("lime", new Color(0, 255, 0));
        _colors.put("olive", new Color(128, 128, 0));
        _colors.put("yellow", Color.YELLOW);
        _colors.put("navy", new Color(0, 0, 128));
        _colors.put("blue", Color.BLUE);
        _colors.put("teal", new Color(0, 128, 128));
        _colors.put("aqua", new Color(0, 255, 255));
    }
}

