/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.business.utils;

import java.util.Date;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.devportal.api.BizAppService;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.IFormView;
import kd.bos.list.IListView;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.ILogService;
import kd.bos.log.api.OpLogAppInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.print.api.facade.IPrintServiceFacade;
import kd.bos.print.api.facade.PrtFacadeFactory;
import kd.bos.print.api.facade.param.PrintLogParam;
import kd.bos.print.business.utils.PrintOpLogMsgEnum;
import kd.bos.service.ServiceFactory;

public class PrintOpLogUtils {
    private static ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
    private static Log log = LogFactory.getLog(PrintOpLogUtils.class);

    public static void addLog(String appId, String entityId, String clientType, String opKey, String opName, String keyWord) {
        try {
            logService.addLog(PrintOpLogUtils.buildLogInfo(appId, entityId, clientType, opKey, opName, keyWord, null));
        }
        catch (Exception e) {
            log.warn((Throwable)e);
        }
    }

    public static void addLog(String appId, String entityId, String clientType, String opKey, String keyWord) {
        PrintOpLogUtils.addLog(appId, entityId, clientType, opKey, "", keyWord);
    }

    public static void addLog(String appId, String entityId, String clientType, String keyWord, PrintOpLogMsgEnum printOpLogMsgEnum) {
        try {
            logService.addLog(PrintOpLogUtils.buildLogInfo(appId, entityId, clientType, printOpLogMsgEnum.getOpKey(), printOpLogMsgEnum.getOpName(), keyWord, printOpLogMsgEnum.getDescriptionM()));
        }
        catch (Exception e) {
            log.warn((Throwable)e);
        }
    }

    public static void addLog(String appId, String entityId, String keyWord, PrintOpLogMsgEnum printOpLogMsgEnum) {
        try {
            logService.addLog(PrintOpLogUtils.buildLogInfo(appId, entityId, printOpLogMsgEnum.getOpKey(), printOpLogMsgEnum.getOpNameM().getDescription(), keyWord, printOpLogMsgEnum.getDescriptionM()));
        }
        catch (Exception e) {
            log.warn((Throwable)e);
        }
    }

    public static void addLog(IFormView view, String keyWord, PrintOpLogMsgEnum printOpLogMsgEnum) {
        try {
            String appId = view.getFormShowParameter().getAppId();
            String entityId = view.getEntityId();
            if (view instanceof IListView) {
                entityId = ((IListView)view).getBillFormId();
            }
            logService.addLog(PrintOpLogUtils.buildLogInfo(appId, entityId, printOpLogMsgEnum.getOpKey(), printOpLogMsgEnum.getOpNameM().getDescription(), keyWord, printOpLogMsgEnum.getDescriptionM()));
        }
        catch (Exception e) {
            log.warn((Throwable)e);
        }
    }

    public static void addLog(IFormView view, ListSelectedRowCollection listSelectedRows, PrintOpLogMsgEnum printOpLogMsgEnum) {
        for (ListSelectedRow listSelectedRow : listSelectedRows) {
            PrintOpLogUtils.addLog(view, listSelectedRow.getNumber(), printOpLogMsgEnum);
        }
    }

    public static void addOpLog(PrintLogParam logParam, AppLogInfo appLogInfo) {
        try {
            if (logParam == null && appLogInfo == null) {
                return;
            }
            if (PrintOpLogUtils.cancelOpLog()) {
                if (logParam == null) {
                    return;
                }
                for (IPrintServiceFacade facade : PrtFacadeFactory.getAllPrtServiceFacades()) {
                    facade.beforeDoOperationLog(logParam);
                }
                return;
            }
            if (appLogInfo != null) {
                logService.addLog(appLogInfo);
            }
        }
        catch (Exception e) {
            log.warn((Throwable)e);
        }
    }

    public static boolean cancelOpLog() {
        for (IPrintServiceFacade facade : PrtFacadeFactory.getAllPrtServiceFacades()) {
            if (!facade.cancelOpLog()) continue;
            return true;
        }
        return false;
    }

    public static AppLogInfo buildLogInfo(IFormView view, String opKey, String opName, String keyword) {
        String appId = view.getFormShowParameter().getAppId();
        String entityId = view.getEntityId();
        if (view instanceof IListView) {
            entityId = ((IListView)view).getBillFormId();
        }
        return PrintOpLogUtils.buildLogInfo(appId, entityId, opKey, opName, keyword, null);
    }

    public static AppLogInfo buildLogInfo(IFormView view, String opName, String keyword) {
        return PrintOpLogUtils.buildLogInfo(view, opName, opName, keyword);
    }

    private static AppLogInfo buildLogInfo(String appId, String entityId, String opKey, String opName, String keyWord, MultiLangEnumBridge description) {
        return PrintOpLogUtils.buildLogInfo(appId, entityId, RequestContext.get().getClient(), opKey, opName, keyWord, description);
    }

    private static String getAppId(String appNumber, String entityId) {
        AppInfo appInfo;
        if (StringUtils.isNotEmpty((CharSequence)appNumber) && null != (appInfo = AppMetadataCache.getAppInfo((String)appNumber))) {
            return appInfo.getId();
        }
        if (StringUtils.isBlank((CharSequence)appNumber)) {
            BizAppService bizAppService = (BizAppService)ServiceFactory.getService(BizAppService.class);
            if (StringUtils.isNotBlank((CharSequence)entityId)) {
                return bizAppService.getAppIdByFormNum(entityId);
            }
        }
        return "";
    }

    private static AppLogInfo buildLogInfo(String appId, String entityId, String clientType, String opKey, String opName, String keyWord, MultiLangEnumBridge description) {
        OpLogAppInfo logInfo = new OpLogAppInfo();
        logInfo.setUserID(Long.valueOf(RequestContext.get().getUserId()));
        String bizAppid = PrintOpLogUtils.getAppId(appId, entityId);
        logInfo.setBizAppID(bizAppid);
        logInfo.setBizObjID(entityId);
        logInfo.setOrgID(Long.valueOf(RequestContext.get().getOrgId()));
        logInfo.setOpTime(new Date());
        logInfo.setClientType(clientType);
        logInfo.setClientIP(RequestContext.get().getLoginIP());
        logInfo.setKeyWord(keyWord);
        logInfo.setOpName(opKey, opName);
        if (description != null) {
            logInfo.setOpDesc(description, new String[0]);
        }
        logInfo.setKeyWord(keyWord);
        return logInfo;
    }
}

