/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.print;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.form.PrintMetadata;
import kd.bos.mservice.print.IPrintService;
import kd.bos.orm.query.QFilter;
import kd.bos.print.PrintJob;
import kd.bos.print.api.utils.ConfigConstUtil;
import kd.bos.print.business.utils.OldPrintTemplateUtil;
import kd.bos.print.service.util.PrintClientUtil;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.print.NotePrintService;
import kd.bos.servicehelper.print.PrintSettingService;
import kd.bos.svc.acl.AclAdapter;
import kd.bos.svc.util.print.PrintFileUtil;
import kd.sdk.annotation.SdkPublic;
import org.apache.commons.io.IOUtils;

@SdkPublic
public class PrintServiceImp
implements IPrintService {
    private static final String ACCOUNTID = "accountid";
    private static final String SERVICE_ID = "serviceId";
    private static final String PRINT_STATUS = "printstatus";
    private static final String MODIFYTIME = "modifytime";
    private static final String MODIFYDATE = "modifydate";
    private static final String ENABLE = "enable";
    private static final String CREATETIME = "createtime";
    private static final String STATUS = "status";
    private static final String NUMBER = "number";
    private static final String PRINTER_ADDRESS = "printeraddress";
    private static final String NAME = "name";
    private static final String CTRL_STRATEGY = "ctrlstrategy";
    private static final String CREATETIME_STAMP = "createtimestamp";
    private static Log log = LogFactory.getLog(PrintServiceImp.class);
    private static final DistributeSessionlessCache distributeCache = AclAdapter.getCacheService().getDistributeSessionlessCache("CachePrtRegion");

    public List<Map<String, Object>> getPrintJobs(String acctId, String serviceId) {
        PrintClientUtil.doHeartBeatOld((String)acctId, (String)serviceId);
        ArrayList<Map<String, Object>> lstData = new ArrayList<Map<String, Object>>();
        String key = "PrintServiceId:" + serviceId;
        String updateFlag = (String)distributeCache.get(key);
        if (StringUtils.isBlank((CharSequence)updateFlag)) {
            return lstData;
        }
        if (StringUtils.isNotBlank((CharSequence)acctId) && StringUtils.isNotBlank((CharSequence)serviceId)) {
            log.info("\u5f00\u59cb\u67e5\u627e\u5f85\u6253\u5370\u4efb\u52a1, Account Id:" + acctId + ", serviceId" + serviceId);
            QFilter filter1 = new QFilter(ACCOUNTID, "=", (Object)acctId);
            QFilter filter2 = new QFilter(SERVICE_ID, "=", (Object)Long.parseLong(serviceId));
            QFilter filter3 = new QFilter(PRINT_STATUS, "=", (Object)Character.valueOf('1'));
            QFilter[] filters = new QFilter[]{filter1, filter2, filter3};
            MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"bos_printtask");
            String orderby = "";
            IDataEntityProperty createTimeStampProp = (IDataEntityProperty)dt.getProperties().get((Object)CREATETIME_STAMP);
            if (createTimeStampProp != null) {
                orderby = createTimeStampProp.getName() + " asc";
            } else {
                IDataEntityProperty modifyTimeProp = (IDataEntityProperty)dt.getProperties().get((Object)MODIFYTIME);
                if (modifyTimeProp != null) {
                    orderby = modifyTimeProp.getName() + " asc";
                }
            }
            String selectFields = "*";
            DynamicObjectCollection objsMap = QueryServiceHelper.query((String)"bos_printtask", (String)selectFields, (QFilter[])filters, (String)orderby);
            if (objsMap != null && objsMap.size() > 0) {
                IDataEntityProperty configkeyProp = (IDataEntityProperty)dt.getProperties().get((Object)"configkey");
                IDataEntityProperty cacheidProp = (IDataEntityProperty)dt.getProperties().get((Object)"cacheid");
                IDataEntityProperty filepathProp = (IDataEntityProperty)dt.getProperties().get((Object)"filepath");
                IDataEntityProperty printeraddressProp = (IDataEntityProperty)dt.getProperties().get((Object)PRINTER_ADDRESS);
                IDataEntityProperty typeProp = (IDataEntityProperty)dt.getProperties().get((Object)"printtype");
                for (DynamicObject jobObj : objsMap) {
                    String filePath;
                    String content;
                    Object id = jobObj.get("id");
                    String configKey = "";
                    if (configkeyProp != null) {
                        configKey = configkeyProp.getValue((Object)jobObj).toString();
                    }
                    String cacheId = (String)cacheidProp.getValue((Object)jobObj);
                    String type = "zpl";
                    if (typeProp != null) {
                        type = (String)typeProp.getValue((Object)jobObj);
                    }
                    if (StringUtils.isBlank((CharSequence)(content = this.getContent(configKey, cacheId, filePath = (String)filepathProp.getValue((Object)jobObj))))) {
                        jobObj.set(PRINT_STATUS, (Object)4);
                        try {
                            this.updateStatus(id.toString(), "4");
                        }
                        catch (Exception e) {
                            log.error("\u66f4\u65b0\u6253\u5370\u4efb\u52a1\u72b6\u6001\u65f6\u51fa\u73b0\u5f02\u5e38" + e.getMessage());
                        }
                        continue;
                    }
                    jobObj.set(PRINT_STATUS, (Object)2);
                    HashMap<String, Object> items = new HashMap<String, Object>();
                    items.put("id", id);
                    items.put("type", type);
                    items.put("printer", printeraddressProp.getValue((Object)jobObj));
                    items.put("content", content);
                    if (dt.getProperty(MODIFYTIME) != null) {
                        items.put(MODIFYTIME, jobObj.get(MODIFYTIME));
                    }
                    if (dt.getProperty(MODIFYDATE) != null) {
                        items.put(MODIFYDATE, jobObj.get(MODIFYDATE));
                    }
                    try {
                        boolean isUpdate = this.updateStatus(id.toString(), "2");
                        if (!isUpdate) continue;
                        lstData.add(items);
                    }
                    catch (Exception e) {
                        log.error("\u66f4\u65b0\u6253\u5370\u4efb\u52a1\u72b6\u6001\u65f6\u51fa\u73b0\u5f02\u5e38" + e.getMessage());
                    }
                }
            }
            log.info("\u5b8c\u6210\u67e5\u627e\u5f85\u6253\u5370\u4efb\u52a1, \u5f85\u6253\u5370\u4efb\u52a1\u6570\u91cf\u4e3a\uff1a" + lstData.size());
        }
        distributeCache.remove(key);
        return lstData;
    }

    @Deprecated
    public boolean syncConfig(String acctId, String serviceId, Map<String, String> printers) {
        boolean isSuccessful = true;
        if (ConfigConstUtil.isNewTenantOfVersion((int)7)) {
            log.info("\u65e7\u6253\u5370\u5ba2\u6237\u7aef\u5df2\u4e0b\u7ebf\uff0c\u8bf7\u4f7f\u7528\u65b0\u5ba2\u6237\u7aef\u8fdb\u884c\u540c\u6b65\u3002");
            return false;
        }
        try (TXHandle h = TX.beginRequired();){
            try {
                log.info("\u5f00\u59cb\u540c\u6b65\u6253\u5370\u673a\u4fe1\u606f\u3002");
                log.info("\u6253\u5370\u673a\u6570\u91cf\u4e3a\uff1a" + printers.size());
                Object[] params = new SqlParameter[]{new SqlParameter(":fserviceid", 12, (Object)serviceId)};
                String langSql = "delete from t_bas_netprinter_l where fid in (select fid from t_bas_netprinter where fserviceid = ?)";
                DB.execute((DBRoute)DBRoute.basedata, (String)langSql, (Object[])params);
                String sql = "delete from t_bas_netprinter where fserviceid = ?";
                DB.execute((DBRoute)DBRoute.basedata, (String)sql, (Object[])params);
                for (Map.Entry<String, String> entry : printers.entrySet()) {
                    MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"bos_cloudprinter");
                    DynamicObject dynaObj = new DynamicObject((DynamicObjectType)dt);
                    dynaObj.set(NUMBER, (Object)UUID.randomUUID());
                    dynaObj.set(NAME, (Object)entry.getValue());
                    dynaObj.set(STATUS, (Object)"C");
                    dynaObj.set(ENABLE, (Object)"1");
                    dynaObj.set("createorg", (Object)RequestContext.get().getOrgId());
                    dynaObj.set("serviceid", (Object)serviceId);
                    dynaObj.set("servicename", (Object)serviceId);
                    dynaObj.set(MODIFYTIME, (Object)new Date());
                    dynaObj.set(CREATETIME, (Object)new Date());
                    dynaObj.set(PRINTER_ADDRESS, (Object)entry.getKey());
                    SaveServiceHelper.save((IDataEntityType)dt, (Object[])new DynamicObject[]{dynaObj});
                }
                log.info("\u7ed3\u675f\u540c\u6b65\u6253\u5370\u673a\u4fe1\u606f\u3002");
            }
            catch (Exception e) {
                h.markRollback();
                isSuccessful = false;
            }
        }
        return isSuccessful;
    }

    public String registerService(String accountId, String serviceId, String serviceName) {
        boolean isExistService;
        DynamicObject dynaObj = null;
        if (StringUtils.isNotBlank((CharSequence)serviceId) && (isExistService = QueryServiceHelper.exists((String)"bos_cloudprintservice", (Object)serviceId)) && (dynaObj = BusinessDataServiceHelper.loadSingle((Object)serviceId, (String)"bos_cloudprintservice")) != null) {
            dynaObj.set(NAME, (Object)new LocaleString(serviceName));
            dynaObj.set(MODIFYTIME, (Object)new Date());
            dynaObj.set(ACCOUNTID, (Object)accountId);
        }
        if (dynaObj == null || ObjectUtils.isEmpty((Object)dynaObj.getPkValue())) {
            dynaObj = BusinessDataServiceHelper.newDynamicObject((String)"bos_cloudprintservice");
            if (StringUtils.isNotBlank((CharSequence)serviceId)) {
                dynaObj.set("id", (Object)serviceId);
            }
            String number = UUID.randomUUID().toString();
            dynaObj.set(NUMBER, (Object)number);
            dynaObj.set(NAME, (Object)new LocaleString(serviceName));
            dynaObj.set(STATUS, (Object)"C");
            dynaObj.set(CREATETIME, (Object)new Date());
            dynaObj.set(MODIFYTIME, (Object)new Date());
            dynaObj.set(ENABLE, (Object)"1");
            dynaObj.set(ACCOUNTID, (Object)accountId);
            dynaObj.set("longnumber", (Object)number);
            dynaObj.set("creator", (Object)RequestContext.get().getCurrUserId());
            dynaObj.set("servicetype", (Object)"A");
        }
        log.info("registerService, accountId = " + accountId + ", serviceId = " + serviceId);
        Object[] obj = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynaObj});
        String id = "";
        if (obj != null && obj.length > 0) {
            id = ((DynamicObject)obj[0]).getPkValue().toString();
        }
        return id;
    }

    public boolean syncPrinter(String serviceId, Map<String, String> printers) {
        if (ConfigConstUtil.isNewTenantOfVersion((int)7)) {
            log.info("\u65e7\u6253\u5370\u5ba2\u6237\u7aef\u5df2\u4e0b\u7ebf\uff0c\u8bf7\u4f7f\u7528\u65b0\u5ba2\u6237\u7aef\u8fdb\u884c\u540c\u6b65\u3002");
            return false;
        }
        boolean isSuccessful = true;
        ArrayList<Object> delIds = new ArrayList<Object>();
        ArrayList<String> existAddress = new ArrayList<String>();
        ArrayList<DynamicObject> printerList = new ArrayList<DynamicObject>(10);
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"bos_cloudprintmanage");
        QFilter filter = new QFilter("group", "=", (Object)Long.parseLong(serviceId));
        Map cachePrinters = BusinessDataServiceHelper.loadFromCache((String)"bos_cloudprintmanage", (QFilter[])new QFilter[]{filter});
        DynamicObject curUser = BusinessDataServiceHelper.loadSingleFromCache((Object)RequestContext.get().getCurrUserId(), (String)"bos_user");
        DynamicObject curOrg = BusinessDataServiceHelper.loadSingleFromCache((Object)RequestContext.get().getOrgId(), (String)"bos_org");
        DynamicObject[] currentObjs = null;
        if (cachePrinters != null && !cachePrinters.isEmpty()) {
            for (DynamicObject o : currentObjs = BusinessDataServiceHelper.load((Object[])cachePrinters.keySet().toArray(), (DynamicObjectType)dt)) {
                String pAddress = (String)o.get(PRINTER_ADDRESS);
                if (printers.containsKey(pAddress)) {
                    o.set(NAME, (Object)new LocaleString(printers.get(pAddress)));
                    o.set(MODIFYTIME, (Object)new Date());
                    Object createOrg = o.get("createorg");
                    if (createOrg == null) {
                        o.set("createorg", (Object)curOrg);
                    }
                    existAddress.add(pAddress);
                    printerList.add(o);
                    continue;
                }
                delIds.add(o.getPkValue());
            }
        }
        for (Map.Entry<String, String> mp : printers.entrySet()) {
            String printerAddress = mp.getKey();
            if (existAddress.contains(printerAddress)) continue;
            DynamicObject dynaObj = new DynamicObject((DynamicObjectType)dt);
            dynaObj.set(NUMBER, (Object)UUID.randomUUID());
            dynaObj.set(NAME, (Object)new LocaleString(mp.getValue()));
            dynaObj.set(STATUS, (Object)"C");
            dynaObj.set(ENABLE, (Object)"1");
            dynaObj.set("group", (Object)serviceId);
            dynaObj.set(MODIFYTIME, (Object)new Date());
            dynaObj.set(CREATETIME, (Object)new Date());
            dynaObj.set("creator", (Object)curUser);
            dynaObj.set("createorg", (Object)curOrg);
            dynaObj.set(PRINTER_ADDRESS, (Object)printerAddress);
            dynaObj.set(CTRL_STRATEGY, (Object)5);
            printerList.add(dynaObj);
        }
        try (TXHandle h = TX.requiresNew((String)"syncprinter");){
            try {
                OperationResult operationResult;
                if (!delIds.isEmpty()) {
                    DeleteServiceHelper.delete((IDataEntityType)dt, (Object[])delIds.toArray());
                }
                if (!(operationResult = OperationServiceHelper.executeOperate((String)"save", (String)"bos_cloudprintmanage", (DynamicObject[])printerList.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create())).isSuccess()) {
                    h.markRollback();
                    log.warn("\u540c\u6b65\u6253\u5370\u673a\u5931\u8d25\uff1a" + SerializationUtils.toJsonString((Object)operationResult));
                    isSuccessful = false;
                }
            }
            catch (Exception e) {
                h.markRollback();
                isSuccessful = false;
                log.error("\u540c\u6b65\u6253\u5370\u673a\u5931\u8d25\uff1a", (Throwable)e);
            }
        }
        return isSuccessful;
    }

    public boolean updateStatus(String jobId, String status) {
        boolean result = false;
        if (StringUtils.isNotBlank((CharSequence)jobId) && StringUtils.isNotBlank((CharSequence)status)) {
            String sql = "UPDATE t_bas_printtask SET fprintstatus = ? , FModifyDate = ? WHERE fid=? ";
            ArrayList<SqlParameter> params = new ArrayList<SqlParameter>();
            params.add(new SqlParameter(":fprintstatus", 12, (Object)status));
            params.add(new SqlParameter(":FModifyDate", 91, (Object)new Date()));
            params.add(new SqlParameter(":fid", -5, (Object)Long.parseLong(jobId)));
            int ret = DB.update((DBRoute)DBRoute.basedata, (String)sql, (Object[])params.toArray(new SqlParameter[params.size()]));
            if (ret > 0) {
                result = true;
                String filePath = this.getFilePath(jobId);
                if (StringUtils.isNotBlank((CharSequence)filePath)) {
                    FileService fileService = FileServiceFactory.getAttachmentFileService();
                    fileService.delete(filePath);
                }
            }
        }
        return result;
    }

    public boolean UpdatePrintCount(String id, String formId, String billTypeId) {
        boolean result = false;
        MainEntityType printLog = EntityMetadataCache.getDataEntityType((String)"bos_print_logs");
        try {
            DynamicObject logObj = (DynamicObject)printLog.createInstance();
            logObj.set("formId", (Object)formId);
            logObj.set("billtype", (Object)billTypeId);
            logObj.set(CREATETIME, (Object)new Date());
            logObj.set("creater", (Object)Long.parseLong(RequestContext.get().getUserId()));
            logObj.set("bizobjid", (Object)id);
            logObj.set("operationtype", (Object)this.getClass().getSimpleName());
            DynamicObject[] objArray = new DynamicObject[]{logObj};
            SaveServiceHelper.save((DynamicObject[])objArray);
            result = true;
        }
        catch (Exception e) {
            log.error("\u8bb0\u5f55\u6253\u5370\u65e5\u5fd7\u65f6\u53d1\u751f\u9519\u8bef" + e.getCause());
        }
        return result;
    }

    private String getFilePath(String id) {
        String fpath = "";
        Object[] params = new SqlParameter[]{new SqlParameter(":fid", -5, (Object)Long.parseLong(id))};
        String sql = "select ffilepath from t_bas_printtask where fid=?";
        try {
            fpath = (String)DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])params, (ResultSetHandler)new ResultSetHandler<String>(){

                public String handle(ResultSet rs) throws Exception {
                    String sFdata = null;
                    try {
                        if (rs.next()) {
                            sFdata = rs.getString(1);
                        }
                    }
                    catch (SQLException e) {
                        throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format("Error:%s", e.getMessage())});
                    }
                    return sFdata;
                }
            });
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[0]);
        }
        return fpath;
    }

    private String getContent(String configKey, String cacheId, String filePath) {
        String ret = "";
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
             InputStream fileInputStream = PrintFileUtil.getFileInputStream((String)filePath);){
            if (fileInputStream != null) {
                IOUtils.copy((InputStream)fileInputStream, (OutputStream)baos);
                ret = Base64.getEncoder().encodeToString(baos.toByteArray());
            }
        }
        catch (IOException e) {
            log.info("\u4ece\u6587\u4ef6\u670d\u52a1\u5668\u5185\u83b7\u53d6\u6253\u5370\u5185\u5bb9\u65f6\uff0c\u53d1\u751f\u5f02\u5e38\u3002" + e.getMessage());
        }
        if (StringUtils.isEmpty((CharSequence)ret)) {
            log.info("\u6ca1\u6709\u4ece\u6587\u4ef6\u670d\u52a1\u5668\u5185\u83b7\u53d6\u5230\u6253\u5370\u5185\u5bb9\u3002");
        }
        return ret;
    }

    public String doPrint(String taskId, String printType, List<Object> mjobs, Map<String, Object> extParam) {
        List jobs = mjobs.stream().map(p -> p == null ? null : (PrintJob)p).collect(Collectors.toList());
        NotePrintService printSvr = new NotePrintService();
        return printSvr.doPrint(taskId, printType, jobs, extParam);
    }

    public String createPdfUrl(List<Object> mjobs) {
        List jobs = mjobs.stream().map(p -> p == null ? null : (PrintJob)p).collect(Collectors.toList());
        NotePrintService printSvr = new NotePrintService();
        PrintJob firstJob = (PrintJob)jobs.get(0);
        PrintMetadata printMetadata = OldPrintTemplateUtil.findOldPrintMetadata((String)firstJob.getTemplateId().toString());
        return printSvr.createPdfUrl(printMetadata.getName(), jobs);
    }

    public String createXlsUrl(List<Object> mjobs, Map<String, Object> para) {
        List jobs = mjobs.stream().map(p -> p == null ? null : (PrintJob)p).collect(Collectors.toList());
        NotePrintService printSvr = new NotePrintService();
        return printSvr.createXlsUrl(jobs, para);
    }

    public byte[] createCrossPdf(List<Object> mjobs) {
        List jobs = mjobs.stream().map(p -> p == null ? null : (PrintJob)p).collect(Collectors.toList());
        NotePrintService printSvr = new NotePrintService();
        return printSvr.createCrossPdf(jobs);
    }

    public boolean createPrintJob(List<Object> mjobs) {
        List jobs = mjobs.stream().map(p -> p == null ? null : (PrintJob)p).collect(Collectors.toList());
        NotePrintService printSvr = new NotePrintService();
        PrintJob firstJob = (PrintJob)jobs.get(0);
        PrintMetadata printMetadata = OldPrintTemplateUtil.findOldPrintMetadata((String)firstJob.getTemplateId().toString());
        return printSvr.createPrintJob(printMetadata.getName(), jobs);
    }

    public byte[] createSinglePdf(String pageId, String formId, String templateFromId, Object pkId) {
        String tplId = MetadataDao.getIdByNumber((String)templateFromId, (MetaCategory)MetaCategory.Form);
        NotePrintService printSvr = new NotePrintService();
        return printSvr.createSinglePdf(pageId, formId, tplId, pkId);
    }

    public byte[] createPdfBytes(String pageId, String formId, String templateFromId, Object billPkId, Map<String, List<String>> entryFilterExp) {
        String tplId = MetadataDao.getIdByNumber((String)templateFromId, (MetaCategory)MetaCategory.Form);
        NotePrintService printSvr = new NotePrintService();
        return printSvr.createPdfBytes(pageId, formId, tplId, billPkId, entryFilterExp);
    }

    public String createPdfUrl(String pageId, String formId, String templateFromId, Object billPkId, Map<String, List<String>> entryFilterExp) {
        String tplId = MetadataDao.getIdByNumber((String)templateFromId, (MetaCategory)MetaCategory.Form);
        NotePrintService printSvr = new NotePrintService();
        return printSvr.createPdfUrl(pageId, formId, tplId, billPkId, entryFilterExp);
    }

    public boolean createScriptPrintJob(String formId, Object billPkId, String templatePkId, String printerPkId, String separator, Boolean isShowLastSep) {
        return false;
    }

    public boolean createScriptPrintJob(String formId, Object billPkId, String templatePkId, String printerPkId, String separator, Boolean isShowLastSep, Boolean isSplitEntry) {
        return false;
    }

    public boolean createEasyScriptPrintJob(String formId, Object templatePkId, Object printerPkId, Map<String, String> values) {
        return false;
    }

    public String createPrintCommand(String formId, Object schemeId, Object pkId) {
        return "";
    }

    public Map<Object, List<Object>> readPrintSetting(String formId, String userId, List<Object> pks) {
        PrintSettingService pss = new PrintSettingService(formId, userId);
        return pss.getTemplateIdByPK(pks);
    }
}

