/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.business.control;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.print.business.control.DesignModelFunction;
import kd.bos.print.business.control.PrintModelLangUtil;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.xml.sax.SAXException;

public abstract class BaseModelReader {
    private SAXReader saxReader;
    private static Map<String, List<Map>> propertiesCache = new HashMap<String, List<Map>>();

    private SAXReader getSaxReader() {
        if (this.saxReader == null) {
            this.saxReader = new SAXReader();
            try {
                this.saxReader.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
                this.saxReader.setFeature("http://xml.org/sax/features/external-general-entities", false);
                this.saxReader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            }
            catch (SAXException sAXException) {
                // empty catch block
            }
        }
        return this.saxReader;
    }

    protected Object read(Element element) throws Exception {
        return null;
    }

    protected Object read(Element elementm, String ext) throws Exception {
        return null;
    }

    protected final void extModelParser(String extFileName, Element rootElement) throws IOException, DocumentException {
        if (rootElement.attribute("Ext") != null) {
            try (InputStream extIn = this.getClass().getResourceAsStream(extFileName);){
                this.extActionExe(rootElement, this.getDocument(extIn).getRootElement());
            }
        }
    }

    private void extActionExe(Element root, Element extEle) {
        if (extEle == null) {
            return;
        }
        if ("Action".equals(extEle.getName())) {
            String id;
            String cmd = extEle.attribute("Cmd").getValue();
            LinkedList<Element> groupDeque = new LinkedList<Element>();
            for (Element cur = extEle.getParent(); cur != null; cur = cur.getParent()) {
                groupDeque.push(cur);
            }
            while (!groupDeque.isEmpty()) {
                Element pop = (Element)groupDeque.pop();
                List elements = root.elements(pop.getName());
                if (elements.size() > 1) {
                    id = pop.attribute("Id").getValue();
                    Optional<Element> idOp = elements.stream().filter(f -> id.equals(f.attribute("Id").getValue())).findFirst();
                    if (!idOp.isPresent()) continue;
                    root = idOp.get();
                    continue;
                }
                if (elements.size() != 1) continue;
                root = (Element)elements.get(0);
            }
            if ("Add".equals(cmd)) {
                for (Element extChildEle : extEle.elements()) {
                    root.add(extChildEle.detach());
                }
            } else {
                for (Element ele : root.elements()) {
                    id = ele.attribute("Id").getValue();
                    if (!id.equals(extEle.attribute("Id").getValue())) continue;
                    if ("Modify".equals(cmd)) {
                        String[] targetLabels;
                        String target = extEle.attribute("Target").getValue();
                        for (String targetLabel : targetLabels = target.split(":")) {
                            Element modifyEle = extEle.element(targetLabel);
                            ele.remove(ele.element(targetLabel));
                            ele.add(modifyEle.detach());
                        }
                        break;
                    }
                    if (!"Delete".equals(cmd)) break;
                    root.remove(ele);
                    break;
                }
            }
        } else {
            for (Element extChildEle : extEle.elements()) {
                this.extActionExe(root, extChildEle);
            }
        }
    }

    protected Document getDocument(InputStream in) throws DocumentException {
        SAXReader reader = this.getSaxReader();
        Document doc = reader.read(in);
        return doc;
    }

    protected Map elementToObject(Element element, String modelType) {
        Map obj = this.elementAttributeToObj(element, modelType);
        obj.putAll(this.elementTagToObj(element, modelType));
        return obj;
    }

    protected Map elementAttributeToObj(Element categoryEl, String modelType) {
        List attributes = categoryEl.attributes();
        HashMap<String, Object> node = new HashMap<String, Object>(attributes.size());
        Attribute langAttr = categoryEl.attribute("Lang");
        Object[] language = null;
        if (langAttr != null && langAttr.getValue() != null) {
            language = langAttr.getValue().split(";");
        }
        Attribute idAttr = categoryEl.attribute("Id");
        String prefix = "";
        if (idAttr != null && idAttr.getValue() != null) {
            prefix = idAttr.getValue();
        }
        for (Attribute attribute : attributes) {
            String key = attribute.getName();
            String value = attribute.getValue();
            if ("Desc".equals(key) || "Lang".equals(key) || "LangConvert".equals(key)) continue;
            if ("true".equals(value) || "false".equals(value)) {
                node.put(key, Boolean.parseBoolean(value));
                continue;
            }
            if (language != null && ArrayUtils.contains((Object[])language, (Object)key)) {
                node.put(key, ResManager.loadKDString((String)value, (String)(prefix + "_" + key), (String)("bos-print-" + modelType), (Object[])new Object[0]));
                continue;
            }
            node.put(key, value);
        }
        return node;
    }

    protected Map elementTagToObj(Element categoryEl, String modelType) {
        HashMap<String, Object> node = new HashMap<String, Object>();
        Iterator iterator = categoryEl.elementIterator();
        while (iterator.hasNext()) {
            Element next = (Element)iterator.next();
            node.put(next.getName(), this.getElementData(next, modelType));
        }
        return node;
    }

    protected Object getElementData(Element element, String modelType) {
        String dataType = element.attributeValue("DataType");
        if ("Function".equals(dataType)) {
            String method = element.attributeValue("Method");
            return DesignModelFunction.executeMethod(method);
        }
        if ("Array".equals(dataType)) {
            JSONArray jsonArray = (JSONArray)JSONArray.parse((String)element.getText());
            return PrintModelLangUtil.convert(jsonArray, element, modelType);
        }
        if ("JSON".equals(dataType)) {
            JSONObject jsonObject = JSONObject.parseObject((String)element.getText());
            return PrintModelLangUtil.convert(jsonObject, element, modelType);
        }
        return PrintModelLangUtil.convert(element.getText(), element, modelType);
    }

    protected List<Map> readCommonProp(String key, String ext) throws Exception {
        String lang = RequestContext.get().getLang().toString();
        String cacheKey = lang + key + ext;
        List<Map> properties = propertiesCache.get(cacheKey);
        if (properties == null) {
            try (InputStream in = this.getClass().getResourceAsStream("/control/CommonProperties.xml");){
                SAXReader reader = this.getSaxReader();
                Document doc = reader.read(in);
                Element rootElement = doc.getRootElement();
                if (ext != null) {
                    this.extModelParser(String.format("/control/CommonProperties_%s.xml", ext), rootElement);
                }
                Iterator iterator = rootElement.elementIterator();
                while (iterator.hasNext()) {
                    Element propertiesEl = (Element)iterator.next();
                    ArrayList<Map> propertyList = new ArrayList<Map>(10);
                    List elements = propertiesEl.elements();
                    for (Element element : elements) {
                        propertyList.add(this.elementToObject(element, "CommonProperties"));
                    }
                    propertiesCache.put(lang + propertiesEl.attributeValue("Id") + ext, propertyList);
                }
            }
            properties = propertiesCache.get(cacheKey);
        }
        List copyList = (List)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString(properties), List.class);
        return copyList;
    }
}

