/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.business.control;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheConfigInfo;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.exception.KDBizException;
import kd.bos.inte.api.EnabledLang;
import kd.bos.inte.api.IInteService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.print.api.utils.SerializeUtils;
import kd.bos.print.business.control.ModelInfo;
import kd.bos.print.business.control.PrintDesignModelReader;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class PrintControlUtils {
    private static final Log log = LogFactory.getLog(PrintControlUtils.class);
    private static final String MODEL_CACHE_KEY = "modeKey";
    private static int visitCache = 1;

    private static LocalMemoryCache getModelLocalCache() {
        CacheConfigInfo info = new CacheConfigInfo();
        info.setTimeout(432000);
        info.setMaxMemSize(1000);
        return CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache(CacheKeyUtil.getAcctId(), "modelCacheGroup", info);
    }

    public static String getControlModel() {
        return PrintControlUtils.getControlModel(null);
    }

    public static String getControlModel(String bizType) {
        String ext = BizType.getExtByBizType(bizType);
        ModelInfo modelInfo = PrintControlUtils.getModelFromCache(ext);
        if (modelInfo == null) {
            visitCache = 0;
            String modelFromDb = PrintControlUtils.getModelFromDb(ext);
            PrintControlUtils.cacheModel(modelFromDb, ext);
            return modelFromDb;
        }
        return modelInfo.getData();
    }

    public static void removeCache() {
        PrintControlUtils.getModelLocalCache().clear();
    }

    private static String getModelCacheKey(String ext) {
        if (ext == null) {
            return MODEL_CACHE_KEY + RequestContext.get().getLang().toString();
        }
        return MODEL_CACHE_KEY + ext + RequestContext.get().getLang().toString();
    }

    private static List<String> getPrintLangs() {
        IInteService inteService = (IInteService)ServiceFactory.getService(IInteService.class);
        List languages = inteService.getLocalLangForPrint("1");
        ArrayList<String> langs = new ArrayList<String>(languages.size());
        for (EnabledLang lang : languages) {
            langs.add(lang.getNumber());
        }
        return langs;
    }

    private static ModelInfo getModelFromCache(String ext) {
        ++visitCache;
        Object m = PrintControlUtils.getModelLocalCache().get(PrintControlUtils.getModelCacheKey(ext));
        if (m == null) {
            return null;
        }
        ModelInfo modelInfo = (ModelInfo)m;
        boolean isChange = false;
        if (visitCache % 5 == 0) {
            visitCache = 0;
            List<String> printLangs = PrintControlUtils.getPrintLangs();
            List<String> cacheLangs = modelInfo.getLangs();
            if (printLangs.size() != cacheLangs.size()) {
                isChange = true;
            } else {
                for (String lang : printLangs) {
                    if (cacheLangs.contains(lang)) continue;
                    isChange = true;
                    break;
                }
            }
        }
        if (isChange) {
            modelInfo = null;
        }
        return modelInfo;
    }

    private static void cacheModel(String model, String ext) {
        ModelInfo modelInfo = new ModelInfo();
        modelInfo.setData(model);
        modelInfo.setLangs(PrintControlUtils.getPrintLangs());
        modelInfo.setEnableRich("true");
        PrintControlUtils.getModelLocalCache().put(PrintControlUtils.getModelCacheKey(ext), (Object)modelInfo);
    }

    public static String getModelFromDb() {
        return PrintControlUtils.getModelFromDb(null);
    }

    public static String getModelFromDb(String ext) {
        List<Map<String, String>> fontNameList;
        PrintDesignModelReader reader = new PrintDesignModelReader();
        Map printModel = null;
        try {
            Map read;
            printModel = read = reader.read(ext);
        }
        catch (Exception e) {
            log.error((Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u6a21\u578b\u6570\u636e\u83b7\u53d6\u5931\u8d25\u3002", (String)"PrintControlUtils_0", (String)"bos-print-business", (Object[])new Object[0]));
        }
        if (BizType.ESC_POS.ext.equals(ext)) {
            fontNameList = new ArrayList<Map<String, String>>(1);
            HashMap<String, String> fontMap = new HashMap<String, String>(3);
            fontMap.put("Value", "\u601d\u6e90\u5b8b\u4f53 CN");
            fontMap.put("Name", "\u601d\u6e90\u5b8b\u4f53 CN");
            fontMap.put("IsCustom", "false");
            fontNameList.add(fontMap);
        } else {
            fontNameList = PrintControlUtils.getFontFromDb(printModel);
        }
        String modelStr = JSONObject.toJSONString((Object)printModel);
        modelStr = modelStr.replace("\"${{FontName}}\"", SerializeUtils.toJsonString(fontNameList));
        return modelStr;
    }

    private static List<Map<String, String>> getFontFromDb(Map printModel) {
        ArrayList<Map<String, String>> fontNameList = new ArrayList<Map<String, String>>(10);
        ArrayList fontMappingList = new ArrayList(10);
        QFilter qFilter = new QFilter("tenantid", "=", (Object)RequestContext.get().getTenantId());
        qFilter.or(new QFilter("source", "=", (Object)"1"));
        Object[] ids = new Object[]{1186818181369438208L, 1186818041472623616L, 1189126456966392832L, 1189125939531885568L};
        QFilter qFilter1 = new QFilter("id", "not in", (Object)ids);
        QFilter qFilter2 = new QFilter("number", "!=", (Object)"Microsoft YaHei").or(new QFilter("source", "!=", (Object)"1"));
        QFilter[] filters = new QFilter[]{qFilter2, qFilter1, qFilter, new QFilter("billstatus", "=", (Object)"B")};
        DynamicObject[] fonts = BusinessDataServiceHelper.load((String)"bos_prt_font", (String)"number,name,source,alias,rcId", (QFilter[])filters, (String)"ordernum asc,createtime asc");
        HashSet<String> fontSet = new HashSet<String>();
        HashSet<String> cusFontSet = new HashSet<String>();
        for (DynamicObject item : fonts) {
            String fontName = item.getString("name");
            String fontNum = item.getString("number");
            String alias = item.getString("alias");
            String source = item.getString("source");
            if (StringUtils.equals((CharSequence)"1", (CharSequence)source) && fontSet.contains(fontName) || !StringUtils.equals((CharSequence)"1", (CharSequence)source) && cusFontSet.contains(fontName)) continue;
            if (StringUtils.equals((CharSequence)"1", (CharSequence)source)) {
                fontSet.add(fontName);
            } else {
                cusFontSet.add(fontName);
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("Name", StringUtils.isNotBlank((CharSequence)alias) ? alias : fontName);
            map.put("Value", fontName);
            map.put("IsCustom", !StringUtils.equals((CharSequence)"1", (CharSequence)source));
            fontNameList.add(map);
            if (StringUtils.equals((CharSequence)"1", (CharSequence)source)) continue;
            HashMap<String, String> mapper = new HashMap<String, String>();
            mapper.put("Name", fontName);
            mapper.put("Code", fontNum);
            long rcId = item.getLong("rcId");
            mapper.put("RcId", rcId + "");
            fontMappingList.add(mapper);
        }
        List fontMapping = (List)printModel.get("FontMapping");
        fontMapping.addAll(fontMappingList);
        return fontNameList;
    }

    static enum BizType {
        NORMAL(null),
        ESC_POS("esc"),
        CPCL("esc"),
        ESCP("esc");

        private final String ext;

        private BizType(String ext) {
            this.ext = ext;
        }

        public static String getExtByBizType(String bizType) {
            try {
                int i = Integer.parseInt(bizType);
                BizType[] values = BizType.values();
                if (i >= 0 && i < values.length) {
                    return values[i].ext;
                }
                return null;
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
    }
}

