/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.business.control;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.util.StringUtils;
import org.dom4j.Element;

public class PrintModelLangUtil {
    public static final String XML_LANG_CONVERT = "LangConvert";
    public static final String XML_LANG = "Lang";
    public static final String XMM_LANG_SPLIT = ";";
    private static final String XMM_LANG_CONVERT_SPLIT = ":";
    public static final String RESOURCE_PREV = "bos-print-";
    private static final String ALL_SCOPE = "*";
    private static final JsonObjectLangConvert TIPS_CONVERT = (json, scope, prefix, systemType) -> {
        String value;
        JSONObject tips = (JSONObject)json.get((Object)"Tips");
        if (tips == null) {
            return json;
        }
        if (scope != null && (value = (String)json.get((Object)scope)) != null) {
            json.replace((Object)scope, (Object)value, (Object)ResManager.loadKDString((String)value, (String)(prefix + "_" + scope), (String)systemType, (Object[])new Object[0]));
        }
        tips.replaceAll((key, oldV) -> {
            if (oldV instanceof String) {
                return ResManager.loadKDString((String)((String)oldV), (String)(prefix + "_" + key), (String)systemType, (Object[])new Object[0]);
            }
            return oldV;
        });
        return json;
    };
    private static final JsonObjectLangConvert ENUM_CONVERT = (json, scope, prefix, systemType) -> {
        JSONArray enumArray = json.getJSONArray("Enum");
        if (enumArray == null) {
            return json;
        }
        if (ALL_SCOPE.equals(scope)) {
            for (Object o : enumArray) {
                JSONObject enumJson = (JSONObject)o;
                String name = enumJson.getString("Name");
                String value = enumJson.getString("Value");
                if (!StringUtils.isEmpty((Object)name) && !StringUtils.isEmpty((Object)value)) {
                    enumJson.replace((Object)"Name", (Object)name, (Object)ResManager.loadKDString((String)name, (String)(prefix + "_" + value), (String)systemType, (Object[])new Object[0]));
                    continue;
                }
                break;
            }
        } else {
            int i = 1;
            int bitIndex = Integer.parseInt(scope);
            for (Object enumObj : enumArray) {
                JSONObject enumJson = (JSONObject)enumObj;
                String name = enumJson.getString("Name");
                String value = enumJson.getString("Value");
                if (!StringUtils.isEmpty((Object)name) && !StringUtils.isEmpty((Object)value)) {
                    if ((bitIndex & i) > 0) {
                        enumJson.replace((Object)"Name", (Object)name, (Object)ResManager.loadKDString((String)name, (String)(prefix + "_" + value), (String)systemType, (Object[])new Object[0]));
                    }
                    i <<= 1;
                    continue;
                }
                break;
            }
        }
        return json;
    };
    private static final JsonObjectLangConvert LINK_TIPS_CONVERT = (json, scope, prefix, systemType) -> {
        String title;
        JSONArray linkData;
        String content = json.getString("content");
        if (!StringUtils.isEmpty((Object)content)) {
            json.replace((Object)"content", (Object)content, (Object)ResManager.loadKDString((String)content, (String)(prefix + "_content"), (String)systemType, (Object[])new Object[0]));
        }
        if ((linkData = json.getJSONArray("linkData")) != null) {
            for (Object data : linkData) {
                String name;
                JSONObject jsonData = (JSONObject)data;
                String code = jsonData.getString("code");
                if (code == null || (name = jsonData.getString("name")) == null) continue;
                jsonData.replace((Object)"name", (Object)name, (Object)ResManager.loadKDString((String)name, (String)(prefix + "_" + code), (String)systemType, (Object[])new Object[0]));
            }
        }
        if (!StringUtils.isEmpty((Object)(title = json.getString("title")))) {
            json.replace((Object)"title", (Object)title, (Object)ResManager.loadKDString((String)title, (String)(prefix + "_title"), (String)systemType, (Object[])new Object[0]));
        }
        return json;
    };

    public static Object convert(Object obj, Element element, String resourceType) {
        String langConvert;
        if (obj == null || element == null || (langConvert = element.attributeValue(XML_LANG_CONVERT)) == null) {
            return obj;
        }
        String[] split = langConvert.split(XMM_LANG_CONVERT_SPLIT);
        if (split.length < 1) {
            return obj;
        }
        String convertType = split[0];
        String scope = null;
        if (split.length >= 2) {
            scope = split[1];
        }
        String prefix = null;
        for (Element startEle = element; startEle != null && (prefix = startEle.attributeValue("Id")) == null; startEle = startEle.getParent()) {
        }
        if (StringUtils.isEmpty(prefix)) {
            return obj;
        }
        String systemType = RESOURCE_PREV + resourceType;
        if (obj instanceof JSONObject) {
            JSONObject jsonObject = (JSONObject)obj;
            switch (convertType) {
                case "Tips": {
                    return TIPS_CONVERT.langConvert(jsonObject, scope, prefix, systemType);
                }
                case "Enum": {
                    return ENUM_CONVERT.langConvert(jsonObject, scope, prefix, systemType);
                }
                case "LinkTips": {
                    return LINK_TIPS_CONVERT.langConvert(jsonObject, scope, prefix, systemType);
                }
            }
            return obj;
        }
        if (obj instanceof JSONArray) {
            JSONArray jsonArray = (JSONArray)obj;
            if (scope == null) {
                AtomicInteger i = new AtomicInteger(1);
                String finalPrefix = prefix;
                jsonArray.replaceAll(oldV -> ResManager.loadKDString((String)((String)oldV), (String)(finalPrefix + "_Array_" + i.getAndIncrement()), (String)systemType, (Object[])new Object[0]));
            } else {
                for (int i = 0; i < jsonArray.size(); ++i) {
                    JSONObject jsonObject = (JSONObject)jsonArray.get(i);
                    String value = jsonObject.getString(scope);
                    if (StringUtils.isEmpty((Object)value)) continue;
                    jsonObject.replace((Object)scope, (Object)value, (Object)ResManager.loadKDString((String)value, (String)(prefix + "_Array_" + (i + 1)), (String)systemType, (Object[])new Object[0]));
                }
            }
        } else if (obj instanceof String) {
            return ResManager.loadKDString((String)((String)obj), (String)(prefix + "_" + element.getName() + "_Text"), (String)systemType, (Object[])new Object[0]);
        }
        return obj;
    }

    @FunctionalInterface
    static interface JsonObjectLangConvert {
        public JSONObject langConvert(JSONObject var1, String var2, String var3, String var4);
    }
}

