/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.business.designer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.param.CustomParam;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.Label;
import kd.bos.form.control.PrintDesigner;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.isv.ISVService;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.SystemPropertyUtils;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.mservice.svc.picture.IImage;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.print.api.metedata.DesignerMetadata;
import kd.bos.print.api.metedata.LocaleValue;
import kd.bos.print.api.metedata.PrintMetadata;
import kd.bos.print.api.utils.SerializeUtils;
import kd.bos.print.business.designer.BaseInfo;
import kd.bos.print.business.designer.OpResult;
import kd.bos.print.business.designer.datasource.DsType;
import kd.bos.print.business.designer.datasource.PrintDataSourceUtil;
import kd.bos.print.business.designer.datasource.PrtDataSourceUtil;
import kd.bos.print.business.designer.function.InitFunctionUtil;
import kd.bos.print.business.designer.plugin.NumberCheckUtils;
import kd.bos.print.business.designer.plugin.SortFieldSettingPlugin;
import kd.bos.print.business.metedata.PrintMetadataUtil;
import kd.bos.print.business.metedata.bean.AbstractDesignMetadata;
import kd.bos.print.business.metedata.bean.DesignMetadata;
import kd.bos.print.business.metedata.bean.LibraryDesignMetadata;
import kd.bos.print.business.metedata.service.AbstractTplService;
import kd.bos.print.business.metedata.service.LibraryTplService;
import kd.bos.print.business.metedata.service.PrintTplObj;
import kd.bos.print.business.metedata.service.PrintTplService;
import kd.bos.print.business.service.UserGideService;
import kd.bos.print.business.utils.PrintOpLogMsgEnum;
import kd.bos.print.business.utils.PrintOpLogUtils;
import kd.bos.print.business.utils.PrintParamUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.svc.util.print.PrintPermissionUtil;

public class PrintDesignerPlugin
extends AbstractFormPlugin {
    private static final String PRINT_DESIGNER = "printdesigner";
    private static final String BTN_SAVE = "save";
    private static final String BTN_UPDATE = "update";
    private static final String BTN_PREVIEW = "preview";
    private static final String BTN_TPL = "template";
    private static final String BTN_HELPER = "helper";
    private static final String BTN_PLUGIN = "plugin";
    private static final String BTN_WF = "wfsetting";
    private static final String CACHE_LANG_MAP = "localeValueMap";
    private static final String CACHE_BASE_INFO = "baseInfo";
    private static final String CACHE_DATA_SOURCE = "dataSourceCache";
    private static final String CACHE_CURRENT_LANG = "curLang";
    private static final String PROJECT_NAME = "bos-print-business";
    private static final String FORM_ID_SORT_SETTINGS = "ide_sortfieldsetting";
    private static final String FORM_ID_Filter_SETTINGS = "bos_printfilterediter";
    private static final String BOS_PRINTFILENAME_SETTING = "bos_printfilename_setting";
    private static final Log log = LogFactory.getLog(PrintDesignerPlugin.class);
    private AbstractTplService tplService = new PrintTplService();
    private AbstractTplService libraryTplService = new LibraryTplService();

    public static String getPrintDesignerAction() {
        return PRINT_DESIGNER;
    }

    private AbstractTplService getDesignService() {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String tplType = (String)showParameter.getCustomParam("tplType");
        if ("PrintTplMetadata".equals(tplType)) {
            return this.libraryTplService;
        }
        return this.tplService;
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTN_SAVE, BTN_PREVIEW, BTN_TPL, BTN_HELPER, BTN_PLUGIN, BTN_WF, BTN_UPDATE});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        boolean isHasPermisson = PrintDesignerPlugin.checkPermission("47150e89000000ac");
        if (!isHasPermisson) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u6743\u9650\u8bbf\u95ee\u6253\u5370\u6a21\u677f\u3002", (String)"PrintDesignerPlugin_8", (String)PROJECT_NAME, (Object[])new Object[0]));
        }
        this.loadDesignerMetadata();
        if (this.getDesignService() instanceof LibraryTplService) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_PLUGIN, BTN_TPL, BTN_WF});
        }
        IImage logo = (IImage)this.getControl("imageap");
        if (Lang.zh_CN != Lang.get() && Lang.zh_TW != Lang.get()) {
            logo.setUrl("/images/pc/other/Dev_platform_logo_en.png");
        }
    }

    public void click(EventObject evt) {
        Button btn = (Button)evt.getSource();
        String key = btn.getKey();
        if (StringUtils.equals((CharSequence)key, (CharSequence)BTN_SAVE)) {
            this.savePrintMeta();
        } else if (StringUtils.equals((CharSequence)key, (CharSequence)BTN_UPDATE)) {
            PrintDesigner designer = (PrintDesigner)this.getView().getControl(PRINT_DESIGNER);
            IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            proxy.invokeControlMethod(designer.getKey(), "getPrintData", new Object[0]);
        } else if (StringUtils.equals((CharSequence)key, (CharSequence)BTN_PREVIEW)) {
            this.preview();
        } else if (StringUtils.equals((CharSequence)key, (CharSequence)BTN_PLUGIN)) {
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId("ide_plugins");
            CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "addPlugin");
            parameter.setCloseCallBack(callBack);
            parameter.setCustomParam("scripttypefilter", (Object)"PrintModel");
            parameter.setCustomParam("modelType", (Object)"PrintModel");
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            List<Map> pluginList = this.getCacheBaseInfo().getPluginList();
            parameter.getCustomParams().put("value", pluginList);
            this.getView().showForm(parameter);
        } else if (StringUtils.equals((CharSequence)key, (CharSequence)BTN_TPL)) {
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId("bos_newtpl_guide");
            BaseInfo baseInfo = this.getCacheBaseInfo();
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("formId", baseInfo.getFormId());
            param.put("entityId", baseInfo.getEntityId());
            param.put("tplId", baseInfo.getTplId());
            param.put("tplKey", baseInfo.getTplKey());
            param.put("tplName", (String)baseInfo.getTplName());
            param.put("sTplId", baseInfo.getStpld());
            param.put("bizType", baseInfo.getBizType());
            parameter.setCustomParams(param);
            CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "switchSTpl");
            parameter.setCloseCallBack(callBack);
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setCaption(ResManager.loadKDString((String)"\u6a21\u677f\u5e93", (String)"PrintDesignerPlugin_0", (String)PROJECT_NAME, (Object[])new Object[0]));
            this.getView().showForm(parameter);
        } else if (StringUtils.equals((CharSequence)key, (CharSequence)BTN_WF)) {
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId("bos_wf_prtparam");
            BaseInfo baseInfo = this.getCacheBaseInfo();
            Map wfParam = baseInfo.getWfParam();
            parameter.setCustomParams(wfParam);
            CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "wfSetting");
            parameter.setCloseCallBack(callBack);
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setCaption(ResManager.loadKDString((String)"\u5de5\u4f5c\u6d41\u8bbe\u7f6e", (String)"PrintDesignerPlugin_6", (String)PROJECT_NAME, (Object[])new Object[0]));
            this.getView().showForm(parameter);
        } else if (StringUtils.equals((CharSequence)key, (CharSequence)BTN_HELPER)) {
            this.getView().openUrl("https://vip.kingdee.com/knowledge/specialDetail/164785655732573952");
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId = e.getActionId();
        if ("switchSTpl".equals(actionId)) {
            Map returnData = (Map)e.getReturnData();
            if (returnData == null) {
                return;
            }
            String stplId = (String)returnData.get("stplId");
            if (StringUtils.isNotBlank((CharSequence)stplId)) {
                this.switchSTpl(stplId);
            }
        } else if ("addPlugin".equals(actionId)) {
            Map returnData = (Map)e.getReturnData();
            this.addPlugin(returnData);
        } else if ("modifyRefDataSource".equals(actionId)) {
            List returnData = (List)e.getReturnData();
            if (returnData == null) {
                return;
            }
            this.modifyRefDataSource(returnData);
        } else if ("modifyCustomDataSource".equals(actionId)) {
            List returnData = (List)e.getReturnData();
            if (returnData != null) {
                this.modifyCustomDataSource(returnData);
            }
        } else if ("wfSetting".equals(actionId)) {
            Map wfParam = (Map)e.getReturnData();
            if (wfParam == null) {
                return;
            }
            this.modifyWFParam(wfParam);
        } else if ("modifySortSettings".equals(actionId)) {
            IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            proxy.invokeControlMethod(PrintDesignerPlugin.getPrintDesignerAction(), "updateSortFields", new Object[]{e.getReturnData()});
        } else if ("modifyFilterSettings".equals(actionId)) {
            IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            proxy.invokeControlMethod(PrintDesignerPlugin.getPrintDesignerAction(), "updateFilterSetting", new Object[]{e.getReturnData()});
        }
    }

    private void preview() {
        String curLang = this.getPageCache().get(CACHE_CURRENT_LANG);
        PrintDesigner designer = (PrintDesigner)this.getView().getControl(PRINT_DESIGNER);
        Map content = designer.getContent();
        BaseInfo baseInfo = this.getCacheBaseInfo();
        content.put("refDs", baseInfo.getRefDs());
        content.put("customDs", baseInfo.getCustomDs());
        content.put("plugins", baseInfo.getPlugins());
        content.put("wfParam", baseInfo.getWfParam());
        PrintMetadata printMetadata = PrintMetadataUtil.parseMetadata(content, curLang);
        String previewUrl = this.getDesignService().getPreviewUrl(printMetadata, curLang);
        this.getView().openUrl(previewUrl);
    }

    private void savePrintMeta() {
        PrintDesigner designer = (PrintDesigner)this.getView().getControl(PRINT_DESIGNER);
        Map content = designer.getContent();
        this.savePrintMeta(content);
    }

    private boolean savePrintMeta(Map<String, Object> content) {
        Map beforeSave = this.getDesignService().beforeSave(content);
        if ("false".equals(beforeSave.get("success"))) {
            String message = String.valueOf(beforeSave.get("message"));
            this.getView().showErrorNotification(message);
            return false;
        }
        if (!this.checkTplPermission("4715a0df000000ac")) {
            return false;
        }
        BaseInfo baseInfo = this.getCacheBaseInfo();
        content.put("refDs", baseInfo.getRefDs());
        content.put("customDs", baseInfo.getCustomDs());
        content.put("plugins", baseInfo.getPlugins());
        content.put("stplId", baseInfo.getStpld());
        content.put("wfParam", baseInfo.getWfParam());
        this.updatePrintMeta(content);
        PrintOpLogUtils.addLog((String)"cts", (String)"ide_printdesigner", (String)"web", (String)String.valueOf(content.get("key")), (PrintOpLogMsgEnum)PrintOpLogMsgEnum.TPL_SAVE);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"PrintDesignerPlugin_3", (String)PROJECT_NAME, (Object[])new Object[0]));
        return true;
    }

    private void updatePrintMeta(Map<String, Object> content) {
        String oldTplKey;
        BaseInfo baseInfo = this.getCacheBaseInfo();
        Map paper = (Map)content.get("paper");
        String tplKey = (String)paper.get("key");
        if (!StringUtils.equals((CharSequence)tplKey, (CharSequence)(oldTplKey = baseInfo.getTplKey())) && NumberCheckUtils.isNumberExist(tplKey)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6a21\u677f\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"NumberCheckUtils_3", (String)PROJECT_NAME, (Object[])new Object[0]));
        }
        String localValueStr = this.getPageCache().get(CACHE_LANG_MAP);
        String curLang = this.getPageCache().get(CACHE_CURRENT_LANG);
        PrintTplObj printTplObj = this.getDesignService().updatePrintMeta(content, localValueStr, curLang);
        Map<String, LocaleValue> newLocalValueMap = printTplObj.getLocaleValueMap();
        this.getPageCache().put(CACHE_LANG_MAP, SerializeUtils.toJsonString(newLocalValueMap));
        PrintMetadata printMetadata = printTplObj.getPrintMetadata();
        Label label = (Label)this.getView().getControl("templatename");
        LocaleValue name = printMetadata.getName();
        label.setText((String)name.get((Object)curLang));
        if (!StringUtils.equals((CharSequence)tplKey, (CharSequence)oldTplKey)) {
            baseInfo.setTplKey(printMetadata.getKey());
            this.cacheBaseInfo(baseInfo);
        }
    }

    private void loadDesignerMetadata() {
        FormShowParameter showParameter;
        String tplId;
        HashMap<String, Object> returnData = new HashMap<String, Object>();
        PrintMetadata printMetadata = null;
        AbstractTplService designService = this.getDesignService();
        Object designMeta = designService.getDesignMeta(tplId = (String)(showParameter = this.getView().getFormShowParameter()).getCustomParam("id"));
        String isv = designMeta.getIsv();
        if (StringUtils.isNotBlank((CharSequence)isv) && !isv.equals(ISVService.getISVInfo().getId()) || designService.isSysTemplate((AbstractDesignMetadata)designMeta)) {
            if (designService instanceof PrintTplService) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7cfb\u7edf\u9884\u7f6e\u6a21\u677f\u4e0d\u652f\u6301\u4fee\u6539\uff0c\u53ef\u901a\u8fc7\u590d\u5236\u6a21\u677f\u540e\u4fee\u6539\u3002", (String)"PrintDesignerPlugin_14", (String)PROJECT_NAME, (Object[])new Object[0]));
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7cfb\u7edf\u9884\u7f6e\u6a21\u677f\u4e0d\u652f\u6301\u4fee\u6539\u3002", (String)"PrintDesignerPlugin_16", (String)PROJECT_NAME, (Object[])new Object[0]));
            }
        } else if (!this.checkTplPermission("4715a0df000000ac")) {
            // empty if block
        }
        printMetadata = designService.getPrintMetadata((AbstractDesignMetadata)designMeta);
        String curLang = Lang.get().toString();
        DesignerMetadata designerMetadata = PrintMetadataUtil.toDesignerMetadata(printMetadata, curLang);
        returnData.put("Metadata", designerMetadata.getMetadata());
        returnData.put("IsFirstVisit", !UserGideService.isFinishGuide("0"));
        returnData.put("IsFirstUseGrid", !UserGideService.isFinishGuide("1"));
        BaseInfo baseInfo = new BaseInfo();
        baseInfo.setRefDs(printMetadata.getRefDs());
        baseInfo.setCustomDs(printMetadata.getCustomDs());
        baseInfo.setPlugins(printMetadata.getPlugins());
        baseInfo.setBizType(StringUtils.isBlank((CharSequence)printMetadata.getBizType()) ? "0" : printMetadata.getBizType());
        String entityId = printMetadata.getEntityId();
        OpResult opResult = new OpResult();
        List dataSource = designService.loadDataSource(entityId, baseInfo.getRefList(), baseInfo.getCustomList(), opResult);
        if (!opResult.isSuccess()) {
            List<String> errMsg = opResult.getErrMsg();
            this.getView().showErrorNotification(StringUtils.join((Object[])errMsg.toArray(), (String)","));
        }
        if (opResult.isContainWf()) {
            this.getView().setVisible(Boolean.TRUE, new String[]{BTN_WF});
        }
        returnData.put("Datasource", dataSource);
        returnData.put("Function", InitFunctionUtil.getFun());
        this.cacheDataSource(dataSource);
        List<String> resIds = PrintMetadataUtil.getResIds(printMetadata);
        PrintPermissionUtil.setMetaRcPermission(resIds);
        Label label = (Label)this.getView().getControl("templatename");
        LocaleValue name = printMetadata.getName();
        label.setText((String)name.getLocaleValue());
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod(PRINT_DESIGNER, "open", new Object[]{returnData});
        this.getPageCache().put(CACHE_LANG_MAP, SerializeUtils.toJsonString((Object)designerMetadata.getLocaleValueMap()));
        this.getPageCache().put(CACHE_CURRENT_LANG, curLang);
        baseInfo.setEntityId(printMetadata.getEntityId());
        baseInfo.setFormId(printMetadata.getFormId());
        baseInfo.setTplId(printMetadata.getId());
        baseInfo.setTplKey(printMetadata.getKey());
        baseInfo.setTplName((LocaleValue<String>)printMetadata.getName());
        baseInfo.setWfParam((Map)SerializeUtils.fromJsonString((String)SerializeUtils.toJsonString((Object)printMetadata.getWfParam()), Map.class));
        baseInfo.setOriLang(printMetadata.getOriLang());
        String sTplId = printMetadata.getStplId();
        if (StringUtils.isNotBlank((CharSequence)sTplId)) {
            baseInfo.setStpld(sTplId);
        }
        this.cacheBaseInfo(baseInfo);
    }

    private void cacheDataSource(List dataSource) {
        this.getPageCache().put(CACHE_DATA_SOURCE, SerializeUtils.toJsonString((Object)dataSource));
    }

    private void removeDataSourceCache() {
        this.getPageCache().remove(CACHE_DATA_SOURCE);
    }

    private List<Map<String, Object>> getDataSource() {
        String cacheInfo = this.getPageCache().get(CACHE_DATA_SOURCE);
        if (cacheInfo != null) {
            return (List)SerializeUtils.fromJsonString((String)cacheInfo, List.class);
        }
        return null;
    }

    public void customEvent(CustomEventArgs e) {
        String eventName = e.getEventName();
        BaseInfo cacheBaseInfo = this.getCacheBaseInfo();
        if ("openRefDsModal".equals(eventName)) {
            HashMap p = new HashMap();
            Map entityInfo = (Map)SerializeUtils.fromJsonString((String)this.getPageCache().get(CACHE_BASE_INFO), Map.class);
            Object entityId = entityInfo.get("entityId");
            p.put("EntityId", entityId);
            FormShowParameter parameter = new FormShowParameter();
            parameter.getCustomParams().put("mainentityId", entityId);
            parameter.getCustomParams().put("context", Collections.singletonList(Collections.singletonList(p)));
            parameter.getCustomParams().put("value", cacheBaseInfo.getRefDs());
            parameter.getCustomParams().put("openSourceType", "PrintNew");
            parameter.setFormId("ide_refqueryentity");
            CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "modifyRefDataSource");
            parameter.setCloseCallBack(callBack);
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setCaption(ResManager.loadKDString((String)"\u5173\u8054\u6570\u636e\u6e90", (String)"PrintDesignerPlugin_4", (String)PROJECT_NAME, (Object[])new Object[0]));
            this.getView().showForm(parameter);
        } else if ("openCustomDsModal".equals(eventName)) {
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId("bos_custom_ds");
            ArrayList<String> dsList = new ArrayList<String>(10);
            String formId = cacheBaseInfo.getFormId();
            dsList.add(formId);
            dsList.add("$DsKey=[System]");
            List<Map> refList = cacheBaseInfo.getRefList();
            for (Map ds : refList) {
                String refKey = (String)ds.get("number");
                dsList.add(refKey);
            }
            parameter.getCustomParams().put("dsList", dsList);
            parameter.getCustomParams().put("data", cacheBaseInfo.getCustomDs());
            CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "modifyCustomDataSource");
            parameter.setCloseCallBack(callBack);
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setCaption(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u6570\u636e\u6e90", (String)"PrintDesignerPlugin_5", (String)PROJECT_NAME, (Object[])new Object[0]));
            this.getView().showForm(parameter);
        } else if ("changePLang".equals(eventName)) {
            String args = e.getEventArgs();
            Map data = (Map)SerializeUtils.fromJsonString((String)args, Map.class);
            String curLang = (String)data.get("language");
            Map content = null;
            boolean flag = true;
            Object postDataObj = data.get("postData");
            if (postDataObj != null) {
                List postData = (List)postDataObj;
                content = (Map)((Map)postData.get(0)).get(PRINT_DESIGNER);
                try {
                    flag = this.savePrintMeta(content);
                }
                catch (Exception ex) {
                    this.getView().showErrorNotification(ex.getMessage());
                    flag = false;
                }
            }
            IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            HashMap param = new HashMap();
            if (flag) {
                BaseInfo baseInfo = (BaseInfo)SerializeUtils.fromJsonString((String)this.getPageCache().get(CACHE_BASE_INFO), BaseInfo.class);
                String tplId = baseInfo.getTplId();
                PrintMetadata printMetadata = this.getDesignService().getMetadata(tplId);
                DesignerMetadata designerMetadata = PrintMetadataUtil.toDesignerMetadata(printMetadata, curLang);
                param.put("pages", designerMetadata.getMetadata().get("pages"));
                param.put("paper", designerMetadata.getMetadata().get("paper"));
                Label label = (Label)this.getView().getControl("templatename");
                LocaleValue name = printMetadata.getName();
                label.setText((String)name.getOrDefault((Object)curLang, name.getDefaultValue()));
            } else {
                curLang = this.getPageCache().get(CACHE_CURRENT_LANG);
                param.put("pages", content.get("pages"));
                Map paper = (Map)content.get("paper");
                paper.put("language", curLang);
                param.put("paper", paper);
            }
            proxy.invokeControlMethod(PRINT_DESIGNER, "updateMeta", new Object[]{param});
            this.getPageCache().put(CACHE_CURRENT_LANG, curLang);
        } else if ("prtUserGuide".equals(eventName)) {
            UserGideService.finishGuide("0");
        } else if ("prtGridUserGride".equals(eventName)) {
            UserGideService.finishGuide("1");
        } else if ("prtGridSortFields".equals(eventName)) {
            FormShowParameter parameter = new FormShowParameter();
            String args = e.getEventArgs();
            Map data = (Map)SerializeUtils.fromJsonString((String)args, Map.class);
            String dataSourceKey = String.valueOf(data.get("dataSource"));
            String dataGridId = String.valueOf(data.get("id"));
            Object sortSettings = data.get("sortSettings");
            parameter.getCustomParams().put(SortFieldSettingPlugin.getFormParamSortSettings(), sortSettings);
            parameter.setFormId(FORM_ID_SORT_SETTINGS);
            parameter.getCustomParams().put(SortFieldSettingPlugin.getCustomParamDataGridId(), dataGridId);
            parameter.getCustomParams().put(SortFieldSettingPlugin.getCustomParamDataSource(), dataSourceKey);
            List dsList = (List)data.get("dsList");
            parameter.getCustomParams().put(SortFieldSettingPlugin.getCustomParamSortFields(), this.buildSortFields(dataSourceKey, dsList, this.getCacheBaseInfo()));
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setCaption(ResManager.loadKDString((String)"\u6392\u5e8f\u8bbe\u7f6e", (String)"PrintDesignerPlugin_9", (String)PROJECT_NAME, (Object[])new Object[0]));
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "modifySortSettings"));
            this.getView().showForm(parameter);
        } else if ("prtGridFilterSetting".equals(eventName)) {
            FormShowParameter parameter = new FormShowParameter();
            String args = e.getEventArgs();
            Map data = (Map)SerializeUtils.fromJsonString((String)args, Map.class);
            Object filterSetting = data.get("filterSettingValue");
            Map filterSettingMap = new HashMap(16);
            if (StringUtils.isNotBlank(filterSetting)) {
                filterSettingMap = (Map)SerializeUtils.fromJsonString((String)String.valueOf(filterSetting), Map.class);
            }
            parameter.setFormId(FORM_ID_Filter_SETTINGS);
            String dataSource = String.valueOf(data.get("dataSource"));
            String[] split = dataSource.split("\\.");
            parameter.setCustomParam("formid", (Object)split[0]);
            parameter.setCustomParam("filterEntityNumber", (Object)split[split.length - 1]);
            if (CollectionUtils.isEmpty(filterSettingMap)) {
                parameter.setCustomParam("name", null);
                parameter.setCustomParam("condition", null);
            } else {
                parameter.setCustomParam("name", filterSettingMap.get("name"));
                parameter.setCustomParam("condition", filterSettingMap.get("condition"));
            }
            parameter.setCustomParam("dataGridId", data.get("id"));
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setCaption(ResManager.loadKDString((String)"\u8fc7\u6ee4\u6761\u4ef6\u8bbe\u7f6e", (String)"PrintDesignerPlugin_11", (String)PROJECT_NAME, (Object[])new Object[0]));
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "modifyFilterSettings"));
            this.getView().showForm(parameter);
        } else if ("clickTipsLink".equals(eventName)) {
            String url;
            switch (e.getEventArgs()) {
                case "lineWrapRule": {
                    url = "https://vip.kingdee.com/knowledge/specialDetail/164785655732573952?category=198070881598520832&id=444598144001700352&productLineId=29";
                    break;
                }
                case "tableTail": {
                    url = "https://vip.kingdee.com/knowledge/specialDetail/164785655732573952?category=198070881598520832&id=450969772042206208&productLineId=29";
                    break;
                }
                case "statWithData": {
                    url = "https://vip.kingdee.com/knowledge/specialDetail/164785655732573952?category=207964195034794496&id=479374996725319680&productLineId=29";
                    break;
                }
                case "mergePrint": {
                    url = "https://vip.kingdee.com/article/561278862982792192";
                    break;
                }
                case "currencyCode": {
                    url = "https://vip.kingdee.com/knowledge/specialDetail/164785655732573952?category=207965585698228736&id=433926422889871872&productLineId=29";
                    break;
                }
                default: {
                    return;
                }
            }
            if (!StringUtils.equals((CharSequence)Lang.zh_CN.toString(), (CharSequence)RequestContext.get().getLang().toString())) {
                url = url + "&lang=en-US";
            }
            this.getView().openUrl(url);
        }
    }

    private List<Map<String, Object>> buildSortFields(String dataSourceKey, List<Map<String, Object>> dsList, BaseInfo baseInfo) {
        Map mainDsMap;
        List items;
        Optional<Map> entryDsMapOp;
        if (StringUtils.isBlank((CharSequence)dataSourceKey)) {
            return Collections.emptyList();
        }
        List dataSources = this.getDataSource();
        if (dataSources == null) {
            dataSources = this.getDesignService().loadDataSource(baseInfo.getEntityId(), baseInfo.getRefList(), baseInfo.getCustomList(), new OpResult());
        }
        String[] split = dataSourceKey.split("\\.");
        if (dataSourceKey.length() < 2 || split.length < 2) {
            return this.buildRefSortFields(dataSources, dataSourceKey, dsList);
        }
        String mainDs = split[0];
        String entryDs = split[1];
        Optional<Map> mainDsOp = dataSources.stream().filter(f -> StringUtils.equals((CharSequence)mainDs, (CharSequence)String.valueOf(f.get("Key")))).findFirst();
        if (mainDsOp.isPresent() && (entryDsMapOp = (items = (List)(mainDsMap = mainDsOp.get()).get("Items")).stream().filter(f -> StringUtils.equals((CharSequence)entryDs, (CharSequence)f.get("Key").toString()) && f.containsKey("IsDataGridDs") && (Boolean)f.get("IsDataGridDs") != false).findFirst()).isPresent()) {
            Map entryDsMap = entryDsMapOp.get();
            List entryFieldMap = (List)entryDsMap.get("Items");
            return this.buildProperties(entryFieldMap, dsList);
        }
        return Collections.emptyList();
    }

    private List<Map<String, Object>> buildProperties(List<Map<String, Object>> sortFieldMap, List<Map<String, Object>> dsList) {
        if (dsList != null) {
            HashMap seen = new HashMap(dsList.size());
            dsList = dsList.stream().filter(f -> seen.putIfAbsent(f.get("bindField"), Boolean.TRUE) == null).collect(Collectors.toList());
        }
        List<Map<String, Object>> finalDsList = dsList;
        List<Map<String, Object>> result = sortFieldMap.stream().flatMap(fMap -> {
            if (fMap.containsKey("Items")) {
                List<Map<String, Object>> pItems = (List<Map<String, Object>>)fMap.get("Items");
                if ("ReportEntryGroup".equals(fMap.get("Type"))) {
                    ArrayList<Map<String, Object>> resultItems = new ArrayList<Map<String, Object>>(10);
                    this.reportEntryGroupSortFields(finalDsList, (Map<String, Object>)fMap, pItems, (List<Map<String, Object>>)resultItems);
                    pItems = resultItems;
                } else {
                    pItems = this.baseDataSortFields(finalDsList, (Map<String, Object>)fMap, pItems);
                }
                pItems.forEach(pItem -> pItem.put("Name", String.valueOf(Optional.ofNullable(pItem.get("ViewName")).orElseGet(() -> {
                    Object name = pItem.get("Name");
                    if (StringUtils.isBlank(name)) {
                        name = "";
                    }
                    return name;
                })).replaceAll("\\.", "-")));
                return pItems.stream();
            }
            return Stream.of(fMap);
        }).filter(f -> f.containsKey("SortedAble") && (Boolean)f.get("SortedAble") != false).collect(Collectors.toList());
        return result;
    }

    private void reportEntryGroupSortFields(List<Map<String, Object>> finalDsList, Map<String, Object> fMap, List<Map<String, Object>> pItems, List<Map<String, Object>> resultItems) {
        for (Map<String, Object> pItem : pItems) {
            if (pItem.containsKey("Items")) {
                List items = (List)pItem.get("Items");
                if ("ReportEntryGroup".equals(pItem.get("Type"))) {
                    this.reportEntryGroupSortFields(finalDsList, fMap, items, resultItems);
                    continue;
                }
                resultItems.addAll(this.baseDataSortFields(finalDsList, pItem, items));
                continue;
            }
            resultItems.add(pItem);
        }
    }

    private List<Map<String, Object>> baseDataSortFields(List<Map<String, Object>> finalDsList, Map<String, Object> fMap, List<Map<String, Object>> pItems) {
        ArrayList<Map<String, Object>> addItems = new ArrayList<Map<String, Object>>(10);
        if (finalDsList != null) {
            for (Map<String, Object> pItem : pItems) {
                List<Map<String, Object>> filterItem;
                if (Boolean.parseBoolean(String.valueOf(pItem.get("NameProp"))) || Boolean.parseBoolean(String.valueOf(pItem.get("NumberProp"))) || (filterItem = this.filterItem(pItem, fMap, finalDsList)).size() <= 0) continue;
                addItems.addAll(filterItem);
            }
        }
        pItems = pItems.stream().filter(f -> Boolean.parseBoolean(String.valueOf(f.get("NameProp"))) || Boolean.parseBoolean(String.valueOf(f.get("NumberProp")))).peek(m -> {
            m.put("Name", fMap.get("Name") + "-" + m.get("Name"));
            m.put("Key", fMap.get("Key") + "." + m.get("Key"));
        }).collect(Collectors.toList());
        pItems.addAll(addItems);
        return pItems;
    }

    private List<Map<String, Object>> filterItem(Map<String, Object> pItem, Map<String, Object> fMap, List<Map<String, Object>> dsList) {
        ArrayList<Map<String, Object>> items = new ArrayList<Map<String, Object>>(10);
        for (Map<String, Object> ds : dsList) {
            List<Map<String, Object>> childItems;
            String bindField = String.valueOf(ds.get("bindField"));
            String[] split = bindField.split("\\.");
            if (!fMap.get("Key").equals(split[0]) || split.length > 1 && !pItem.get("Key").equals(split[1])) continue;
            if (split.length == 2) {
                Map<String, Object> node = this.createEndNode(pItem, split);
                items.add(node);
                continue;
            }
            List itemList = (List)pItem.get("Items");
            if (itemList == null || (childItems = this.filterChildItem(itemList, split, 2)).size() <= 0) continue;
            items.addAll(childItems);
        }
        return items;
    }

    private List<Map<String, Object>> filterChildItem(List<Map<String, Object>> children, String[] bindField, int index) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(10);
        for (Map<String, Object> item : children) {
            List<Map<String, Object>> nodes;
            if (!bindField[index].equals(item.get("Key"))) continue;
            if (index == bindField.length - 1) {
                Map<String, Object> node = this.createEndNode(item, bindField);
                result.add(node);
                return result;
            }
            children = (List)item.get("Items");
            if (children == null || (nodes = this.filterChildItem(children, bindField, ++index)).size() <= 0) continue;
            result.addAll(nodes);
        }
        return result;
    }

    private Map<String, Object> createEndNode(Map<String, Object> item, String[] bindField) {
        HashMap<String, Object> node = new HashMap<String, Object>(3);
        node.put("Name", String.valueOf(Optional.ofNullable(item.get("ViewName")).orElseGet(() -> {
            Object name = item.get("Name");
            if (StringUtils.isBlank(name)) {
                name = "";
            }
            return name;
        })));
        node.put("Key", String.join((CharSequence)".", bindField));
        node.put("SortedAble", Boolean.TRUE);
        return node;
    }

    private List<Map<String, Object>> buildRefSortFields(List<Map<String, Object>> dataSources, String dataSourceKey, List<Map<String, Object>> dsList) {
        Optional<Map> refMainDsOp;
        if (CollectionUtils.isEmpty(dataSources) || !(refMainDsOp = dataSources.stream().filter(f -> StringUtils.equals((CharSequence)f.get("Key").toString(), (CharSequence)dataSourceKey) && f.get("IsDataGridDs") != null && (Boolean)f.get("IsDataGridDs") != false).findFirst()).isPresent()) {
            return Collections.emptyList();
        }
        Map refMainDs = refMainDsOp.get();
        if (refMainDs.containsKey("Items")) {
            List pItems = (List)refMainDs.get("Items");
            return this.buildProperties(pItems, dsList);
        }
        return Collections.emptyList();
    }

    private void switchSTpl(String stplId) {
        String curLang = this.getPageCache().get(CACHE_CURRENT_LANG);
        LibraryDesignMetadata libraryDMeta = (LibraryDesignMetadata)this.libraryTplService.getDesignMeta(stplId);
        String dataTag = libraryDMeta.getData();
        Map metaMap = (Map)SerializeUtils.fromJsonString((String)dataTag, Map.class);
        String oriLang = (String)metaMap.get("oriLang");
        Map paper = (Map)metaMap.get("paper");
        Object pages = metaMap.get("pages");
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String tplId = (String)showParameter.getCustomParam("id");
        DesignMetadata designMeta = (DesignMetadata)this.tplService.getDesignMeta(tplId);
        dataTag = designMeta.getData();
        metaMap = (Map)SerializeUtils.fromJsonString((String)dataTag, Map.class);
        BaseInfo baseInfo = this.getCacheBaseInfo();
        paper.put("key", designMeta.getNumber());
        paper.put("name", baseInfo.getTplName());
        metaMap.put("paper", paper);
        metaMap.put("pages", pages);
        metaMap.put("stplId", stplId);
        metaMap.put("oriLang", oriLang);
        PrintMetadata printMetadata = PrintMetadataUtil.parseMetadata(metaMap);
        DesignerMetadata designerMetadata = PrintMetadataUtil.toDesignerMetadata(printMetadata, curLang);
        baseInfo.setStpld(stplId);
        this.cacheBaseInfo(baseInfo);
        this.getPageCache().put(CACHE_LANG_MAP, SerializeUtils.toJsonString((Object)designerMetadata.getLocaleValueMap()));
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        HashMap param = new HashMap();
        param.put("paper", designerMetadata.getMetadata().get("paper"));
        param.put("pages", designerMetadata.getMetadata().get("pages"));
        proxy.invokeControlMethod(PRINT_DESIGNER, "updateMeta", new Object[]{param});
    }

    private void modifyWFParam(Map wfParam) {
        BaseInfo baseInfo = this.getCacheBaseInfo();
        if (wfParam == null) {
            return;
        }
        baseInfo.setWfParam(wfParam);
        this.cacheBaseInfo(baseInfo);
    }

    private void addPlugin(Map returnData) {
        BaseInfo baseInfo = this.getCacheBaseInfo();
        if (returnData == null) {
            return;
        }
        Object value = returnData.get("value");
        baseInfo.setPlugins(SerializeUtils.toJsonString(value));
        this.cacheBaseInfo(baseInfo);
    }

    private void modifyCustomDataSource(List<Map> returnData) {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        if (returnData == null || returnData.isEmpty()) {
            EnumMap<DsType, List> dsParam = new EnumMap<DsType, List>(DsType.class);
            dsParam.put(DsType.Custom, Collections.EMPTY_LIST);
            proxy.invokeControlMethod(PRINT_DESIGNER, "updateDs", new Object[]{dsParam});
            BaseInfo cacheBaseInfo = this.getCacheBaseInfo();
            cacheBaseInfo.setCustomDs(null);
            this.cacheBaseInfo(cacheBaseInfo);
            return;
        }
        List customDsList = PrintDataSourceUtil.buildCustomDataSource(returnData);
        EnumMap<DsType, List> dsParam = new EnumMap<DsType, List>(DsType.class);
        dsParam.put(DsType.Custom, customDsList);
        proxy.invokeControlMethod(PRINT_DESIGNER, "updateDs", new Object[]{dsParam});
        BaseInfo cacheBaseInfo = this.getCacheBaseInfo();
        cacheBaseInfo.setCustomDs(SerializeUtils.toJsonString(returnData));
        this.cacheBaseInfo(cacheBaseInfo);
        this.removeDataSourceCache();
    }

    private void modifyRefDataSource(List<Map> returnData) {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        String curLang = this.getPageCache().get(CACHE_CURRENT_LANG);
        List refDsList = Collections.EMPTY_LIST;
        if (returnData != null && !returnData.isEmpty()) {
            Map map = returnData.get(0);
            String value = (String)map.get("value");
            refDsList = (List)SerializeUtils.fromJsonString((String)value, List.class);
        }
        ArrayList list = new ArrayList();
        for (Map ds : refDsList) {
            String formId = (String)ds.get("number");
            String entityId = MetadataDao.getIdByNumber((String)formId, (MetaCategory)MetaCategory.Entity);
            ds.put("entityId", entityId);
            ds.put("formId", formId);
            List refDs = PrtDataSourceUtil.loadRefDs(entityId);
            Map aliasMap = (Map)ds.get("alias");
            ((Map)refDs.get(0)).put("Name", aliasMap.get(curLang));
            list.addAll(refDs);
        }
        BaseInfo cacheBaseInfo = this.getCacheBaseInfo();
        cacheBaseInfo.setRefDs(SerializeUtils.toJsonString((Object)refDsList));
        this.cacheBaseInfo(cacheBaseInfo);
        this.removeDataSourceCache();
        EnumMap dsParam = new EnumMap(DsType.class);
        dsParam.put(DsType.Ref, list);
        proxy.invokeControlMethod(PRINT_DESIGNER, "updateDs", new Object[]{dsParam});
    }

    private void cacheBaseInfo(BaseInfo baseInfo) {
        this.getPageCache().put(CACHE_BASE_INFO, SerializeUtils.toJsonString((Object)baseInfo));
    }

    private BaseInfo getCacheBaseInfo() {
        BaseInfo baseInfo = (BaseInfo)SerializeUtils.fromJsonString((String)this.getPageCache().get(CACHE_BASE_INFO), BaseInfo.class);
        return baseInfo;
    }

    private static boolean checkPermission(String permissionItemId) {
        CustomParam customParam = new CustomParam();
        customParam.getSearchKeySet().add("printcheckPermission");
        Map paramMap = SystemParamServiceHelper.loadCustomParameterFromCache((CustomParam)customParam);
        if ("false".equals(paramMap.get("printcheckPermission"))) {
            return true;
        }
        String limit = SystemPropertyUtils.getProptyByTenant((String)"print.limit", (String)RequestContext.get().getTenantId());
        if (limit != null && "true".equals(limit)) {
            long userId = RequestContext.get().getCurrUserId();
            int flag = PermissionServiceHelper.checkFunctionPermission((long)userId, (long)0L, (String)"bos_manageprinttpl", (String)permissionItemId);
            boolean isHasPermission = flag == 1;
            return isHasPermission;
        }
        return true;
    }

    private boolean checkTplPermission(String permissionItemId) {
        boolean hasPermission;
        if (!PrintParamUtils.isTemplateOrgIsolated()) {
            return true;
        }
        CustomParam customParam = new CustomParam();
        customParam.getSearchKeySet().add("printcheckPermission");
        Map paramMap = SystemParamServiceHelper.loadCustomParameterFromCache((CustomParam)customParam);
        if ("false".equals(paramMap.get("printcheckPermission"))) {
            return true;
        }
        AbstractTplService designService = this.getDesignService();
        if (designService instanceof LibraryTplService) {
            return true;
        }
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String id = (String)showParameter.getCustomParam("id");
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_manageprinttpl", (String)"id,createorg", (QFilter[])new QFilter[]{new QFilter("printtplid", "=", (Object)id)});
        if (dynamicObject == null) {
            return true;
        }
        DynamicObject orgObj = dynamicObject.getDynamicObject("createorg");
        if (orgObj == null) {
            return true;
        }
        long createorg = orgObj.getLong("id");
        if (createorg == -1L) {
            return true;
        }
        boolean bl = hasPermission = 1 == PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (Long)createorg, (String)"15", (String)AppMetadataCache.getAppInfoByNumber((String)"cts").getId(), (String)"bos_manageprinttpl", (String)permissionItemId);
        if (!hasPermission) {
            String permItemName = String.valueOf(PermissionServiceHelper.getPermItemNameById((String)"4715a0df000000ac"));
            String formName = String.valueOf(FormMetadataCache.getFormConfig((String)"bos_manageprinttpl").getCaption());
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u65e0\u201c%1$s\u201d\u7684\u201c%2$s\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"PrintDesignerPlugin_15", (String)PROJECT_NAME, (Object[])new Object[0]), formName, permItemName));
        }
        return hasPermission;
    }
}

