/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.business.designer.datasource;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.metadata.entity.Entity;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.print.api.utils.localcache.LocalCache;
import kd.bos.print.business.designer.datasource.DsType;
import kd.bos.print.business.designer.datasource.FieldType;
import kd.bos.print.business.designer.datasource.IDsBuilder;

public abstract class BaseDsBuilder
implements IDsBuilder {
    protected static final String PROJECT_NAME = "bos-print-business";
    protected LocalCache<EntityMetadata> localCache = new LocalCache(300L, 500);
    protected String key;
    protected String name;
    protected DsType dsType;
    protected Boolean isDs = Boolean.TRUE;
    protected String entityId;
    protected String entityNum;
    protected Entity<?, ?> entity;
    protected MainEntityType mainEntityType;

    public BaseDsBuilder setEntityId(String entityId) {
        this.entityId = entityId;
        return this;
    }

    public BaseDsBuilder setEntityNum(String formId) {
        this.entityNum = formId;
        this.mainEntityType = EntityMetadataCache.getDataEntityType((String)this.entityNum);
        return this;
    }

    public BaseDsBuilder setEntity(Entity<?, ?> entity) {
        this.entity = entity;
        return this;
    }

    @Override
    public Map<String, Object> build() {
        this.init();
        HashMap<String, Object> ds = new HashMap<String, Object>(16);
        ds.put("Key", this.key);
        ds.put("DsType", this.dsType.getCode());
        ds.put("Icon", this.dsType.getIcon());
        ds.put("IsDs", this.isDs);
        ds.put("Name", this.name);
        ds.put("Items", this.buildItems());
        return ds;
    }

    @Override
    public List buildItems() {
        return new ArrayList();
    }

    protected Map<String, Object> createFieldNode(String key, String name, String viewName, FieldType fieldType) {
        Map<String, Object> eleNode = this.createFieldNode(key, name, fieldType);
        if (StringUtils.isNotBlank((CharSequence)viewName)) {
            eleNode.put("ViewName", viewName);
        }
        return eleNode;
    }

    protected Map<String, Object> createFieldNode(String key, String name, FieldType fieldType) {
        HashMap<String, Object> eleNode = new HashMap<String, Object>();
        eleNode.put("Key", key);
        eleNode.put("Type", fieldType.getType());
        eleNode.put("IsField", Boolean.TRUE);
        eleNode.put("Name", name);
        eleNode.put("Icon", fieldType.getIcon());
        HashMap<String, String> intiAttr = new HashMap<String, String>();
        intiAttr.put("TextFormat", fieldType == FieldType.Attach ? FieldType.Text.getCode() : fieldType.getCode());
        eleNode.put("InitAttr", intiAttr);
        return eleNode;
    }

    protected Map<String, Object> createContainNode(String key, String name, List<Object> itemsList) {
        HashMap<String, Object> node = new HashMap<String, Object>();
        node.put("Key", key);
        node.put("Name", name);
        node.put("Items", itemsList);
        return node;
    }
}

