/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.business.designer.datasource;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.print.business.designer.datasource.BaseDsBuilder;
import kd.bos.print.business.designer.datasource.DsType;
import kd.bos.print.business.designer.datasource.FieldType;
import kd.bos.util.StringUtils;

public class CustomDsBuilder
extends BaseDsBuilder {
    @Override
    public void init() {
        this.dsType = DsType.Custom;
    }

    @Override
    public List buildItems() {
        return null;
    }

    private List buildItems(List<Map> items) {
        ArrayList<Map<String, Object>> nodes = new ArrayList<Map<String, Object>>(10);
        for (Map map : items) {
            String type;
            String name;
            String key = (String)map.get("fieldkey");
            Map localName = (Map)map.get("fieldmname");
            if (localName != null) {
                name = localName.getOrDefault(RequestContext.get().getLang().toString(), (String)map.get("fieldname"));
                if (name == null) {
                    name = (String)localName.get("GLang");
                }
            } else {
                name = (String)map.get("fieldname");
            }
            if (StringUtils.isBlank((String)(type = (String)map.get("fieldtype")))) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5b57\u6bb5\u7c7b\u578b\u3002", (String)"CustomDsPlugin_6", (String)"bos-print-business", (Object[])new Object[0]));
            }
            nodes.add(this.createFieldNode(key, name == null ? "" : name, FieldType.valueOf(type)));
        }
        return nodes;
    }

    public Map<String, Object> build(Map customItem) {
        this.init();
        HashMap<String, Object> ds = new HashMap<String, Object>(16);
        ds.put("Key", customItem.get("key"));
        ds.put("DsType", this.dsType.getCode());
        ds.put("Icon", this.dsType.getIcon());
        ds.put("IsDs", this.isDs);
        ds.put("IsDataGridDs", Boolean.TRUE);
        Map localName = (Map)customItem.get("mname");
        String name = "";
        if (localName != null) {
            name = localName.getOrDefault(RequestContext.get().getLang().toString(), (String)customItem.get("name"));
            if (name == null) {
                name = (String)localName.get("GLang");
            }
        } else {
            name = (String)customItem.get("name");
        }
        ds.put("Name", name);
        HashMap<String, String> tag = new HashMap<String, String>();
        tag.put("Name", ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49", (String)"PrintDataSourceUtil_2", (String)"bos-print-business", (Object[])new Object[0]));
        tag.put("Color", "#3DCCC0");
        ds.put("Tag", tag);
        ds.put("Items", this.buildItems((List)customItem.get("fielditems")));
        return ds;
    }

    @Override
    protected Map<String, Object> createFieldNode(String key, String name, FieldType fieldType) {
        HashMap<String, Object> eleNode = new HashMap<String, Object>(7);
        eleNode.put("Key", key);
        eleNode.put("Type", fieldType.getType());
        eleNode.put("IsField", Boolean.TRUE);
        eleNode.put("Name", name);
        eleNode.put("Icon", fieldType.getIcon());
        eleNode.put("SortedAble", Boolean.TRUE);
        HashMap<String, String> intiAttr = new HashMap<String, String>(1);
        intiAttr.put("TextFormat", fieldType == FieldType.Attach ? FieldType.Text.getCode() : fieldType.getCode());
        eleNode.put("InitAttr", intiAttr);
        return eleNode;
    }
}

