/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.business.designer.datasource;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntryEntity;
import kd.bos.metadata.entity.SubEntryEntity;
import kd.bos.metadata.entity.businessfield.AbstractBasedataField;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.metadata.entity.businessfield.BasedataPropField;
import kd.bos.metadata.entity.businessfield.MulBasedataField;
import kd.bos.metadata.entity.commonfield.DateRangeField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.LargeTextField;
import kd.bos.print.business.designer.datasource.DsType;
import kd.bos.print.business.designer.datasource.FieldType;
import kd.bos.print.business.designer.datasource.FormDsBuilder;

public class EntryDsBuilder
extends FormDsBuilder {
    private static final String PROJECT_NAME = "bos-print-business";

    public EntryDsBuilder(DsType dsType) {
        this.dsType = dsType;
    }

    @Override
    public void init() {
        this.key = this.entity.getKey();
        this.name = this.entity.getName().toString();
    }

    @Override
    public Map<String, Object> build() {
        Map<String, Object> entryNode = super.build();
        if (this.dsType == DsType.Entry) {
            entryNode.put("IsDataGridDs", Boolean.TRUE);
        } else {
            entryNode.put("IsDataGridDs", Boolean.TRUE);
            entryNode.put("IsSubDataGridDs", Boolean.TRUE);
        }
        EntryEntity entryEntity = (EntryEntity)this.entity;
        List items = entryEntity.getItems();
        for (EntityItem entityItem : items) {
            if (!(entityItem instanceof SubEntryEntity) || !StringUtils.isNotBlank((CharSequence)((SubEntryEntity)entityItem).getTableName())) continue;
            List subEntryList = entryNode.getOrDefault("SubEntryList", new ArrayList());
            subEntryList.add(this.mainEntityType.getName() + "." + entityItem.getKey());
            entryNode.put("SubEntryList", subEntryList);
        }
        return entryNode;
    }

    @Override
    public List buildItems() {
        EntryEntity entryEntity = (EntryEntity)this.entity;
        List<Object> nodes = this.buildEntryNode(entryEntity, 1);
        return nodes;
    }

    private List<Object> buildEntryNode(EntryEntity entry, int treeHeight) {
        ArrayList<Object> nodes = new ArrayList<Object>();
        if (treeHeight <= 2) {
            if (this.showFields == null && StringUtils.isNotBlank((CharSequence)entry.getSeqFieldName())) {
                Map<String, Object> node = this.createFieldNode("seq", ResManager.loadKDString((String)"\u5e8f\u53f7", (String)"EntryDsBuilder_0", (String)PROJECT_NAME, (Object[])new Object[0]), FieldType.Number);
                nodes.add(node);
            }
            for (EntityItem element : entry.getItems()) {
                String curHeadKey = element.getKey();
                String curHeadName = element.getName().toString();
                if (element instanceof BasedataField) {
                    Map<String, Object> basedataNode;
                    if (this.isCheckDBField && StringUtils.isEmpty((CharSequence)((BasedataField)element).getFieldName()) || (basedataNode = this.basedataEntityNode((AbstractBasedataField)((BasedataField)element), curHeadKey, curHeadName, treeHeight + 1)) == null) continue;
                    nodes.add(basedataNode);
                    continue;
                }
                if (element instanceof SubEntryEntity) continue;
                if (element instanceof MulBasedataField) {
                    nodes.add(this.createFieldNode(curHeadKey, curHeadName, element));
                    continue;
                }
                if (!(element instanceof Field) || !this.isShowField(element)) continue;
                if (element instanceof DateRangeField) {
                    String newname;
                    String newKey;
                    DateRangeField dateRange = (DateRangeField)element;
                    if (!this.isCheckDBField || StringUtils.isNotBlank((CharSequence)dateRange.getStartDateFieldName())) {
                        newKey = dateRange.getStartDateFieldKey();
                        newname = String.format(ResManager.loadKDString((String)"%s-\u5f00\u59cb", (String)"EntryDsBuilder_1", (String)PROJECT_NAME, (Object[])new Object[0]), element.getName());
                        nodes.add(this.createFieldNode(newKey, newname, element));
                    }
                    if (this.isCheckDBField && !StringUtils.isNotBlank((CharSequence)dateRange.getEndDateFieldName())) continue;
                    newKey = dateRange.getEndDateFieldKey();
                    newname = String.format(ResManager.loadKDString((String)"%s-\u7ed3\u675f", (String)"EntryDsBuilder_2", (String)PROJECT_NAME, (Object[])new Object[0]), element.getName());
                    nodes.add(this.createFieldNode(newKey, newname, element));
                    continue;
                }
                if (this.isCheckDBField && StringUtils.isEmpty((CharSequence)((Field)element).getFieldName()) || this.showFields != null && !this.showFields.isEmpty() && !(element instanceof SubEntryEntity) && this.showFields.stream().noneMatch(clazz -> clazz.isInstance(element))) continue;
                if (element instanceof BasedataPropField) {
                    BasedataPropField basdataProp = (BasedataPropField)element;
                    if (basdataProp.getControlField() == null) continue;
                    curHeadKey = basdataProp.getControlField().getKey() + "." + basdataProp.getRefDisplayProp();
                    curHeadName = basdataProp.getName().getLocaleValue();
                    nodes.add(this.createFieldNode(curHeadKey, curHeadName, element));
                    continue;
                }
                if (element instanceof LargeTextField) {
                    nodes.add(this.createFieldNode(element.getKey(), String.format(ResManager.loadKDString((String)"%s-\u6807\u9898", (String)"EntryDsBuilder_3", (String)PROJECT_NAME, (Object[])new Object[0]), element.getName().toString()), element));
                    nodes.add(this.createFieldNode(element.getKey() + "_tag", String.format(ResManager.loadKDString((String)"%s-\u5185\u5bb9", (String)"EntryDsBuilder_4", (String)PROJECT_NAME, (Object[])new Object[0]), element.getName().toString()), element));
                    continue;
                }
                nodes.add(this.createFieldNode(curHeadKey, curHeadName, element));
            }
        } else if (treeHeight == 3 || treeHeight >= 4) {
            // empty if block
        }
        return nodes;
    }
}

